/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.CompatibleVectorHints;
import com.extentech.toolkit.Logger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class CompatibleVector
extends Vector {
    private static final long serialVersionUID = 6805047965683753637L;
    private int change_offset = 0;
    private int reindex_change_size = 1000;
    int hits = 0;
    int misses = 0;
    int cursor = 0;
    int lastRet = -1;

    public void resetHints(boolean ignore_records) {
        if (!ignore_records) {
            int t = 0;
            while (t < this.size()) {
                try {
                    ((CompatibleVectorHints)this.get(t)).setRecordIndexHint(t);
                }
                catch (Exception e) {
                    return;
                }
                ++t;
            }
        }
        this.change_offset = 0;
    }

    public CompatibleVector() {
    }

    public CompatibleVector(int i) {
        super(i);
    }

    @Override
    public Iterator iterator() {
        return new Itr();
    }

    public int indexOf(CompatibleVectorHints r2) {
        int x = r2.getRecordIndexHint();
        if (x > 0 && x < super.size() && super.elementAt(x) != null && super.elementAt(x).equals(r2)) {
            return x;
        }
        if ((x -= this.change_offset) > 0 && x < super.size() && super.elementAt(x).equals(r2)) {
            return x;
        }
        int t = -1;
        if (this.change_offset > this.reindex_change_size) {
            this.resetHints(false);
        }
        if (x > 0) {
            t = super.indexOf(r2);
        }
        if (t < 0) {
            t = super.indexOf(r2);
        }
        r2.setRecordIndexHint(t);
        return t;
    }

    public Object next() {
        try {
            Object next = this.get(this.cursor);
            this.lastRet = this.cursor++;
            return next;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Object get(int idx) {
        return super.elementAt(idx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addOrderedDouble(Double obj) {
        double d = obj;
        try {
            int i = 0;
            while (i < super.size()) {
                Double dd = (Double)super.elementAt(i);
                if (dd > d) {
                    super.insertElementAt(obj, i);
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
        super.add(obj);
        return true;
    }

    public Object last() {
        return super.elementAt(super.size() - 1);
    }

    @Override
    public boolean add(CompatibleVectorHints obj) {
        ++this.change_offset;
        int idx = super.size();
        if (obj != null) {
            obj.setRecordIndexHint(idx);
        }
        try {
            super.insertElementAt(obj, idx);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void add(int idx, CompatibleVectorHints obj) {
        ++this.change_offset;
        obj.setRecordIndexHint(idx);
        super.insertElementAt(obj, idx);
    }

    public void addAll(CompatibleVector cv) {
        int i = 0;
        while (i < cv.size()) {
            Object b = cv.get(i);
            if (b instanceof CompatibleVectorHints) {
                this.add((CompatibleVectorHints)b);
            } else {
                this.add(b);
            }
            ++i;
        }
    }

    @Override
    public boolean remove(Object obj) {
        if (super.remove(obj)) {
            --this.change_offset;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.change_offset = 0;
        super.removeAllElements();
    }

    @Override
    public Object[] toArray() {
        Object[] obj = new Object[super.size()];
        int i = 0;
        while (i < super.size()) {
            obj[i] = super.elementAt(i);
            ++i;
        }
        return obj;
    }

    @Override
    public Object[] toArray(Object[] obj) {
        int i = 0;
        while (i < super.size()) {
            try {
                obj[i] = super.elementAt(i);
            }
            catch (Exception e) {
                Logger.logInfo("CompatibleVector.toArray() failed.");
            }
            ++i;
        }
        return obj;
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = CompatibleVector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CompatibleVector.this.size();
        }

        public Object next() {
            Object next = CompatibleVector.this.get(this.cursor);
            this.lastRet = this.cursor++;
            return next;
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            CompatibleVector.this.remove(this.lastRet);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.expectedModCount = CompatibleVector.this.modCount;
        }
    }
}

