/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import java.io.IOException;
import java.io.Reader;

public class DelimitedValuesParser {
    private Reader source;
    private char delimiter = (char)9;
    private StringBuilder value = new StringBuilder();
    private Token current = null;
    private Token next = null;

    public DelimitedValuesParser(Reader source) {
        this.source = source;
    }

    public Token next() throws IOException {
        this.value.setLength(0);
        if (this.next != null) {
            this.current = this.next;
            this.next = null;
            return this.current;
        }
        while (true) {
            int read;
            if ((read = this.source.read()) == -1) {
                if (this.value.length() == 0) {
                    this.current = Token.EOF;
                    return this.current;
                }
                this.current = Token.VALUE;
                return this.current;
            }
            if (read == this.delimiter) {
                this.current = Token.VALUE;
                return this.current;
            }
            if (read == 10) {
                if (this.value.length() > 0) {
                    if (this.value.charAt(this.value.length() - 1) == '\r') {
                        this.value.setLength(this.value.length() - 1);
                    }
                    this.next = Token.NEWLINE;
                    this.current = Token.VALUE;
                    return this.current;
                }
                this.current = Token.NEWLINE;
                return this.current;
            }
            this.value.append((char)read);
        }
    }

    public String getValue() {
        return this.value.length() > 0 ? this.value.toString() : null;
    }

    public static enum Token {
        VALUE,
        NEWLINE,
        EOF;

    }
}

