/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.Logger;
import com.extentech.toolkit.Recyclable;
import com.extentech.toolkit.RecycleBin;
import com.extentech.toolkit.RecycleBinFullException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public abstract class GenericRecycleBin
extends Thread
implements Map,
RecycleBin {
    protected Map map = new HashMap();
    protected Vector active = new Vector();
    protected Stack spares = new Stack();
    protected int MAXITEMS = -1;

    @Override
    public void addItem(Recyclable r2) throws RecycleBinFullException {
        if (this.MAXITEMS != -1 && this.map.size() >= this.MAXITEMS) {
            throw new RecycleBinFullException();
        }
        this.addItem(this.map.size(), r2);
    }

    public int getNumItems() {
        return this.active.size();
    }

    @Override
    public void addItem(Object key, Recyclable r2) throws RecycleBinFullException {
        if (this.MAXITEMS != -1 && this.map.size() >= this.MAXITEMS) {
            throw new RecycleBinFullException();
        }
        this.active.add(r2);
        this.map.put(key, r2);
    }

    public synchronized void recycle() {
        Object[] rs = new Recyclable[this.active.size()];
        this.active.copyInto(rs);
        int t = 0;
        while (t < rs.length) {
            try {
                Object rb = rs[t];
                if (!rb.inUse()) {
                    rb.recycle();
                    this.active.remove(rb);
                    this.map.remove(rb);
                    this.spares.push(rb);
                }
            }
            catch (Exception ex) {
                Logger.logErr("recycle failed", ex);
            }
            ++t;
        }
    }

    @Override
    public void empty() {
        this.map.clear();
        this.active.clear();
    }

    @Override
    public synchronized List getAll() {
        return this.active;
    }

    @Override
    public synchronized Recyclable getItem() throws RecycleBinFullException {
        Recyclable active = null;
        if (this.spares.size() > 0) {
            active = (Recyclable)this.spares.pop();
            this.addItem(active);
            return active;
        }
        this.recycle();
        return this.getItem();
    }

    @Override
    public void setMaxItems(int i) {
        this.MAXITEMS = i;
    }

    public int getMaxItems() {
        return this.MAXITEMS;
    }

    public int getSpareCount() {
        return this.spares.size();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.active.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object arg0, Object arg1) {
        this.active.add(arg1);
        return this.map.put(arg0, arg1);
    }

    public void putAll(Map arg0) {
        this.active.addAll(arg0.entrySet());
        this.map.putAll(arg0);
    }

    public Object remove(Object key) {
        this.active.remove(this.map.get(key));
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    public Collection values() {
        return this.map.values();
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(HashMap _map) {
        this.map = _map;
    }
}

