/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IndirectOutputStream
extends OutputStream {
    private OutputStream sink;
    private boolean discardOnNull;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public IndirectOutputStream() {
        this(null);
    }

    public IndirectOutputStream(OutputStream sink) {
        this(sink, false);
    }

    public IndirectOutputStream(OutputStream sink, boolean discard) {
        this.sink = sink;
        this.discardOnNull = discard;
    }

    public OutputStream getSink() {
        return this.sink;
    }

    public void setSink(OutputStream sink) {
        this.lock.writeLock().lock();
        try {
            this.sink = sink;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean discardOnNoSink() {
        return this.discardOnNull;
    }

    public void discardOnNoSink(boolean discard) {
        this.discardOnNull = discard;
    }

    private boolean checkSink() throws IOException {
        if (this.sink == null) {
            if (this.discardOnNull) {
                return true;
            }
            throw new IOException("sink not connected");
        }
        return false;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.lock.readLock().lock();
        try {
            if (this.checkSink()) {
                return;
            }
            this.sink.write(b);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.lock.readLock().lock();
        try {
            if (this.checkSink()) {
                return;
            }
            this.sink.write(b);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.lock.readLock().lock();
        try {
            if (this.checkSink()) {
                return;
            }
            this.sink.write(b, off, len);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.lock.readLock().lock();
        try {
            if (this.checkSink()) {
                return;
            }
            this.sink.flush();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.lock.readLock().lock();
        try {
            if (this.checkSink()) {
                return;
            }
            this.sink.close();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

