/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.InFile;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.OutFile;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import javax.swing.JTextArea;

public class JFileWriter {
    String path = "";
    String filename = "";
    String data = "";
    byte newLine = (byte)13;

    public void setPath(String p) {
        this.path = p;
    }

    public void setFileName(String f) {
        this.filename = f;
    }

    public void setData(String d) {
        this.data = d;
    }

    void printErr(String err) {
        Logger.logInfo("Error in JFileWriter: " + err);
        Logger.logWarn("Error in JFileWriter: " + err);
    }

    public static final synchronized void appendToFile(String pth, String text) {
        try {
            byte[] bbuf = text.getBytes("UTF-8");
            File outp = new File(pth);
            if (!outp.exists()) {
                outp.mkdirs();
                outp.delete();
                outp = new File(pth);
            }
            RandomAccessFile outputFile = new RandomAccessFile(outp, "rw");
            outputFile.skipBytes((int)outputFile.length());
            int strt = 0;
            if (outp.exists()) {
                strt = (int)outputFile.length();
            }
            outputFile.write(bbuf, 0, bbuf.length);
            outputFile.close();
        }
        catch (Exception e) {
            Logger.logInfo("JFileWriter.appendToFile() IO Error : " + e.toString());
        }
    }

    public static void writeToFile(InputStream is, File file) throws IOException {
        int len;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        is.close();
        out.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeIt() {
        try {
            this.path = String.valueOf(this.path) + this.filename;
            StringReader SR = new StringReader(this.data);
            File outputFile = new File(this.path);
            FileWriter out = new FileWriter(outputFile);
            if (outputFile.length() > 0L) {
                return false;
            }
            while (true) {
                int c;
                if ((c = SR.read()) == -1) {
                    out.flush();
                    out.close();
                    return true;
                }
                out.write(c);
            }
        }
        catch (IOException e) {
            Logger.logInfo("JFileWriter IO Error : " + e.toString());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeIt(String data, String filename, String path) {
        try {
            path = String.valueOf(path) + filename;
            StringReader SR = new StringReader(data);
            File outputFile = new File(path);
            FileWriter out = new FileWriter(outputFile);
            if (outputFile.length() > 0L) {
                return false;
            }
            while (true) {
                int c;
                if ((c = SR.read()) == -1) {
                    out.flush();
                    out.close();
                    return true;
                }
                out.write(c);
            }
        }
        catch (IOException e) {
            Logger.logInfo("JFileWriter IO Error : " + e.toString());
        }
        return true;
    }

    public String readFile(String fname) {
        StringBuffer addTxt = new StringBuffer();
        try {
            BufferedReader d = new BufferedReader(new FileReader(fname));
            while (d.ready()) {
                addTxt.append(d.readLine());
            }
            d.close();
        }
        catch (Exception e) {
            this.printErr("problem reading file: " + e);
        }
        return addTxt.toString();
    }

    public static void copyFile(String infile, String outfile) throws FileNotFoundException, IOException {
        File fx = new File(infile);
        JFileWriter.copyFile(fx, outfile);
    }

    public static void copyFile(File source, String target) throws FileNotFoundException, IOException {
        File fout = new File(target);
        fout.mkdirs();
        fout.delete();
        fout = new File(target);
        FileChannel in = new FileInputStream(source).getChannel();
        FileChannel out = new FileOutputStream(target).getChannel();
        in.transferTo(0L, in.size(), out);
        in.close();
        out.close();
    }

    public void writeLine(String file, String line) {
        try {
            String s;
            File f = new File(file);
            FileWriter out = new FileWriter(f);
            DataInputStream inStream = new DataInputStream(new StringBufferInputStream(line));
            while ((s = inStream.readLine()) != null) {
                out.write(s);
                out.write(this.newLine);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            this.printErr(e.toString());
        }
        catch (Exception e) {
            this.printErr(e.toString());
        }
    }

    public void writeLogToFile(String fname, JTextArea jta) {
        try {
            OutFile n = new OutFile(fname);
            String logText = jta.getText();
            n.writeBytes(logText);
            jta.setText("");
            n.close();
        }
        catch (FileNotFoundException e) {
            this.printErr(e.toString());
        }
        catch (IOException e) {
            this.printErr(e.toString());
        }
    }

    public String readLog(String logFname) {
        String addTxt = "";
        try {
            InFile n = new InFile(logFname);
            while (n.available() != 0) {
                addTxt = String.valueOf(addTxt) + n.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.printErr(e.toString());
        }
        catch (IOException e) {
            this.printErr(e.toString());
        }
        addTxt = String.valueOf(addTxt) + "\r\n";
        return addTxt;
    }
}

