/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.IndirectOutputStream;
import com.extentech.toolkit.LogOutputter;
import com.extentech.toolkit.WriterOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger
extends PrintStream
implements LogOutputter {
    protected PrintStream ous = this;
    private static final String endl = System.getProperty("line.separator");
    private LogOutputter targetLogger;
    private BufferedWriter targetWriter;
    private StringBuffer lineBuffer = new StringBuffer();
    private boolean autoFlush;
    public static final String INFO_STRING = "";
    public static final String WARN_STRING = "WARNING: ";
    public static final String ERROR_STRING = "ERROR: ";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSSS";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSSS");
    private static String dateSpec = "yyyy-MM-dd HH:mm:ss:SSSS";

    public Logger(LogOutputter target) {
        this();
        this.init(target);
    }

    public Logger(LogOutputter target, String charset) throws UnsupportedEncodingException {
        this(charset);
        this.init(target);
    }

    public Logger(OutputStream target) {
        this(target, false);
    }

    public Logger(OutputStream target, boolean autoFlush) {
        this(new OutputStreamWriter(target), autoFlush);
    }

    public Logger(OutputStream target, String charset, boolean autoFlush) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(target, charset), charset, autoFlush);
    }

    public Logger(Writer target) {
        this(target, false);
    }

    public Logger(Writer target, boolean autoFlush) {
        this();
        this.init(target, autoFlush);
    }

    public Logger(Writer target, String charset, boolean autoFlush) throws UnsupportedEncodingException {
        this(charset);
        this.init(target, autoFlush);
    }

    private Logger() {
        super(new IndirectOutputStream(), true);
        ((IndirectOutputStream)this.out).setSink(new WriterOutputStream((Appendable)this, Charset.defaultCharset()));
    }

    private Logger(String charset) throws UnsupportedEncodingException {
        super((OutputStream)new IndirectOutputStream(), true, charset);
        ((IndirectOutputStream)this.out).setSink(new WriterOutputStream((Appendable)this, charset));
    }

    private void init(LogOutputter target) {
        this.targetLogger = target;
        this.targetWriter = null;
        this.autoFlush = false;
    }

    private void init(Writer target, boolean autoFlush) {
        this.targetLogger = null;
        this.targetWriter = new BufferedWriter(target);
        this.autoFlush = autoFlush;
    }

    public void install() {
        Logger.setLogger(this);
        System.setOut(this);
        System.setErr(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String message) {
        if (this.targetLogger != null) {
            this.targetLogger.log(message);
        } else {
            BufferedWriter bufferedWriter = this.targetWriter;
            synchronized (bufferedWriter) {
                try {
                    this.targetWriter.write(Logger.getLogDate());
                    this.targetWriter.write(" ");
                    this.targetWriter.write(message);
                    this.targetWriter.newLine();
                    if (this.autoFlush) {
                        this.targetWriter.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void log(String message, Exception ex, boolean trace) {
        if (this.targetLogger != null) {
            this.targetLogger.log(message, ex, trace);
        } else {
            this.log(Logger.formatThrowable(message, ex, trace));
        }
    }

    @Override
    public void log(String message, Exception ex) {
        if (this.targetLogger != null) {
            this.targetLogger.log(message, ex);
        } else {
            this.log(Logger.formatThrowable(message, ex, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logLine() {
        StringBuffer stringBuffer = this.lineBuffer;
        synchronized (stringBuffer) {
            int length = this.lineBuffer.length();
            if (length >= endl.length() && endl.equals(this.lineBuffer.substring(length - endl.length(), length))) {
                this.lineBuffer.setLength(length - endl.length());
            }
            if (this.lineBuffer.length() > 0) {
                this.log(this.lineBuffer.toString());
                this.lineBuffer.setLength(0);
            }
        }
    }

    @Override
    public Logger append(char value) {
        this.lineBuffer.append(value);
        return this;
    }

    @Override
    public Logger append(CharSequence value) {
        this.lineBuffer.append(value);
        return this;
    }

    @Override
    public Logger append(CharSequence value, int start, int end) {
        this.lineBuffer.append(value, start, end);
        return this;
    }

    @Override
    public void print(boolean b) {
        this.lineBuffer.append(b);
    }

    @Override
    public void print(char c) {
        this.lineBuffer.append(c);
    }

    @Override
    public void print(int i) {
        this.lineBuffer.append(i);
    }

    @Override
    public void print(long l) {
        this.lineBuffer.append(l);
    }

    @Override
    public void print(float f) {
        this.lineBuffer.append(f);
    }

    @Override
    public void print(double d) {
        this.lineBuffer.append(d);
    }

    @Override
    public void print(char[] s) {
        this.lineBuffer.append(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String s) {
        StringBuffer stringBuffer = this.lineBuffer;
        synchronized (stringBuffer) {
            this.lineBuffer.append(s);
            if (s.endsWith(endl)) {
                this.println();
            }
        }
    }

    @Override
    public void print(Object obj) {
        this.lineBuffer.append(obj);
    }

    @Override
    public void println(boolean x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.lineBuffer.append(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.lineBuffer.append(x);
        this.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        StringBuffer stringBuffer = this.lineBuffer;
        synchronized (stringBuffer) {
            super.flush();
            this.logLine();
        }
    }

    public static LogOutputter getLogger() {
        LogOutputter logger;
        try {
            logger = (LogOutputter)System.getProperties().get("com.extentech.toolkit.logger");
        }
        catch (Exception ex) {
            logger = null;
        }
        if (logger == null) {
            logger = System.err instanceof Logger ? (Logger)System.err : new Logger(System.err, true);
            Logger.setLogger(logger);
        }
        return logger;
    }

    public static void setLogger(LogOutputter logger) {
        System.getProperties().put("com.extentech.toolkit.logger", logger);
    }

    public static String formatThrowable(String message, Throwable ex, boolean trace) {
        StringWriter writer = new StringWriter();
        writer.write(message);
        if (trace) {
            writer.write(endl);
            writer.write(endl);
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            printer.flush();
        } else {
            writer.write(": ");
            writer.write(ex.toString());
        }
        return writer.toString();
    }

    public static void logErr(String message, Exception ex) {
        Logger.getLogger().log(ERROR_STRING + message, ex);
    }

    public static void logErr(String message, Throwable ex) {
        Logger.getLogger().log(Logger.formatThrowable(ERROR_STRING + message, ex, false));
    }

    public static void logErr(String message) {
        Logger.getLogger().log(ERROR_STRING + message);
    }

    public static void logErr(String message, Exception ex, boolean trace) {
        Logger.getLogger().log(ERROR_STRING + message, ex, trace);
    }

    public static void log(Object object) {
        Logger.logInfo(object.toString());
    }

    public static void logWarn(String message) {
        Logger.getLogger().log(WARN_STRING + message);
    }

    public static void logErr(Exception ex) {
        Logger.logErr(ex.toString());
    }

    public static void logInfo(String message) {
        Logger.getLogger().log(message);
    }

    public static void setOut(String filename) {
        try {
            File logfile = new File(filename);
            FileOutputStream sysout = new FileOutputStream(logfile);
            System.setOut(new Logger(sysout));
        }
        catch (Exception e) {
            Logger.logErr("Setting System Output Stream in Logger failed: ", e);
        }
    }

    public static void setErr(String filename) {
        try {
            File logfile = new File(filename);
            FileOutputStream sysout = new FileOutputStream(logfile);
            System.setErr(new Logger(sysout));
        }
        catch (Exception e) {
            Logger.logErr("Setting System Error Stream in Logger failed: ", e);
        }
    }

    public static String getLogDate() {
        String spec = System.getProperty("com.extentech.toolkit.logger.dateformat");
        if (spec != null) {
            if ("none".equalsIgnoreCase(spec)) {
                return INFO_STRING;
            }
            if (!dateSpec.equals(spec)) {
                try {
                    dateFormat.applyPattern(spec);
                }
                catch (IllegalArgumentException e) {
                    dateFormat.applyPattern(DATE_FORMAT);
                }
                dateSpec = spec;
            }
        }
        return dateFormat.format(new Date());
    }
}

