/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class Money
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2055249101317798370L;
    protected BigDecimal value = null;
    protected int roundingMode = 1;
    protected DecimalFormat currencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
    protected static final BigDecimal ZERO = new BigDecimal("0.00");

    public Money() {
        this.value = ZERO;
    }

    public Money(double amount) {
        this.value = new BigDecimal(Double.toString(amount));
    }

    public Money(long amount) {
        this.value = new BigDecimal(Long.toString(amount));
    }

    public Money(long amount, int scale) throws InvalidScaleFactorException {
        if (scale < 0 || scale > 2) {
            throw new InvalidScaleFactorException("Invalid scale factor: " + scale + " (must be 0, 1, or 2)");
        }
        this.value = new BigDecimal(Long.toString(amount)).movePointLeft(scale);
    }

    public Money(String string) throws ParseException {
        Number number = this.currencyFormat.parse(string);
        this.value = new BigDecimal(number.toString());
    }

    public Money(BigDecimal amount) {
        this.value = new BigDecimal(amount.toString());
    }

    public Money(Money amount) {
        this.roundingMode = amount.roundingMode;
        this.currencyFormat = (DecimalFormat)amount.currencyFormat.clone();
        this.value = amount.value;
    }

    public Money add(Money money) {
        Money result = new Money(this);
        result.value = this.value.add(money.value);
        return result;
    }

    public Money subtract(Money money) {
        Money result = new Money(this);
        result.value = this.value.subtract(money.value);
        return result;
    }

    public Money multiply(double mult) {
        Money result = new Money(this);
        result.value = this.value.multiply(new BigDecimal(mult));
        return result;
    }

    public Money multiply(long mult) {
        Money result = new Money(this);
        result.value = this.value.multiply(new BigDecimal(Long.toString(mult)));
        return result;
    }

    public Money divide(double div) {
        Money result = new Money(this);
        result.value = this.value.divide(new BigDecimal(div), 4);
        return result;
    }

    public Money divide(long div) {
        Money result = new Money(this);
        result.value = this.value.divide(new BigDecimal(Long.toString(div)), 4);
        return result;
    }

    public Money negate() {
        Money result = new Money(this);
        result.value = this.value.negate();
        return result;
    }

    public Money abs() {
        Money result = new Money(this);
        result.value = this.value.abs();
        return result;
    }

    public long toLong() {
        BigDecimal result = this.value.setScale(2, this.roundingMode);
        result = result.movePointRight(2);
        return result.longValue();
    }

    public double toDouble() {
        return this.value.doubleValue();
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public Money setRoundingMode(int mode) throws InvalidRoundingModeException {
        if (mode == 7) {
            throw new InvalidRoundingModeException("Rounding mode not valid for monetary data: " + mode);
        }
        Money result = new Money(this);
        result.roundingMode = mode;
        return result;
    }

    public DecimalFormat getCurrencyFormat() {
        return this.currencyFormat;
    }

    public Money setCurrencyFormat(DecimalFormat format) {
        Money result = new Money(this);
        result.currencyFormat = format;
        return result;
    }

    public String toString() {
        BigDecimal result = this.value.setScale(2, this.roundingMode);
        return this.currencyFormat.format(result);
    }

    public Money parse(String string) throws ParseException {
        Money result = new Money(this);
        Number number = this.currencyFormat.parse(string);
        result.value = new BigDecimal(number.toString());
        return result;
    }

    public boolean isZero() {
        return this.value.compareTo(ZERO) == 0;
    }

    public boolean isNegative() {
        return this.value.compareTo(ZERO) < 0;
    }

    public boolean isPositive() {
        return this.value.compareTo(ZERO) >= 0;
    }

    public boolean isEqual(Money other) {
        return this.value.compareTo(other.value) == 0;
    }

    public boolean isLessThan(Money other) {
        return this.value.compareTo(other.value) < 0;
    }

    public boolean isLessThanOrEqual(Money other) {
        return this.value.compareTo(other.value) <= 0;
    }

    public boolean isGreaterThan(Money other) {
        return this.value.compareTo(other.value) > 0;
    }

    public boolean isGreaterThanOrEqual(Money other) {
        return this.value.compareTo(other.value) >= 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Money)) {
            return false;
        }
        return this.value.compareTo(((Money)object).value) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object clone() {
        Money result = new Money(this);
        return result;
    }

    public static class InvalidRoundingModeException
    extends RuntimeException {
        private static final long serialVersionUID = 5658836125641516151L;

        public InvalidRoundingModeException() {
        }

        public InvalidRoundingModeException(String info) {
            super(info);
        }
    }

    public static class InvalidScaleFactorException
    extends RuntimeException {
        private static final long serialVersionUID = -8038085965896123803L;

        public InvalidScaleFactorException() {
        }

        public InvalidScaleFactorException(String info) {
            super(info);
        }
    }
}

