/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.ExtenXLS.DocumentHandle;
import com.extentech.toolkit.DefaultTempFileGeneratorImpl;
import com.extentech.toolkit.JFileWriter;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.TempFileGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TempFileManager {
    public static String TEMPFILE_MANAGER_CLASSNAME = "com.extentech.extenxls.tempfilemanager";

    public static File createTempFile(String prefix, String extension) throws IOException {
        String tmpfu = System.getProperty(TEMPFILE_MANAGER_CLASSNAME);
        if (tmpfu != null) {
            try {
                TempFileGenerator tgen = (TempFileGenerator)Class.forName(tmpfu).newInstance();
                return tgen.createTempFile(prefix, extension);
            }
            catch (Exception e) {
                Logger.logErr("Could not load custom TempFileGenerator: " + tmpfu + ". Falling back to default TempFileGenerator.");
            }
        }
        return new DefaultTempFileGeneratorImpl().createTempFile(prefix, extension);
    }

    public static File createTempFile(InputStream input, String prefix, String extension) throws IOException {
        File tmpfile = TempFileManager.createTempFile(prefix, extension);
        JFileWriter.writeToFile(input, tmpfile);
        return tmpfile;
    }

    public static File createTempFile(String prefix, String extension, File dir) throws IOException {
        prefix = String.valueOf(dir.getAbsolutePath()) + prefix;
        return TempFileManager.createTempFile(prefix, extension);
    }

    public static File writeToTempFile(String prefix, String extension, DocumentHandle doc) throws IOException {
        File file = TempFileManager.createTempFile(prefix, extension);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        doc.write(stream, 0);
        stream.flush();
        stream.close();
        return file;
    }
}

