/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    private Appendable target;
    private CharsetDecoder decoder;
    private float bytesPerChar;
    private ByteBuffer inputBuffer;
    private CharBuffer outputBuffer;

    public WriterOutputStream(Appendable target) {
        this(target, Charset.defaultCharset());
    }

    public WriterOutputStream(Appendable target, String charset) {
        this(target, Charset.forName(charset));
    }

    public WriterOutputStream(Appendable target, Charset charset) {
        this.target = target;
        this.bytesPerChar = charset.newEncoder().maxBytesPerChar();
        this.decoder = charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.inputBuffer = ByteBuffer.allocate((int)Math.ceil(8192.0f * this.bytesPerChar));
        this.outputBuffer = CharBuffer.allocate(8192);
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.decoder == null) {
            throw new IOException("this stream has been closed");
        }
        if ((float)this.inputBuffer.remaining() < this.bytesPerChar) {
            this.decodeInputBuffer();
        }
        if (length <= this.inputBuffer.remaining() || this.inputBuffer.position() > 0) {
            int fill = Math.min(this.inputBuffer.remaining(), length);
            this.inputBuffer.put(buffer, offset, fill);
            if (fill == length) {
                return;
            }
            this.inputBuffer.flip();
            this.decode(this.inputBuffer);
            offset += (fill -= this.inputBuffer.remaining());
            length -= fill;
            this.inputBuffer.clear();
        }
        if (length > this.inputBuffer.remaining()) {
            ByteBuffer tempBuffer = ByteBuffer.wrap(buffer, offset, length);
            this.decode(tempBuffer);
            if (tempBuffer.hasRemaining()) {
                this.inputBuffer.put(tempBuffer);
            }
        } else {
            this.inputBuffer.put(buffer, offset, length);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.decoder == null) {
            throw new IOException("this stream has been closed");
        }
        if (!this.inputBuffer.hasRemaining()) {
            this.decodeInputBuffer();
        }
        this.inputBuffer.put((byte)b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        WriterOutputStream writerOutputStream = this;
        synchronized (writerOutputStream) {
            if (this.decoder == null) {
                throw new IOException("this stream has been closed");
            }
            this.decodeInputBuffer();
        }
        if (this.target instanceof Writer) {
            ((Writer)this.target).flush();
        }
    }

    private void decodeInputBuffer() throws IOException {
        this.inputBuffer.flip();
        this.decode(this.inputBuffer);
        this.inputBuffer.compact();
    }

    private void decode(ByteBuffer bytes) throws IOException {
        CoderResult result;
        do {
            this.outputBuffer.clear();
            result = this.decoder.decode(bytes, this.outputBuffer, false);
            this.outputBuffer.flip();
            this.target.append(this.outputBuffer);
        } while (result == CoderResult.OVERFLOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        WriterOutputStream writerOutputStream = this;
        synchronized (writerOutputStream) {
            CoderResult result;
            if (this.decoder == null) {
                return;
            }
            this.inputBuffer.flip();
            do {
                this.outputBuffer.clear();
                result = this.decoder.decode(this.inputBuffer, this.outputBuffer, true);
                this.outputBuffer.flip();
                this.target.append(this.outputBuffer);
            } while (result == CoderResult.OVERFLOW);
            do {
                this.outputBuffer.clear();
                result = this.decoder.flush(this.outputBuffer);
                this.outputBuffer.flip();
                this.target.append(this.outputBuffer);
            } while (result == CoderResult.OVERFLOW);
            this.inputBuffer = null;
            this.outputBuffer = null;
            this.decoder = null;
        }
        if (this.target instanceof Writer) {
            ((Writer)this.target).close();
        }
    }
}

