/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.Cell;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.CommentHandle;
import com.extentech.ExtenXLS.ConditionalFormatHandle;
import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.DocumentObjectNotFoundException;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.ValidationHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Blank;
import com.extentech.formats.XLS.Boolerr;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.CellPositionConflictException;
import com.extentech.formats.XLS.CellTypeMismatchException;
import com.extentech.formats.XLS.Cf;
import com.extentech.formats.XLS.ColumnNotFoundException;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Hlink;
import com.extentech.formats.XLS.Labelsst;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Note;
import com.extentech.formats.XLS.NumberRec;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.ReferenceTracker;
import com.extentech.formats.XLS.Rk;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.cellformat.CellFormatFactory;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.json.JSONException;
import org.json.JSONObject;

public class CellHandle
implements Cell,
Serializable,
Handle,
Comparable<CellHandle> {
    private static final long serialVersionUID = 4737120893891570607L;
    public static final int TYPE_BLANK = -1;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_FP = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_FORMULA = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int NOTATION_STANDARD = 0;
    public static final int NOTATION_SCIENTIFIC = 1;
    public static final int NOTATION_SCIENTIFIC_EXCEL = 2;
    private transient WorkBook wbh = null;
    private transient WorkSheetHandle wsh = null;
    private ColHandle mycol;
    private RowHandle myrow;
    private FormatHandle formatter;
    private boolean DEBUG = false;
    private XLSRecord mycell;
    short mulblankcolnum = (short)-1;
    static final String begin_hidden_emptycell_xml = "<Cell Address=\"";
    static final String end_hidden_emptycell_xml = "\" StyleID=\"s15\" Hidden=\"true\"><Data Type=\"String\"></Data></Cell>";
    static final String begin_cell_xml = "<Cell Address=\"";
    static final String end_emptycell_xml = "\" StyleID=\"s15\"><Data Type=\"String\"></Data></Cell>";
    static final String end_cell_xml = "</Cell>";

    public XLSRecord getRecord() {
        return this.mycell;
    }

    public void setRecord(XLSRecord rec) {
        this.mycell = rec;
    }

    public CellHandle(BiffRec c) {
        this.mycell = (XLSRecord)c;
    }

    private void setMulblank() {
        if (this.mycell.getOpcode() == 190) {
            if (this.mulblankcolnum == -1) {
                this.mulblankcolnum = ((Mulblank)this.mycell).getColNumber();
                ((Mulblank)this.mycell).setCurrentCell(this.mulblankcolnum);
                ((Mulblank)this.mycell).getIxfe();
            } else if (this.mulblankcolnum != this.mycell.getColNumber()) {
                ((Mulblank)this.mycell).setCurrentCell(this.mulblankcolnum);
                ((Mulblank)this.mycell).getIxfe();
            }
            this.formatter = null;
        }
    }

    public CellHandle(BiffRec c, WorkBook myb) {
        this.mycell = (XLSRecord)c;
        this.setMulblank();
        this.wbh = myb;
    }

    void setFormatHandle() {
        this.setMulblank();
        if (this.formatter != null && this.formatter.getFormatId() == this.mycell.getIxfe()) {
            return;
        }
        this.formatter = this.mycell.getXfRec() != null ? new FormatHandle(this.wbh, this.mycell.myxf) : (this.wbh == null && this.mycell.getWorkBook() != null ? new FormatHandle(this.mycell.getWorkBook(), -1) : new FormatHandle(this.wbh, -1));
        this.formatter.addCell(this.mycell);
    }

    public void setToDefault() {
        this.setVal(this.getDefaultVal());
    }

    public Object getDefaultVal() {
        return this.mycell.getDefaultVal();
    }

    public void setFormatPattern(String pat) {
        this.setFormatHandle();
        this.formatter.setFormatPattern(pat);
    }

    public String getFormatPattern() {
        if (this.getFont() == null) {
            return "";
        }
        return this.mycell.getFormatPattern();
    }

    @Override
    public boolean isDate() {
        if (this.mycell.myxf == null) {
            return false;
        }
        if (this.mycell.isString) {
            return false;
        }
        if (this.mycell.isBoolean) {
            return false;
        }
        if (this.mycell.isBlank) {
            return false;
        }
        return this.mycell.myxf.isDatePattern();
    }

    public boolean isFormula() {
        return this.mycell.isFormula();
    }

    public boolean isFormulaHidden() {
        return this.getFormatHandle().isFormulaHidden();
    }

    public boolean isLocked() {
        return this.getFormatHandle().isLocked();
    }

    public boolean isBlank() {
        return this.mycell.isBlank;
    }

    public boolean isCurrency() {
        if (this.mycell.myxf == null) {
            return false;
        }
        return this.mycell.myxf.isCurrencyPattern();
    }

    public boolean isNumber() {
        return this.mycell.isNumber();
    }

    public void setFontSize(int sz) {
        this.setFormatHandle();
        this.formatter.setFontHeight(sz *= 20);
    }

    public void setFontWeight(int wt) {
        this.setFormatHandle();
        this.formatter.setFontWeight(wt);
    }

    public void setBold(boolean bold) {
        this.setFormatHandle();
        this.formatter.setBold(bold);
    }

    public int getFontWeight() {
        if (this.getFont() == null) {
            return 200;
        }
        return this.mycell.getFont().getFontWeight();
    }

    public int getFontSize() {
        if (this.getFont() == null) {
            return 20;
        }
        return this.mycell.getFont().getFontHeight() / 20;
    }

    public Color getFontColor() {
        if (this.getFont() == null) {
            return FormatHandle.Black;
        }
        int clidx = this.getFont().getColor();
        Xf x = this.mycell.getXfRec();
        short clidb = x.getBackgroundColor();
        if (clidx == 64 && clidb == 64) {
            return FormatHandle.Black;
        }
        if (clidx < this.getWorkBook().getColorTable().length) {
            Color mycolr = this.getWorkBook().getColorTable()[clidx];
            return mycolr;
        }
        return Color.black;
    }

    public void setFontColor(Color col) {
        this.setFormatHandle();
        this.formatter.setFontColor(col);
    }

    public void setForegroundColor(int t) {
        this.setFormatHandle();
        this.formatter.setForegroundColor(t);
    }

    public void setForeColor(int i) {
        if (this.mycell.myxf == null) {
            this.getNewXf();
        }
        this.mycell.myxf.setForeColor(i, null);
    }

    public void setBackgroundColor(int t) {
        this.setFormatHandle();
        this.formatter.setBackgroundColor(t);
    }

    public Color getForegroundColor() {
        short clidx;
        if (this.mycell.getXfRec() != null && (clidx = this.mycell.getXfRec().getForegroundColor()) < this.getWorkBook().getColorTable().length) {
            Color mycolr = this.getWorkBook().getColorTable()[clidx];
            return mycolr;
        }
        return Color.black;
    }

    public void setForegroundColor(Color col) {
        this.setFormatHandle();
        this.formatter.setForegroundColor(col);
    }

    public Color getBackgroundColor() {
        Xf x;
        short clidx;
        if (this.mycell.getXfRec() != null && (clidx = (x = this.mycell.getXfRec()).getBackgroundColor()) < this.getWorkBook().getColorTable().length) {
            Color mycolr = this.getWorkBook().getColorTable()[clidx];
            return mycolr;
        }
        return Color.white;
    }

    public Color getCellBackgroundColor() {
        this.setFormatHandle();
        int clidx = this.formatter.getCellBackgroundColor();
        if (clidx < this.wbh.getWorkBook().getColorTable().length) {
            Color mycolr = this.getWorkBook().getColorTable()[clidx];
            return mycolr;
        }
        return Color.white;
    }

    public void setBackgroundColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBackgroundColor(col);
    }

    public void setCellBackgroundColor(int t) {
        this.setFormatHandle();
        this.formatter.setCellBackgroundColor(t);
    }

    public void setCellBackgroundColor(Color col) {
        this.setFormatHandle();
        this.formatter.setCellBackgroundColor(col);
    }

    public void setPatternBackgroundColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBackgroundColor(col);
    }

    public void setBackgroundPattern(int t) {
        this.setFormatHandle();
        this.formatter.setPattern(t);
    }

    public int getBackgroundPattern() {
        return this.mycell.getXfRec().getFillPattern();
    }

    public int getFillPattern() {
        this.setFormatHandle();
        return this.formatter.getFillPattern();
    }

    public void setBorderColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBorderColor(col);
    }

    public void setBorderRightColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBorderRightColor(col);
    }

    public void setBorderLeftColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBorderLeftColor(col);
    }

    public void setBorderTopColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBorderTopColor(col);
    }

    public void setBorderBottomColor(Color col) {
        this.setFormatHandle();
        this.formatter.setBorderBottomColor(col);
    }

    public String getFontFace() {
        if (this.getFont() == null) {
            return "Arial";
        }
        return this.mycell.getFont().getFontName();
    }

    public void setFontFace(String fn) {
        this.setFormatHandle();
        this.formatter.setFontName(fn);
    }

    public void setBorderLineStyle(short s) {
        this.setFormatHandle();
        this.formatter.setBorderLineStyle(s);
    }

    public void setRightBorderLineStyle(short s) {
        this.setFormatHandle();
        this.formatter.setRightBorderLineStyle(s);
    }

    public void setLeftBorderLineStyle(short s) {
        this.setFormatHandle();
        this.formatter.setLeftBorderLineStyle(s);
    }

    public void setTopBorderLineStyle(short s) {
        this.setFormatHandle();
        this.formatter.setTopBorderLineStyle(s);
    }

    public void setBottomBorderLineStyle(short s) {
        this.setFormatHandle();
        this.formatter.setBottomBorderLineStyle(s);
    }

    public void removeBorder() {
        this.setFormatHandle();
        this.formatter.removeBorders();
    }

    public Font getFont() {
        return this.mycell.getFont();
    }

    public java.awt.Font getAwtFont() {
        String fface = "Arial";
        try {
            fface = this.getFontFace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int sz = 12;
        try {
            sz = this.getFontSize();
        }
        catch (Exception e) {
            sz = 12;
        }
        sz += 4;
        HashMap<TextAttribute, Object> ftmap = new HashMap<TextAttribute, Object>();
        try {
            if (this.getIsUnderlined()) {
                ftmap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ftmap.put(TextAttribute.FAMILY, fface);
        float fx = this.getFontWeight();
        ftmap.put(TextAttribute.SIZE, new Float(sz));
        if (fx == 700.0f) {
            ftmap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            ftmap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        return new java.awt.Font(ftmap);
    }

    public void setFont(String fn, int stl, int sz) {
        this.setFormatHandle();
        this.formatter.setFont(fn, stl, sz);
    }

    public CommentHandle getComment() throws DocumentObjectNotFoundException {
        ArrayList notes = this.mycell.getSheet().getNotes();
        int i = 0;
        while (i < notes.size()) {
            Note n = (Note)notes.get(i);
            if (n.getCellAddressWithSheet().equals(this.getCellAddressWithSheet())) {
                return new CommentHandle(n);
            }
            ++i;
        }
        throw new DocumentObjectNotFoundException("Note record not found at " + this.getCellAddressWithSheet());
    }

    public void removeComment() {
        try {
            CommentHandle note = this.getComment();
            note.remove();
        }
        catch (DocumentObjectNotFoundException documentObjectNotFoundException) {
            // empty catch block
        }
    }

    public CommentHandle createComment(String comment, String author) {
        Note n = this.mycell.getSheet().createNote(this.getCellAddress(), comment, author);
        return new CommentHandle(n);
    }

    public boolean getIsUnderlined() {
        if (this.getFont() == null) {
            return false;
        }
        return this.getFont().getUnderlineStyle() != 0;
    }

    public void setUnderlined(boolean isUnderlined) {
        this.setFormatHandle();
        if (isUnderlined) {
            this.getFont().setUnderlineStyle((byte)1);
        } else {
            this.getFont().setUnderlineStyle((byte)0);
        }
    }

    public void setFontColor(int t) {
        this.setFormatHandle();
        this.formatter.setFontColor(t);
    }

    public CellRange getMergedCellRange() {
        return this.mycell.getMergeRange();
    }

    public boolean isMergeParent() {
        CellRange cr;
        block3: {
            try {
                cr = this.mycell.getMergeRange();
                if (cr != null) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        int[] i = cr.getRangeCoords();
        return this.getRowNum() + 1 == i[0] && this.getColNum() == i[1];
    }

    public ColHandle getCol() {
        try {
            if (this.mycol == null) {
                this.mycol = this.wsh.getCol(this.getColNum());
            }
        }
        catch (ColumnNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return this.mycol;
    }

    public RowHandle getRow() {
        if (this.myrow == null) {
            this.myrow = new RowHandle(this.mycell.getRow(), this.wsh);
        }
        return this.myrow;
    }

    @Override
    public Object getVal() {
        return FormulaHandle.sanitizeValue(this.mycell.getInternalVal());
    }

    public String getCellTypeName() {
        String typename = "Object";
        int tp = this.getCellType();
        switch (tp) {
            case -1: {
                typename = "String";
                break;
            }
            case 0: {
                typename = "String";
                break;
            }
            case 1: {
                typename = "Float";
                break;
            }
            case 2: {
                typename = "Integer";
                break;
            }
            case 3: {
                typename = "Formula";
                break;
            }
            case 5: {
                typename = "Double";
            }
        }
        return typename;
    }

    @Override
    public int getCellType() {
        return this.mycell.getCellType();
    }

    public BiffRec getCell() {
        return this.mycell;
    }

    public Color[] getBorderColors() {
        this.getFormatHandle();
        return this.formatter.getBorderColors();
    }

    public byte[] getBytes() {
        return this.mycell.getData();
    }

    @Override
    public int getColNum() {
        this.setMulblank();
        return this.mycell.getColNumber();
    }

    @Override
    public int getRowNum() {
        return this.mycell.getRowNumber();
    }

    @Override
    public String getCellAddress() {
        this.setMulblank();
        return this.mycell.getCellAddress();
    }

    public int[] getIntLocation() {
        this.setMulblank();
        return this.mycell.getIntLocation();
    }

    public String getCellAddressWithSheet() {
        this.setMulblank();
        return this.mycell.getCellAddressWithSheet();
    }

    public void setBlankRef(int c) {
        this.mulblankcolnum = (short)c;
    }

    @Override
    public String getWorkSheetName() {
        if (this.wsh == null) {
            try {
                return this.mycell.getSheet().getSheetName();
            }
            catch (Exception e) {
                return "";
            }
        }
        return this.wsh.getSheetName();
    }

    public String getStringVal() {
        return this.mycell.getStringVal();
    }

    @Override
    public String getFormattedStringVal() {
        FormatHandle myfmt = this.getFormatHandle();
        return CellFormatFactory.fromPatternString(myfmt.getFormatPattern()).format(this);
    }

    public String getFormattedStringVal(boolean formatForXML) {
        FormatHandle myfmt = this.getFormatHandle();
        String val = this.getVal().toString();
        if (formatForXML) {
            val = OOXMLAdapter.stripNonAscii(val).toString();
        }
        return CellFormatFactory.fromPatternString(myfmt.getFormatPattern()).format(val);
    }

    public String getStringVal(int notation) {
        String numval = this.mycell.getStringVal();
        int i = this.getCellType();
        if (i == 1 || i == 2 || i == 3 || i == 5) {
            return ExcelTools.formatNumericNotation(numval, notation);
        }
        return numval;
    }

    public String getStringVal(String encoding) {
        return this.mycell.getStringVal(encoding);
    }

    @Override
    public int getFormatId() {
        this.setMulblank();
        return this.mycell.getIxfe();
    }

    public int getConditionalFormatId() {
        ConditionalFormatHandle[] cfhandles = this.getConditionalFormatHandles();
        if (cfhandles == null || cfhandles.length == 0) {
            return this.getFormatId();
        }
        Condfmt cfmt = cfhandles[0].getCndfmt();
        for (Cf cx1 : cfmt.getRules()) {
            PtgRef pref;
            if (!cx1.evaluate(pref = new PtgRef(this.getCellAddress(), this.mycell, false))) continue;
            int ret = cfmt.getCfxe();
            return ret;
        }
        return this.getFormatId();
    }

    public void moveToRow(int newrow) throws CellPositionConflictException {
        String newaddr = ExcelTools.getAlphaVal(this.mycell.getColNumber());
        newaddr = String.valueOf(newaddr) + String.valueOf(newrow);
        this.moveTo(newaddr);
    }

    public void moveAndOverwriteToRow(int newrow) {
        String newaddr = ExcelTools.getAlphaVal(this.mycell.getColNumber());
        newaddr = String.valueOf(newaddr) + String.valueOf(newrow);
        this.moveAndOverwriteTo(newaddr);
    }

    public void moveToCol(String newcol) throws CellPositionConflictException {
        String newaddr = newcol;
        newaddr = String.valueOf(newaddr) + String.valueOf(this.mycell.getRowNumber() + 1);
        this.moveTo(newaddr);
    }

    public void copyFormat(CellHandle source) {
        this.getCell().copyFormat(source.getCell());
    }

    public CellHandle copyTo(String newaddr) throws CellPositionConflictException {
        Boundsheet bs = this.mycell.getSheet();
        XLSRecord rec = this.mycell;
        XLSRecord nucell = (XLSRecord)rec.clone();
        int[] rc = ExcelTools.getRowColFromString(newaddr);
        nucell.setRowNumber(rc[0]);
        nucell.setCol((short)rc[1]);
        nucell.setXFRecord(this.mycell.getIxfe());
        bs.addRecord(nucell, rc);
        CellHandle ret = new CellHandle(nucell, this.wbh);
        if (this.mycell.hyperlink != null) {
            ret.setURL(this.getURL());
        }
        ret.setWorkSheetHandle(this.getWorkSheetHandle());
        return ret;
    }

    public void remove(boolean nullme) {
        this.mycell.getSheet().removeCell(this.mycell);
        if (nullme) {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void moveTo(String newaddr) throws CellPositionConflictException {
        Boundsheet bs = this.mycell.getSheet();
        BiffRec oldhand = bs.getCell(newaddr);
        if (oldhand != null) {
            throw new CellPositionConflictException(newaddr);
        }
        bs.moveCell(this.getCellAddress(), newaddr);
        if (this.mycell.hyperlink != null) {
            int[] bnds = ExcelTools.getRowColFromString(this.getCellAddress());
            Hlink hl = this.mycell.hyperlink;
            hl.setRowFirst(bnds[0]);
            hl.setRowLast(bnds[0]);
            hl.setColFirst(bnds[1]);
            hl.setColLast(bnds[1]);
            hl.init();
        }
    }

    public void moveAndOverwriteTo(String newaddr) {
        Boundsheet bs = this.mycell.getSheet();
        BiffRec oldhand = bs.getCell(newaddr);
        bs.moveCell(this.getCellAddress(), newaddr);
        if (this.mycell.hyperlink != null) {
            int[] bnds = ExcelTools.getRowColFromString(this.getCellAddress());
            Hlink hl = this.mycell.hyperlink;
            hl.setRowFirst(bnds[0]);
            hl.setRowLast(bnds[0]);
            hl.setColFirst(bnds[1]);
            hl.setColLast(bnds[1]);
            hl.init();
        }
    }

    public void addConditionalFormat(ConditionalFormatHandle format) {
        format.addCell(this);
    }

    public FormatHandle[] getConditionallyFormattedHandles() {
        ConditionalFormatHandle[] cfhandles = this.getConditionalFormatHandles();
        if (cfhandles != null) {
            FormatHandle[] fmx = new FormatHandle[cfhandles[0].getCndfmt().getRules().size()];
            int t = 0;
            while (t < fmx.length) {
                fmx[t++] = new FormatHandle(cfhandles[0].getCndfmt(), this.wbh, t, this);
                ++t;
            }
            return fmx;
        }
        return null;
    }

    public ConditionalFormatHandle[] getConditionalFormatHandles() {
        WorkSheetHandle sh = this.getWorkSheetHandle();
        if (sh == null) {
            return null;
        }
        ConditionalFormatHandle[] cfs = sh.getConditionalFormatHandles();
        ArrayList<ConditionalFormatHandle> cfhandles = new ArrayList<ConditionalFormatHandle>();
        int i = 0;
        while (i < cfs.length) {
            if (cfs[i].contains(this)) {
                cfhandles.add(cfs[i]);
            }
            ++i;
        }
        ConditionalFormatHandle[] c = new ConditionalFormatHandle[cfhandles.size()];
        return cfhandles.toArray(c);
    }

    public FormatHandle getFormatHandle() {
        if (this.formatter == null) {
            this.setFormatHandle();
        }
        return this.formatter;
    }

    public void setLocked(boolean locked) {
        this.getFormatHandle().setLocked(locked);
    }

    public void setFormulaHidden(boolean hidden) {
        this.getFormatHandle().setFormulaHidden(hidden);
    }

    public void setFormatHandle(FormatHandle f) {
        f.addCell(this.mycell);
        this.formatter = f;
    }

    public void setFormatId(int i) {
        this.mycell.setXFRecord(i);
    }

    public void clearFormats() {
        this.setFormatId(this.getWorkBook().getWorkBook().getDefaultIxfe());
    }

    public void clearContents() {
        this.setVal(null);
    }

    public void clear() {
        this.clearFormats();
        this.clearContents();
    }

    public FormulaHandle getFormulaHandle() throws FormulaNotFoundException {
        Formula f = this.mycell.getFormulaRec();
        if (f == null) {
            throw new FormulaNotFoundException("No Formula for: " + this.getCellAddress());
        }
        FormulaHandle fh = new FormulaHandle(f, this.wbh);
        return fh;
    }

    public String getURL() {
        if (this.mycell.hyperlink != null) {
            return this.mycell.hyperlink.getURL();
        }
        return null;
    }

    public String getURLDescription() {
        if (this.mycell.hyperlink != null) {
            return this.mycell.hyperlink.getDescription();
        }
        return "";
    }

    public boolean hasHyperlink() {
        return this.mycell.hyperlink != null;
    }

    public void setURL(String urlstr) {
        if (urlstr == null) {
            this.mycell.hyperlink = null;
            return;
        }
        this.setURL(urlstr, "", "");
    }

    public void setURL(String urlstr, String desc, String textMark) {
        if (this.mycell.hyperlink != null) {
            this.mycell.hyperlink.setURL(urlstr, desc, textMark);
        } else {
            this.mycell.hyperlink = (Hlink)Hlink.getPrototype();
            this.mycell.hyperlink.setURL(urlstr, desc, textMark);
            int[] bnds = ExcelTools.getRowColFromString(this.getCellAddress());
            this.mycell.hyperlink.setRowFirst(bnds[0]);
            this.mycell.hyperlink.setColFirst(bnds[1]);
            this.mycell.hyperlink.setRowLast(bnds[0]);
            this.mycell.hyperlink.setColLast(bnds[1]);
        }
    }

    public void setFileURL(String fileURLStr) {
        this.setFileURL(fileURLStr, "", "");
    }

    public void setFileURL(String fileURLstr, String desc, String textMark) {
        if (this.mycell.hyperlink != null) {
            this.mycell.hyperlink.setFileURL(fileURLstr, desc, textMark);
        } else {
            this.mycell.hyperlink = (Hlink)Hlink.getPrototype();
            this.mycell.hyperlink.setFileURL(fileURLstr, desc, textMark);
            if (!desc.equals("")) {
                this.setVal(desc);
            }
            int[] bnds = ExcelTools.getRowColFromString(this.getCellAddress());
            this.mycell.hyperlink.setRowFirst(bnds[0]);
            this.mycell.hyperlink.setColFirst(bnds[1]);
            this.mycell.hyperlink.setRowLast(bnds[0]);
            this.mycell.hyperlink.setColLast(bnds[1]);
        }
    }

    public void setVal(Object obj) throws CellTypeMismatchException {
        String formstr22;
        if (this.wbh.getFormulaCalculationMode() != 1) {
            this.clearAffectedCells();
        }
        if (obj instanceof Date) {
            this.setVal((Date)obj, null);
            return;
        }
        if (obj instanceof String && ((formstr22 = (String)obj).indexOf("=") == 0 || formstr22.startsWith("{="))) {
            try {
                this.setFormula(formstr22);
                return;
            }
            catch (Exception a) {
                Logger.logWarn("CellHandle.setVal() failed.  Setting Formula to " + obj.toString() + " failed: " + a);
            }
        }
        try {
            this.setBiffRecValue(obj);
        }
        catch (FunctionNotSupportedException formstr22) {
        }
        catch (Exception e) {
            throw new CellTypeMismatchException(e.toString());
        }
    }

    public void setStringVal(String s) {
        try {
            if ((s == null || s.equals("")) && !(this.mycell instanceof Blank)) {
                this.changeCellType(s);
            } else if (s != null && !s.equals("")) {
                if (!(this.mycell instanceof Labelsst)) {
                    this.changeCellType(" ");
                }
                this.mycell.setStringVal(s);
            }
        }
        catch (Exception e) {
            throw new CellTypeMismatchException(e.toString());
        }
    }

    public void setStringVal(Unicodestring us) {
        try {
            if ((us == null || us.equals("")) && !(this.mycell instanceof Blank)) {
                this.changeCellType(null);
            } else if (us != null && !us.equals("")) {
                if (!(this.mycell instanceof Labelsst)) {
                    this.changeCellType(" ");
                }
                ((Labelsst)this.mycell).setStringVal(us);
            }
        }
        catch (Exception e) {
            throw new CellTypeMismatchException(e.toString());
        }
    }

    public void fireParserEvent() {
    }

    public String toString() {
        String ret = String.valueOf(this.getCellAddress()) + ":" + this.getStringVal();
        if (this.getURL() != null) {
            ret = String.valueOf(ret) + this.getURL();
        }
        return ret;
    }

    public void setVal(double d) throws CellTypeMismatchException {
        this.setVal(new Double(d));
    }

    public void setVal(float f) throws CellTypeMismatchException {
        this.setVal(new Float(f));
    }

    public void setVal(Date dt, String fmt) {
        if (this.wbh.getFormulaCalculationMode() != 1) {
            this.clearAffectedCells();
        }
        if (fmt == null) {
            fmt = "m/d/yyyy";
        }
        this.setVal(new Double(DateConverter.getXLSDateVal(dt)));
        this.setFormatPattern(fmt);
    }

    public void setVal(boolean b) throws CellTypeMismatchException {
        this.setVal((Object)b);
    }

    public void setVal(int i) throws CellTypeMismatchException {
        if (this.mycell.getCellType() == 4) {
            if (i > 0) {
                this.setVal((Object)true);
            } else {
                this.setVal((Object)false);
            }
        } else {
            this.setVal((Object)i);
        }
    }

    public double getDoubleVal() {
        return this.mycell.getDblVal();
    }

    public int getIntVal() {
        return this.mycell.getIntVal();
    }

    public float getFloatVal() {
        return this.mycell.getFloatVal();
    }

    public boolean getBooleanVal() {
        return this.mycell.getBooleanVal();
    }

    public void setFormula(String formStr) throws FunctionNotSupportedException {
        int ixfe = this.mycell.getIxfe();
        this.remove(true);
        this.mycell = this.wsh.add((Object)formStr, (String)this.getCellAddress()).mycell;
        this.mycell.setXFRecord(ixfe);
    }

    public void setFormula(String formStr, Object value) throws Exception {
        if (!(this.mycell instanceof Formula)) {
            int ixfe = this.mycell.getIxfe();
            CellRange cr = this.mycell.getMergeRange();
            int r2 = this.getRowNum();
            int c = this.getColNum();
            this.remove(true);
            this.mycell = this.wsh.add((Object)formStr, (int)r2, (int)c, (int)ixfe).mycell;
            this.mycell.setMergeRange(cr);
        }
        Formula f = (Formula)this.mycell;
        f.setCachedValue(value);
    }

    public void setFormula(Stack newExp, Object value) {
        if (!(this.mycell instanceof Formula)) {
            int ixfe = this.mycell.getIxfe();
            CellRange mccr = this.mycell.getMergeRange();
            int r2 = this.getRowNum();
            int c = this.getColNum();
            this.remove(true);
            this.mycell = this.wsh.add((Object)"=0", (int)r2, (int)c, (int)ixfe).mycell;
            this.mycell.setMergeRange(mccr);
        }
        try {
            Formula f = (Formula)this.mycell;
            f.setExpression(newExp);
            f.setCachedValue(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public int[] getSpan(int row, int column) {
        CellRange mergerange = this.getMergedCellRange();
        if (mergerange != null) {
            if (this.DEBUG) {
                Logger.logInfo("CellHandle " + this.toString() + " getSpan() for range: " + mergerange.toString());
            }
            int[] ret = new int[2];
            try {
                ret[0] = mergerange.getRows().length;
                ret[1] = mergerange.getCols().length;
            }
            catch (Exception e) {
                Logger.logWarn("CellHandle getting CellSpan failed: " + e);
            }
            return ret;
        }
        return null;
    }

    public WorkBook getWorkBook() {
        return this.wbh;
    }

    public int getSheetNum() {
        return this.mycell.getSheet().getSheetNum();
    }

    public WorkSheetHandle getWorkSheetHandle() {
        return this.wsh;
    }

    public boolean isDefaultCell() {
        return this.getCellType() == -1 && (this.getFormatId() == 15 && !this.wbh.getWorkBook().getIsExcel2007() || this.getFormatId() == 0) && this.getMergedCellRange() == null && this.getURL() == null && this.getValidationHandle() == null;
    }

    public void setWorkSheetHandle(WorkSheetHandle handle) {
        this.wsh = handle;
    }

    public String getXML() {
        return this.getXML(null);
    }

    public String getXML(int[] mergedRange) {
        String typename;
        StringBuffer retval;
        Object val;
        String hlink;
        String csp;
        String hd;
        String sv;
        String fvl;
        String vl;
        block29: {
            vl = "";
            fvl = "";
            sv = "";
            hd = "";
            csp = "";
            hlink = "";
            val = null;
            retval = new StringBuffer();
            typename = this.getCellTypeName();
            if (typename.equals("Formula")) {
                try {
                    FormulaHandle fmh = this.getFormulaHandle();
                    String fms = fmh.getFormulaString();
                    fvl = fms.indexOf("\"") > 0 ? " Formula='" + StringTool.convertXMLChars(fms) + "'" : " Formula=\"" + StringTool.convertXMLChars(fms) + "\"";
                    try {
                        if (this.wbh.getWorkBook().getCalcMode() != 1) {
                            val = fmh.calculate();
                        } else {
                            try {
                                val = fmh.getStringVal();
                            }
                            catch (Exception e) {
                                Logger.logWarn("CellHandle.getXML formula calc failed: " + e.toString());
                            }
                        }
                        if (val instanceof Float) {
                            typename = "Float";
                            break block29;
                        }
                        if (val instanceof Double) {
                            typename = "Double";
                            break block29;
                        }
                        if (val instanceof Integer) {
                            typename = "Integer";
                            break block29;
                        }
                        if (val instanceof java.util.Date || val instanceof Date || val instanceof Timestamp) {
                            typename = "DateTime";
                            break block29;
                        }
                        typename = "String";
                    }
                    catch (Exception e) {
                        typename = "String";
                    }
                }
                catch (Exception e) {
                    Logger.logErr("ExtenXLS.getXML() failed getting type of Formula for: " + this.toString(), e);
                }
            }
        }
        if (this.isDate()) {
            typename = "DateTime";
        }
        if (this.mycell.getOpcode() != 190) {
            sv = " StyleID=\"s" + this.getFormatId() + "\"";
            if (mergedRange != null) {
                csp = String.valueOf(csp) + " MergeAcross=\"" + (mergedRange[3] - mergedRange[1]) + "\"";
                csp = String.valueOf(csp) + " MergeDown=\"" + (mergedRange[2] - mergedRange[0]) + "\"";
            }
            if (this.getCol().isHidden()) {
                hd = " Hidden=\"true\"";
            }
            if (this.getURL() != null) {
                hlink = " HRef=\"" + StringTool.convertXMLChars(this.getURL()) + "\"";
            }
            retval.append("<Cell Address=\"" + this.getCellAddress() + "\"" + sv + csp + fvl + hd + hlink + "><Data Type=\"" + typename + "\">");
            if (typename.equals("DateTime")) {
                retval.append(DateConverter.getFormattedDateVal(this));
            } else if (this.getCellType() == 0) {
                val = this.getStringVal();
                if (!val.equals("")) {
                    retval.append(StringTool.convertXMLChars(val.toString()));
                }
            } else {
                try {
                    val = this.getVal();
                    retval.append(String.valueOf(StringTool.convertXMLChars(val.toString())) + vl);
                }
                catch (Exception e) {
                    Logger.logErr("CellHandle.getXML failed for: " + this.getCellAddress() + " in: " + this.getWorkBook().toString(), e);
                    retval.append("XML ERROR!");
                }
            }
            retval.append("</Data>");
            retval.append(end_cell_xml);
        } else {
            int c = ((Mulblank)this.mycell).getColFirst();
            int lastcol = ((Mulblank)this.mycell).getColLast();
            while (c <= lastcol) {
                this.mulblankcolnum = (short)c;
                sv = " StyleID=\"s" + this.getFormatId() + "\"";
                if (this.getCol().isHidden()) {
                    hd = " Hidden=\"true\"";
                }
                if (this.getURL() != null) {
                    hlink = " HRef=\"" + StringTool.convertXMLChars(this.getURL()) + "\"";
                }
                retval.append("<Cell Address=\"" + this.getCellAddress() + "\"" + sv + csp + fvl + hd + hlink + "><Data Type=\"" + typename + "\"/>");
                retval.append(end_cell_xml);
                ++c;
            }
        }
        return retval.toString();
    }

    public void setHorizontalAlignment(int align) {
        this.setFormatHandle();
        this.formatter.setHorizontalAlignment(align);
    }

    public int getHorizontalAlignment() {
        if (this.mycell.getXfRec() != null) {
            return this.mycell.getXfRec().getHorizontalAlignment();
        }
        return 0;
    }

    public void setVerticalAlignment(int align) {
        this.setFormatHandle();
        this.formatter.setVerticalAlignment(align);
    }

    public int getVerticalAlignment() {
        if (this.mycell.getXfRec() != null) {
            return this.mycell.getXfRec().getVerticalAlignment();
        }
        return 1;
    }

    public void setWrapText(boolean wrapit) {
        this.setFormatHandle();
        this.formatter.setWrapText(wrapit);
        if (wrapit) {
            try {
                if (!this.getRow().isAlteredHeight()) {
                    this.getRow().setRowHeightAutoFit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getWrapText() {
        if (this.mycell.getXfRec() != null) {
            return this.mycell.getXfRec().getWrapText();
        }
        return false;
    }

    public void setCellRotation(int align) {
        this.setFormatHandle();
        this.formatter.setCellRotation(align);
    }

    public int getCellRotation() {
        if (this.mycell.getXfRec() != null) {
            return this.mycell.getXfRec().getRotation();
        }
        return 0;
    }

    @Override
    public int compareTo(CellHandle that) {
        int comp = this.getRowNum() - that.getRowNum();
        if (comp != 0) {
            return comp;
        }
        return this.getColNum() - that.getColNum();
    }

    public boolean equals(Object that) {
        if (!(that instanceof CellHandle)) {
            return false;
        }
        return this.mycell.equals(((CellHandle)that).mycell);
    }

    public int hashCode() {
        return this.mycell.hashCode();
    }

    public void setScript(int ss) {
        if (this.mycell.myxf == null) {
            this.getNewXf();
        }
        this.mycell.myxf.getFont().setScript(ss);
    }

    private void setBiffRecValue(Object obj) throws CellTypeMismatchException {
        if (this.mycell.getOpcode() == 513 || this.mycell.getOpcode() == 190) {
            this.changeCellType(obj);
        } else if (obj == null) {
            this.changeCellType(obj);
        } else if (obj instanceof Float || obj instanceof Double || obj instanceof Integer || obj instanceof Long) {
            if (this.mycell instanceof NumberRec || this.mycell instanceof Rk) {
                if (obj instanceof Float) {
                    Float f = (Float)obj;
                    this.mycell.setFloatVal(f.floatValue());
                } else if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    this.mycell.setIntVal(i);
                } else if (obj instanceof Double) {
                    Double d = (Double)obj;
                    this.mycell.setDoubleVal(d);
                } else if (obj instanceof Long) {
                    Long d = (Long)obj;
                    this.mycell.setDoubleVal(d.longValue());
                }
            } else {
                this.changeCellType(obj);
            }
        } else if (obj instanceof Boolean) {
            if (this.mycell instanceof Boolerr) {
                ((Boolerr)this.mycell).setBooleanVal((Boolean)obj);
            } else {
                this.changeCellType(obj);
            }
        } else if (obj instanceof String) {
            if (((String)obj).startsWith("=")) {
                this.changeCellType(obj);
            } else if (!obj.toString().equalsIgnoreCase("")) {
                if (this.mycell instanceof Labelsst) {
                    this.mycell.setStringVal(String.valueOf(obj));
                } else {
                    this.changeCellType(obj);
                }
            } else if (!(this.mycell instanceof Blank)) {
                this.changeCellType(obj);
            }
        }
    }

    private void changeCellType(Object obj) {
        int[] rc = new int[]{this.mycell.getRowNumber(), this.mycell.getColNumber()};
        Boundsheet bs = this.mycell.getSheet();
        int oldXf = this.mycell.getIxfe();
        bs.removeCell(this.mycell);
        BiffRec addedrec = bs.addValue(obj, rc, true);
        this.mycell = (XLSRecord)addedrec;
        this.mycell.setXFRecord(oldXf);
    }

    private Xf getNewXf() {
        if (this.mycell.myxf != null) {
            return this.mycell.myxf;
        }
        try {
            this.mycell.myxf = new Xf(this.getFont().getIdx());
            int insertIdx = this.mycell.getWorkBook().getXf(this.mycell.getWorkBook().getNumXfs() - 1).getRecordIndex();
            this.mycell.myxf.setSheet(null);
            this.mycell.getWorkBook().getStreamer().addRecordAt(this.mycell.myxf, insertIdx + 1);
            this.mycell.getWorkBook().addRecord(this.mycell.myxf, false);
            int xfe = this.mycell.myxf.getIdx();
            this.mycell.setIxfe(xfe);
            return this.mycell.myxf;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String getEmptyCellXML(String loc, boolean isVisible) {
        if (!isVisible) {
            return "<Cell Address=\"" + loc + end_hidden_emptycell_xml;
        }
        return "<Cell Address=\"" + loc + end_emptycell_xml;
    }

    public List calculateAffectedCells() {
        ReferenceTracker rt = this.wbh.getWorkBook().getRefTracker();
        Iterator its = rt.clearAffectedFormulaCells(this).values().iterator();
        ArrayList<CellHandle> ret = new ArrayList<CellHandle>();
        while (its.hasNext()) {
            CellHandle cx = new CellHandle((BiffRec)its.next(), this.wbh);
            ret.add(cx);
        }
        return ret;
    }

    protected void clearAffectedCells() {
        ReferenceTracker rt = this.wbh.getWorkBook().getRefTracker();
        rt.clearAffectedFormulaCells(this);
    }

    public List<CellHandle> calculateAffectedCellsOnSheet() {
        Iterator its = this.wbh.getWorkBook().getRefTracker().clearAffectedFormulaCellsOnSheet(this, this.getWorkSheetName()).values().iterator();
        ArrayList<CellHandle> ret = new ArrayList<CellHandle>();
        while (its.hasNext()) {
            CellHandle cx = new CellHandle((BiffRec)its.next(), this.wbh);
            ret.add(cx);
        }
        return ret;
    }

    public void clearChartReferences() {
        ArrayList ret = new ArrayList();
        for (Ai ai : this.wbh.getWorkBook().getRefTracker().getChartReferences(this.getCell())) {
            if (ai.getParentChart() == null) continue;
            ai.getParentChart().setMetricsDirty();
        }
    }

    public static final CellHandle copyCellToWorkSheet(CellHandle sourcecell, WorkSheetHandle newsheet, int row, int col) throws CellPositionConflictException, CellNotFoundException {
        return CellHandle.copyCellToWorkSheet(sourcecell, newsheet, row, col, false);
    }

    public static CellHandle copyCellToWorkSheet(CellHandle sourcecell, WorkSheetHandle newsheet, int row, int col, boolean copyByValue) {
        CellHandle newcell = null;
        int[] offsets = new int[]{row - sourcecell.getRowNum(), col - sourcecell.getColNum()};
        if (sourcecell.isFormula() && !copyByValue) {
            try {
                FormulaHandle fmh = sourcecell.getFormulaHandle();
                newcell = newsheet.add((Object)fmh.getFormulaString(), row, col);
                FormulaHandle fm2 = newcell.getFormulaHandle();
                FormulaHandle.moveCellRefs(fm2, offsets);
            }
            catch (FormulaNotFoundException ex) {
                newcell = null;
            }
        }
        if (newcell == null) {
            newcell = newsheet.add(sourcecell.getVal(), row, col);
        }
        return CellHandle.copyCellHelper(sourcecell, newcell);
    }

    public static final CellHandle copyCellToWorkSheet(CellHandle sourcecell, WorkSheetHandle newsheet) {
        CellHandle newcell = null;
        try {
            FormulaHandle fmh = sourcecell.getFormulaHandle();
            newcell = newsheet.add(fmh.getFormulaString(), sourcecell.getCellAddress());
        }
        catch (FormulaNotFoundException ex) {
            newcell = newsheet.add(sourcecell.getVal(), sourcecell.getCellAddress());
        }
        return CellHandle.copyCellHelper(sourcecell, newcell);
    }

    public String getJSON() {
        return this.getJSONObject().toString();
    }

    public JSONObject getJSONObject() {
        CellRange cr = this.getMergedCellRange();
        int[] mergedCellRange = null;
        if (cr != null) {
            try {
                Mulblank m;
                mergedCellRange = cr.getRangeCoords();
                if (this.mycell.getOpcode() == 190 && !cr.contains((m = (Mulblank)this.mycell).getIntLocation())) {
                    mergedCellRange = null;
                }
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
        }
        return this.getJSONObject(mergedCellRange);
    }

    @Deprecated
    public JSONObject getJSONObject(int[] mergedRange) {
        JSONObject theCell = new JSONObject();
        try {
            int alignment;
            JSONObject dataval;
            String typename;
            Object val;
            block47: {
                theCell.put("loc", (Object)this.getCellAddress());
                try {
                    val = this.getVal();
                    if (val == null) {
                        val = "";
                    }
                }
                catch (Exception ex) {
                    Logger.logWarn("new JSONObjectObject failed: " + ex.toString());
                    val = "#ERR!";
                }
                typename = this.getCellTypeName();
                dataval = new JSONObject();
                if (typename.equals("Formula")) {
                    try {
                        FormulaHandle fmh = this.getFormulaHandle();
                        String fms = fmh.getFormulaString();
                        theCell.put("fm", (Object)fms);
                        try {
                            if (Float.parseFloat(val.toString()) == Float.NaN) {
                                typename = "Float";
                                break block47;
                            }
                            if (val instanceof Float) {
                                typename = "Float";
                                break block47;
                            }
                            if (val instanceof Double) {
                                typename = "Double";
                                break block47;
                            }
                            if (val instanceof Integer) {
                                typename = "Integer";
                                break block47;
                            }
                            if (val instanceof java.util.Date || val instanceof Date || val instanceof Timestamp) {
                                typename = "DateTime";
                                break block47;
                            }
                            typename = "String";
                        }
                        catch (Exception e) {
                            typename = "String";
                        }
                    }
                    catch (Exception e) {
                        Logger.logErr("new JSONObject() failed getting type of Formula for: " + this.toString(), e);
                    }
                }
            }
            if (this.isDate()) {
                typename = "DateTime";
            }
            dataval.put("t", (Object)typename);
            theCell.put("sid", this.getConditionalFormatId());
            if (mergedRange != null) {
                theCell.put("MergeAcross", mergedRange[3] - mergedRange[1]);
                theCell.put("MergeDown", mergedRange[2] - mergedRange[0]);
                if (this.isMergeParent()) {
                    theCell.put("MergeParent", true);
                } else {
                    theCell.put("MergeChild", true);
                }
            }
            try {
                if (this.getCol().isHidden()) {
                    theCell.put("Hidden", true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.isFormulaHidden()) {
                    theCell.put("fhd", true);
                }
                theCell.put("lck", this.isLocked());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                ValidationHandle vh = this.getValidationHandle();
                if (vh != null) {
                    theCell.put("vm", (Object)(String.valueOf(vh.getPromptBoxTitle()) + ":" + vh.getPromptBoxText()));
                }
            }
            catch (Exception vh) {
                // empty catch block
            }
            if (this.getURL() != null) {
                theCell.put("HRef", (Object)this.getURL());
            }
            if (this.getWrapText()) {
                theCell.put("wrap", true);
            }
            if ((alignment = this.getFormatHandle().getHorizontalAlignment()) == 3) {
                theCell.put("txtAlign", (Object)"right");
            } else if (alignment == 2) {
                theCell.put("txtAlign", (Object)"center");
            } else if (alignment == 1) {
                theCell.put("txtAlign", (Object)"left");
            }
            if (typename.equals("DateTime") && val != null && !val.equals("")) {
                dataval.put("v", (Object)this.getFormattedStringVal());
                dataval.put("time", DateConverter.getCalendarFromCell(this).getTimeInMillis());
            } else if (this.getCellType() == 0) {
                if (((String)val).indexOf("\n") > -1) {
                    val = ((String)val).replaceAll("\n", "<br/>");
                }
                if (!val.equals("")) {
                    dataval.put("v", (Object)val.toString());
                }
            } else {
                dataval.put("v", (Object)val.toString());
                try {
                    String s = this.getFormatPattern();
                    if (!s.equals("")) {
                        Double d;
                        String fmtd = this.getFormattedStringVal();
                        if (!val.equals(fmtd)) {
                            dataval.put("fv", (Object)fmtd);
                        }
                        if (s.indexOf("Red") > -1 && (d = new Double(val.toString())) < 0.0) {
                            theCell.put("negRed", (Object)"1");
                            if (fmtd.indexOf("-") == 0) {
                                fmtd = fmtd.substring(1, fmtd.length());
                            }
                            dataval.put("fv", (Object)fmtd);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            theCell.put("d", (Object)dataval);
        }
        catch (JSONException e) {
            Logger.logErr("error getting JSON for the cell: " + (Object)((Object)e));
        }
        return theCell;
    }

    public ValidationHandle getValidationHandle() {
        ValidationHandle ret = null;
        try {
            ret = this.getWorkSheetHandle().getValidationHandle(this.getCellAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    protected static final CellHandle copyCellHelper(CellHandle sourcecell, CellHandle newcell) {
        int rz = sourcecell.getRow().getHeight();
        newcell.getRow().setHeight(rz);
        if (sourcecell.getRow().isHidden()) {
            newcell.getRow().setHidden(true);
        }
        int rzx = sourcecell.getCol().getWidth();
        newcell.getCol().setWidth(rzx);
        if (sourcecell.getCol().isHidden()) {
            newcell.getCol().setHidden(true);
        }
        try {
            CellRange rng = sourcecell.getMergedCellRange();
            if (rng != null) {
                rng = new CellRange(rng.getRange(), newcell.getWorkBook());
                rng.addCellToRange(newcell);
                rng.mergeCells(false);
            }
            Xf origxf = sourcecell.getWorkBook().getWorkBook().getXf(sourcecell.getFormatId());
            newcell.getFormatHandle().addXf(origxf);
            return newcell;
        }
        catch (Exception ex) {
            Logger.logErr("CellHandle.copyCellHelper failed.", ex);
            return newcell;
        }
    }
}

