/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.Cell;
import com.extentech.ExtenXLS.CellComparator;
import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRangeRef;
import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Blank;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.CellRec;
import com.extentech.formats.XLS.ColumnNotFoundException;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.Mergedcells;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.RowNotFoundException;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgMemFunc;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CellRange
implements Serializable {
    Condfmt cfx = null;
    private static final long serialVersionUID = -3609881364824289079L;
    private boolean ismerged = false;
    private BiffRec parent = null;
    public static final boolean REMOVE_MERGED_CELLS = true;
    public static final boolean RETAIN_MERGED_CELLS = false;
    public boolean DEBUG = false;
    private boolean isDirty = false;
    int firstcellrow = -1;
    int firstcellcol = -1;
    int lastcellrow = -1;
    int lastcellcol = -1;
    private boolean createBlanks = false;
    private boolean initializeCells = true;
    public transient CellHandle[] cells;
    protected transient String range;
    protected transient String sheetname;
    protected transient WorkBook mybook;
    private transient WorkSheetHandle sheet = null;
    private int[] myrowints;
    private int[] mycolints;
    private transient RowHandle[] myrows;
    private transient ColHandle[] mycols;
    protected int externalLink1 = 0;
    protected int externalLink2 = 0;
    FormatHandle fmtr = null;
    boolean wholeCol = false;
    boolean wholeRow = false;
    public static String xmlResponsePre = "<CellRange>";
    public static String xmlResponsePost = "</CellRange>";
    public static final int COPY_CONTENTS = 1;
    public static final int COPY_FORMULAS = 2;
    public static final int COPY_FORMATS = 256;

    protected Condfmt getConditionalFormat() {
        return this.cfx;
    }

    protected CellRange(WorkSheetHandle sheet, int row, int col, int width, int height) {
        this.sheet = sheet;
        this.sheetname = sheet.getSheetName();
        this.mybook = sheet.getWorkBook();
        this.firstcellrow = row;
        this.firstcellcol = col;
        this.lastcellrow = row + height - 1;
        this.lastcellcol = col + width - 1;
        this.range = String.valueOf(this.sheetname) + "!" + ExcelTools.formatRange(new int[]{this.firstcellcol, this.firstcellrow, this.lastcellcol, this.lastcellrow});
        this.cells = new CellHandle[width * height];
    }

    public CellRange(CellRangeRef source, boolean init, boolean create) {
        this.initializeCells = init;
        this.createBlanks = create;
        this.sheet = source.getFirstSheet();
        if (this.sheet == null || source.isMultiSheet()) {
            throw new IllegalArgumentException("the source range must have a single resolved sheet");
        }
        this.mybook = this.sheet.getWorkBook();
        this.sheetname = this.sheet.getSheetName();
        this.range = source.toString();
        try {
            this.init();
        }
        catch (CellNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public CellRange(CellRangeRef source) {
        this(source, false, true);
    }

    public void clearFormats() {
        int idx = 0;
        while (idx < this.cells.length) {
            if (this.cells[idx] != null) {
                this.cells[idx].clearFormats();
            }
            ++idx;
        }
    }

    public void clearContents() {
        int idx = 0;
        while (idx < this.cells.length) {
            if (this.cells[idx] != null) {
                this.cells[idx].clearContents();
            }
            ++idx;
        }
    }

    public void clear() {
        int idx = 0;
        while (idx < this.cells.length) {
            if (this.cells[idx] != null) {
                this.cells[idx].clear();
            }
            ++idx;
        }
    }

    public void removeCells() {
        int idx = 0;
        while (idx < this.cells.length) {
            if (this.cells[idx] != null) {
                this.cells[idx].remove(true);
            }
            ++idx;
        }
    }

    public void unMergeCells() throws Exception {
        BiffRec[] mycells = this.getCellRecs();
        int t = 0;
        while (t < mycells.length) {
            mycells[t].setMergeRange(null);
            mycells[t].getXfRec().setMerged(false);
            ++t;
        }
        Mergedcells mc = this.getSheet().getSheet().getMergedCellsRec();
        if (mc != null) {
            mc.removeCellRange(this);
        }
        this.ismerged = false;
    }

    public void setFormatID(int fmtID) throws Exception {
        BiffRec[] mycells = this.getCellRecs();
        int t = 0;
        while (t < mycells.length) {
            mycells[t].setXFRecord(fmtID);
            ++t;
        }
    }

    public void setURL(String url) throws Exception {
        BiffRec[] mycells = this.getCellRecs();
        int t = 0;
        while (t < mycells.length) {
            new CellHandle(mycells[t], this.mybook).setURL(url);
            ++t;
        }
    }

    public void mergeCells(boolean remove) {
        this.createBlanks();
        if (remove) {
            this.mergeCellsClearFollowingCells();
        } else {
            this.mergeCellsKeepFollowingCells();
        }
    }

    private void mergeCellsClearFollowingCells() {
        BiffRec[] mycells = this.getCellRecs();
        Xf r2 = mycells[0].getXfRec();
        if (r2 == null) {
            this.fmtr = new FormatHandle(this.getWorkBook());
            this.fmtr.addCell(mycells[0]);
            r2 = mycells[0].getXfRec();
        }
        r2.setMerged(true);
        int t = 0;
        while (t < mycells.length) {
            if (mycells[t] != null) {
                mycells[t].setSheet(this.getSheet().getMysheet());
            }
            mycells[t].setMergeRange(this);
            if (t > 0 && !(mycells[t] instanceof Blank)) {
                String cellname = mycells[t].getCellAddress();
                Boundsheet sheet = mycells[t].getSheet();
                mycells[t].remove(true);
                sheet.addValue(null, cellname);
            }
            ++t;
        }
        Mergedcells mc = this.getSheet().getSheet().getMergedCellsRec();
        if (mc == null) {
            mc = this.getSheet().getSheet().addMergedCellRec();
        }
        mc.addCellRange(this);
        this.ismerged = true;
    }

    private void mergeCellsKeepFollowingCells() {
        BiffRec[] mycells = this.getCellRecs();
        int t = 0;
        while (t < mycells.length) {
            mycells[t].setMergeRange(this);
            Xf r2 = mycells[t].getXfRec();
            if (r2 == null) {
                this.fmtr = new FormatHandle(this.getWorkBook());
                this.fmtr.addCellRange(this);
                r2 = mycells[t].getXfRec();
            }
            r2.setMerged(true);
            ++t;
        }
        Mergedcells mc = this.getSheet().getSheet().getMergedCellsRec();
        if (mc == null) {
            mc = this.getSheet().getSheet().addMergedCellRec();
        }
        mc.addCellRange(this);
        this.ismerged = true;
    }

    public int getWidth() {
        return this.lastcellcol - this.firstcellcol + 1;
    }

    public int getHeight() {
        return this.lastcellrow - this.firstcellrow + 1;
    }

    public int[] getRowInts() {
        if (this.myrowints != null) {
            return this.myrowints;
        }
        int numrows = this.lastcellrow + 1 - this.firstcellrow;
        this.myrowints = new int[numrows];
        int t = 0;
        while (t < numrows) {
            this.myrowints[t] = this.firstcellrow + t;
            ++t;
        }
        return this.myrowints;
    }

    public int[] getColInts() {
        if (this.mycolints != null) {
            return this.mycolints;
        }
        int numcols = this.lastcellcol + 1 - this.firstcellcol;
        this.mycolints = new int[numcols];
        int t = 0;
        while (t < numcols) {
            this.mycolints[t] = this.firstcellcol + t;
            ++t;
        }
        return this.mycolints;
    }

    public RowHandle[] getRows() throws RowNotFoundException {
        if (this.myrows != null) {
            return this.myrows;
        }
        int numrows = this.lastcellrow + 1 - this.firstcellrow;
        this.myrows = new RowHandle[numrows];
        int t = 0;
        while (t < numrows) {
            RowHandle rx = null;
            try {
                rx = this.sheet.getRow(this.firstcellrow - 1 + t);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myrows[t] = rx;
            ++t;
        }
        return this.myrows;
    }

    public int getNumberOfRows() {
        int numRows = this.lastcellrow + 1 - this.firstcellrow;
        return numRows;
    }

    public ColHandle[] getCols() throws ColumnNotFoundException {
        if (this.mycols != null) {
            return this.mycols;
        }
        int numcols = this.lastcellcol + 1 - this.firstcellcol;
        this.mycols = new ColHandle[numcols];
        int t = 0;
        while (t < numcols) {
            this.mycols[t] = this.sheet.getCol(this.firstcellcol + t);
            ++t;
        }
        return this.mycols;
    }

    public int getNumberOfCols() {
        int numCols = this.lastcellcol + 1 - this.firstcellcol;
        return numCols;
    }

    public int[] getEdgePositions(CellHandle ch, int sz) {
        int[] coords = new int[4];
        String adr = ch.getCellAddress();
        int[] rc = ExcelTools.getRowColFromString(adr);
        rc[0] = rc[0] + 1;
        if (rc[0] == this.firstcellrow) {
            coords[0] = sz;
        }
        if (rc[0] == this.lastcellrow) {
            coords[2] = sz;
        }
        if (rc[1] == this.firstcellcol) {
            coords[1] = sz;
        }
        if (rc[1] == this.lastcellcol) {
            coords[3] = sz;
        }
        return coords;
    }

    public boolean intersects(CellRange cr) {
        try {
            int[] rc = cr.getRangeCoords();
            if (rc[0] >= this.firstcellrow && rc[2] <= this.lastcellrow && rc[1] >= this.firstcellcol && rc[3] <= this.lastcellcol) {
                return true;
            }
        }
        catch (CellNotFoundException e) {
            Logger.logWarn("CellRange unable to determine intersection of range: " + cr.toString());
        }
        return false;
    }

    public boolean contains(Cell cxx) {
        String chsheet = cxx.getWorkSheetName();
        String mysheet = "";
        if (this.getSheet() != null) {
            mysheet = this.getSheet().getSheetName();
        }
        if (!chsheet.equalsIgnoreCase(mysheet)) {
            return false;
        }
        String adr = cxx.getCellAddress();
        int[] rc = ExcelTools.getRowColFromString(adr);
        return this.contains(rc);
    }

    public boolean contains(int[] rc) {
        boolean ret = true;
        if (rc[0] + 1 < this.firstcellrow) {
            ret = false;
        }
        if (rc[0] + 1 > this.lastcellrow) {
            ret = false;
        }
        if (rc[1] < this.firstcellcol) {
            ret = false;
        }
        if (rc[1] > this.lastcellcol) {
            ret = false;
        }
        return ret;
    }

    public String toString() {
        return this.range;
    }

    public CellRange(WorkSheetHandle sht, int[] coords, boolean cb) throws Exception {
        this.createBlanks = cb;
        this.sheet = sht;
        this.mybook = sht.wbh;
        this.sheetname = sht.getSheetName();
        this.sheetname = GenericPtg.qualifySheetname(this.sheetname);
        String addr = String.valueOf(this.sheetname) + "!";
        String c1 = String.valueOf(ExcelTools.getAlphaVal(coords[1])) + String.valueOf(coords[0] + 1);
        String c2 = String.valueOf(ExcelTools.getAlphaVal(coords[3])) + String.valueOf(coords[2] + 1);
        this.range = addr = String.valueOf(addr) + c1 + ":" + c2;
        this.init();
    }

    public void setAsPrintArea() {
        if (this.sheet == null) {
            Logger.logErr("CellRange.setAsPrintArea() failed: " + this.toString() + " does not have a valid Sheet reference.");
            return;
        }
        this.sheet.setPrintArea(this);
    }

    public CellRange(WorkSheetHandle sht, int[] coords) throws Exception {
        this(sht, coords, false);
    }

    public CellRange(String r2) {
        this.range = r2;
    }

    public boolean addCellToRange(CellHandle ch) {
        String sheetname = ch.getWorkSheetName();
        if (sheetname == null) {
            Logger.logWarn("Cell " + ch.toString() + " NOT added to Range: " + this.toString());
            return false;
        }
        if (!sheetname.equalsIgnoreCase(this.getSheet().getSheetName())) {
            Logger.logWarn("Cell " + ch.toString() + " NOT added to Range: " + this.toString());
            return false;
        }
        int[] rc = new int[]{ch.getRowNum(), ch.getColNum()};
        rc[0] = rc[0] + 1;
        if (this.firstcellrow == -1) {
            this.firstcellrow = rc[0];
        }
        if (this.firstcellcol == -1) {
            this.firstcellcol = rc[1];
        }
        if (this.lastcellrow == -1) {
            this.lastcellrow = rc[0];
        }
        if (this.lastcellcol == -1) {
            this.lastcellcol = rc[1];
        }
        if (rc[0] < this.firstcellrow) {
            --this.firstcellrow;
        }
        if (rc[1] < this.firstcellcol) {
            --this.firstcellcol;
        }
        if (rc[0] > this.lastcellrow) {
            ++this.lastcellrow;
        }
        if (rc[1] > this.lastcellcol) {
            ++this.lastcellcol;
        }
        String newrange = String.valueOf(this.getSheet().getSheetName()) + "!";
        String newcellrange = "";
        newcellrange = String.valueOf(newcellrange) + ExcelTools.getAlphaVal(this.firstcellcol);
        newcellrange = String.valueOf(newcellrange) + String.valueOf(this.firstcellrow);
        newcellrange = String.valueOf(newcellrange) + ":";
        newcellrange = String.valueOf(newcellrange) + ExcelTools.getAlphaVal(this.lastcellcol);
        newcellrange = String.valueOf(newcellrange) + String.valueOf(this.lastcellrow);
        this.range = String.valueOf(newrange) + newcellrange;
        this.isDirty = true;
        if (this.parent != null && this.parent.getOpcode() == 24) {
            ((Name)this.parent).setLocation(this.range);
        }
        return false;
    }

    public CellHandle[] getCells() {
        if (this.isDirty) {
            try {
                this.init();
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
        }
        return this.cells;
    }

    public List<CellHandle> getCellList() {
        return Arrays.asList(this.cells);
    }

    public BiffRec[] getCellRecs() {
        CellHandle[] ch = this.getCells();
        BiffRec[] ret = new BiffRec[ch.length];
        int t = 0;
        while (t < ret.length) {
            if (ch[t] != null) {
                ret[t] = ch[t].getCell();
            }
            ++t;
        }
        return ret;
    }

    public int getIncrementAmount() throws Exception {
        CellHandle[] ch = this.getCells();
        if (ch.length == 1) {
            throw new Exception("Cannot have increment with non-range cell");
        }
        boolean initialized = false;
        int incAmount = 0;
        int i = 1;
        while (i < ch.length) {
            int value1 = ch[i - 1].getIntVal();
            int value2 = ch[i].getIntVal();
            if (!initialized) {
                incAmount = value2 - value1;
                initialized = true;
            } else if (value2 - value1 != incAmount) {
                throw new Exception("Inconsistent values across increment");
            }
            ++i;
        }
        if (!initialized) {
            throw new Exception("Error determining increment");
        }
        return incAmount;
    }

    public CellRange(String range, WorkBook bk, boolean createblanks, boolean initcells) {
        this.createBlanks = createblanks;
        this.initializeCells = initcells;
        this.range = range;
        if (bk == null) {
            return;
        }
        this.setWorkBook(bk);
        try {
            this.init();
        }
        catch (CellNotFoundException cellNotFoundException) {
            // empty catch block
        }
    }

    public CellRange(String range, WorkBook bk, boolean c) {
        this.createBlanks = c;
        this.range = range;
        if (bk == null) {
            return;
        }
        this.setWorkBook(bk);
        try {
            if (!"".equals(this.range)) {
                this.init();
            }
        }
        catch (CellNotFoundException cellNotFoundException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setParent(BiffRec b) {
        this.parent = b;
    }

    public void sort(int rownumber, Comparator<CellHandle> comparator, boolean ascending) throws RowNotFoundException {
        this.createBlanks();
        ArrayList<CellHandle> sortRow = this.getCellsByRow(rownumber);
        Collections.sort(sortRow, comparator);
        if (!ascending) {
            Collections.reverse(sortRow);
        }
        int[] coords = null;
        try {
            coords = this.getRangeCoords();
            coords[0] = coords[0] - 1;
            coords[2] = coords[2] - 1;
        }
        catch (CellNotFoundException cellNotFoundException) {
            // empty catch block
        }
        ArrayList<ArrayList<CellHandle>> outputCols = new ArrayList<ArrayList<CellHandle>>();
        int i = 0;
        while (i < sortRow.size()) {
            CellHandle cell = sortRow.get(i);
            ArrayList<CellHandle> cells = null;
            try {
                cells = this.getCellsByCol(ExcelTools.getAlphaVal(cell.getColNum()));
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            outputCols.add(cells);
            ++i;
        }
        this.removeCells();
        i = coords[1];
        while (i <= coords[3]) {
            ArrayList cells = (ArrayList)outputCols.get(i - coords[1]);
            int x = 0;
            while (x < cells.size()) {
                CellHandle cell = (CellHandle)cells.get(x);
                Boundsheet bs = this.getSheet().getBoundsheet();
                cell.getCell().setCol((short)i);
                bs.addCell((CellRec)cell.getCell());
                ++x;
            }
            ++i;
        }
    }

    private void createBlanks() {
        if (!this.createBlanks) {
            this.createBlanks = true;
            this.initializeCells = true;
            try {
                this.init();
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
        }
    }

    public void sort(int rownumber, boolean ascending) throws RowNotFoundException {
        CellComparator cp = new CellComparator();
        this.sort(rownumber, (Comparator<CellHandle>)cp, ascending);
    }

    public void sort(String columnName, Comparator comparator, boolean ascending) throws ColumnNotFoundException {
        if (!this.createBlanks) {
            this.createBlanks = true;
            try {
                this.init();
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
        }
        ArrayList<CellHandle> sortCol = this.getCellsByCol(columnName);
        Collections.sort(sortCol, comparator);
        if (!ascending) {
            Collections.reverse(sortCol);
        }
        int[] coords = null;
        try {
            coords = this.getRangeCoords();
            coords[0] = coords[0] - 1;
            coords[2] = coords[2] - 1;
        }
        catch (CellNotFoundException e1) {
            e1.printStackTrace();
        }
        ArrayList<ArrayList<CellHandle>> outputRows = new ArrayList<ArrayList<CellHandle>>();
        int i = 0;
        while (i < sortCol.size()) {
            CellHandle cell = sortCol.get(i);
            ArrayList<CellHandle> cells = null;
            try {
                cells = this.getCellsByRow(cell.getRowNum());
            }
            catch (RowNotFoundException rowNotFoundException) {
                // empty catch block
            }
            outputRows.add(cells);
            ++i;
        }
        this.removeCells();
        i = coords[0];
        while (i <= coords[2]) {
            ArrayList cells = (ArrayList)outputRows.get(i - coords[0]);
            int x = 0;
            while (x < cells.size()) {
                CellHandle cell = (CellHandle)cells.get(x);
                Boundsheet bs = this.getSheet().getBoundsheet();
                cell.getCell().setRowNumber(i - 1);
                bs.addCell((CellRec)cell.getCell());
                ++x;
            }
            ++i;
        }
    }

    public void sort(String columnName, boolean ascending) throws ColumnNotFoundException {
        CellComparator cp = new CellComparator();
        this.sort(columnName, (Comparator)cp, ascending);
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer("<CellRange Range=\"" + this.getRange() + "\">");
        CellHandle[] cx = this.getCells();
        sb.append("\r\n");
        int t = 0;
        while (t < cx.length) {
            sb.append(cx[t].getXML());
            sb.append("\r\n");
            ++t;
        }
        sb.append(xmlResponsePost);
        return sb.toString();
    }

    public String getCellRangeXML(boolean fragment) {
        StringBuffer sbx = new StringBuffer();
        if (!fragment) {
            sbx.append("<?xml version=\"1\" encoding=\"utf-8\"?>");
        }
        sbx.append("<CellRange Range=\"" + this.getRange() + "\">");
        sbx.append(this.getXML());
        sbx.append("</NameHandle>");
        return sbx.toString();
    }

    public String getCellRangeXML() {
        StringBuffer sbx = new StringBuffer();
        sbx.append("<?xml version=\"1\" encoding=\"utf-8\"?>");
        sbx.append(this.getXML());
        return sbx.toString();
    }

    public CellRange(CellHandle[] newcells) throws CellNotFoundException {
        this.setWorkBook(newcells[0].getWorkBook());
        this.sheet = newcells[0].getWorkSheetHandle();
        int x = 0;
        while (x < newcells.length) {
            this.addCellToRange(newcells[x]);
            ++x;
        }
        this.init();
    }

    public CellRange(CellHandle[] newcells, boolean createblanks) throws CellNotFoundException {
        this.createBlanks = createblanks;
        this.setWorkBook(newcells[0].getWorkBook());
        this.sheet = newcells[0].getWorkSheetHandle();
        int x = 0;
        while (x < newcells.length) {
            this.addCellToRange(newcells[x]);
            ++x;
        }
        this.init();
    }

    public CellRange(String range, WorkBook bk) throws CellNotFoundException {
        this(range, bk, true);
    }

    public void setWorkBook(WorkBook bk) {
        this.mybook = bk;
    }

    public int[] getCoords() throws CellNotFoundException {
        int numrows = 0;
        int numcols = 0;
        int numcells = 0;
        int[] coords = new int[5];
        String temprange = this.range;
        String[] s = ExcelTools.stripSheetNameFromRange(temprange);
        temprange = s[1];
        this.sheetname = GenericPtg.qualifySheetname(s[0]);
        if (this.sheetname != null && !this.sheetname.equals("")) {
            if (s[2] == null) {
                this.range = String.valueOf(this.sheetname) + "!" + temprange;
            } else {
                s[2] = GenericPtg.qualifySheetname(s[2]);
                this.range = String.valueOf(this.sheetname) + ":" + s[2] + "!" + temprange;
            }
        }
        if (temprange.indexOf("R") == 0 && temprange.indexOf("C") > 1 && Character.isDigit(temprange.charAt(temprange.indexOf("C") - 1))) {
            int[] b = ExcelTools.getRangeRowCol(temprange);
            numrows = b[2] - b[0];
            if (numrows <= 0) {
                numrows = 1;
            }
            if ((numcols = b[3] - b[2]) <= 0) {
                numcols = 1;
            }
            numcells = numrows * numcols;
            int[] retr = new int[]{b[0], b[1], b[2], b[3], numcells};
            return retr;
        }
        String startcell = "";
        String endcell = "";
        int lastcolon = temprange.lastIndexOf(":");
        endcell = temprange.substring(lastcolon + 1);
        startcell = lastcolon == -1 ? endcell : temprange.substring(0, lastcolon);
        startcell = StringTool.strip(startcell, "$");
        endcell = StringTool.strip(endcell, "$");
        int charct = startcell.length();
        while (charct > 0) {
            if (Character.isDigit(startcell.charAt(--charct))) continue;
            ++charct;
            break;
        }
        String firstcellrowstr = startcell.substring(charct);
        this.firstcellrow = Integer.parseInt(firstcellrowstr);
        String firstcellcolstr = startcell.substring(0, charct);
        this.firstcellcol = ExcelTools.getIntVal(firstcellcolstr);
        charct = endcell.length();
        while (charct > 0) {
            if (Character.isDigit(endcell.charAt(--charct))) continue;
            ++charct;
            break;
        }
        String lastcellrowstr = endcell.substring(charct);
        this.lastcellrow = Integer.parseInt(lastcellrowstr);
        String lastcellcolstr = endcell.substring(0, charct);
        this.lastcellcol = ExcelTools.getIntVal(lastcellcolstr);
        numrows = this.lastcellrow - this.firstcellrow + 1;
        numcols = this.lastcellcol - this.firstcellcol + 1;
        numcells = numrows * numcols;
        if (numcells < 0) {
            numcells *= -1;
        }
        coords[0] = this.firstcellrow - 1;
        coords[1] = this.firstcellcol;
        coords[2] = this.lastcellrow - 1;
        coords[3] = this.lastcellcol;
        coords[4] = numcells;
        if (this.firstcellrow < 0 && this.lastcellrow < 0 || this.firstcellcol < 0 || this.lastcellcol < 0) {
            if (this.firstcellcol == -1 && this.lastcellcol == -1) {
                this.wholeRow = true;
            } else if (this.firstcellrow == -1 && this.lastcellrow == -1) {
                this.wholeCol = true;
            } else {
                Logger.logErr("CellRange.getRangeCoords: Error in Range " + this.range);
            }
        }
        if (s[3] != null) {
            this.externalLink1 = Integer.valueOf(s[3].substring(1, s[3].length() - 1));
        }
        if (s[4] != null) {
            this.externalLink2 = Integer.valueOf(s[4].substring(1, s[4].length() - 1));
        }
        return coords;
    }

    public int[] getRangeCoords() throws CellNotFoundException {
        int[] ordinalValues = this.getCoords();
        ordinalValues[0] = ordinalValues[0] + 1;
        ordinalValues[2] = ordinalValues[2] + 1;
        return ordinalValues;
    }

    public WorkSheetHandle getSheet() {
        return this.sheet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws CellNotFoundException {
        block22: {
            if (!FormulaParser.isComplexRange(this.range)) {
                int[] coords = this.getRangeCoords();
                int rowctr = coords[0];
                int firstcellcol = coords[1];
                int lastcellcol = coords[3];
                int numcells = coords[4];
                int cellctr = firstcellcol - 1;
                try {
                    String s;
                    if (this.sheetname != null && this.sheetname.equals("")) {
                        this.sheetname = this.mybook.getWorkSheet(0).getSheetName();
                    }
                    if (this.sheetname == null) {
                        if (this.sheet == null) {
                            throw new IllegalArgumentException("sheet name not specified: " + this.range);
                        }
                        this.sheetname = this.sheet.getSheetName();
                    }
                    if ((s = this.sheetname) != null && s.charAt(0) == '\'' && (s = s.substring(1, s.length())).charAt(s.length() - 1) == '\'') {
                        s = s.substring(0, s.length() - 1);
                    }
                    this.sheet = this.mybook.getWorkSheet(s);
                    if (this.wholeCol || this.wholeRow) {
                        return;
                    }
                    this.cells = new CellHandle[numcells];
                    boolean resetFastAdds = false;
                    if (this.sheet.getFastCellAdds() && this.createBlanks) {
                        resetFastAdds = true;
                        this.sheet.setFastCellAdds(false);
                    }
                    int i = 0;
                    while (true) {
                        block23: {
                            if (i >= numcells) {
                                if (resetFastAdds) {
                                    this.sheet.setFastCellAdds(true);
                                }
                                break block22;
                            }
                            if (cellctr == lastcellcol) {
                                cellctr = firstcellcol - 1;
                                ++rowctr;
                            }
                            ++cellctr;
                            try {
                                if (this.initializeCells) {
                                    this.cells[i] = this.sheet.getCell(rowctr - 1, cellctr, this.sheet.getUseCache());
                                }
                            }
                            catch (CellNotFoundException e) {
                                if (!this.createBlanks) break block23;
                                this.cells[i] = this.sheet.add(null, rowctr - 1, cellctr);
                            }
                        }
                        ++i;
                    }
                }
                catch (WorkSheetNotFoundException e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
            PtgMemFunc pm = new PtgMemFunc();
            XLSRecord b = new XLSRecord();
            b.setWorkBook(this.mybook.getWorkBook());
            pm.setParentRec(b);
            try {
                pm.setLocation(this.range);
                Ptg[] p = pm.getComponents();
                ArrayList<CellHandle> cellsfromcomplexrange = new ArrayList<CellHandle>();
                int i = 0;
                while (true) {
                    block24: {
                        if (i >= p.length) {
                            this.cells = new CellHandle[cellsfromcomplexrange.size()];
                            this.cells = cellsfromcomplexrange.toArray(this.cells);
                            break;
                        }
                        try {
                            cellsfromcomplexrange.add(this.mybook.getCell(((PtgRef)p[i]).getLocation()));
                        }
                        catch (CellNotFoundException e) {
                            if (!this.createBlanks) break block24;
                            this.cells[i] = this.sheet.add(null, p[i].getLocation());
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        this.isDirty = false;
    }

    public void initCells(boolean createBlanks) {
        if (this.initializeCells && (!createBlanks || this.createBlanks)) {
            return;
        }
        this.initializeCells = true;
        this.createBlanks = createBlanks;
        try {
            this.init();
        }
        catch (CellNotFoundException e) {
            throw new Error();
        }
    }

    public WorkBook getWorkBook() {
        return this.mybook;
    }

    public boolean getCreateBlanks() {
        return this.createBlanks;
    }

    public void setCreateBlanks(boolean b) {
        this.createBlanks = b;
    }

    public String getRange() {
        return this.range;
    }

    public String getR1C1Range() {
        String rc1x = "R";
        try {
            int[] rc1 = this.getRangeCoords();
            rc1x = String.valueOf(rc1x) + (rc1[0] + 1);
            rc1x = String.valueOf(rc1x) + "C" + rc1[1];
            rc1x = String.valueOf(rc1x) + ":R" + (rc1[2] + 1);
            rc1x = String.valueOf(rc1x) + "C" + rc1[3];
        }
        catch (CellNotFoundException e) {
            Logger.logErr("CellRange.getR1C1Range failed", e);
        }
        return rc1x;
    }

    public void setRange(String rng) {
        this.range = rng;
        try {
            this.init();
        }
        catch (CellNotFoundException cellNotFoundException) {
            // empty catch block
        }
    }

    public void setBorder(int width, int linestyle, Color colr) {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            int[] coords = this.getEdgePositions(ch[t], width);
            if (coords[0] > 0) {
                ch[t].setTopBorderLineStyle((short)linestyle);
                ch[t].setBorderTopColor(colr);
            }
            if (coords[1] > 0) {
                ch[t].setLeftBorderLineStyle((short)linestyle);
                ch[t].setBorderLeftColor(colr);
            }
            if (coords[2] > 0) {
                ch[t].setBottomBorderLineStyle((short)linestyle);
                ch[t].setBorderBottomColor(colr);
            }
            if (coords[3] > 0) {
                ch[t].setRightBorderLineStyle((short)linestyle);
                ch[t].setBorderRightColor(colr);
            }
            ++t;
        }
    }

    public boolean update() {
        if (this.cells == null) {
            return false;
        }
        if (this.cells[0] != null) {
            this.firstcellrow = this.cells[0].getRowNum() + 1;
            this.firstcellcol = this.cells[0].getColNum();
            this.lastcellrow = this.cells[0].getRowNum() + 1;
            this.lastcellcol = this.cells[0].getColNum();
            int t = 0;
            while (t < this.cells.length) {
                CellHandle cx = this.cells[t];
                if (cx != null) {
                    this.addCellToRange(cx);
                }
                ++t;
            }
            this.myrowints = null;
            this.mycolints = null;
            return true;
        }
        if (this.range != null) {
            if (this.DEBUG) {
                Logger.logWarn("CellRange.update:  trying to access blank cells in range " + this.range);
            }
            try {
                this.getRangeCoords();
                return true;
            }
            catch (CellNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isMerged() {
        return this.ismerged;
    }

    public void setSheet(WorkSheetHandle aSheet) {
        this.sheet = aSheet;
        this.sheetname = aSheet.getSheetName();
    }

    public CellRange copy(WorkSheetHandle sheet, int row, int col, int what) {
        CellRange result = new CellRange(sheet, row, col, this.getWidth(), this.getHeight());
        int first_col = col;
        boolean copy_contents = (what & 1) != 0;
        boolean copy_formulas = (what & 2) != 0;
        boolean copy_formats = (what & 0x100) != 0;
        copy_formats = true;
        copy_formulas = true;
        int cur_row = this.cells[0].getRowNum();
        int idx = 0;
        while (idx < this.cells.length) {
            CellHandle source = this.cells[idx];
            if (source.getRowNum() != cur_row) {
                cur_row = source.getRowNum();
                ++row;
                col = first_col;
            }
            CellHandle target = null;
            try {
                target = sheet.getCell(row, col);
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
            int formatID = copy_formats ? source.getFormatId() : (target != null ? target.getFormatId() : sheet.getWorkBook().getWorkBook().getDefaultIxfe());
            if (copy_contents) {
                Object value;
                if (copy_formulas && source.isFormula()) {
                    try {
                        value = source.getFormulaHandle().getFormulaString();
                    }
                    catch (FormulaNotFoundException e) {
                        throw new Error("formula cell has no Formula record", e);
                    }
                } else {
                    value = source.getVal();
                }
                target = sheet.add(value, row, col, formatID);
                if (target.isFormula()) {
                    try {
                        FormulaHandle.moveCellRefs(target.getFormulaHandle(), new int[]{row - source.getRowNum(), col - source.getColNum()});
                    }
                    catch (FormulaNotFoundException formulaNotFoundException) {}
                }
            } else if (target == null) {
                target = sheet.add(null, row, col, formatID);
            }
            if (copy_formats) {
                target.setFormatId(formatID);
            }
            result.cells[idx] = target;
            ++col;
            ++idx;
        }
        return result;
    }

    public void fill(CellHandle source, int what, double increment) {
        if (source == null) {
            source = this.cells[0];
        }
        boolean copy_contents = (what & 1) != 0;
        boolean copy_formulas = (what & 2) != 0;
        boolean copy_formats = (what & 0x100) != 0;
        int sourceRow = source.getRowNum();
        int sourceCol = source.getColNum();
        Object value = null;
        if (copy_contents) {
            if (copy_formulas && source.isFormula()) {
                try {
                    value = source.getFormulaHandle().getFormulaString();
                }
                catch (FormulaNotFoundException e) {
                    throw new Error("formula cell has no Formula record", e);
                }
            } else {
                value = source.getVal();
            }
        }
        if (!(Double.isNaN(increment) || copy_contents && value instanceof Number)) {
            throw new IllegalArgumentException("cannot increment unless filling with a numeric value");
        }
        int idx = 0;
        while (idx < this.cells.length) {
            CellHandle target = this.cells[idx];
            if (!source.equals(target)) {
                if (!Double.isNaN(increment)) {
                    value = ((Number)value).doubleValue() + increment;
                }
                int formatID = (copy_formats ? source : target).getFormatId();
                if (copy_contents) {
                    this.cells[idx] = target = this.sheet.add(value, target.getRowNum(), target.getColNum(), formatID);
                    if (target.isFormula()) {
                        try {
                            FormulaHandle.moveCellRefs(target.getFormulaHandle(), new int[]{target.getRowNum() - sourceRow, target.getColNum() - sourceCol});
                        }
                        catch (FormulaNotFoundException formulaNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (copy_formats) {
                    target.setFormatId(formatID);
                }
            }
            ++idx;
        }
    }

    public Collection<CellHandle> calculateAffectedCellsOnSheet() {
        HashSet<CellHandle> affected = new HashSet<CellHandle>();
        CellHandle[] cellHandleArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            CellHandle cell = cellHandleArray[n2];
            if (cell != null) {
                affected.add(cell);
                affected.addAll(cell.calculateAffectedCellsOnSheet());
            }
            ++n2;
        }
        return affected;
    }

    public static JSONArray getValuesAsJSON(String range, WorkBook wbh) {
        JSONArray rangeArray = new JSONArray();
        try {
            CellRange cr = new CellRange(range, wbh, true);
            int j = 0;
            while (j < cr.getCells().length) {
                rangeArray.put(cr.getCells()[j].getVal());
                ++j;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error obtaining CellRange " + range + " JSON: " + e);
        }
        return rangeArray;
    }

    public JSONObject getBasicJSON() {
        try {
            JSONObject crObj = new JSONObject();
            crObj.put("Range", (Object)this.getRange());
            JSONArray rangeArray = new JSONArray();
            CellHandle[] cells = this.getCells();
            int j = 0;
            while (j < cells.length) {
                JSONObject result = new JSONObject();
                String addy = cells[j].getCellAddress();
                String val = cells[j].getVal().toString();
                result.put("loc", (Object)addy);
                result.put("v", (Object)val);
                rangeArray.put((Object)result);
                ++j;
            }
            crObj.put("cs", (Object)rangeArray);
            return crObj;
        }
        catch (Exception e) {
            Logger.logErr("Error obtaining CellRange " + this.range + " JSON: " + e);
            return new JSONObject();
        }
    }

    public JSONObject getJSON() {
        JSONObject theRange = new JSONObject();
        JSONArray cells = new JSONArray();
        try {
            theRange.put("Range", (Object)this.getRange());
            CellHandle[] chandles = this.getCells();
            int i = 0;
            while (i < chandles.length) {
                CellHandle thisCell = chandles[i];
                JSONObject result = new JSONObject();
                result.put("Cell", (Object)thisCell.getJSONObject());
                cells.put((Object)result);
                ++i;
            }
            theRange.put("cs", (Object)cells);
        }
        catch (JSONException e) {
            Logger.logErr("Error getting cellRange JSON: " + (Object)((Object)e));
        }
        return theRange;
    }

    public ArrayList<CellHandle> getCellsByRow(int rownumber) throws RowNotFoundException {
        ArrayList<CellHandle> al = new ArrayList<CellHandle>();
        RowHandle r2 = this.getSheet().getRow(rownumber);
        CellHandle[] cells = r2.getCells();
        int[] coords = null;
        try {
            coords = this.getRangeCoords();
        }
        catch (CellNotFoundException e) {
            throw new RowNotFoundException("Error getting internal coordinates for CellRange" + e);
        }
        int i = 0;
        while (i < cells.length) {
            if (cells[i].getColNum() >= coords[1] && cells[i].getColNum() <= coords[3]) {
                al.add(cells[i]);
            }
            ++i;
        }
        return al;
    }

    public ArrayList<CellHandle> getCellsByCol(String col) throws ColumnNotFoundException {
        ArrayList<CellHandle> al = new ArrayList<CellHandle>();
        ColHandle r2 = this.getSheet().getCol(col);
        CellHandle[] cells = r2.getCells();
        int[] coords = null;
        try {
            coords = this.getRangeCoords();
            coords[0] = coords[0] - 1;
            coords[2] = coords[2] - 1;
        }
        catch (CellNotFoundException e) {
            throw new ColumnNotFoundException("Error getting internal coordinates for CellRange" + e);
        }
        int i = 0;
        while (i < cells.length) {
            if (cells[i].getRowNum() >= coords[0] && cells[i].getRowNum() <= coords[2]) {
                al.add(cells[i]);
            }
            ++i;
        }
        return al;
    }

    public static CellHandle[] getCells(String range, WorkBookHandle wbh) {
        CellRange cr = new CellRange(range, wbh, true);
        return cr.getCells();
    }

    public void removeBorder() {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            ch[t].removeBorder();
            ++t;
        }
    }

    public void setInnerBorderBottom(int linestyle, Color colr) {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            ch[t].setBottomBorderLineStyle((short)linestyle);
            ch[t].setBorderBottomColor(colr);
            ++t;
        }
    }

    public void setInnerBorderRight(int linestyle, Color colr) {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            ch[t].setRightBorderLineStyle((short)linestyle);
            ch[t].setBorderRightColor(colr);
            ++t;
        }
    }

    public void setInnerBorderLeft(int linestyle, Color colr) {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            ch[t].setLeftBorderLineStyle((short)linestyle);
            ch[t].setBorderLeftColor(colr);
            ++t;
        }
    }

    public void setInnerBorderTop(int linestyle, Color colr) {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            ch[t].setTopBorderLineStyle((short)linestyle);
            ch[t].setBorderTopColor(colr);
            ++t;
        }
    }

    public void setInnerBorderSurround(int linestyle, Color colr) {
        CellHandle[] ch = this.getCells();
        int t = 0;
        while (t < ch.length) {
            ch[t].setBorderColor(colr);
            ch[t].setBorderLineStyle((short)linestyle);
            ++t;
        }
    }
}

