/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.WorkSheetNotFoundException;

public class CellRangeRef
implements Cloneable {
    private int first_col;
    private int first_row;
    private int last_col;
    private int last_row;
    private String first_sheet_name;
    private String last_sheet_name;
    private WorkSheetHandle first_sheet;
    private WorkSheetHandle last_sheet;

    private CellRangeRef() {
    }

    public CellRangeRef(int first_row, int first_col, int last_row, int last_col) {
        this.first_row = first_row;
        this.first_col = first_col;
        this.last_row = last_row;
        this.last_col = last_col;
    }

    public int numCells() {
        int ret = -1;
        int numrows = this.last_row - this.first_row;
        int numcols = this.last_col - this.first_col;
        ret = ++numrows * ++numcols;
        return ret;
    }

    public CellRangeRef(int first_row, int first_col, int last_row, int last_col, String first_sheet, String last_sheet) {
        this(first_row, first_col, last_row, last_col);
        this.first_sheet_name = first_sheet;
        this.last_sheet_name = last_sheet;
    }

    public CellRangeRef(int first_row, int first_col, int last_row, int last_col, WorkSheetHandle first_sheet, WorkSheetHandle last_sheet) {
        this(first_row, first_col, last_row, last_col);
        this.first_sheet = first_sheet;
        this.last_sheet = last_sheet;
    }

    public static CellRangeRef fromA1(String reference) {
        CellRangeRef ret = new CellRangeRef();
        Object[] parts = ExcelTools.stripSheetNameFromRange(reference);
        ret.first_sheet_name = parts[0];
        String range = parts[1];
        ret.last_sheet_name = parts[2];
        if (range == null) {
            throw new IllegalArgumentException("missing range component");
        }
        parts = ExcelTools.getRangeRowCol(range);
        ret.first_row = (int)parts[0];
        ret.first_col = (int)parts[1];
        ret.last_row = (int)parts[2];
        ret.last_col = (int)parts[3];
        return ret;
    }

    public static CellRangeRef fromA1(String reference, WorkBookHandle book) throws WorkSheetNotFoundException {
        CellRangeRef ret = CellRangeRef.fromA1(reference);
        ret.resolve(book);
        return ret;
    }

    public void resolve(WorkBookHandle book) throws WorkSheetNotFoundException {
        if (this.first_sheet_name != null) {
            this.first_sheet = book.getWorkSheet(this.first_sheet_name);
        }
        if (this.last_sheet_name != null) {
            this.last_sheet = book.getWorkSheet(this.last_sheet_name);
        }
    }

    public int getFirstRow() {
        return this.first_row;
    }

    public int getFirstColumn() {
        return this.first_col;
    }

    public int getLastRow() {
        return this.last_row;
    }

    public int getLastColumn() {
        return this.last_col;
    }

    public String getFirstSheetName() {
        if (this.first_sheet != null) {
            return this.first_sheet.getSheetName();
        }
        return this.first_sheet_name;
    }

    public WorkSheetHandle getFirstSheet() {
        return this.first_sheet;
    }

    public String getLastSheetName() {
        if (this.last_sheet != null) {
            return this.last_sheet.getSheetName();
        }
        return this.last_sheet_name;
    }

    public WorkSheetHandle getLastSheet() {
        return this.last_sheet;
    }

    public boolean hasSheet() {
        return this.first_sheet != null || this.first_sheet_name != null;
    }

    public boolean isMultiSheet() {
        return this.first_sheet != null && this.last_sheet != null && this.first_sheet != this.last_sheet || this.first_sheet_name != null && this.last_sheet_name != null && this.first_sheet_name != this.last_sheet_name;
    }

    public void setFirstRow(int value) {
        this.first_row = value;
    }

    public void setFirstColumn(int value) {
        this.first_col = value;
    }

    public void setFirstSheet(WorkSheetHandle sheet) {
        this.first_sheet_name = null;
        this.first_sheet = sheet;
    }

    public void setLastRow(int value) {
        this.last_row = value;
    }

    public void setLastColumn(int value) {
        this.last_col = value;
    }

    public void setLastSheet(WorkSheetHandle sheet) {
        this.last_sheet_name = null;
        this.last_sheet = sheet;
    }

    public boolean contains(CellRangeRef range) {
        return this.first_row <= range.first_row && this.last_row >= range.last_row && this.first_col <= range.first_col && this.last_col >= range.last_col;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CellRangeRef)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Object.clone() threw CNSE but we're Cloneable");
        }
    }

    public String toString() {
        String sheet1 = this.getFirstSheetName();
        String sheet2 = this.getLastSheetName();
        return String.valueOf(sheet1 != null ? String.valueOf(sheet1) + (sheet2 != null && sheet2 != sheet1 ? ":" + sheet2 : "") + "!" : "") + ExcelTools.formatRange(new int[]{this.first_col, this.first_row, this.last_col, this.last_row});
    }
}

