/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartSeriesHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.OOXML.Layout;
import com.extentech.formats.OOXML.Legend;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.Title;
import com.extentech.formats.OOXML.TwoCellAnchor;
import com.extentech.formats.OOXML.TxPr;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartConstants;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.OOXMLChart;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.charts.ThreeD;
import com.extentech.toolkit.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ChartHandle
implements ChartConstants {
    public static final int BARCHART = 1;
    public static final int COLCHART = 0;
    public static final int LINECHART = 2;
    public static final int PIECHART = 3;
    public static final int AREACHART = 4;
    public static final int SCATTERCHART = 5;
    public static final int RADARCHART = 6;
    public static final int SURFACECHART = 7;
    public static final int DOUGHNUTCHART = 8;
    public static final int BUBBLECHART = 9;
    public static final int OFPIECHART = 10;
    public static final int PYRAMIDCHART = 11;
    public static final int CYLINDERCHART = 12;
    public static final int CONECHART = 13;
    public static final int PYRAMIDBARCHART = 14;
    public static final int CYLINDERBARCHART = 15;
    public static final int CONEBARCHART = 16;
    public static final int RADARAREACHART = 17;
    public static final int STOCKCHART = 18;
    public static final int BAR = 1;
    public static final int COL = 0;
    public static final int LINE = 2;
    public static final int PIE = 3;
    public static final int AREA = 4;
    public static final int SCATTER = 5;
    public static final int RADAR = 6;
    public static final int SURFACE = 7;
    public static final int DOUGHNUT = 8;
    public static final int BUBBLE = 9;
    public static final int RADARAREA = 17;
    public static final int PYRAMID = 11;
    public static final int CYLINDER = 12;
    public static final int CONE = 13;
    public static final int PYRAMIDBAR = 14;
    public static final int CYLINDERBAR = 15;
    public static final int CONEBAR = 16;
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int ZAXIS = 2;
    public static final int XVALAXIS = 3;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int WIDTH = 2;
    public static final int HEIGHT = 3;
    protected WorkBookHandle wbh;
    private Chart mychart;

    public ChartHandle(Chart c, WorkBookHandle wb) {
        this.mychart = c;
        this.wbh = wb;
        if (this.mychart.getWorkBook() == null) {
            this.mychart.setWorkBook(wb.getWorkBook());
        }
    }

    public String getTitle() {
        return this.mychart.getTitle();
    }

    public void setTitle(String title) {
        this.mychart.setTitle(title);
    }

    public String getDataRangeJSON() {
        return this.mychart.getChartSeries().getDataRangeJSON().toString();
    }

    public int[] getEncompassingDataRange() {
        return ChartHandle.getEncompassingDataRange(this.mychart.getChartSeries().getDataRangeJSON());
    }

    public static int[] getEncompassingDataRange(JSONObject jsonDataRange) {
        try {
            String catrange = jsonDataRange.get("c").toString();
            String sheet = catrange.substring(0, catrange.indexOf(33));
            int[] retVals = ExcelTools.getRangeRowCol(catrange);
            int nSeries = jsonDataRange.getJSONArray("Series").length();
            int i = 0;
            while (i < nSeries) {
                JSONObject series = (JSONObject)jsonDataRange.getJSONArray("Series").get(i);
                String serrange = series.get("v").toString();
                if (serrange.startsWith(sheet)) {
                    int[] locs = ExcelTools.getRangeRowCol(serrange);
                    try {
                        String legendrange;
                        if (locs[0] < retVals[0]) {
                            retVals[0] = locs[0];
                        }
                        if (locs[1] < retVals[1]) {
                            retVals[1] = locs[1];
                        }
                        if (locs[2] > retVals[2]) {
                            retVals[2] = locs[2];
                        }
                        if (locs[3] > retVals[3]) {
                            retVals[3] = locs[3];
                        }
                        if ((locs = ExcelTools.getRowColFromString(legendrange = series.get("l").toString()))[0] < retVals[0]) {
                            retVals[0] = locs[0];
                        }
                        if (locs[1] < retVals[1]) {
                            retVals[1] = locs[1];
                        }
                        if (locs[0] > retVals[2]) {
                            retVals[2] = locs[0];
                        }
                        if (locs[1] > retVals[3]) {
                            retVals[3] = locs[1];
                        }
                        if (series.has("b")) {
                            String bubblerange = series.get("b").toString();
                            locs = ExcelTools.getRangeRowCol(serrange);
                            if (locs[0] < retVals[0]) {
                                retVals[0] = locs[0];
                            }
                            if (locs[1] < retVals[1]) {
                                retVals[1] = locs[1];
                            }
                            if (locs[2] > retVals[2]) {
                                retVals[2] = locs[2];
                            }
                            if (locs[3] > retVals[3]) {
                                retVals[3] = locs[3];
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return retVals;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getId() {
        return this.mychart.getId();
    }

    public String toString() {
        return this.mychart.getTitle();
    }

    public String[] getSeries() {
        return this.mychart.getSeries(-1);
    }

    public String[] getCategories() {
        return this.getCategories(-1);
    }

    private String[] getCategories(int nChart) {
        return this.mychart.getCategories(nChart);
    }

    public ChartSeriesHandle[] getAllChartSeriesHandles() {
        return this.getAllChartSeriesHandles(-1);
    }

    public ChartSeriesHandle[] getAllChartSeriesHandles(int nChart) {
        Vector v = this.mychart.getAllSeries(nChart);
        ChartSeriesHandle[] csh = new ChartSeriesHandle[v.size()];
        int i = 0;
        while (i < v.size()) {
            Series s = (Series)v.get(i);
            csh[i] = new ChartSeriesHandle(s, this.wbh);
            ++i;
        }
        return csh;
    }

    public ChartSeriesHandle getChartSeriesHandle(String seriesRange) {
        ChartSeriesHandle[] series = this.getAllChartSeriesHandles();
        int i = 0;
        while (i < series.length) {
            String sr = series[i].getSeriesRange();
            if (seriesRange.equalsIgnoreCase(sr)) {
                return series[i];
            }
            ++i;
        }
        return null;
    }

    public ChartSeriesHandle getChartSeriesHandle(int idx) {
        ChartSeriesHandle[] series = this.getAllChartSeriesHandles();
        if (series.length >= idx) {
            return series[idx];
        }
        return null;
    }

    public ChartSeriesHandle getChartSeriesHandleByName(String legend) {
        Series s = this.mychart.getSeries(legend, -1);
        return new ChartSeriesHandle(s, this.wbh);
    }

    public void setAxisTitle(int axisType, String ttl) {
        this.mychart.getAxes().setTitle(axisType, ttl);
    }

    public String getYAxisLabel() {
        return this.mychart.getAxes().getTitle(1);
    }

    public void setYAxisLabel(String yTitle) {
        this.mychart.getAxes().setTitle(1, yTitle);
    }

    public String getXAxisLabel() {
        return this.mychart.getAxes().getTitle(0);
    }

    public void setXAxisLabel(String xTitle) {
        this.mychart.getAxes().setTitle(0, xTitle);
    }

    public String getZAxisLabel() {
        return this.mychart.getAxes().getTitle(2);
    }

    public void setZAxisLabel(String zTitle) {
        this.mychart.getAxes().setTitle(2, zTitle);
    }

    public void setAxisAutomaticScale(int axisType, boolean b) {
        this.mychart.getAxes().setAxisAutomaticScale(axisType, b);
        this.mychart.setDirtyFlag(true);
    }

    public double getAxisMinScale(int axisType) {
        double[] minmax = this.mychart.getMinMax(this.wbh);
        return this.mychart.getAxes().getMinMax(minmax[0], minmax[1], axisType)[0];
    }

    public double getAxisMaxScale(int axisType) {
        double[] minmax = this.mychart.getMinMax(this.wbh);
        return this.mychart.getAxes().getMinMax(minmax[0], minmax[1], axisType)[1];
    }

    public int getAxisMajorUnit(int axisType) {
        return this.mychart.getAxes().getAxisMajorUnit(axisType);
    }

    public int getAxisMinorUnit(int axisType) {
        return this.mychart.getAxes().getAxisMinorUnit(axisType);
    }

    public void setAxisMax(int axisType, int MaxValue) {
        this.mychart.getAxes().setAxisMax(axisType, MaxValue);
        this.mychart.setDirtyFlag(true);
    }

    public void setAxisMin(int axisType, int MinValue) {
        this.mychart.getAxes().setAxisMin(axisType, MinValue);
        this.mychart.setDirtyFlag(true);
    }

    public boolean getAxisAutomaticScale(int axisType) {
        return this.mychart.getAxes().getAxisAutomaticScale(axisType);
    }

    public boolean getAxisAutomaticScale() {
        return this.mychart.getAxisAutomaticScale();
    }

    public void setAxisAutomaticScale(boolean b) {
        this.mychart.getAxes().setAxisAutomaticScale(b);
        this.mychart.setDirtyFlag(true);
    }

    public double getAxisMinScale() {
        double[] minmax = this.mychart.getMinMax(this.wbh);
        return this.mychart.getAxes().getMinMax(minmax[0], minmax[1])[0];
    }

    public double getAxisMaxScale() {
        double[] minmax = this.mychart.getMinMax(this.wbh);
        return this.mychart.getAxes().getMinMax(minmax[0], minmax[1])[1];
    }

    public int getAxisMajorUnit() {
        double[] minmax = this.mychart.getMinMax(this.wbh);
        return (int)this.mychart.getAxes().getMinMax(minmax[0], minmax[1])[2];
    }

    public int getAxisMinorUnit() {
        double[] minmax = this.mychart.getMinMax(this.wbh);
        return (int)this.mychart.getAxes().getMinMax(minmax[0], minmax[1])[1];
    }

    public void setAxisMax(int MaxValue) {
        this.mychart.getAxes().setAxisMax(MaxValue);
        this.mychart.setDirtyFlag(true);
    }

    public void setAxisMin(int MinValue) {
        this.mychart.getAxes().setAxisMin(MinValue);
        this.mychart.setDirtyFlag(true);
    }

    public void setAxisOption(int axisType, String op, String val) {
        this.mychart.getAxes().setChartOption(axisType, op, val);
    }

    public void setTitleFont(String name, int height, boolean bold, boolean italic, boolean underline) {
        Font f = new Font(name, 200, height);
        f.setBold(bold);
        f.setItalic(italic);
        f.setUnderlined(underline);
        int idx = this.wbh.getWorkBook().getFontIdx(f);
        if (idx == -1) {
            f.setIdx(-1);
            idx = this.wbh.getWorkBook().insertFont(f) + 1;
        }
        this.mychart.setTitleFont(idx);
    }

    public void setTitleFont(Font f) {
        int idx = this.wbh.getWorkBook().getFontIdx(f);
        if (idx == -1) {
            f.setIdx(-1);
            idx = this.wbh.getWorkBook().insertFont(f) + 1;
        }
        this.mychart.setTitleFont(idx);
    }

    public Font getTitleFont() {
        return this.mychart.getTitleFont();
    }

    public void setAxisFont(String name, int height, boolean bold, boolean italic, boolean underline) {
        Font f = new Font(name, 200, height);
        f.setBold(bold);
        f.setItalic(italic);
        f.setUnderlined(underline);
        int idx = this.wbh.getWorkBook().getFontIdx(f);
        if (idx == -1) {
            f.setIdx(-1);
            idx = this.wbh.getWorkBook().insertFont(f) + 1;
        }
        this.mychart.getAxes().setTitleFont(0, idx);
        this.mychart.getAxes().setTitleFont(1, idx);
        this.mychart.getAxes().setTitleFont(2, idx);
        this.mychart.setDirtyFlag(true);
    }

    public void setAxisFont(Font f) {
        int idx = this.wbh.getWorkBook().getFontIdx(f);
        if (idx == -1) {
            f.setIdx(-1);
            idx = this.wbh.getWorkBook().insertFont(f) + 1;
        }
        this.mychart.getAxes().setTitleFont(0, idx);
        this.mychart.getAxes().setTitleFont(1, idx);
        this.mychart.getAxes().setTitleFont(2, idx);
        this.mychart.setDirtyFlag(true);
    }

    public Font getAxisFont() {
        Font f = null;
        f = this.mychart.getAxes().getTitleFont(0);
        if (f != null) {
            return f;
        }
        f = this.mychart.getAxes().getTitleFont(1);
        if (f != null) {
            return f;
        }
        f = this.mychart.getAxes().getTitleFont(2);
        if (f != null) {
            return f;
        }
        return null;
    }

    public void resetFonts() {
        this.mychart.resetFonts();
    }

    public Boundsheet getSheet() {
        return this.mychart.getSheet();
    }

    public int getPlotAreaBgColor() {
        String bg = this.mychart.getPlotAreaBgColor();
        return FormatHandle.HexStringToColorInt(bg, (short)0);
    }

    public String getPlotAreaBgColorStr() {
        return this.mychart.getPlotAreaBgColor();
    }

    public void setPlotAreaBgColor(int bg) {
        this.mychart.setPlotAreaBgColor(bg);
    }

    public boolean changeTextValue(String originalval, String newval) {
        return this.mychart.changeTextValue(originalval, newval);
    }

    private boolean setLocationPolicy(String loc, int l) {
        Logger.logErr("ChartHandle.setLocationPolicy is broken");
        return false;
    }

    public void setChartType(int chartType) {
        this.mychart.setChartType(chartType, 0, EnumSet.noneOf(ChartOptions.class));
    }

    public static ChartHandle createNewChart(WorkSheetHandle sheet, int chartType, EnumSet<ChartOptions> options) {
        ChartHandle cht = sheet.getWorkBook().createChart("", sheet);
        cht.setChartType(chartType, 0, options);
        return cht;
    }

    public void setChartType(int chartType, int nChart, EnumSet<ChartOptions> options) {
        this.mychart.setChartType(chartType, nChart, options);
    }

    public void setChartType(int chartType, int nChart) {
        this.mychart.setChartType(chartType, nChart, EnumSet.noneOf(ChartOptions.class));
    }

    public int getChartType() {
        return this.mychart.getChartType();
    }

    public int getChartType(int nChart) {
        return this.mychart.getChartType(nChart);
    }

    public boolean changeSeriesRange(String originalrange, String newrange) {
        return this.mychart.changeSeriesRange(originalrange, newrange);
    }

    public boolean changeCategoryRange(String originalrange, String newrange) {
        return this.mychart.changeCategoryRange(originalrange, newrange);
    }

    public ChartSeriesHandle setSeries(int index, String legendCell, String categoryRange, String seriesRange, String bubbleRange) throws CellNotFoundException {
        String legendText = "";
        try {
            CellHandle ICell = null;
            if (legendCell != null && !legendCell.equals("")) {
                block5: {
                    try {
                        ICell = this.wbh.getCell(legendCell);
                    }
                    catch (CellNotFoundException c) {
                        int shtpos = legendCell.indexOf("!");
                        if (shtpos <= 0) break block5;
                        String sheetstr = legendCell.substring(0, shtpos);
                        WorkSheetHandle sht = this.wbh.getWorkSheet(sheetstr);
                        String celstr = legendCell.substring(shtpos + 1);
                        ICell = sht.add("", celstr);
                    }
                }
                legendText = ICell.getStringVal();
            }
            return this.setSeries(index, legendCell, legendText, categoryRange, seriesRange, bubbleRange);
        }
        catch (WorkSheetNotFoundException e) {
            throw new CellNotFoundException("Error locating cell for adding series range: " + legendCell);
        }
    }

    public ChartSeriesHandle setSeries(int index, String legendCell, String legendText, String categoryRange, String seriesRange, String bubbleRange) throws CellNotFoundException {
        return this.setSeries(index, legendCell, legendText, categoryRange, seriesRange, bubbleRange, 0);
    }

    public ChartSeriesHandle setSeries(int index, String legendCell, String legendText, String categoryRange, String seriesRange, String bubbleRange, int nChart) throws CellNotFoundException {
        try {
            Series s = (Series)this.mychart.getAllSeries(nChart).get(index);
            ChartSeriesHandle csh = new ChartSeriesHandle(s, this.wbh);
            csh.setSeries(legendCell, categoryRange, seriesRange, bubbleRange);
            this.setDimensionsRecord();
            return csh;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            return this.addSeriesRange(legendCell, legendText, categoryRange, seriesRange, bubbleRange, nChart);
        }
    }

    private ChartSeriesHandle addSeriesRange(String legendAddress, String legendText, String categoryRange, String seriesRange, String bubbleRange) throws CellNotFoundException {
        return this.addSeriesRange(legendAddress, legendText, categoryRange, seriesRange, bubbleRange, 0);
    }

    private ChartSeriesHandle addSeriesRange(String legendAddress, String legendText, String categoryRange, String seriesRange, String bubbleRange, int nChart) throws CellNotFoundException {
        Series s = null;
        s = bubbleRange == null || bubbleRange.equals("") ? this.mychart.addSeries(seriesRange, categoryRange, "", legendAddress, legendText, nChart) : this.mychart.addSeries(seriesRange, categoryRange, bubbleRange, legendAddress, legendText, nChart);
        this.setDimensionsRecord();
        return new ChartSeriesHandle(s, this.wbh);
    }

    public ChartSeriesHandle addSeriesRange(String legendCell, String categoryRange, String seriesRange, String bubbleRange) throws CellNotFoundException {
        return this.addSeriesRange(legendCell, categoryRange, seriesRange, bubbleRange, 0);
    }

    public ChartSeriesHandle addSeriesRange(String legendCell, String categoryRange, String seriesRange, String bubbleRange, int nChart) throws CellNotFoundException {
        String legendText = "";
        String legendAddr = "";
        try {
            CellHandle ICell = null;
            if (legendCell != null && !legendCell.equals("")) {
                block5: {
                    try {
                        ICell = this.wbh.getCell(legendCell);
                        legendAddr = legendCell.indexOf("!") == -1 ? String.valueOf(ICell.getWorkSheetName()) + "!" + ICell.getCellAddress() : legendCell;
                    }
                    catch (CellNotFoundException c) {
                        int shtpos = legendCell.indexOf("!");
                        if (shtpos <= 0) break block5;
                        String sheetstr = legendCell.substring(0, shtpos);
                        WorkSheetHandle sht = this.wbh.getWorkSheet(sheetstr);
                        String celstr = legendCell.substring(shtpos + 1);
                        ICell = sht.add("", celstr);
                        legendAddr = celstr;
                    }
                }
                legendText = ICell != null ? ICell.getStringVal() : legendCell;
            }
            Series s = null;
            s = bubbleRange == null ? this.mychart.addSeries(seriesRange, categoryRange, "", legendAddr, legendText, nChart) : this.mychart.addSeries(seriesRange, categoryRange, bubbleRange, legendAddr, legendText, nChart);
            this.setDimensionsRecord();
            return new ChartSeriesHandle(s, this.wbh);
        }
        catch (WorkSheetNotFoundException e) {
            throw new CellNotFoundException("Error locating cell for adding series range: " + legendCell);
        }
    }

    public ChartSeriesHandle addSeriesRange(CellHandle legendCell, CellRange categoryRange, CellRange seriesRange, CellRange bubbleRange) {
        return this.addSeriesRange(legendCell, categoryRange, seriesRange, bubbleRange, 0);
    }

    public ChartSeriesHandle addSeriesRange(CellHandle legendCell, CellRange categoryRange, CellRange seriesRange, CellRange bubbleRange, int nChart) {
        Series s = null;
        s = bubbleRange == null ? this.mychart.addSeries(seriesRange.toString(), categoryRange.toString(), "", String.valueOf(legendCell.getWorkSheetName()) + "!" + legendCell.getCellAddress(), legendCell.getStringVal(), nChart) : this.mychart.addSeries(seriesRange.toString(), categoryRange.toString(), bubbleRange.toString(), String.valueOf(legendCell.getWorkSheetName()) + "!" + legendCell.getCellAddress(), legendCell.getStringVal(), nChart);
        this.setDimensionsRecord();
        return new ChartSeriesHandle(s, this.wbh);
    }

    public void removeSeries(int index) {
        this.removeSeries(index, -1);
    }

    public void removeSeries(int index, int nChart) {
        Vector seriesperchart = this.mychart.getAllSeries(nChart);
        Series seriestodelete = (Series)seriesperchart.get(index);
        this.mychart.removeSeries(seriestodelete);
        this.setDimensionsRecord();
    }

    public void addAllSeries(String[] valueRanges, String[] legendCells, String[] bubbleSizeRanges, String categoryRange) {
        this.addAllSeries(valueRanges, legendCells, bubbleSizeRanges, categoryRange, 0);
    }

    private void addAllSeries(String[] valueRanges, String[] legendCells, String[] bubbleSizeRanges, String categoryRange, int nChart) {
        Vector v = this.mychart.getAllSeries();
        int i = 0;
        while (i < v.size()) {
            this.mychart.removeSeries((Series)v.get(i));
            ++i;
        }
        try {
            HashMap chartMetrics = this.mychart.getMetrics(this.wbh);
            this.mychart.getLegend().resetPos((Double)chartMetrics.get("y"), (Double)chartMetrics.get("h"), (Double)chartMetrics.get("canvash"), legendCells.length);
        }
        catch (Exception chartMetrics) {
            // empty catch block
        }
        this.setDimensionsRecord();
        boolean hasBubbles = bubbleSizeRanges != null && bubbleSizeRanges.length == valueRanges.length;
        int i2 = valueRanges.length - 1;
        while (i2 >= 0) {
            try {
                if (!hasBubbles) {
                    this.addSeriesRange(legendCells[i2], categoryRange, valueRanges[i2], null, nChart);
                } else {
                    this.addSeriesRange(legendCells[i2], categoryRange, valueRanges[i2], bubbleSizeRanges[i2], nChart);
                }
            }
            catch (Exception e) {
                Logger.logErr("Error adding series: " + e.toString());
            }
            --i2;
        }
    }

    public ChartSeriesHandle appendRowSeriesToChart() {
        return this.appendRowSeriesToChart(0);
    }

    public ChartSeriesHandle appendRowSeriesToChart(int nChart) {
        ChartSeriesHandle[] handles = this.getAllChartSeriesHandles(nChart);
        ChartSeriesHandle theHandle = handles[handles.length - 1];
        String legendRef = theHandle.getSeriesLegendReference();
        if (legendRef != null && !legendRef.equals("")) {
            String sheetnm = legendRef.substring(0, legendRef.indexOf("!"));
            legendRef = legendRef.substring(legendRef.indexOf("!") + 1, legendRef.length());
            int[] rc = ExcelTools.getRowColFromString(legendRef);
            rc[0] = rc[0] + 1;
            legendRef = String.valueOf(sheetnm) + "!" + ExcelTools.formatLocation(rc);
        } else {
            legendRef = legendRef == null ? theHandle.getSeriesLegend() : "";
        }
        String categoryRange = theHandle.getCategoryRange();
        String seriesRange = theHandle.getSeriesRange();
        String sheetnm = seriesRange.substring(0, seriesRange.indexOf("!"));
        seriesRange = seriesRange.substring(seriesRange.indexOf("!") + 1, seriesRange.length());
        int[] rc = ExcelTools.getRangeRowCol(seriesRange);
        int[] newRc = new int[]{rc[1], rc[0] + 1, rc[3], rc[2] + 1};
        seriesRange = String.valueOf(sheetnm) + "!" + ExcelTools.formatRange(newRc);
        try {
            return this.addSeriesRange(legendRef, "", categoryRange, seriesRange, "", nChart);
        }
        catch (CellNotFoundException e) {
            Logger.logErr("ChartHandle.appendRowSeriesToChart: Unable to append series to chart: " + e);
            return null;
        }
    }

    public void appendRowCategoryToChart() {
        this.appendRowCategoryToChart(0);
    }

    public void appendRowCategoryToChart(int nChart) {
        ChartSeriesHandle[] handles = this.getAllChartSeriesHandles(nChart);
        int i = 0;
        while (i < handles.length) {
            ChartSeriesHandle theHandle = handles[i];
            String seriesRange = theHandle.getSeriesRange();
            String[] s = ExcelTools.stripSheetNameFromRange(seriesRange);
            String sheetnm = s[0];
            seriesRange = s[1];
            int[] rc = ExcelTools.getRangeRowCol(seriesRange);
            int[] newRc = new int[]{rc[1], rc[0], rc[3], rc[2] + 1};
            seriesRange = String.valueOf(sheetnm) + "!" + ExcelTools.formatRange(newRc);
            theHandle.setSeriesRange(seriesRange);
            seriesRange = theHandle.getCategoryRange();
            s = ExcelTools.stripSheetNameFromRange(seriesRange);
            sheetnm = s[0];
            seriesRange = s[1];
            rc = ExcelTools.getRangeRowCol(seriesRange);
            newRc = new int[]{rc[1], rc[0], rc[3], rc[2] + 1};
            seriesRange = String.valueOf(sheetnm) + "!" + ExcelTools.formatRange(newRc);
            theHandle.setCategoryRange(seriesRange);
            ++i;
        }
    }

    public byte[] getChartBytes() {
        return this.mychart.getChartBytes();
    }

    public byte[] getSerialBytes() {
        return this.mychart.getSerialBytes();
    }

    private String getChartOptionsXML() {
        return this.mychart.getChartOptionsXML(0);
    }

    private String t(int n) {
        String tabs = "\t\t\t\t\t\t\t\t\t\t\t\t\t";
        return tabs.substring(0, n);
    }

    public void parseXML(WorkSheetHandle sht, XmlPullParser xpp, HashMap maps) {
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("ChartFonts")) {
                        int x = 0;
                        while (x < xpp.getAttributeCount()) {
                            this.setChartFont(xpp.getAttributeName(x), xpp.getAttributeValue(x));
                            ++x;
                        }
                    } else if (tnm.equals("ChartFontRec")) {
                        Font f;
                        String fName = "";
                        int fontId = 0;
                        int fSize = 0;
                        int fWeight = 0;
                        int fColor = 0;
                        int fUnderline = 0;
                        boolean bIsBold = false;
                        int x = 0;
                        while (x < xpp.getAttributeCount()) {
                            String attr = xpp.getAttributeName(x);
                            String val = xpp.getAttributeValue(x);
                            if (attr.equals("name")) {
                                fName = val;
                            } else if (attr.equals("id")) {
                                fontId = Integer.parseInt(val);
                            } else if (attr.equals("size")) {
                                fSize = Font.PointsToFontHeight(Double.parseDouble(val));
                            } else if (attr.equals("color")) {
                                fColor = FormatHandle.HexStringToColorInt(val, FormatHandle.colorFONT);
                                if (fColor == 0) {
                                    fColor = Short.MAX_VALUE;
                                }
                            } else if (attr.equals("weight")) {
                                fWeight = Integer.parseInt(val);
                            } else if (attr.equals("bold")) {
                                bIsBold = true;
                            } else if (attr.equals("underline")) {
                                fUnderline = Integer.parseInt(val);
                            }
                            ++x;
                        }
                        while (this.getWorkBook().getNumFonts() < fontId - 1) {
                            this.getWorkBook().insertFont(new Font("Arial", 400, 10));
                        }
                        if (this.getWorkBook().getNumFonts() < fontId) {
                            f = new Font(fName, fWeight, fSize);
                            f.setColor(fColor);
                            f.setBold(bIsBold);
                            f.setUnderlineStyle((byte)fUnderline);
                            this.getWorkBook().insertFont(f);
                        } else {
                            f = this.getWorkBook().getFont(fontId);
                            f.setFontWeight(fWeight);
                            f.setFontName(fName);
                            f.setFontHeight(fSize);
                            f.setColor(fColor);
                            f.setBold(bIsBold);
                            f.setUnderlineStyle((byte)fUnderline);
                        }
                    } else if (!tnm.equals("FormatChartArea")) {
                        HashMap map;
                        String[] s;
                        if (tnm.equals("Series")) {
                            String legend = "";
                            String series = "";
                            String category = "";
                            String bubble = "";
                            String dataTypeX = "";
                            String dataTypeY = "";
                            String shape = "";
                            int x = 0;
                            while (x < xpp.getAttributeCount()) {
                                if (xpp.getAttributeName(x).equalsIgnoreCase("Legend")) {
                                    legend = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Range")) {
                                    series = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Category")) {
                                    category = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Bubbles")) {
                                    bubble = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("TypeX")) {
                                    dataTypeX = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("TypeY")) {
                                    dataTypeY = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Shape")) {
                                    shape = xpp.getAttributeValue(x);
                                }
                                ++x;
                            }
                            s = new String[]{legend, series, category, bubble, dataTypeX, dataTypeY, shape};
                            map = (HashMap)maps.get("chartseries");
                            map.put(s, this);
                        } else if (tnm.equals("ChartOptions")) {
                            int x = 0;
                            while (x < xpp.getAttributeCount()) {
                                this.setChartOption(xpp.getAttributeName(x), xpp.getAttributeValue(x));
                                ++x;
                            }
                        } else if (tnm.equals("ThreeD")) {
                            this.make3D();
                            int x = 0;
                            while (x < xpp.getAttributeCount()) {
                                this.setChartOption(xpp.getAttributeName(x), xpp.getAttributeValue(x));
                                ++x;
                            }
                        } else if (tnm.endsWith("Axis")) {
                            int type = 0;
                            String axis = xpp.getName();
                            if (axis.equalsIgnoreCase("XAxis")) {
                                type = 0;
                            } else if (axis.equalsIgnoreCase("YAxis")) {
                                type = 1;
                            } else if (axis.equalsIgnoreCase("ZAxis")) {
                                type = 2;
                            }
                            if (xpp.getAttributeCount() > 0) {
                                int x = 0;
                                while (x < xpp.getAttributeCount()) {
                                    this.setAxisOption(type, xpp.getAttributeName(x), xpp.getAttributeValue(x));
                                    ++x;
                                }
                            } else {
                                this.removeAxis(type);
                            }
                        } else if (tnm.equals("Series")) {
                            String legend = "";
                            String series = "";
                            String category = "";
                            String bubble = "";
                            String dataTypeX = "";
                            String dataTypeY = "";
                            String shape = "";
                            int x = 0;
                            while (x < xpp.getAttributeCount()) {
                                if (xpp.getAttributeName(x).equalsIgnoreCase("Legend")) {
                                    legend = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Range")) {
                                    series = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Category")) {
                                    category = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Bubbles")) {
                                    bubble = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("TypeX")) {
                                    dataTypeX = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("TypeY")) {
                                    dataTypeY = xpp.getAttributeValue(x);
                                } else if (xpp.getAttributeName(x).equalsIgnoreCase("Shape")) {
                                    shape = xpp.getAttributeValue(x);
                                }
                                ++x;
                            }
                            s = new String[]{legend, series, category, bubble, dataTypeX, dataTypeY, shape};
                            map = (HashMap)maps.get("chartseries");
                            map.put(s, this);
                        }
                    }
                } else if (eventType == 3 && xpp.getName().equals("Chart")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logWarn("ChartHandle.parseXML <" + xpp.getName() + ">: " + e.toString());
        }
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.t(1)) + "<Chart");
        sb.append(" Name=\"" + this.getTitle() + "\"");
        sb.append(" type=\"" + this.getChartType() + "\"");
        sb.append(" Fill=\"" + this.getPlotAreaBgColor() + "\"");
        short[] coords = this.mychart.getCoords();
        sb.append(" Left=\"" + coords[0] + "\" Top=\"" + coords[1] + "\" Width=\"" + coords[2] + "\" Height=\"" + coords[3] + "\"");
        sb.append(">\n");
        sb.append(String.valueOf(this.t(2)) + "<ChartFontRecs>" + this.getChartFontRecsXML());
        sb.append("\n" + this.t(2) + "</ChartFontRecs>\n");
        sb.append(String.valueOf(this.t(2)) + "<ChartFonts" + this.getChartFontsXML() + "/>\n");
        sb.append(String.valueOf(this.t(2)) + "<FormatChartArea>\n");
        sb.append(String.valueOf(this.t(3)) + "<ChartBorder></ChartBorder>\n");
        sb.append(String.valueOf(this.t(3)) + "<ChartProperties></ChartProperties>\n");
        sb.append(String.valueOf(this.t(2)) + "</FormatChartArea>\n");
        sb.append(String.valueOf(this.t(2)) + "<SourceData>\n");
        ChartSeriesHandle[] series = this.getAllChartSeriesHandles();
        int i = 0;
        while (i < series.length) {
            sb.append(String.valueOf(this.t(3)) + "<Series Legend=\"" + series[i].getSeriesLegendReference() + "\"");
            sb.append(" Range=\"" + series[i].getSeriesRange() + "\"");
            sb.append(" Category=\"" + series[i].getCategoryRange() + "\"");
            if (series[i].hasBubbleSizes()) {
                sb.append(" Bubbles=\"" + series[i].getBubbleSizes() + "\"");
            }
            sb.append(" TypeX=\"" + series[i].getCategoryDataType() + "\"");
            sb.append(" TypeY=\"" + series[i].getSeriesDataType() + "\"");
            sb.append(" Shape=\"" + series[i].getShape() + "\"");
            sb.append("/>\n");
            ++i;
        }
        sb.append(String.valueOf(this.t(2)) + "</SourceData>\n");
        sb.append(String.valueOf(this.t(2)) + "<ChartOptions");
        sb.append(this.getChartOptionsXML());
        sb.append("/>\n");
        sb.append(String.valueOf(this.t(2)) + "<Axes>\n");
        sb.append(String.valueOf(this.t(3)) + "<XAxis" + this.getAxisOptionsXML(0) + "/>\n");
        sb.append(String.valueOf(this.t(3)) + "<YAxis" + this.getAxisOptionsXML(1) + "/>\n");
        sb.append(String.valueOf(this.t(3)) + "<ZAxis" + this.getAxisOptionsXML(2) + "/>\n");
        sb.append(String.valueOf(this.t(2)) + "</Axes>\n");
        if (this.isThreeD()) {
            sb.append(String.valueOf(this.t(2)) + "<ThreeD" + this.getThreeDXML() + "/>\n");
        }
        sb.append(String.valueOf(this.t(1)) + "</Chart>\n");
        return sb.toString();
    }

    public String getOOXML(int rId) {
        StringBuffer cooxml = new StringBuffer();
        try {
            OOXMLChart thischart;
            this.mychart.getChartSeries().resetSeriesNumber();
            String catAxisId = Integer.toString((int)(Math.random() * 1000000.0));
            String valAxisId = Integer.toString((int)(Math.random() * 1000000.0));
            String serAxisId = Integer.toString((int)(Math.random() * 1000000.0));
            if (this.mychart instanceof OOXMLChart) {
                thischart = (OOXMLChart)this.mychart;
            } else {
                thischart = new OOXMLChart(this.mychart, this.wbh);
                this.mychart = thischart;
                thischart.getChartSeries().setParentChart(thischart);
            }
            thischart.wbh = this.wbh;
            cooxml.append(thischart.getOOXML(catAxisId, valAxisId, serAxisId));
            ArrayList chartEmbeds = thischart.getChartEmbeds();
            if (chartEmbeds != null) {
                int j = 0;
                int i = 0;
                while (i < chartEmbeds.size()) {
                    if (((String[])chartEmbeds.get(i))[0].equals("userShape")) {
                        cooxml.append("<c:userShapes r:id=\"rId" + ++j + "\"/>");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Logger.logErr("ChartHandle.getOOXML: error generating OOXML.  Chart not created: " + e.toString());
        }
        return cooxml.toString();
    }

    public String getChartDrawingOOXML(int id) {
        TwoCellAnchor t = new TwoCellAnchor(((OOXMLChart)this.mychart).getEditMovement());
        t.setAsChart(id, OOXMLAdapter.stripNonAscii(this.getOOXMLName()).toString(), TwoCellAnchor.convertBoundsFromBIFF8(this.getSheet(), this.mychart.getBounds()));
        return t.getOOXML();
    }

    public void parseOOXML(InputStream ii) {
        try {
            OOXMLChart thischart = (OOXMLChart)this.mychart;
            int drawingOrder = 0;
            boolean hasPivotTableSource = false;
            this.setTitle("");
            this.mychart.getAxes().setPlotAreaBgColor(1);
            this.mychart.getAxes().setPlotAreaBorder(-1, -1);
            Stack<String> lastTag = new Stack<String>();
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block19: {
                    block18: {
                        String tnm;
                        block28: {
                            String parent;
                            block29: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            block20: {
                                                                if (eventType != 2) break block18;
                                                                tnm = xpp.getName();
                                                                lastTag.push(tnm);
                                                                if (tnm.equals("chart")) break block19;
                                                                if (!tnm.equals("lang")) break block20;
                                                                thischart.lang = xpp.getAttributeValue(0);
                                                                break block19;
                                                            }
                                                            if (!tnm.equals("roundedCorners")) break block21;
                                                            thischart.roundedCorners = xpp.getAttributeValue(0).equals("1");
                                                            break block19;
                                                        }
                                                        if (!tnm.equals("pivotSource")) break block22;
                                                        hasPivotTableSource = true;
                                                        break block19;
                                                    }
                                                    if (!tnm.equals("view3D")) break block23;
                                                    ThreeD.parseOOXML(xpp, lastTag, thischart);
                                                    break block19;
                                                }
                                                if (!tnm.equals("layout")) break block24;
                                                thischart.plotAreaLayout = (Layout)Layout.parseOOXML(xpp, lastTag).cloneElement();
                                                break block19;
                                            }
                                            if (!tnm.equals("legend")) break block25;
                                            thischart.showLegend(true, false);
                                            thischart.ooxmlLegend = (Legend)Legend.parseOOXML(xpp, lastTag, this.wbh).cloneElement();
                                            thischart.ooxmlLegend.fill2003Legend(thischart.getLegend());
                                            break block19;
                                        }
                                        if (!tnm.equals(OOXMLConstants.twoDchartTypes[1]) && !tnm.equals(OOXMLConstants.twoDchartTypes[2]) && !tnm.equals(OOXMLConstants.twoDchartTypes[3]) && !tnm.equals(OOXMLConstants.twoDchartTypes[4]) && !tnm.equals(OOXMLConstants.twoDchartTypes[5]) && !tnm.equals(OOXMLConstants.twoDchartTypes[6]) && !tnm.equals(OOXMLConstants.twoDchartTypes[7]) && !tnm.equals(OOXMLConstants.twoDchartTypes[8]) && !tnm.equals(OOXMLConstants.twoDchartTypes[9]) && !tnm.equals(OOXMLConstants.twoDchartTypes[10]) && !tnm.equals(OOXMLConstants.twoDchartTypes[18]) && !tnm.equals(OOXMLConstants.threeDchartTypes[1]) && !tnm.equals(OOXMLConstants.threeDchartTypes[2]) && !tnm.equals(OOXMLConstants.threeDchartTypes[3]) && !tnm.equals(OOXMLConstants.threeDchartTypes[4]) && !tnm.equals(OOXMLConstants.threeDchartTypes[5]) && !tnm.equals(OOXMLConstants.threeDchartTypes[7])) break block26;
                                        ChartType.parseOOXML(xpp, this.wbh, this.mychart, drawingOrder++);
                                        lastTag.pop();
                                        break block19;
                                    }
                                    if (!tnm.equals("title")) break block27;
                                    thischart.setOOXMLTitle((Title)Title.parseOOXML(xpp, lastTag, this.wbh).cloneElement(), this.wbh);
                                    this.setTitle(thischart.getOOXMLTitle().getTitle());
                                    break block19;
                                }
                                if (!tnm.equals("spPr")) break block28;
                                parent = (String)lastTag.get(lastTag.size() - 2);
                                if (!parent.equals("plotArea")) break block29;
                                thischart.setSpPr(0, (SpPr)SpPr.parseOOXML(xpp, lastTag, this.wbh).cloneElement());
                                break block19;
                            }
                            if (!parent.equals("chartSpace")) break block19;
                            thischart.setSpPr(1, (SpPr)SpPr.parseOOXML(xpp, lastTag, this.wbh).cloneElement());
                            break block19;
                        }
                        if (tnm.equals("txPr")) {
                            thischart.setTxPr((TxPr)TxPr.parseOOXML(xpp, lastTag, this.wbh).cloneElement());
                        } else if (tnm.equals("catAx")) {
                            this.mychart.getAxes().parseOOXML(0, xpp, tnm, lastTag, this.wbh);
                        } else if (tnm.equals("valAx")) {
                            if (this.mychart.getAxes().hasAxis(0)) {
                                this.mychart.getAxes().parseOOXML(1, xpp, tnm, lastTag, this.wbh);
                            } else if (this.mychart.getAxes().hasAxis(1)) {
                                this.mychart.getAxes().parseOOXML(3, xpp, tnm, lastTag, this.wbh);
                            } else {
                                this.mychart.getAxes().parseOOXML(1, xpp, tnm, lastTag, this.wbh);
                            }
                        } else if (tnm.equals("serAx")) {
                            this.mychart.getAxes().parseOOXML(2, xpp, tnm, lastTag, this.wbh);
                        } else {
                            tnm.equals("dateAx");
                        }
                        break block19;
                    }
                    if (eventType == 3) {
                        lastTag.pop();
                        String endTag = xpp.getName();
                        if (endTag.equals("chartSpace")) {
                            this.setDimensionsRecord();
                            break;
                        }
                    }
                }
                eventType = xpp.getEventType() != 1 ? xpp.next() : 1;
            }
        }
        catch (Exception e) {
            Logger.logErr("ChartHandle.parseChartOOXML: " + e.toString());
        }
    }

    public void setEditMovement(String editMovement) {
        ((OOXMLChart)this.mychart).setEditMovement(editMovement);
    }

    private String getOOXMLName() {
        return ((OOXMLChart)this.mychart).getOOXMLName();
    }

    public void setOOXMLName(String name) {
        ((OOXMLChart)this.mychart).setOOXMLName(name);
    }

    public ArrayList getChartEmbeds() {
        return ((OOXMLChart)this.mychart).getChartEmbeds();
    }

    public void addChartEmbed(String[] ce) {
        ((OOXMLChart)this.mychart).addChartEmbed(ce);
    }

    protected void setDimensionsRecord() {
        ChartSeriesHandle[] series = this.getAllChartSeriesHandles();
        int nSeries = series.length;
        int nPoints = 0;
        int i = 0;
        while (i < series.length) {
            try {
                int[] coords = ExcelTools.getRangeCoords(series[i].getSeriesRange());
                nPoints = coords[3] > coords[1] ? Math.max(nPoints, coords[3] - coords[1] + 1) : Math.max(nPoints, coords[2] - coords[0] + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.mychart.setDimensionsRecord(0, nPoints, 0, nSeries);
    }

    public void setChartOption(String op, String val) {
        this.mychart.setChartOption(op, val);
    }

    private void setChartOption(String op, String val, int nChart) {
        this.mychart.setChartOption(op, val, nChart);
    }

    private boolean isThreeD(int nChart) {
        return this.mychart.isThreeD(nChart);
    }

    public boolean isThreeD() {
        return this.mychart.isThreeD(0);
    }

    public boolean isStacked() {
        return this.mychart.isStacked(0);
    }

    public boolean is100PercentStacked() {
        return this.mychart.is100PercentStacked(0);
    }

    public boolean isClustered() {
        return this.mychart.isClustered(0);
    }

    public String getThreeDXML() {
        return this.mychart.getThreeDXML(0);
    }

    private ThreeD initThreeD(int nChart) {
        return this.mychart.initThreeD(nChart, this.getChartType(nChart));
    }

    private String getAxisOptionsXML(int Axis2) {
        return this.mychart.getAxes().getAxisOptionsXML(Axis2);
    }

    public int getAxisPlacement(int Axis2) {
        return this.mychart.getAxes().getAxisPlacement(Axis2);
    }

    public void setAxisPlacement(int Axis2, int Placement) {
        this.mychart.getAxes().setAxisPlacement(Axis2, Placement);
        this.mychart.setDirtyFlag(true);
    }

    public void removeAxis(int axisType) {
        this.mychart.getAxes().removeAxis(axisType);
        this.mychart.setDirtyFlag(true);
    }

    public String getChartFontRecsXML() {
        return this.mychart.getChartFontRecsXML();
    }

    public String getChartFontsXML() {
        return this.mychart.getChartFontsXML();
    }

    public void setChartFont(String type, String val) {
        this.mychart.setChartFont(type, val);
    }

    public WorkBook getWorkBook() {
        return this.mychart.getWorkBook();
    }

    public WorkBookHandle getWorkBookHandle() {
        return this.wbh;
    }

    public WorkSheetHandle getWorkSheetHandle() {
        try {
            return this.wbh.getWorkSheet(this.mychart.getSheet().getSheetNum());
        }
        catch (WorkSheetNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBounds(short[] bounds) {
        this.mychart.setCoords(bounds);
    }

    public short[] getBounds() {
        return this.mychart.getCoords();
    }

    public void setCoords(short[] coords) {
        this.mychart.setCoords(coords);
    }

    public short[] getCoords() {
        this.mychart.getMetrics(this.wbh);
        return this.mychart.getCoords();
    }

    public short[] getRelativeBounds() {
        return this.mychart.getBounds();
    }

    public short getColOffset() {
        return this.mychart.getColOffset();
    }

    public void setRelativeBounds(short[] bounds) {
        this.mychart.setBounds(bounds);
    }

    public void setDataLabel(String type, boolean bShowLegendKey) {
        if (!bShowLegendKey) {
            this.mychart.setChartOption("DataLabel", type);
        } else {
            this.mychart.setChartOption("DataLabelWithLegendKey", type);
        }
    }

    public void showDataTable(boolean bShow) {
        this.mychart.showDataTable(bShow);
    }

    public void showLegend(boolean bShow, boolean vertical) {
        this.mychart.showLegend(bShow, vertical);
    }

    public boolean hasDataLegend() {
        return this.mychart.hasDataLegend();
    }

    public void removeLegend() {
        this.mychart.removeLegend();
    }

    @Deprecated
    public void makeStacked(int nChart) {
        int chartType = this.getChartType(nChart);
        this.setChartOption("Stacked", "true", nChart);
        switch (chartType) {
            case 0: 
            case 1: {
                this.setChartOption("Overlap", "-100", nChart);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.setChartOption("Overlap", "-100", nChart);
                ThreeD td = this.initThreeD(nChart);
                td.setChartOption("Cluster", "false");
                break;
            }
            case 2: {
                this.setChartOption("Percentage", "0", nChart);
                break;
            }
            case 4: {
                this.setChartOption("Overlap", "-100", nChart);
                this.setChartOption("Percentage", "25", nChart);
                this.setChartOption("SmoothedLine", "true", nChart);
            }
        }
    }

    @Deprecated
    public void make100PercentStacked(int nChart) {
        int chartType = this.getChartType(nChart);
        this.setChartOption("Stacked", "true", nChart);
        this.setChartOption("PercentageDisplay", "true", nChart);
        switch (chartType) {
            case 0: 
            case 1: {
                this.setChartOption("Overlap", "-100", nChart);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.setChartOption("Overlap", "-100", nChart);
                ThreeD td = this.initThreeD(nChart);
                td.setChartOption("Cluster", "false");
                break;
            }
        }
    }

    public void makeStacked3D(int nChart) {
        int chartType = this.getChartType(nChart);
        this.setChartOption("Stacked", "true", nChart);
        ThreeD td = this.initThreeD(nChart);
        td.setChartOption("AnRot", "20");
        td.setChartOption("ThreeDScaling", "true");
        td.setChartOption("TwoDWalls", "true");
        switch (chartType) {
            case 0: 
            case 1: {
                this.setChartOption("Overlap", "-100", nChart);
                break;
            }
            case 4: {
                this.setChartOption("Percentage", "25", nChart);
                this.setChartOption("SmoothedLine", "true", nChart);
            }
        }
    }

    @Deprecated
    public void make100PercentStacked3D(int nChart) {
        int chartType = this.getChartType(nChart);
        this.setChartOption("Stacked", "true", nChart);
        this.setChartOption("PercentageDisplay", "true", nChart);
        switch (chartType) {
            case 0: 
            case 1: {
                this.setChartOption("Overlap", "-100", nChart);
                ThreeD td = this.initThreeD(nChart);
                td.setChartOption("AnRot", "20");
                td.setChartOption("ThreeDScaling", "true");
                td.setChartOption("TwoDWalls", "true");
                break;
            }
            case 4: {
                this.setChartOption("Percentage", "25", nChart);
                this.setChartOption("SmoothedLine", "true", nChart);
            }
        }
    }

    @Deprecated
    public void make3D() {
        this.make3D(0);
    }

    @Deprecated
    public void make3D(int nChart) {
        int chartType = this.getChartType(nChart);
        ThreeD td = null;
        switch (chartType) {
            case 0: 
            case 1: {
                td = this.initThreeD(nChart);
                td.setChartOption("AnRot", "20");
                td.setChartOption("ThreeDScaling", "true");
                td.setChartOption("TwoDWalls", "true");
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                td = this.initThreeD(nChart);
                td.setChartOption("Cluster", "false");
                break;
            }
            case 4: {
                this.setChartOption("Percentage", "25", nChart);
                this.setChartOption("SmoothedLine", "true", nChart);
                td = this.initThreeD(nChart);
                td.setChartOption("AnRot", "20");
                td.setChartOption("ThreeDScaling", "true");
                td.setChartOption("TwoDWalls", "true");
                td.setChartOption("Perspective", "true");
                break;
            }
            case 2: 
            case 3: {
                this.initThreeD(nChart);
                break;
            }
            case 9: {
                this.setChartOption("Percentage", "25", nChart);
                this.setChartOption("SmoothedLine", "true", nChart);
                this.setChartOption("ThreeDBubbles", "true", nChart);
                td = this.initThreeD(nChart);
            }
        }
    }

    @Deprecated
    public void makeClustered3D(int nChart) {
        int chartType = this.getChartType(nChart);
        switch (chartType) {
            case 0: 
            case 1: {
                ThreeD td = this.initThreeD(nChart);
                td.setChartOption("AnRot", "20");
                td.setChartOption("Cluster", "true");
                td.setChartOption("ThreeDScaling", "true");
                td.setChartOption("TwoDWalls", "true");
            }
        }
    }

    @Deprecated
    public void makeExploded() {
        int chartType = this.getChartType();
        switch (chartType) {
            case 8: {
                this.setChartOption("SmoothedLine", "true");
            }
            case 3: {
                this.setChartOption("ShowLdrLines", "true");
                this.setChartOption("Percentage", "25");
            }
        }
    }

    @Deprecated
    public void makeExploded3D(int nChart) {
        int chartType = this.getChartType(nChart);
        switch (chartType) {
            case 3: 
            case 8: {
                this.setChartOption("ShowLdrLines", "true", nChart);
                this.setChartOption("Percentage", "25", nChart);
                ThreeD td = this.initThreeD(nChart);
                td.setChartOption("AnRot", "236");
            }
        }
    }

    public void setMarkerFormat(int imf) {
        this.setChartOption("MarkerFormat", String.valueOf(imf));
    }

    public String getJSON() {
        JSONObject theChart = new JSONObject();
        try {
            JSONObject titles = new JSONObject();
            int type = this.getChartType();
            titles.put("title", (Object)this.getTitle());
            titles.put("XAxis", (Object)(type != 1 ? this.getXAxisLabel() : this.getYAxisLabel()));
            titles.put("YAxis", (Object)(type != 1 ? this.getYAxisLabel() : this.getXAxisLabel()));
            try {
                titles.put("ZAxis", (Object)this.getZAxisLabel());
            }
            catch (Exception e) {
                Logger.logWarn("ChartHandle.getJSON failed getting zaxislable:" + e.toString());
            }
            theChart.put("titles", (Object)titles);
            short[] coords = this.mychart.getCoords();
            theChart.put("width", (int)coords[2]);
            theChart.put("height", (int)coords[3]);
            theChart.put("row", this.mychart.getRow0());
            theChart.put("col", this.mychart.getCol0());
            int plotAreabg = this.getPlotAreaBgColor();
            if (plotAreabg == 77 || plotAreabg == 78) {
                plotAreabg = 1;
            }
            theChart.put("fill", (Object)FormatConstants.SVGCOLORSTRINGS[plotAreabg]);
            Double[] jMinMax = new Double[3];
            JSONObject chartObjectJSON = this.mychart.getChartObject().getJSON(this.mychart.getChartSeries(), this.wbh, jMinMax);
            double yMax = 1.0;
            double yMin = 0.0;
            int nSeries = 0;
            try {
                theChart.put("Series", (Object)chartObjectJSON.getJSONArray("Series"));
                this.mychart.setSeriesJSON(chartObjectJSON.getJSONArray("Series"));
                theChart.put("SeriesFills", (Object)chartObjectJSON.getJSONArray("SeriesFills"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            theChart.put("type", (Object)chartObjectJSON.getJSONObject("type"));
            yMin = jMinMax[0];
            yMax = jMinMax[1];
            nSeries = jMinMax[2].intValue();
            try {
                theChart.put("y", (Object)this.mychart.getAxes().getJSON(1, this.wbh, type, yMax, yMin, nSeries).getJSONObject("y"));
                theChart.put("back_grid", (Object)this.mychart.getAxes().getJSON(1, this.wbh, type, yMax, yMin, nSeries).getJSONObject("back_grid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                theChart.put("x", (Object)this.mychart.getAxes().getJSON(0, this.wbh, type, yMax, yMin, nSeries).getJSONObject("x"));
                theChart.put("back_grid", (Object)this.mychart.getAxes().getJSON(1, this.wbh, type, yMax, yMin, nSeries).getJSONObject("back_grid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.hasDataLegend()) {
                short s = this.mychart.getLegend().getLegendPosition();
                String[] legends = this.mychart.getLegends(-1);
                String l = "";
                int i = 0;
                while (i < legends.length) {
                    l = String.valueOf(l) + legends[i] + ",";
                    ++i;
                }
                if (l.length() > 0) {
                    l = l.substring(0, l.length() - 1);
                }
                theChart.put("legend", (Object)new JSONObject("{position:" + s + ",labels:[" + l + "]}"));
            }
        }
        catch (JSONException e) {
            Logger.logErr("Error getting Chart JSON: " + (Object)((Object)e));
        }
        return theChart.toString();
    }

    protected void inputJSONObject(JSONObject source, JSONObject input) {
        if (source != null) {
            try {
                int j = 0;
                while (j < input.names().length()) {
                    source.put(input.names().getString(j), input.get(input.names().getString(j)));
                    ++j;
                }
            }
            catch (JSONException e) {
                Logger.logErr("Error inputting JSON Object: " + (Object)((Object)e));
            }
        }
    }

    public JSONArray getSeriesJSON() {
        return this.mychart.getSeriesJSON();
    }

    public void setSeriesJSON(JSONArray s) throws JSONException {
        this.mychart.setSeriesJSON(s);
    }

    public JSONObject getCurrentSeries() {
        JSONObject retJSON = new JSONObject();
        Double[] jMinMax = new Double[3];
        try {
            JSONObject chartObjectJSON = this.mychart.getChartObject().getJSON(this.mychart.getChartSeries(), this.wbh, jMinMax);
            try {
                retJSON.put("Series", (Object)chartObjectJSON.getJSONArray("Series"));
            }
            catch (Exception e) {
                Logger.logWarn("ChartHandle.getCurrentSeries problem:" + e.toString());
            }
            double yMax = 0.0;
            double yMin = 0.0;
            int nSeries = 0;
            yMin = jMinMax[0];
            yMax = jMinMax[1];
            nSeries = jMinMax[2].intValue();
            int n = this.getChartType();
        }
        catch (JSONException e) {
            Logger.logErr("ChartHandle.getCurrentSeries: Error getting Series JSON: " + (Object)((Object)e));
        }
        return retJSON;
    }

    public String getAllSeriesDataJSON() {
        JSONArray s = new JSONArray();
        ChartSeriesHandle[] series = this.getAllChartSeriesHandles();
        try {
            int i = 0;
            while (i < series.length) {
                JSONObject ser = new JSONObject();
                ser.put("l", (Object)series[i].getSeriesLegendReference());
                ser.put("v", (Object)series[i].getSeriesRange());
                ser.put("b", (Object)series[i].getBubbleSizes());
                if (i == 0) {
                    ser.put("c", (Object)series[i].getCategoryRange());
                }
                s.put((Object)ser);
                ++i;
            }
        }
        catch (JSONException e) {
            Logger.logErr("ChartHandle.getAllSeriesDataJSON: " + (Object)((Object)e));
        }
        return s.toString();
    }

    public String getSVG() {
        return this.getSVG(1.0);
    }

    public String getSVG(double scale) {
        HashMap chartMetrics = this.mychart.getMetrics(this.wbh);
        StringBuffer svg = new StringBuffer();
        svg.append("<svg width='" + (Double)chartMetrics.get("canvasw") * scale + "px' height='" + (Double)chartMetrics.get("canvash") * scale + "px' version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\"  xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n");
        svg.append("<g transform='scale(" + scale + ")'  onclick='null;' onmousedown='handleClick(evt);' style='width:100%; height:" + (Double)chartMetrics.get("canvash") * scale + "px'>");
        svg.append(this.getJavaScript());
        String legendSVG = this.getLegendSVG(chartMetrics);
        String bgclr = this.mychart.getPlotAreaBgColor();
        svg.append("<defs>");
        svg.append("<linearGradient id='bg_gradient' x1='0' y1='0' x2='0' y2='100%'>");
        svg.append("<stop offset='0' style='stop-color:" + bgclr + "; stop-opacity:1'/>");
        svg.append("<stop offset='" + chartMetrics.get("w") + "' style='stop-color:white; stop-opacity:.5'/>");
        svg.append("</linearGradient>");
        svg.append("</defs>");
        if (!(this.mychart instanceof OOXMLChart) || !((OOXMLChart)this.mychart).roundedCorners) {
            svg.append("<rect x='0' y='0' width='" + chartMetrics.get("canvasw") + "' height='" + chartMetrics.get("canvash") + "' style='fill-opacity:1;fill:white' stroke='#CCCCCC' stroke-width='1' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'/>\r\n");
        } else {
            svg.append("<rect x='0' y='0' width='" + chartMetrics.get("canvasw") + "' height='" + chartMetrics.get("canvash") + "' rx='20' ry='20" + "' style='fill-opacity:1;fill:white' stroke='#CCCCCC' stroke-width='1' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'/>\r\n");
        }
        svg.append("<rect fill='" + bgclr + "'  style='fill-opacity:1;fill:url(#bg_gradient)' stroke='none' stroke-opacity='.5' stroke-width='1' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'" + " x='" + chartMetrics.get("x") + "' y='" + chartMetrics.get("y") + "' width='" + chartMetrics.get("w") + "' height='" + chartMetrics.get("h") + "' fill-rule='evenodd'/>\r\n");
        svg.append(this.mychart.getAxes().getSVG(0, chartMetrics, this.mychart.getChartSeries().getCategories()));
        svg.append(this.mychart.getAxes().getSVG(1, chartMetrics, this.mychart.getChartSeries().getCategories()));
        svg.append(this.mychart.getChartObject().getSVG(chartMetrics, this.mychart.getAxes().getMetrics(), this.mychart.getChartSeries()));
        svg.append(legendSVG);
        if (this.mychart.getTitleTd() != null) {
            svg.append(this.mychart.getTitleTd().getSVG(chartMetrics));
        }
        svg.append("</g>");
        svg.append("</svg>");
        return svg.toString();
    }

    private String getLegendSVG(HashMap<String, Double> chartMetrics) {
        try {
            return this.mychart.getLegend().getSVG(chartMetrics, this.mychart.getChartObject(), this.mychart.getChartSeries());
        }
        catch (NullPointerException ne) {
            return null;
        }
    }

    protected String getJavaScript() {
        StringBuffer svg = new StringBuffer();
        svg.append("<script type='text/ecmascript'>");
        svg.append("  <![CDATA[");
        svg.append("try{var grid = parent.parent.uiWindowing.getActiveDoc().getContent().contentWindow;");
        svg.append("var selection = new grid.cellSelectionResizable();}catch(x){;}");
        svg.append("function highLight(evt) {");
        svg.append("this.bgc = evt.target.getAttributeNS(null, 'fill');");
        svg.append("evt.target.setAttributeNS(null,'fill','gold');");
        svg.append("evt.target.setAttributeNS(null,'stroke-width','2');");
        svg.append("}");
        svg.append("function restore(evt) {");
        svg.append("evt.target.setAttributeNS(null,'fill',this.bgc);");
        svg.append("evt.target.setAttributeNS(null,'stroke-width','1');");
        svg.append("}");
        svg.append("function handleClick(evt) {");
        svg.append("try{parent.chart.handleClick(evt);}catch(e){;}");
        svg.append("}");
        svg.append("\r\n");
        svg.append("function showRange(range) {");
        svg.append("try{selection.select(new grid.cellRange(range.toString())).show();}catch(x){;}");
        svg.append("}");
        svg.append("\r\n");
        svg.append("function hideRange() {");
        svg.append("try{selection.clear();}catch(x){;}");
        svg.append("}");
        svg.append("]]>");
        svg.append("</script>");
        return svg.toString();
    }

    public void WriteMainChartRecs(String fName) {
        this.mychart.getChartObject().WriteMainChartRecs(fName);
    }

    public static enum ChartOptions {
        CLUSTERED,
        STACKED,
        PERCENTSTACKED,
        THREED,
        EXPLODED,
        HASLINES,
        SMOOTHLINES,
        WIREFRAME,
        DROPLINES,
        UPDOWNBARS,
        SERLINES,
        HILOWLINES,
        FILLED;

    }
}

