/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.charts.Series;

public class ChartSeriesHandle {
    private Series myseries;
    private WorkBookHandle wbh;

    public ChartSeriesHandle(Series series, WorkBookHandle wbk) {
        this.myseries = series;
        this.wbh = wbk;
    }

    public String getSeriesRange() {
        return this.myseries.getSeriesValueAi().toString();
    }

    public String getCategoryRange() {
        return this.myseries.getCategoryValueAi().toString();
    }

    public String getBubbleSizes() {
        return this.myseries.getBubbleValueAi().toString();
    }

    public boolean hasBubbleSizes() {
        return this.myseries.hasBubbleSizes();
    }

    public void setSeriesRange(String seriesRange) {
        this.myseries.getParentChart().setMetricsDirty();
        Ai ai = this.myseries.getSeriesValueAi();
        ai.setParentChart(this.myseries.getParentChart());
        ai.setSheet(this.myseries.getParentChart().getSheet());
        if (ai.getWorkBook() == null) {
            ai.setWorkBook(this.wbh.getWorkBook());
        }
        ai.changeAiLocation(ai.toString(), seriesRange);
        try {
            int[] coords = ExcelTools.getRangeCoords(seriesRange);
            this.myseries.setValueCount(coords[4]);
            this.myseries.getParentChart().setMetricsDirty();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCategoryRange(String categoryRange) {
        this.myseries.getParentChart().setMetricsDirty();
        Ai ai = this.myseries.getCategoryValueAi();
        if (ai.getWorkBook() == null) {
            ai.setWorkBook(this.wbh.getWorkBook());
        }
        ai.changeAiLocation(ai.toString(), categoryRange);
        try {
            int[] coords = ExcelTools.getRangeCoords(categoryRange);
            this.myseries.setCategoryCount(coords[4]);
            this.myseries.getParentChart().setMetricsDirty();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBubbleRange(String bubbleSizes) {
        if (bubbleSizes != null && !bubbleSizes.equals("")) {
            this.myseries.getParentChart().setMetricsDirty();
            Ai ai = this.myseries.getBubbleValueAi();
            if (ai.getWorkBook() == null) {
                ai.setWorkBook(this.wbh.getWorkBook());
            }
            ai.changeAiLocation(ai.toString(), bubbleSizes);
            ai.setRt(2);
            try {
                int[] coords = ExcelTools.getRangeCoords(bubbleSizes);
                this.myseries.setBubbleCount(coords[4]);
                this.myseries.getParentChart().setMetricsDirty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSeriesLegend(String legend) {
        this.myseries.setLegend(legend, this.wbh);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public String getSeriesLegend() {
        return this.myseries.getLegendText();
    }

    public String getSeriesLegendReference() {
        Ai ai = this.myseries.getLegendAi();
        if (ai != null) {
            return ai.getDefinition();
        }
        return null;
    }

    public void setSeriesLegendRef(String legendCell) {
        this.myseries.setLegendRef(legendCell);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public int getCategoryDataType() {
        return this.myseries.getCategoryDataType();
    }

    public int getSeriesDataType() {
        return this.myseries.getValueDataType();
    }

    public void setCategoryDataType(int i) {
        this.myseries.setCategoryDataType(i);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public void setSeriesDataType(int i) {
        this.myseries.setValueDataType(i);
    }

    public int getShape() {
        return this.myseries.getShape();
    }

    public void setShape(int shape) {
        this.myseries.setShape(shape);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public void setSeries(String legendRef, String series, String cat, String bubble) {
        this.setSeriesLegendRef(legendRef);
        this.setSeriesRange(series);
        this.setCategoryRange(cat);
        this.setBubbleRange(bubble);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public void setSeriesColor(int seriesNumber, int clr) {
        this.myseries.setColor(clr);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public void setSeriesColor(int clr) {
        this.myseries.setColor(clr);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public void setSeriesColor(String clr) {
        this.myseries.setColor(clr);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public void setPieChartSliceColor(int clr, int slice) {
        this.myseries.setPieSliceColor(clr, slice);
        this.myseries.getParentChart().setMetricsDirty();
    }

    public int getSeriesColor() {
        return FormatHandle.HexStringToColorInt(this.myseries.getSeriesColor(), FormatHandle.colorBACKGROUND);
    }

    public String getSeriesColorStr() {
        return this.myseries.getSeriesColor();
    }

    public int getPieChartSliceColor(int slice) {
        return FormatHandle.HexStringToColorInt(this.myseries.getPieSliceColor(slice), FormatHandle.colorBACKGROUND);
    }

    public String getPieChartSliceColorStr(int slice) {
        return this.myseries.getPieSliceColor(slice);
    }
}

