/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Colinfo;
import com.extentech.toolkit.StringTool;
import java.awt.Font;
import java.util.ArrayList;

public class ColHandle {
    public static final double DEFAULT_ZERO_CHAR_WIDTH = 7.0;
    public static final int COL_UNITS_TO_PIXELS = 36;
    public static final int DEFAULT_COLWIDTH = 2340;
    private Colinfo myCol;
    private FormatHandle formatter;
    private WorkBook wbh;
    private WorkSheetHandle mySheet;
    private int lastsz = 0;

    protected ColHandle(Colinfo c, WorkSheetHandle sheet) {
        this.myCol = c;
        this.wbh = sheet.getWorkBook();
        this.mySheet = sheet;
    }

    public void autoFit() {
        double w = 0.0;
        CellHandle[] cxt = this.getCells();
        int t = 0;
        while (t < cxt.length) {
            String s = cxt[t].getFormattedStringVal();
            FormatHandle fh = cxt[t].getFormatHandle();
            com.extentech.formats.XLS.Font ef = fh.getFont();
            int style = 0;
            if (ef.getBold()) {
                style |= 1;
            }
            if (ef.getItalic()) {
                style |= 2;
            }
            int h = (int)ef.getFontHeightInPoints();
            Font f = new Font(ef.getFontName(), style, h);
            double newW = 0.0;
            newW = !cxt[t].getFormatHandle().getWrapText() ? StringTool.getApproximateStringWidth(f, s) : (double)(this.getWidth() / 36);
            w = Math.max(w, newW);
            ++t;
        }
        if (w == 0.0) {
            return;
        }
        this.setWidth((int)Math.floor(w / 7.0 * 256.0));
    }

    public void setWidthInChars(int newWidth) {
        ImageHandle ih;
        int z;
        ArrayList<int[]> iAdjust = new ArrayList<int[]>();
        ImageHandle[] images = this.myCol.getSheet().getImages();
        if (images != null) {
            z = 0;
            while (z < images.length) {
                ih = images[z];
                int c0 = ih.getCol();
                int c1 = ih.getCol1();
                int col = this.myCol.getColFirst();
                if (col >= c0 && col <= c1) {
                    short w = ih.getWidth();
                    iAdjust.add(new int[]{z, w});
                }
                ++z;
            }
        }
        this.myCol.setColWidthInChars(newWidth);
        z = 0;
        while (z < iAdjust.size()) {
            ih = images[((int[])iAdjust.get(z))[0]];
            ih.setWidth(((int[])iAdjust.get(z))[1]);
            ++z;
        }
    }

    public void setWidth(int newWidth) {
        ImageHandle ih;
        int z;
        ArrayList<int[]> iAdjust = new ArrayList<int[]>();
        ImageHandle[] images = this.myCol.getSheet().getImages();
        if (images != null) {
            z = 0;
            while (z < images.length) {
                ih = images[z];
                int c0 = ih.getCol();
                int c1 = ih.getCol1();
                int col = this.myCol.getColFirst();
                if (col >= c0 && col <= c1) {
                    short w = ih.getWidth();
                    iAdjust.add(new int[]{z, w});
                }
                ++z;
            }
        }
        this.lastsz = newWidth;
        this.myCol.setColWidth(newWidth);
        z = 0;
        while (z < iAdjust.size()) {
            ih = images[((int[])iAdjust.get(z))[0]];
            ih.setWidth(((int[])iAdjust.get(z))[1]);
            ++z;
        }
    }

    public int getWidth() {
        return this.myCol.getColWidth();
    }

    public int getWidthInChars() {
        return this.myCol.getColWidthInChars();
    }

    public static int getWidth(Boundsheet sheet, int col) {
        int w = 2340;
        try {
            Colinfo c = sheet.getColInfo(col);
            if (c != null) {
                w = c.getColWidth();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return w;
    }

    public void setFormatId(int i) {
        this.myCol.setIxfe(i);
    }

    public int getFormatId() {
        return this.myCol.getIxfe();
    }

    public FormatHandle getFormatHandle() {
        if (this.formatter == null) {
            this.setFormatHandle();
        }
        return this.formatter;
    }

    private void setFormatHandle() {
        if (this.formatter != null) {
            return;
        }
        this.formatter = new FormatHandle(this.wbh, this.getFormatId());
        this.formatter.setColHandle(this);
    }

    public int getColFirst() {
        return this.myCol.getColFirst();
    }

    public int getColLast() {
        return this.myCol.getColLast();
    }

    public CellHandle[] getCells() {
        ArrayList<BiffRec> mycells;
        try {
            mycells = this.mySheet.getBoundsheet().getCellsByCol(this.getColFirst());
        }
        catch (CellNotFoundException e) {
            return new CellHandle[0];
        }
        CellHandle[] ch = new CellHandle[mycells.size()];
        int t = 0;
        while (t < ch.length) {
            ch[t] = new CellHandle((BiffRec)mycells.get(t), null);
            ch[t].setWorkSheetHandle(null);
            ++t;
        }
        return ch;
    }

    public boolean containsMergeRange() {
        RowHandle[] r2 = this.mySheet.getRows();
        int i = 0;
        while (i < r2.length) {
            try {
                BiffRec b = r2[i].myRow.getCell((short)this.getColFirst());
                if (b != null && b.getMergeRange() != null) {
                    return true;
                }
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }

    public void setCollapsed(boolean b) {
        this.myCol.setCollapsed(b);
    }

    public void setHidden(boolean b) {
        this.myCol.setHidden(b);
    }

    public void setOutlineLevel(int x) {
        this.myCol.setOutlineLevel(x);
    }

    public int getOutlineLevel() {
        return this.myCol.getOutlineLevel();
    }

    public boolean isCollapsed() {
        return this.myCol.isCollapsed();
    }

    public boolean isHidden() {
        return this.myCol.isHidden();
    }
}

