/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.TwoCellAnchor;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.toolkit.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class ImageHandle
implements Serializable {
    private static final long serialVersionUID = 3177017738178634238L;
    private byte[] imageBytes;
    private Boundsheet mysheet;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int WIDTH = 2;
    public static final int HEIGHT = 3;
    private String imageName = " ";
    private String shapeName = "";
    private short height;
    private short width;
    private short x;
    private short y;
    private int image_type = -1;
    private int DEBUGLEVEL = 0;
    private SpPr imagesp;
    private String editMovement = null;
    private MSODrawing thisMsodrawing;

    public double getAspectRatio() {
        double aspectRatio = 0.0;
        double height = (double)this.getHeight() / 122.27;
        double width = (double)this.getWidth() / 57.06;
        aspectRatio = width / height;
        return aspectRatio;
    }

    public void setMsgdrawing(MSODrawing rec) {
        this.thisMsodrawing = rec;
    }

    public MSODrawing getMsodrawing() {
        return this.thisMsodrawing;
    }

    public String getType() {
        switch (this.image_type) {
            case 0: {
                return "gif";
            }
            case 5: {
                return "jpeg";
            }
            case 6: {
                return "png";
            }
            case 2: {
                return "emf";
            }
        }
        return "undefined";
    }

    public String getMimeType() {
        return "image/" + this.getImageType();
    }

    public ImageHandle(InputStream imagebytestream, WorkSheetHandle _sheet) {
        this(imagebytestream, _sheet.getMysheet());
    }

    public ImageHandle(InputStream imagebytestream, Boundsheet bs) {
        this.mysheet = bs;
        try {
            this.imageBytes = new byte[imagebytestream.available()];
            imagebytestream.read(this.imageBytes);
        }
        catch (Exception ex) {
            System.err.print("Failed to create new ImageHandle in sheet" + bs.getSheetName() + " from InputStream:" + ex.toString());
        }
        this.initialize();
    }

    public ImageHandle(byte[] _imageBytes, Boundsheet sheet) {
        this.mysheet = sheet;
        this.imageBytes = _imageBytes;
        this.initialize();
    }

    public boolean equals(Object another) {
        return another.toString().equals(this.toString());
    }

    private void initialize() {
        String imageFormat = "";
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.imageBytes);
            imageFormat = this.getImageFormat(bis);
            if (imageFormat == null) {
                if (this.DEBUGLEVEL > 50) {
                    Logger.logErr("ImageHandle.initialize: Unrecognized Image Format");
                }
                return;
            }
            if (!imageFormat.equalsIgnoreCase("jpeg") && !imageFormat.equalsIgnoreCase("png")) {
                bis.reset();
                this.imageBytes = this.convertData(bis);
                this.image_type = 6;
            } else {
                this.image_type = imageFormat.equalsIgnoreCase("jpeg") ? 5 : 6;
            }
            try {
                BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.imageBytes));
                this.width = (short)bi.getWidth();
                this.height = (short)bi.getHeight();
                bi = null;
            }
            catch (IOException ex) {
                Logger.logWarn("Java ImageIO could not decode image bytes for " + this.imageName + ":" + ex.toString());
            }
            this.imageName = "UnnamedImage";
        }
        catch (Exception e) {
            Logger.logWarn("Problem creating ImageHandle:" + e.toString() + " Please see BugTrack article: http://extentech.com/uimodules/docs/docs_detail.jsp?meme_id=1431&showall=true");
        }
    }

    public void update() throws Exception {
        if (this.thisMsodrawing == null) {
            throw new Exception("ImageHandle.Update: Image Not initialzed");
        }
        this.thisMsodrawing.updateRecord();
        this.mysheet.getWorkBook().updateMsodrawingHeaderRec(this.mysheet);
    }

    public boolean isActive() {
        if (this.thisMsodrawing != null) {
            return this.thisMsodrawing.isActive();
        }
        return true;
    }

    public byte[] convertData(InputStream imagebytestream) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedImage bi = ImageIO.read(imagebytestream);
            ImageIO.write((RenderedImage)bi, "png", bos);
            return bos.toByteArray();
        }
        catch (Exception e) {
            Logger.logErr("ImageHandle.convertData: " + e.toString());
            return null;
        }
    }

    public String getImageFormat(InputStream imagebytestream) {
        Iterator<ImageReader> iter;
        ImageInputStream iis;
        block3: {
            try {
                iis = ImageIO.createImageInputStream(imagebytestream);
                iter = ImageIO.getImageReaders(iis);
                if (iter.hasNext()) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        ImageReader reader = iter.next();
        iis.close();
        return reader.getFormatName();
    }

    public short[] getBounds() {
        return this.thisMsodrawing.getBounds();
    }

    public void setBounds(short[] bounds) {
        this.thisMsodrawing.setBounds(bounds);
    }

    public short[] getCoords() {
        if (this.thisMsodrawing != null) {
            return this.thisMsodrawing.getCoords();
        }
        return new short[]{this.x, this.y, this.width, this.height};
    }

    public void setCoords(int x, int y, int w, int h) {
        if (this.thisMsodrawing != null) {
            this.thisMsodrawing.setCoords(new short[]{(short)x, (short)y, (short)w, (short)h});
        } else {
            this.x = (short)x;
            this.y = (short)y;
            this.width = (short)w;
            this.height = (short)h;
        }
    }

    public void setX(int x) {
        if (this.thisMsodrawing != null) {
            this.thisMsodrawing.setX((short)Math.round((double)x / 6.4));
        } else {
            this.x = (short)x;
        }
    }

    public void setY(int y) {
        if (this.thisMsodrawing != null) {
            this.thisMsodrawing.setY((short)Math.round((double)y * 0.6));
        } else {
            this.y = (short)y;
        }
    }

    public int getRow() {
        return this.thisMsodrawing.getRow0();
    }

    public int getRow1() {
        return this.thisMsodrawing.getRow1();
    }

    public void setRow(int row) {
        this.thisMsodrawing.setRow(row);
    }

    public void setRow1(int row) {
        this.thisMsodrawing.setRow1(row);
    }

    public int getCol() {
        return this.thisMsodrawing.getCol();
    }

    public int getCol1() {
        return this.thisMsodrawing.getCol1();
    }

    public int getOriginalWidth() {
        return this.thisMsodrawing.getOriginalWidth();
    }

    public short getWidth() {
        return (short)Math.round((double)this.thisMsodrawing.getWidth() * 6.4);
    }

    public void setWidth(int w) {
        this.thisMsodrawing.setWidth((short)Math.round((double)w / 6.4));
    }

    public short getHeight() {
        return (short)Math.round((double)this.thisMsodrawing.getHeight() / 0.6);
    }

    public void setHeight(int h) {
        this.thisMsodrawing.setHeight((short)Math.round((double)h * 0.6));
    }

    public short getX() {
        return (short)Math.round((double)this.thisMsodrawing.getX() * 6.4);
    }

    public short getY() {
        return (short)Math.round((double)this.thisMsodrawing.getY() * 0.6);
    }

    public short[] getRowAndOffset() {
        return this.thisMsodrawing.getRowAndOffset();
    }

    public short[] getColAndOffset() {
        return this.thisMsodrawing.getColAndOffset();
    }

    public int getImageIndex() {
        return this.thisMsodrawing.getImageIndex();
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.imageBytes);
    }

    public String toString() {
        return this.getName();
    }

    public boolean remove() {
        this.mysheet.removeImage(this);
        this.thisMsodrawing.remove(true);
        return true;
    }

    public int getImageType() {
        return this.image_type;
    }

    public void setImageType(int type) {
        this.image_type = type;
    }

    public Boundsheet getSheet() {
        return this.mysheet;
    }

    public String getName() {
        if (!this.shapeName.equals("")) {
            return this.shapeName;
        }
        return this.imageName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public void setName(String name) {
        this.imageName = name;
        if (this.thisMsodrawing != null && !this.thisMsodrawing.getName().equals(name)) {
            this.thisMsodrawing.setImageName(name);
            this.thisMsodrawing.getWorkBook().updateMsodrawingHeaderRec(this.getSheet());
        }
    }

    public void setShapeName(String name) {
        this.shapeName = name != null ? name : "";
        if (this.thisMsodrawing != null && !this.shapeName.equals(this.thisMsodrawing.getShapeName())) {
            this.thisMsodrawing.setShapeName(this.shapeName);
            this.thisMsodrawing.getWorkBook().updateMsodrawingHeaderRec(this.getSheet());
        }
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
        this.mysheet.getWorkBook().getMSODrawingGroup().setImageBytes(this.imageBytes, this.mysheet, this.thisMsodrawing, this.getName());
    }

    public JSONObject getJSON() {
        JSONObject ch = new JSONObject();
        try {
            ch.put("name", (Object)this.getImageName());
            short[] coords = this.getCoords();
            ch.put("x", (int)coords[0]);
            ch.put("y", (int)coords[1]);
            ch.put("width", (int)coords[2]);
            ch.put("height", (int)coords[3]);
            ch.put("type", (Object)this.getType());
        }
        catch (JSONException e) {
            Logger.logErr("Error getting imageHandle JSON: " + (Object)((Object)e));
        }
        return ch;
    }

    public void position(ImageHandle im) {
        this.setBounds(im.getBounds());
    }

    public String getXML(int rId) {
        StringBuffer sb = new StringBuffer();
        short[] bounds = this.getBounds();
        int EMU = 1270;
        sb.append("<twoCellAnchor editAs=\"oneCell\">");
        sb.append("\r\n");
        sb.append("<from>");
        sb.append("<col>" + bounds[0] + "</col>");
        sb.append("<colOff>" + bounds[1] * 1270 + "</colOff>");
        sb.append("<row>" + bounds[2] + "</row>");
        sb.append("<rowOff>" + bounds[3] * 1270 + "</rowOff>");
        sb.append("</from>");
        sb.append("\r\n");
        sb.append("<to>");
        sb.append("<col>" + bounds[4] + "</col>");
        sb.append("<colOff>" + bounds[5] * 1270 + "</colOff>");
        sb.append("<row>" + bounds[6] + "</row>");
        sb.append("<rowOff>" + bounds[7] * 1270 + "</rowOff>");
        sb.append("</to>");
        sb.append("\r\n");
        sb.append("<pic>");
        sb.append("\r\n");
        sb.append("<nvPicPr>");
        sb.append("<cNvPr id=\"" + this.getMsodrawing().getSPID() + "\"");
        sb.append(" name=\"" + this.getImageName() + "\"");
        sb.append(" descr=\"" + this.getShapeName() + "\"/>");
        sb.append("<cNvPicPr>");
        sb.append("<picLocks noChangeAspect=\"1\" noChangeArrowheads=\"1\"/>");
        sb.append("</cNvPicPr>");
        sb.append("</nvPicPr>");
        sb.append("\r\n");
        sb.append("<blipFill>");
        sb.append("<blip xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" r:embed=\"rId" + rId + "\"/>");
        sb.append("<stretch><fillRect/></stretch>");
        sb.append("</blipFill>");
        sb.append("\r\n");
        sb.append("<spPr>");
        sb.append("<xfrm>");
        int x = this.getX() * 1270;
        int y = this.getY() * 1270;
        int cx = this.getWidth() * 1270;
        int cy = this.getHeight() * 1270;
        sb.append("<off x=\"" + x + "\" y=\"" + y + "\"/>");
        sb.append("<ext cx=\"" + cx + "\" cy=\"" + cy + "\"/>");
        sb.append("</xfrm>");
        sb.append("<prstGeom prst=\"rect\">");
        sb.append("<avLst/>");
        sb.append("</prstGeom>");
        sb.append("<noFill/>");
        sb.append("</spPr>");
        sb.append("</pic>");
        sb.append("\r\n");
        sb.append("<clientData/>");
        sb.append("\r\n");
        sb.append("</twoCellAnchor>");
        return sb.toString();
    }

    public String getOOXML(int rId) {
        TwoCellAnchor t = new TwoCellAnchor(this.editMovement);
        t.setAsImage(rId, this.getImageName(), this.getShapeName(), this.getMsodrawing().getSPID(), this.getSpPr());
        t.setBounds(TwoCellAnchor.convertBoundsFromBIFF8(this.getSheet(), this.getBounds()));
        return t.getOOXML();
    }

    public SpPr getSpPr() {
        return this.imagesp;
    }

    public void setSpPr(SpPr sp) {
        this.imagesp = sp;
    }

    public void setEditMovement(String editMovement) {
        this.editMovement = editMovement;
    }
}

