/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.Handle;
import com.extentech.formats.XLS.Dv;
import com.extentech.formats.XLS.ValidationException;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.util.Date;

public class ValidationHandle
implements Handle {
    private Dv myDv;
    public static final byte VALUE_ANY = 0;
    public static final byte VALUE_INTEGER = 1;
    public static final byte VALUE_DECIMAL = 2;
    public static final byte VALUE_USER_DEFINED_LIST = 3;
    public static final byte VALUE_DATE = 4;
    public static final byte VALUE_TIME = 5;
    public static final byte VALUE_TEXT_LENGTH = 6;
    public static final byte VALUE_FORMULA = 7;
    public static byte ERROR_STOP = 0;
    public static byte ERROR_WARN = 1;
    public static byte ERROR_INFO = (byte)2;
    public static final byte CONDITION_BETWEEN = 0;
    public static final byte CONDITION_NOT_BETWEEN = 1;
    public static final byte CONDITION_EQUAL = 2;
    public static final byte CONDITION_NOT_EQUAL = 3;
    public static final byte CONDITION_GREATER_THAN = 4;
    public static final byte CONDITION_LESS_THAN = 5;
    public static final byte CONDITION_GREATER_OR_EQUAL = 6;
    public static final byte CONDITION_LESS_OR_EQUAL = 7;
    public static short IME_MODE_NO_CONTROL = 0;
    public static short IME_MODE_ON = 1;
    public static short IME_MODE_OFF = (short)2;
    public static short IME_MODE_DISABLE = (short)3;
    public static short IME_MODE_HIRAGANA = (short)4;
    public static short IME_MODE_KATAKANA = (short)5;
    public static short IME_MODE_KATALANA_HALF = (short)6;
    public static short IME_MODE_FULL_WIDTH_ALPHA = (short)7;
    public static short IME_MODE_HALF_WIDTH_ALPHA = (short)8;
    public static short IME_MODE_FULL_WIDTH_HANKUL = (short)9;
    public static short IME_MODE_HALF_WIDTH_HANKUL = (short)16;
    public static String[] CONDITIONS = new String[]{"between", "notBetween", "equal", "notEqual", "greaterThan", "lessThan", "greaterOrEqual", "lessOrEqual"};
    public static String[] VALUE_TYPE = new String[]{"any", "integer", "decimal", "userDefinedList", "date", "time", "textLength", "formula"};

    public static byte getConditionNumber(String conditionType) {
        int i = 0;
        while (i < CONDITIONS.length) {
            if (conditionType.equalsIgnoreCase(CONDITIONS[i])) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    public static byte getValueNumber(String valueType) {
        int i = 0;
        while (i < VALUE_TYPE.length) {
            if (valueType.equalsIgnoreCase(VALUE_TYPE[i])) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    public ValidationHandle(Dv dv) {
        this.myDv = dv;
    }

    public String getRange() {
        String[] s = this.myDv.getRanges();
        String out = "";
        int i = 0;
        while (i < s.length) {
            if (i > 0) {
                out = String.valueOf(out) + " ";
            }
            out = String.valueOf(out) + s[i];
            ++i;
        }
        return out;
    }

    public boolean isValid(Object value) throws ValidationException {
        return this.myDv.isValid(value);
    }

    public boolean isValid(Object value, boolean throwException) throws RuntimeException {
        if (throwException) {
            try {
                return this.myDv.isValid(value);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Exception ex) {
                    Logger.logErr("Error getting isValid " + ex.toString());
                }
            }
        }
        try {
            return this.myDv.isValid(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setRange(String range) {
        this.myDv.setRange(range);
    }

    public void addRange(String range) {
        this.myDv.addRange(range);
    }

    public String getErrorBoxText() {
        return this.myDv.getErrorBoxText();
    }

    public void setErrorBoxText(String textError) {
        this.myDv.setErrorBoxText(textError);
    }

    public String getPromptBoxText() {
        return this.myDv.getPromptBoxText();
    }

    public void setPromptBoxText(String text) {
        this.myDv.setPromptBoxText(text);
    }

    public void setErrorBoxTitle(String textError) {
        this.myDv.setErrorBoxTitle(textError);
    }

    public String getErrorBoxTitle() {
        return this.myDv.getErrorBoxTitle();
    }

    public String getPromptBoxTitle() {
        return this.myDv.getPromptBoxTitle();
    }

    public void setPromptBoxTitle(String text) {
        this.myDv.setPromptBoxTitle(text);
    }

    public byte getErrorStyle() {
        return this.myDv.getErrorStyle();
    }

    public void setErrorStyle(byte errstyle) {
        this.myDv.setErrorStyle(errstyle);
    }

    public short getIMEMode() {
        return this.myDv.getIMEMode();
    }

    public void setIMEMode(short mode) {
        this.myDv.setIMEMode(mode);
    }

    public boolean isAllowBlank() {
        return this.myDv.isAllowBlank();
    }

    public void setAllowBlank(boolean allowBlank) {
        this.myDv.setAllowBlank(allowBlank);
    }

    public String getFirstCondition() {
        return this.myDv.getFirstCond();
    }

    public void setFirstCondition(Object firstCond) {
        String setval = firstCond.toString();
        if (firstCond instanceof Date) {
            double d = DateConverter.getXLSDateVal((Date)firstCond);
            setval = String.valueOf(d);
        }
        this.myDv.setFirstCond(setval);
    }

    public String getSecondCondition() {
        return this.myDv.getSecondCond();
    }

    public void setSecondCondition(Object secondCond) {
        String setval = secondCond.toString();
        if (secondCond instanceof Date) {
            double d = DateConverter.getXLSDateVal((Date)secondCond);
            setval = String.valueOf(d);
        }
        this.myDv.setSecondCond(setval);
    }

    public boolean isShowErrorMsg() {
        return this.myDv.isShowErrorMsg();
    }

    public void setShowErrorMsg(boolean showErrMsg) {
        this.myDv.setShowErrMsg(showErrMsg);
    }

    public boolean getShowInputMsg() {
        return this.myDv.getShowInputMsg();
    }

    public void setShowInputMsg(boolean showInputMsg) {
        this.myDv.setShowInputMsg(showInputMsg);
    }

    public boolean isStrLookup() {
        return this.myDv.isStrLookup();
    }

    public void setStrLookup(boolean strLookup) {
        this.myDv.setStrLookup(strLookup);
    }

    public boolean isSuppressCombo() {
        return this.myDv.isSuppressCombo();
    }

    public void setSuppressCombo(boolean suppressCombo) {
        this.myDv.setSuppressCombo(suppressCombo);
    }

    public byte getTypeOperator() {
        return this.myDv.getTypeOperator();
    }

    public void setTypeOperator(byte typOperator) {
        this.myDv.setTypeOperator(typOperator);
    }

    public byte getValidationType() {
        return this.myDv.getValType();
    }

    public void setValidationType(byte valtype) {
        this.myDv.setValType(valtype);
    }

    public boolean isInRange(String celladdy) {
        return this.myDv.isInRange(celladdy);
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<datavalidation");
        xml.append(" type=\"" + VALUE_TYPE[this.getValidationType()] + "\"");
        xml.append(" operator=\"" + CONDITIONS[this.getTypeOperator()] + "\"");
        xml.append(" allowBlank=\"" + (this.isAllowBlank() ? "1" : "0") + "\"");
        xml.append(" showInputMessage=\"" + (this.getShowInputMsg() ? "1" : "0") + "\"");
        xml.append(" showErrorMessage=\"" + (this.isShowErrorMsg() ? "1" : "0") + "\"");
        xml.append(" errorTitle=\"" + this.getErrorBoxTitle() + "\"");
        xml.append(" error=\"" + this.getErrorBoxText() + "\"");
        xml.append(" promptTitle=\"" + this.getPromptBoxTitle() + "\"");
        xml.append(" prompt=\"" + this.getPromptBoxText() + "\"");
        try {
            xml.append(" sqref=\"" + this.getRange() + "\"");
        }
        catch (Exception e) {
            Logger.logErr("Problem getting range for ValidationHandle.getXML().", e);
        }
        xml.append(">");
        if (this.getFirstCondition() != null) {
            xml.append("<formula1>");
            xml.append(StringTool.convertXMLChars(this.getFirstCondition()));
            xml.append("</formula1>");
        }
        if (this.getSecondCondition() != null) {
            xml.append("<formula2>");
            xml.append(StringTool.convertXMLChars(this.getSecondCondition()));
            xml.append("</formula2>");
        }
        xml.append("</datavalidation>");
        return xml.toString();
    }
}

