/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.FilterColumn;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

public class AutoFilter
implements OOXMLElement {
    private static final long serialVersionUID = 7111401348177004218L;
    private String ref = null;
    private ArrayList<FilterColumn> filterColumns = null;

    public AutoFilter(String ref, ArrayList<FilterColumn> f) {
        this.ref = ref;
        this.filterColumns = f;
    }

    public AutoFilter(AutoFilter a) {
        this.ref = a.ref;
        this.filterColumns = a.filterColumns;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp) {
        String ref = null;
        ArrayList<FilterColumn> f = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("autoFilter")) {
                        if (xpp.getAttributeCount() == 1) {
                            ref = xpp.getAttributeValue(0);
                        }
                    } else if (!tnm.equals("sortState") && tnm.equals("filterColumn")) {
                        if (f == null) {
                            f = new ArrayList<FilterColumn>();
                        }
                        f.add(FilterColumn.parseOOXML(xpp));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("autoFilter")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("autoFilter.parseOOXML: " + e.toString());
        }
        AutoFilter a = new AutoFilter(ref, f);
        return a;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<autoFilter");
        if (this.ref != null) {
            ooxml.append(" ref=\"" + this.ref + "\"");
        }
        ooxml.append(">");
        if (this.filterColumns != null) {
            int i = 0;
            while (i < this.filterColumns.size()) {
                ooxml.append(this.filterColumns.get(i).getOOXML());
                ++i;
            }
        }
        ooxml.append("</autoFilter>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new AutoFilter(this);
    }
}

