/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.ColorChoice;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class BgClr
implements OOXMLElement {
    private static final long serialVersionUID = -879409152334931909L;
    private ColorChoice colorChoice;

    public BgClr(ColorChoice c) {
        this.colorChoice = c;
    }

    public BgClr(BgClr s) {
        this.colorChoice = s.colorChoice;
    }

    public static BgClr parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        ColorChoice c = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("hslClr") || tnm.equals("prstClr") || tnm.equals("schemeClr") || tnm.equals("scrgbClr") || tnm.equals("srgbClr") || tnm.equals("sysClr")) {
                        lastTag.push(tnm);
                        c = (ColorChoice)ColorChoice.parseOOXML(xpp, lastTag, bk);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("bgClr")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("bgClr.parseOOXML: " + e.toString());
        }
        BgClr s = new BgClr(c);
        return s;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:bgClr>");
        if (this.colorChoice != null) {
            ooxml.append(this.colorChoice.getOOXML());
        }
        ooxml.append("</a:bgClr>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new BgClr(this);
    }
}

