/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class ColorTransform {
    private int[] lum;
    private int[] hue;
    private int[] sat;
    private int[] alpha;
    private int tint;
    private int shade;

    public int getTint() {
        return this.tint;
    }

    public ColorTransform(int[] lum, int[] hue, int[] sat, int[] alpha, int tint, int shade) {
        this.lum = lum;
        this.hue = hue;
        this.sat = sat;
        this.alpha = alpha;
        this.tint = tint;
        this.shade = shade;
    }

    public static ColorTransform parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        int[] lum = null;
        int[] hue = null;
        int[] sat = null;
        int[] alpha = null;
        int tint = 0;
        int shade = 0;
        try {
            String parentEl = lastTag.peek();
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block16: {
                    String endTag;
                    block14: {
                        String tnm;
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block15: {
                                                                if (eventType != 2) break block14;
                                                                tnm = xpp.getName();
                                                                if (!tnm.equals("lum")) break block15;
                                                                if (lum == null) {
                                                                    lum = new int[3];
                                                                }
                                                                lum[0] = Integer.valueOf(xpp.getAttributeValue(0));
                                                                break block16;
                                                            }
                                                            if (!tnm.equals("lumMod")) break block17;
                                                            if (lum == null) {
                                                                lum = new int[3];
                                                            }
                                                            lum[1] = Integer.valueOf(xpp.getAttributeValue(0));
                                                            break block16;
                                                        }
                                                        if (!tnm.equals("lumOff")) break block18;
                                                        if (lum == null) {
                                                            lum = new int[3];
                                                        }
                                                        lum[2] = Integer.valueOf(xpp.getAttributeValue(0));
                                                        break block16;
                                                    }
                                                    if (!tnm.equals("hue")) break block19;
                                                    if (hue == null) {
                                                        hue = new int[3];
                                                    }
                                                    hue[0] = Integer.valueOf(xpp.getAttributeValue(0));
                                                    break block16;
                                                }
                                                if (!tnm.equals("hueMod")) break block20;
                                                if (hue == null) {
                                                    hue = new int[3];
                                                }
                                                hue[1] = Integer.valueOf(xpp.getAttributeValue(0));
                                                break block16;
                                            }
                                            if (!tnm.equals("hueOff")) break block21;
                                            if (hue == null) {
                                                hue = new int[3];
                                            }
                                            hue[2] = Integer.valueOf(xpp.getAttributeValue(0));
                                            break block16;
                                        }
                                        if (!tnm.equals("sat")) break block22;
                                        if (sat == null) {
                                            sat = new int[3];
                                        }
                                        sat[0] = Integer.valueOf(xpp.getAttributeValue(0));
                                        break block16;
                                    }
                                    if (!tnm.equals("satMod")) break block23;
                                    if (sat == null) {
                                        sat = new int[3];
                                    }
                                    sat[1] = Integer.valueOf(xpp.getAttributeValue(0));
                                    break block16;
                                }
                                if (!tnm.equals("satOff")) break block24;
                                if (sat == null) {
                                    sat = new int[3];
                                }
                                sat[2] = Integer.valueOf(xpp.getAttributeValue(0));
                                break block16;
                            }
                            if (!tnm.equals("shade")) break block25;
                            shade = Integer.valueOf(xpp.getAttributeValue(0));
                            break block16;
                        }
                        if (!tnm.equals("tint")) break block16;
                        tint = Integer.valueOf(xpp.getAttributeValue(0));
                        break block16;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals(parentEl)) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ColorTransform.parseOOXML: " + e.toString());
        }
        return new ColorTransform(lum, hue, sat, alpha, tint, shade);
    }

    public StringBuffer getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.tint != 0) {
            ooxml.append("<a:tint val=\"" + this.tint + "\"/>");
        }
        if (this.shade != 0) {
            ooxml.append("<a:shade val=\"" + this.shade + "\"/>");
        }
        if (this.alpha != null) {
            if (this.alpha[0] != 0) {
                ooxml.append("<a:alpha val=\"" + this.alpha[0] + "\"/>");
            }
            if (this.alpha[2] != 0) {
                ooxml.append("<a:alphaOff val=\"" + this.alpha[2] + "\"/>");
            }
            if (this.alpha[1] != 0) {
                ooxml.append("<a:alphaMod val=\"" + this.alpha[1] + "\"/>");
            }
        }
        if (this.hue != null) {
            if (this.hue[0] != 0) {
                ooxml.append("<a:hue val=\"" + this.hue[0] + "\"/>");
            }
            if (this.hue[2] != 0) {
                ooxml.append("<a:hueOff val=\"" + this.hue[2] + "\"/>");
            }
            if (this.hue[1] != 0) {
                ooxml.append("<a:hueMod val=\"" + this.hue[1] + "\"/>");
            }
        }
        if (this.sat != null) {
            if (this.sat[0] != 0) {
                ooxml.append("<a:sat val=\"" + this.sat[0] + "\"/>");
            }
            if (this.sat[2] != 0) {
                ooxml.append("<a:satOff val=\"" + this.sat[2] + "\"/>");
            }
            if (this.sat[1] != 0) {
                ooxml.append("<a:satMod val=\"" + this.sat[1] + "\"/>");
            }
        }
        if (this.lum != null) {
            if (this.lum[0] != 0) {
                ooxml.append("<a:lum val=\"" + this.lum[0] + "\"/>");
            }
            if (this.lum[2] != 0) {
                ooxml.append("<a:lumOff val=\"" + this.lum[2] + "\"/>");
            }
            if (this.lum[1] != 0) {
                ooxml.append("<a:lumMod val=\"" + this.lum[1] + "\"/>");
            }
        }
        return ooxml;
    }
}

