/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.AvLst;
import com.extentech.formats.OOXML.CxnLst;
import com.extentech.formats.OOXML.GdLst;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PathLst;
import com.extentech.formats.OOXML.Rect;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class CustGeom
implements OOXMLElement {
    private static final long serialVersionUID = 4036207867619551810L;
    private PathLst pathLst;
    private GdLst gdLst;
    private AvLst avLst;
    private CxnLst cxnLst;
    private Rect rect;

    public CustGeom(PathLst p, GdLst g, AvLst a, CxnLst cx, Rect r2) {
        this.pathLst = p;
        this.gdLst = g;
        this.avLst = a;
        this.cxnLst = cx;
        this.rect = r2;
    }

    public CustGeom(CustGeom c) {
        this.pathLst = c.pathLst;
        this.gdLst = c.gdLst;
        this.avLst = c.avLst;
        this.cxnLst = c.cxnLst;
        this.rect = c.rect;
    }

    public static CustGeom parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        PathLst p = null;
        GdLst g = null;
        AvLst a = null;
        CxnLst cx = null;
        Rect r2 = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block10: {
                            block9: {
                                block8: {
                                    block6: {
                                        if (eventType != 2) break block5;
                                        tnm = xpp.getName();
                                        if (!tnm.equals("pathLst")) break block6;
                                        lastTag.push(tnm);
                                        p = PathLst.parseOOXML(xpp, lastTag);
                                        break block7;
                                    }
                                    if (!tnm.equals("gdLst")) break block8;
                                    lastTag.push(tnm);
                                    g = GdLst.parseOOXML(xpp, lastTag);
                                    break block7;
                                }
                                if (!tnm.equals("avLst")) break block9;
                                lastTag.push(tnm);
                                a = (AvLst)AvLst.parseOOXML(xpp, lastTag);
                                break block7;
                            }
                            if (!tnm.equals("cxnLst")) break block10;
                            lastTag.push(tnm);
                            cx = CxnLst.parseOOXML(xpp, lastTag);
                            break block7;
                        }
                        if (!tnm.equals("rect")) break block7;
                        lastTag.push(tnm);
                        r2 = Rect.parseOOXML(xpp, lastTag);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("custGeom")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("custGeom.parseOOXML: " + e.toString());
        }
        CustGeom c = new CustGeom(p, g, a, cx, r2);
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:custGeom>");
        if (this.avLst != null) {
            ooxml.append(this.avLst.getOOXML());
        }
        if (this.gdLst != null) {
            ooxml.append(this.gdLst.getOOXML());
        }
        ooxml.append("<a:ahLst/>");
        if (this.cxnLst != null) {
            ooxml.append(this.cxnLst.getOOXML());
        }
        if (this.rect != null) {
            ooxml.append(this.rect.getOOXML());
        }
        if (this.pathLst != null) {
            ooxml.append(this.pathLst.getOOXML());
        }
        ooxml.append("</a:custGeom>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CustGeom(this);
    }
}

