/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.EffectDag;
import com.extentech.formats.OOXML.EffectLst;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class EffectPropsGroup
implements OOXMLElement {
    private static final long serialVersionUID = 8250236905326475833L;
    private EffectDag effectDag;
    private EffectLst effectLst;

    public EffectPropsGroup(EffectDag ed, EffectLst el) {
        this.effectDag = ed;
        this.effectLst = el;
    }

    public EffectPropsGroup(EffectPropsGroup e) {
        this.effectDag = e.effectDag;
        this.effectLst = e.effectLst;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        EffectDag ed = null;
        EffectLst el = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("effectDag")) {
                        lastTag.push(tnm);
                        ed = EffectDag.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("effectLst")) {
                        lastTag.push(tnm);
                        el = EffectLst.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                } else if (eventType == 3) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("EffectPropsGroup.parseOOXML: " + e.toString());
        }
        EffectPropsGroup e = new EffectPropsGroup(ed, el);
        return e;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.effectDag != null) {
            ooxml.append(this.effectDag.getOOXML());
        }
        if (this.effectLst != null) {
            ooxml.append(this.effectLst.getOOXML());
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new EffectPropsGroup(this);
    }
}

