/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Ext
implements OOXMLElement {
    private static final long serialVersionUID = 2827740330905704185L;
    private HashMap<String, String> attrs;
    private String nameSpace = null;

    public Ext() {
        this.attrs = new HashMap();
        this.attrs.put("cx", new String("0"));
        this.attrs.put("cy", new String("0"));
    }

    public Ext(HashMap<String, String> attrs, String ns) {
        this.attrs = attrs;
        this.nameSpace = ns;
    }

    public Ext(Ext e) {
        this.attrs = e.attrs;
        this.nameSpace = e.nameSpace;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        String ns = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("ext")) {
                        ns = xpp.getPrefix();
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("ext")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ext.parseOOXML: " + e.toString());
        }
        Ext e = new Ext(attrs, ns);
        return e;
    }

    public void setNamespace(String ns) {
        this.nameSpace = ns;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<" + this.nameSpace + ":ext");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Ext(this);
    }
}

