/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class FillMode
implements OOXMLElement {
    private static final long serialVersionUID = 967269629502516244L;
    private HashMap<String, String> attrs = null;
    private boolean tile = false;

    public FillMode() {
    }

    public FillMode(HashMap<String, String> attrs, boolean tile) {
        this.attrs = attrs;
        this.tile = tile;
    }

    public FillMode(FillMode f) {
        this.attrs = f.attrs;
        this.tile = f.tile;
    }

    public static FillMode parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        boolean tile = false;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block9: {
                    String endTag;
                    block7: {
                        int i;
                        String tnm;
                        block8: {
                            if (eventType != 2) break block7;
                            tnm = xpp.getName();
                            if (!tnm.equals("tile")) break block8;
                            tile = true;
                            i = 0;
                            while (i < xpp.getAttributeCount()) {
                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                ++i;
                            }
                            break block9;
                        }
                        if (!tnm.equals("fillRect")) break block9;
                        i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                        break block9;
                    }
                    if (eventType == 3 && ((endTag = xpp.getName()).equals("tile") || endTag.equals("stretch"))) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("FillMode.parseOOXML: " + e.toString());
        }
        FillMode fm = new FillMode(attrs, tile);
        return fm;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.tile) {
            ooxml.append("<a:tile");
        } else {
            ooxml.append("<a:stretch><a:fillRect");
        }
        if (this.attrs != null) {
            for (String key : this.attrs.keySet()) {
                String val = this.attrs.get(key);
                ooxml.append(" " + key + "=\"" + val + "\"");
            }
        }
        if (this.tile) {
            ooxml.append("/>");
        } else {
            ooxml.append("/></a:stretch>");
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new FillMode(this);
    }
}

