/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.Gd;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class GdLst
implements OOXMLElement {
    private static final long serialVersionUID = -7852193131141462744L;
    private ArrayList<Gd> gds;

    public GdLst(ArrayList<Gd> gds) {
        this.gds = gds;
    }

    public GdLst(GdLst g) {
        this.gds = g.gds;
    }

    public static GdLst parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        ArrayList<Gd> gds = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("gd")) {
                        lastTag.push(tnm);
                        if (gds == null) {
                            gds = new ArrayList<Gd>();
                        }
                        gds.add((Gd)Gd.parseOOXML(xpp, lastTag));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("gdLst")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("gdLst.parseOOXML: " + e.toString());
        }
        GdLst g = new GdLst(gds);
        return g;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:gdLst>");
        if (this.gds != null) {
            int i = 0;
            while (i < this.gds.size()) {
                ooxml.append(this.gds.get(i).getOOXML());
                ++i;
            }
        }
        ooxml.append("</a:gdLst>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new GdLst(this);
    }
}

