/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class GraphicData
implements OOXMLElement {
    private static final long serialVersionUID = 7395991759307532325L;
    private String uri = "http://schemas.openxmlformats.org/drawingml/2006/chart";
    private String rid = null;

    public GraphicData() {
    }

    public GraphicData(String uri, String rid) {
        this.uri = uri;
        this.rid = rid;
    }

    public GraphicData(GraphicData gd) {
        this.uri = gd.uri;
        this.rid = gd.rid;
    }

    public static GraphicData parseOOXML(XmlPullParser xpp, Stack lastTag) {
        String uri = null;
        String rid = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block7: {
                            if (eventType != 2) break block6;
                            tnm = xpp.getName();
                            if (!tnm.equals("graphicData")) break block7;
                            if (xpp.getAttributeCount() > 0) {
                                uri = xpp.getAttributeValue(0);
                            }
                            break block8;
                        }
                        if (!tnm.equals("chart") || xpp.getAttributeCount() <= 0) break block8;
                        rid = xpp.getAttributeValue(0);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("graphicData")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("graphicData.parseOOXML: " + e.toString());
        }
        GraphicData g = new GraphicData(uri, rid);
        return g;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:graphicData");
        if (this.uri != null) {
            ooxml.append(" uri=\"" + this.uri + "\"");
        }
        if (this.rid != null) {
            ooxml.append("><c:chart xmlns:c=\"http://schemas.openxmlformats.org/drawingml/2006/chart\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"  r:id=\"" + this.rid + "\"/></a:graphicData>");
        } else {
            ooxml.append("/>");
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new GraphicData(this);
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getChartRId() {
        return this.rid;
    }

    public void setChartRId(String rid) {
        this.rid = rid;
    }
}

