/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Layout;
import com.extentech.formats.OOXML.LegendEntry;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.TxPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Legend
implements OOXMLElement {
    private static final long serialVersionUID = 419453456635220517L;
    private String legendpos;
    private LegendEntry le;
    private Layout layout;
    private SpPr shapeProps;
    private TxPr txpr;
    private String overlay;

    public Legend(String pos, String overlay, Layout l, LegendEntry le, SpPr sp, TxPr txpr) {
        this.legendpos = pos;
        this.le = le;
        this.overlay = overlay;
        this.layout = l;
        this.shapeProps = sp;
        this.txpr = txpr;
    }

    public Legend(Legend l) {
        this.legendpos = l.legendpos;
        this.le = l.le;
        this.overlay = l.overlay;
        this.layout = l.layout;
        this.shapeProps = l.shapeProps;
        this.txpr = l.txpr;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        String legendpos = null;
        LegendEntry le = null;
        String overlay = null;
        Layout layout = null;
        SpPr shapeProps = null;
        TxPr txpr = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block6: {
                                            if (eventType != 2) break block5;
                                            tnm = xpp.getName();
                                            if (!tnm.equals("legendPos")) break block6;
                                            legendpos = xpp.getAttributeValue(0);
                                            break block7;
                                        }
                                        if (!tnm.equals("layout")) break block8;
                                        lastTag.push(tnm);
                                        layout = (Layout)Layout.parseOOXML(xpp, lastTag);
                                        break block7;
                                    }
                                    if (!tnm.equals("legendEntry")) break block9;
                                    lastTag.push(tnm);
                                    le = LegendEntry.parseOOXML(xpp, lastTag, bk);
                                    break block7;
                                }
                                if (!tnm.equals("spPr")) break block10;
                                lastTag.push(tnm);
                                shapeProps = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk);
                                break block7;
                            }
                            if (!tnm.equals("txPr")) break block11;
                            lastTag.push(tnm);
                            txpr = (TxPr)TxPr.parseOOXML(xpp, lastTag, bk);
                            break block7;
                        }
                        if (!tnm.equals("overlay")) break block7;
                        overlay = xpp.getAttributeValue(0);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("legend")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.parseLegendElement: " + e.toString());
        }
        Legend l = new Legend(legendpos, overlay, layout, le, shapeProps, txpr);
        return l;
    }

    public void fill2003Legend(com.extentech.formats.XLS.charts.Legend l_2003) {
        String[] pos = new String[]{"b", "tr", "t", "r", "l"};
        int i = 0;
        while (i < pos.length) {
            if (pos[i].equals(this.legendpos)) {
                l_2003.setLegendPosition((short)i);
                break;
            }
            ++i;
        }
        if (this.hasBox()) {
            l_2003.addBox();
        }
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<c:legend>");
        if (this.legendpos != null) {
            ooxml.append("<c:legendPos val=\"" + this.legendpos + "\"/>");
        }
        if (this.le != null) {
            ooxml.append(this.le.getOOXML());
        }
        if (this.layout != null) {
            ooxml.append(this.layout.getOOXML());
        }
        if (this.overlay != null) {
            ooxml.append("<c:overlay val=\"" + this.overlay + "\"/>");
        }
        if (this.shapeProps != null) {
            ooxml.append(this.shapeProps.getOOXML());
        }
        if (this.txpr != null) {
            ooxml.append(this.txpr.getOOXML());
        }
        ooxml.append("</c:legend>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Legend(this);
    }

    public boolean hasBox() {
        if (this.shapeProps != null) {
            return this.shapeProps.hasLine();
        }
        return false;
    }

    public static Legend createLegend(com.extentech.formats.XLS.charts.Legend l) {
        Legend ooxmllegend = null;
        try {
            SpPr sp = null;
            sp = new SpPr("c");
            sp.setLine(3175, "000000");
            l.getFnt();
            ooxmllegend = new Legend(l.getLegendPositionString(), "1", null, null, sp, null);
        }
        catch (Exception e) {
            Logger.logWarn("Error creating 2007+ version Legend: " + e.toString());
        }
        return ooxmllegend;
    }
}

