/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.Xf;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import org.xmlpull.v1.XmlPullParser;

public class NumFmt
implements OOXMLElement {
    private static final long serialVersionUID = -206715418106414662L;
    private String formatCode;
    private String numFmtId;
    private boolean sourceLinked = false;

    public NumFmt(String formatCode, String numFmtId, boolean sourceLinked) {
        this.formatCode = formatCode;
        this.numFmtId = numFmtId;
        this.sourceLinked = sourceLinked;
    }

    public NumFmt(NumFmt n) {
        this.formatCode = n.formatCode;
        this.numFmtId = n.numFmtId;
        this.sourceLinked = n.sourceLinked;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp) {
        String formatCode = null;
        String numFmtId = null;
        boolean sourceLinked = false;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("numFmt")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (n.equals("formatCode")) {
                                formatCode = v;
                            } else if (n.equals("numFmtId")) {
                                numFmtId = v;
                            } else if (n.equals("sourceLinked")) {
                                sourceLinked = v.equals("1");
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("numFmt")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("numFmt.parseOOXML: " + e.toString());
        }
        NumFmt oe = new NumFmt(formatCode, numFmtId, sourceLinked);
        return oe;
    }

    @Override
    public String getOOXML() {
        return this.getOOXML("");
    }

    public String getOOXML(String ns) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<" + ns + "numFmt");
        ooxml.append(" formatCode=\"" + OOXMLAdapter.stripNonAscii(this.formatCode) + "\"");
        if (this.numFmtId != null) {
            ooxml.append(" numFmtId=\"" + this.numFmtId + "\"");
        }
        if (this.sourceLinked) {
            ooxml.append(" sourceLinked=\"1\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new NumFmt(this);
    }

    public String getFormatId() {
        return this.numFmtId;
    }

    public static String getOOXML(Xf xf) {
        StringBuffer ooxml = new StringBuffer();
        if (xf.getIfmt() > FormatConstants.BUILTIN_FORMATS.length) {
            String s = xf.getFormatPattern();
            if (s != null) {
                s = StringTool.replaceText(s, "\"", "&quot;");
            }
            ooxml.append("<numFmt numFmtId=\"" + xf.getIfmt() + "\" formatCode=\"" + s + "\"/>");
            ooxml.append("\r\n");
        }
        return ooxml.toString();
    }
}

