/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class PivotCacheDefinition
implements OOXMLElement {
    private static final long serialVersionUID = -5070227633357072878L;
    private String ref = null;
    private String sheet = null;
    private final int icache;

    @Override
    public OOXMLElement cloneElement() {
        return null;
    }

    public PivotCacheDefinition(String ref, String sheet, int icache) {
        this.ref = ref;
        this.sheet = sheet;
        this.icache = icache;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PivotCacheDefinition parseOOXML(WorkBookHandle bk, String cacheid, InputStream ii) {
        String ref = null;
        String sheet = null;
        int icache = 1;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String tnm;
                if (eventType == 2 && !(tnm = xpp.getName()).equals("pivotCacheDefinition")) {
                    String v;
                    String nm;
                    int z;
                    if (tnm.equals("cacheSource")) {
                        z = 0;
                        while (z < xpp.getAttributeCount()) {
                            nm = xpp.getAttributeName(z);
                            v = xpp.getAttributeValue(z);
                            if (nm.equals("type") && !v.equals("worksheet")) {
                                Logger.logWarn("PivotCacheDefinition: Data Souce " + v + " Not Supported");
                                return null;
                            }
                            ++z;
                        }
                    } else if (tnm.equals("worksheetSource")) {
                        z = 0;
                        while (z < xpp.getAttributeCount()) {
                            nm = xpp.getAttributeName(z);
                            v = xpp.getAttributeValue(z);
                            if (nm.equals("ref")) {
                                ref = v;
                            } else if (nm.equals("sheet")) {
                                sheet = v;
                            } else if (nm.equals("name")) {
                                ref = v;
                            } else {
                                nm.equals("id");
                            }
                            ++z;
                        }
                    } else {
                        tnm.equals("cacheFields");
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("PivotCacheDefinition.parseOOXML: " + e.toString());
        }
        if (cacheid != null) {
            icache = 1;
        }
        icache = bk.getWorkBook().addPivotStream(ref, sheet, icache);
        return new PivotCacheDefinition(ref, sheet, icache);
    }

    public int getICache() {
        return this.icache;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSheet() {
        return this.sheet;
    }

    @Override
    public String getOOXML() {
        return null;
    }
}

