/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.NvSpPr;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.Style;
import com.extentech.formats.OOXML.TxBody;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Sp
implements OOXMLElement {
    private static final long serialVersionUID = 7454285931503575078L;
    private NvSpPr nvsp;
    private SpPr sppr;
    private Style sty;
    private TxBody txb;
    private HashMap<String, String> attrs = null;

    public Sp(NvSpPr nvsp, SpPr sppr, Style sty, TxBody txb, HashMap<String, String> attrs) {
        this.nvsp = nvsp;
        this.sppr = sppr;
        this.sty = sty;
        this.txb = txb;
        this.attrs = attrs;
    }

    public Sp(Sp shp) {
        this.nvsp = shp.nvsp;
        this.sppr = shp.sppr;
        this.sty = shp.sty;
        this.txb = shp.txb;
        this.attrs = shp.attrs;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        NvSpPr nvsp = null;
        SpPr sppr = null;
        Style sty = null;
        TxBody txb = null;
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        if (eventType != 2) break block6;
                                        tnm = xpp.getName();
                                        if (!tnm.equals("sp")) break block7;
                                        int i = 0;
                                        while (i < xpp.getAttributeCount()) {
                                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                            ++i;
                                        }
                                        break block8;
                                    }
                                    if (!tnm.equals("nvSpPr")) break block9;
                                    lastTag.push(tnm);
                                    nvsp = NvSpPr.parseOOXML(xpp, lastTag);
                                    break block8;
                                }
                                if (!tnm.equals("spPr")) break block10;
                                lastTag.push(tnm);
                                sppr = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk);
                                break block8;
                            }
                            if (!tnm.equals("style")) break block11;
                            lastTag.push(tnm);
                            sty = (Style)Style.parseOOXML(xpp, lastTag, bk);
                            break block8;
                        }
                        if (!tnm.equals("txBody")) break block8;
                        lastTag.push(tnm);
                        txb = (TxBody)TxBody.parseOOXML(xpp, lastTag, bk);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("sp")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("sp.parseOOXML: " + e.toString());
        }
        Sp shp = new Sp(nvsp, sppr, sty, txb, attrs);
        return shp;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:sp");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        ooxml.append(this.nvsp.getOOXML());
        ooxml.append(this.sppr.getOOXML());
        if (this.sty != null) {
            ooxml.append(this.sty.getOOXML());
        }
        if (this.txb != null) {
            ooxml.append(this.txb.getOOXML());
        }
        ooxml.append("</xdr:sp>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Sp(this);
    }

    public String getMacro() {
        if (this.attrs.get("macro") != null) {
            return this.attrs.get("macro");
        }
        return null;
    }

    public void setMacro(String macro) {
        this.attrs.put("macro", macro);
    }

    public String getEmbed() {
        if (this.sppr != null) {
            return this.sppr.getEmbed();
        }
        return null;
    }

    public String getLink() {
        if (this.sppr != null) {
            return this.sppr.getLink();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.sppr != null) {
            this.sppr.setEmbed(embed);
        }
    }

    public void setLink(String link) {
        if (this.sppr != null) {
            this.sppr.setLink(link);
        }
    }

    public String getName() {
        if (this.nvsp != null) {
            return this.nvsp.getName();
        }
        return null;
    }

    public void setName(String name) {
        if (this.nvsp != null) {
            this.nvsp.setName(name);
        }
    }

    public String getDescr() {
        if (this.nvsp != null) {
            return this.nvsp.getDescr();
        }
        return null;
    }

    public void setDescr(String descr) {
        if (this.nvsp != null) {
            this.nvsp.setDescr(descr);
        }
    }

    public void setId(int id) {
        if (this.nvsp != null) {
            this.nvsp.setId(id);
        }
    }

    public int getId() {
        if (this.nvsp != null) {
            return this.nvsp.getId();
        }
        return -1;
    }
}

