/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Ss_rPr;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Text
implements OOXMLElement {
    private static final long serialVersionUID = 5886384020139606328L;
    private Unicodestring str = null;

    public Text(Unicodestring str) {
        this.str = str;
    }

    public Text(Text t) {
        this.str = t.str;
    }

    public Text(String s) {
        this.str = Sst.createUnicodeString(s, null, 0);
    }

    public static Text parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        Unicodestring str = null;
        String s = "";
        ArrayList<short[]> formattingRuns = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block10: {
                    block8: {
                        String tnm;
                        block9: {
                            if (eventType != 2) break block8;
                            tnm = xpp.getName();
                            if (!tnm.equals("rPr")) break block9;
                            int idx = s.length();
                            Ss_rPr rp = (Ss_rPr)Ss_rPr.parseOOXML(xpp, bk);
                            Font f = rp.generateFont(bk);
                            int fIndex = bk.getWorkBook().getFontIdx(f);
                            if (fIndex == -1) {
                                fIndex = bk.getWorkBook().insertFont(f) + 1;
                            }
                            if (formattingRuns == null) {
                                formattingRuns = new ArrayList<short[]>();
                            }
                            formattingRuns.add(new short[]{Integer.valueOf(idx).shortValue(), Integer.valueOf(fIndex).shortValue()});
                            break block10;
                        }
                        if (!tnm.equals("t")) break block10;
                        eventType = xpp.next();
                        while (eventType != 1 && eventType != 3 && eventType != 4) {
                            eventType = xpp.next();
                        }
                        if (eventType != 4) break block10;
                        s = String.valueOf(s) + xpp.getText();
                        break block10;
                    }
                    if (eventType == 3 && xpp.getName().equals("text")) {
                        str = Sst.createUnicodeString(s, formattingRuns, 1);
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("r.parseOOXML: " + e.toString());
        }
        Text oe = new Text(str);
        return oe;
    }

    @Override
    public String getOOXML() {
        return null;
    }

    public String getOOXML(WorkBook bk) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<text>");
        if (this.str != null) {
            String s = OOXMLAdapter.stripNonAsciiRetainQuote(this.str.getStringVal()).toString();
            ArrayList runs = this.str.getFormattingRuns();
            if (runs == null) {
                if (s.indexOf(" ") == 0 || s.lastIndexOf(" ") == s.length() - 1) {
                    ooxml.append("<t xml:space=\"preserve\">" + s + "</t>");
                } else {
                    ooxml.append("<t>" + s + "</t>");
                }
                ooxml.append("\r\n");
            } else {
                int begIdx = 0;
                ooxml.append("<r>");
                int j = 0;
                while (j < runs.size()) {
                    short[] idxs = (short[])runs.get(j);
                    if (idxs[0] > begIdx) {
                        ooxml.append("<t xml:space=\"preserve\">" + OOXMLAdapter.stripNonAscii(s.substring(begIdx, idxs[0])) + "</t>");
                        ooxml.append("</r>");
                        ooxml.append("\r\n");
                        ooxml.append("<r>");
                        begIdx = idxs[0];
                    }
                    Ss_rPr rp = Ss_rPr.createFromFont(bk.getFont(idxs[1]));
                    ooxml.append(rp.getOOXML());
                    ++j;
                }
                s = begIdx < s.length() ? s.substring(begIdx) : "";
                ooxml.append("<t xml:space=\"preserve\">" + OOXMLAdapter.stripNonAscii(s) + "</t>");
                ooxml.append("\r\n");
                ooxml.append("</r>");
            }
        }
        ooxml.append("</text>");
        ooxml.append("\r\n");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Text(this);
    }

    public String getComment() {
        if (this.str != null) {
            return this.str.getStringVal();
        }
        return null;
    }

    public Unicodestring getCommentWithFormatting() {
        return this.str;
    }
}

