/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class Top10
implements OOXMLElement {
    private static final long serialVersionUID = 77735498689922082L;
    private HashMap<String, String> attrs = null;

    public Top10(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public Top10(Top10 t) {
        this.attrs = t.attrs;
    }

    public static Top10 parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("top10")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("top10")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("top10.parseOOXML: " + e.toString());
        }
        Top10 t = new Top10(attrs);
        return t;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<top10");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Top10(this);
    }
}

