/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.CommentHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.ExtenXLS.PrinterSettingsHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.OOXML.OneCellAnchor;
import com.extentech.formats.OOXML.SheetPr;
import com.extentech.formats.OOXML.SheetView;
import com.extentech.formats.OOXML.Text;
import com.extentech.formats.OOXML.TwoCellAnchor;
import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.AutoFilter;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Blank;
import com.extentech.formats.XLS.Bof;
import com.extentech.formats.XLS.Boolerr;
import com.extentech.formats.XLS.CellAddressible;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.CellRec;
import com.extentech.formats.XLS.Cf;
import com.extentech.formats.XLS.Colinfo;
import com.extentech.formats.XLS.ColumnRange;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.DefColWidth;
import com.extentech.formats.XLS.Dimensions;
import com.extentech.formats.XLS.Dv;
import com.extentech.formats.XLS.Dval;
import com.extentech.formats.XLS.Eof;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.FontBasis;
import com.extentech.formats.XLS.Footerrec;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Guts;
import com.extentech.formats.XLS.Headerrec;
import com.extentech.formats.XLS.Index;
import com.extentech.formats.XLS.InvalidRecordException;
import com.extentech.formats.XLS.Labelsst;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.MSODrawingGroup;
import com.extentech.formats.XLS.MSODrawingSelection;
import com.extentech.formats.XLS.Mergedcells;
import com.extentech.formats.XLS.Mul;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Mulrk;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.Note;
import com.extentech.formats.XLS.NumberRec;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.OOXMLReader;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.Pane;
import com.extentech.formats.XLS.ReferenceTracker;
import com.extentech.formats.XLS.Rk;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.RowNotFoundException;
import com.extentech.formats.XLS.Scl;
import com.extentech.formats.XLS.Selection;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.SheetProtectionManager;
import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Sxview;
import com.extentech.formats.XLS.Txo;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.Window2;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkBookAssembler;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.WsBool;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.Fontx;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.cellformat.CellFormatFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class Boundsheet
extends XLSRecord
implements Sheet {
    private static final long serialVersionUID = 8977216410574107840L;
    private Bof mybof = null;
    private Eof myeof = null;
    private String sheetname = "";
    private String sheetHash = "";
    private final Map<Integer, Row> rows = new LinkedHashMap<Integer, Row>();
    private SortedMap<CellAddressible, BiffRec> cellsByRow = new TreeMap<CellAddressible, BiffRec>(new CellAddressible.RowMajorComparator());
    private SortedMap<CellAddressible, BiffRec> cellsByCol = new TreeMap<CellAddressible, BiffRec>(new CellAddressible.ColumnMajorComparator());
    private final Map arrFormulaLocs = new HashMap();
    protected AbstractList arrayformulas = new ArrayList();
    private final SortedMap<ColumnRange, Colinfo> colinfos = new TreeMap<ColumnRange, Colinfo>(new ColumnRange.Comparator());
    private AbstractList SheetRecs = new ArrayList();
    private AbstractList localrecs;
    private List printRecs;
    private List transferXfs = new ArrayList();
    private List transferFonts = new ArrayList();
    public HashMap imageMap = new HashMap();
    private final List charts = new ArrayList();
    private long lbPlyPos;
    private short grbit;
    private byte cch;
    private byte grbitChr;
    private Index myidx;
    private BiffRec lastCell;
    private Row lastRow = null;
    private Window2 win2;
    private Scl scl;
    private Pane pane;
    private Dval dval;
    protected Headerrec hdr;
    protected Footerrec ftr;
    private WsBool wsbool;
    private Guts guts;
    public int lastObjId = 0;
    static final byte SHEET_DIALOG = 0;
    static final byte XL4_MACRO = 1;
    static final byte CHART = 2;
    static final byte VBMODULE = 6;
    public static final byte VISIBLE = 0;
    public static final byte HIDDEN = 1;
    public static final byte VERY_HIDDEN = 2;
    private boolean formulaShiftInclusive = false;
    private AbstractList cond_formats = new Vector();
    private final AbstractList autoFilters = new Vector();
    private AbstractList ooxmlObjects = new ArrayList();
    private boolean thickBottom = false;
    private boolean thickTop = false;
    private boolean zeroHeight = false;
    private boolean customHeight = false;
    private double defaultRowHeight = 12.75;
    private float defaultColWidth = -1.0f;
    private DefColWidth defColWidth = null;
    private HashMap ooxmlShapes = null;
    private SheetView sheetview = null;
    private SheetPr sheetPr = null;
    private com.extentech.formats.OOXML.AutoFilter ooautofilter = null;
    private SheetProtectionManager protector;
    private transient HashMap sheetNameRecs = new HashMap();
    List mc = new CompatibleVector();
    private Selection lastselection = null;
    private Dimensions dimensions;
    boolean selected = false;
    public boolean fastCellAdds = false;
    private boolean copypriorformats = true;
    private int maximumCellCol = -1;
    private int maximumCellRow = -1;
    HashMap<String, String> shExternalLinkInfo = null;

    @Override
    public Headerrec getHeader() {
        return this.hdr;
    }

    @Override
    public void setHeader(BiffRec h) {
        this.hdr = (Headerrec)h;
    }

    @Override
    public Footerrec getFooter() {
        return this.ftr;
    }

    @Override
    public void setFooter(BiffRec ftr) {
        this.ftr = (Footerrec)ftr;
    }

    public void setDvalRec(Dval d) {
        this.dval = d;
    }

    public Dval getDvalRec() {
        return this.dval;
    }

    public SheetProtectionManager getProtectionManager() {
        if (this.protector == null) {
            this.protector = new SheetProtectionManager(this);
        }
        return this.protector;
    }

    @Override
    public BiffRec getLastCell() {
        return this.lastCell;
    }

    @Override
    public List getSheetRecs() {
        return this.SheetRecs;
    }

    public void insertImage(ImageHandle im) {
        this.insertImage(im, false);
    }

    public void insertImage(ImageHandle im, boolean bAddUnconditionally) {
        MSODrawingGroup msodg = this.wkbook.getMSODrawingGroup();
        MSODrawing msoDrawing = (MSODrawing)MSODrawing.getPrototype();
        msoDrawing.setSheet(this);
        msoDrawing.setCoords(im.getCoords());
        im.setMsgdrawing(msoDrawing);
        int insertIndex = -1;
        Obj obj = (Obj)Obj.getPrototype();
        if (msodg != null) {
            insertIndex = this.getIndexOf((short)237);
            if (insertIndex < 0) {
                insertIndex = this.getIndexOf((short)574);
            }
            if (msodg.getMsoHeaderRec(this) == null) {
                msoDrawing.setIsHeader();
            }
        } else {
            this.wkbook.setMSODrawingGroup((MSODrawingGroup)MSODrawingGroup.getPrototype());
            msodg = this.wkbook.getMSODrawingGroup();
            msodg.initNewMSODrawingGroup();
            msoDrawing.setIsHeader();
            insertIndex = this.getIndexOf((short)512) + 1;
        }
        if (insertIndex > 0) {
            int idx = msodg.addImage(im.getImageBytes(), im.getImageType(), bAddUnconditionally);
            this.imageMap.put(im, im.getImageIndex() - 1);
            msoDrawing.createRecord(++this.wkbook.lastSPID, im.getImageName(), im.getShapeName(), idx);
            this.SheetRecs.add(insertIndex++, msoDrawing);
            this.SheetRecs.add(insertIndex++, obj);
            msodg.addMsodrawingrec(msoDrawing);
            this.wkbook.updateMsodrawingHeaderRec(this);
            msodg.setSpidMax(this.wkbook.lastSPID + 1);
            msodg.updateRecord();
            msodg.dirtyflag = true;
        } else {
            Logger.logErr("Boundsheet.insertImage:  Drawing Group not created.");
        }
    }

    public List getImageVect() {
        ArrayList im = new ArrayList();
        Iterator ir = this.imageMap.keySet().iterator();
        while (ir.hasNext()) {
            im.add(ir.next());
        }
        return im;
    }

    public Name[] getSheetScopedNames() {
        if (this.sheetNameRecs == null) {
            this.sheetNameRecs = new HashMap();
        }
        ArrayList a = new ArrayList(this.sheetNameRecs.values());
        Name[] n = new Name[a.size()];
        a.toArray(n);
        return n;
    }

    void updateLocalNameReferences() {
        if (this.sheetNameRecs == null) {
            return;
        }
        for (Name n : this.sheetNameRecs.values()) {
            n.setItab((short)(this.getSheetNum() + 1));
        }
    }

    public ImageHandle[] getImages() {
        if (this.imageMap == null) {
            return null;
        }
        ImageHandle[] im = new ImageHandle[this.imageMap.size()];
        Iterator ir = this.imageMap.keySet().iterator();
        int i = 0;
        while (ir.hasNext()) {
            im[i++] = (ImageHandle)ir.next();
        }
        return im;
    }

    @Override
    public void addColinfo(Colinfo c) {
        if (!this.colinfos.containsValue(c)) {
            this.colinfos.put(c, c);
        }
    }

    public Dval insertDvalRec() {
        if (this.getDvalRec() != null) {
            return this.getDvalRec();
        }
        Dval d = (Dval)Dval.getPrototype();
        d.setSheet(this);
        int insertIdx = this.win2.getRecordIndex() + 1;
        short opc = ((BiffRec)this.SheetRecs.get(insertIdx)).getOpcode();
        while (opc != 10) {
            if (opc == 2151 || opc == 2152 || opc == 2146) break;
            opc = ((BiffRec)this.SheetRecs.get(++insertIdx)).getOpcode();
        }
        this.SheetRecs.add(insertIdx, d);
        this.setDvalRec(d);
        return d;
    }

    public Dv createDv(String location) {
        if (this.getDvalRec() == null) {
            this.insertDvalRec();
        }
        Dv dv = this.getDvalRec().createDvRec(location);
        int insertIdx = this.SheetRecs.size() - 2;
        short opc = ((BiffRec)this.SheetRecs.get(insertIdx)).getOpcode();
        while (opc != 446 && opc != 434) {
            opc = ((BiffRec)this.SheetRecs.get(--insertIdx)).getOpcode();
        }
        this.SheetRecs.add(insertIdx + 1, dv);
        return dv;
    }

    public Condfmt createCondfmt(String location, WorkBookHandle wbh) {
        Condfmt cfx = (Condfmt)Condfmt.getPrototype();
        int insertIdx = this.win2.getRecordIndex() + 1;
        BiffRec rec = (BiffRec)this.SheetRecs.get(insertIdx);
        while (rec.getOpcode() != 440 && rec.getOffset() != 434 && rec.getOpcode() != 2146 && rec.getOpcode() != 2151 && rec.getOpcode() != 2152 && rec.getOpcode() != 10) {
            rec = (BiffRec)this.SheetRecs.get(++insertIdx);
        }
        this.SheetRecs.add(insertIdx, cfx);
        cfx.setStreamer(this.streamer);
        cfx.setWorkBook(this.getWorkBook());
        cfx.resetRange(location);
        this.addConditionalFormat(cfx);
        cfx.setSheet(this);
        return cfx;
    }

    public Cf createCf(Condfmt cfx) {
        Cf cf = (Cf)Cf.getPrototype();
        int insertIdx = cfx.getRecordIndex() + 1;
        this.SheetRecs.add(insertIdx, cf);
        cf.setStreamer(this.streamer);
        cf.setWorkBook(this.getWorkBook());
        cf.setSheet(this);
        cf.setCondfmt(cfx);
        cfx.addRule(cf);
        return cf;
    }

    public ImageHandle getImageByMsoIndex(int index) {
        if (this.imageMap == null) {
            return null;
        }
        Iterator ir = this.imageMap.keySet().iterator();
        ImageHandle ret = null;
        while (ir.hasNext() && ret == null) {
            ImageHandle im = (ImageHandle)ir.next();
            if (im.getMsodrawing().getImageIndex() != index) continue;
            ret = im;
        }
        return ret;
    }

    public int getIndexOfMsodrawingselection() {
        BiffRec rec = null;
        int size = this.SheetRecs.size();
        int foundIndex = -1;
        int i = 0;
        while (i < size) {
            rec = (BiffRec)this.SheetRecs.get(i);
            if (rec instanceof MSODrawingSelection) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        return foundIndex;
    }

    public int getIndexOfWindow2() {
        BiffRec rec = null;
        int size = this.SheetRecs.size();
        int foundIndex = -1;
        int i = 0;
        while (i < size) {
            rec = (BiffRec)this.SheetRecs.get(i);
            if (rec instanceof Window2) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        return foundIndex;
    }

    public int getIndexOfDimensions() {
        BiffRec rec = null;
        int size = this.SheetRecs.size();
        int foundIndex = -1;
        int i = 0;
        while (i < size) {
            rec = (BiffRec)this.SheetRecs.get(i);
            if (rec instanceof Dimensions) {
                foundIndex = i + 1;
                break;
            }
            ++i;
        }
        return foundIndex;
    }

    public int getIndexOf(short opc) {
        BiffRec rec = null;
        int size = this.SheetRecs.size();
        int foundIndex = -1;
        int i = 0;
        while (i < size && foundIndex == -1) {
            rec = (BiffRec)this.SheetRecs.get(i);
            if (rec.getOpcode() == opc) {
                foundIndex = i;
            }
            ++i;
        }
        return foundIndex;
    }

    public BiffRec getSheetRec(short opc) {
        BiffRec rec = null;
        int size = this.SheetRecs.size();
        int foundIndex = -1;
        int i = 0;
        while (i < size && foundIndex == -1) {
            rec = (BiffRec)this.SheetRecs.get(i);
            if (rec.getOpcode() == opc) {
                return rec;
            }
            ++i;
        }
        return null;
    }

    public void insertSheetRecordAt(BiffRec r2, int index) {
        r2.setSheet(this);
        if (index > -1 && index < this.SheetRecs.size()) {
            this.SheetRecs.add(index, r2);
        } else {
            this.SheetRecs.add(r2);
        }
    }

    public String getSheetHash() {
        if (this.sheetHash.equals("")) {
            this.sheetHash = String.valueOf(this.getSheetName()) + this.getSheetNum() + this.getRealRecordIndex();
        }
        return this.sheetHash;
    }

    public List assembleSheetRecs() {
        return WorkBookAssembler.assembleSheetRecs(this);
    }

    public void writeAsTabbedText(OutputStream dest) throws IOException {
        int lastrow = this.getMaxRow();
        int lastcol = this.getMaxCol();
        boolean isInteger = false;
        byte[] tab = new byte[]{9};
        byte[] crlf = new byte[]{13, 10};
        int i = 0;
        while (i < lastrow) {
            Row r2 = this.getRowByNumber(i);
            if (r2 != null) {
                int j = 0;
                while (j < lastcol) {
                    BiffRec c = null;
                    try {
                        Object o;
                        c = r2.getCell((short)j);
                        int type = ((XLSRecord)c).getCellType();
                        if (type != 3) {
                            isInteger = type == 2;
                            o = c.getStringVal();
                        } else {
                            o = ((Formula)c).calculateFormula();
                            isInteger = o instanceof Integer || o instanceof Double && (double)((Double)o).intValue() == (Double)o;
                        }
                        try {
                            String output = CellFormatFactory.fromPatternString(c.getFormatPattern()).format(o.toString());
                            if (output.indexOf(",") != -1) {
                                output = "\"" + output + "\"";
                            }
                            dest.write(output.getBytes());
                        }
                        catch (Exception e) {
                            Logger.logWarn("Boundsheet.writeAsTabbedText: error writing " + c.getCellAddress() + ":" + e.toString());
                        }
                    }
                    catch (CellNotFoundException cellNotFoundException) {
                        // empty catch block
                    }
                    dest.write(tab);
                    ++j;
                }
            }
            dest.write(crlf);
            ++i;
        }
        dest.flush();
        dest.close();
    }

    @Override
    public void preStream() {
    }

    @Override
    public Bof getMyBof() {
        return this.mybof;
    }

    @Override
    public Eof getMyEof() {
        return this.myeof;
    }

    public List getDvRecs() {
        if (this.getDvalRec() != null) {
            return this.getDvalRec().getDvs();
        }
        return null;
    }

    public List getConditionalFormats() {
        return this.cond_formats;
    }

    public void addConditionalFormat(Condfmt cf) {
        if (this.cond_formats == null) {
            this.cond_formats = new ArrayList();
        }
        if (this.cond_formats.indexOf(cf) == -1) {
            this.cond_formats.add(cf);
        }
    }

    @Override
    public void setWindow2(Window2 w) {
        this.win2 = w;
    }

    @Override
    public Window2 getWindow2() {
        return this.win2;
    }

    public void setPane(Pane p) {
        if (p == null) {
            p = (Pane)Pane.getPrototype();
            int insertIdx = this.win2.getRecordIndex() + 1;
            this.SheetRecs.add(insertIdx, p);
        }
        this.pane = p;
        this.pane.setWindow2(this.win2);
    }

    public Pane getPane() {
        return this.pane;
    }

    public void removePane() {
        this.SheetRecs.remove(this.pane);
        this.pane = null;
    }

    @Override
    public WorkBook getWorkBook() {
        return this.wkbook;
    }

    @Override
    @Deprecated
    public void removeCell(String celladdr) {
        BiffRec c = this.getCell(celladdr);
        if (c != null) {
            this.removeCell(c);
        }
    }

    public void removeCell(int row, int col) {
        try {
            BiffRec c = this.getCell(row, col);
            this.removeCell(c);
        }
        catch (CellNotFoundException cellNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void removeCell(BiffRec cell) {
        if (cell.getOpcode() == 190) {
            ((Mulblank)cell).removeCell(cell.getColNumber());
        }
        if (cell.getOpcode() == 6) {
            Formula f = (Formula)cell;
            this.wkbook.removeFormula(f);
        }
        this.cellsByRow.remove(cell);
        this.cellsByCol.remove(cell);
    }

    public boolean removeImage(ImageHandle img) {
        return this.imageMap.remove(img) != null;
    }

    public void removeRecFromVec(int idx) {
        try {
            BiffRec rec = (BiffRec)this.SheetRecs.get(idx);
            this.removeRecFromVec(rec);
        }
        catch (Exception e) {
            Logger.logErr("Boundsheet.removeRecFromVec: " + e.toString());
        }
    }

    public void removeRows(int first, int count, boolean shift) {
        int rowIdx = first;
        while (rowIdx < first + count) {
            Row row = this.rows.get(rowIdx);
            if (row != null) {
                Iterator<BiffRec> iter = row.getCells().iterator();
                while (iter.hasNext()) {
                    BiffRec cell = iter.next();
                    iter.remove();
                    this.removeCell(cell);
                }
                this.rows.remove(rowIdx);
                this.removeRecFromVec(row);
            }
            ++rowIdx;
        }
        if (shift && !this.rows.isEmpty()) {
            int shiftBy = -1 * count;
            int lastrow = this.lastRow.getRowNumber();
            int rowIdx2 = first + 1;
            while (rowIdx2 <= lastrow) {
                Row row = this.rows.get(rowIdx2);
                if (row != null) {
                    this.shiftRow(row, shiftBy);
                }
                ++rowIdx2;
            }
        }
        this.dimensions.setRowLast(this.lastRow != null ? this.lastRow.getRowNumber() : 0);
    }

    @Override
    public void removeRecFromVec(BiffRec rec) {
        boolean removerec = true;
        if (rec.getOpcode() == 638) {
            Rk thisrk = (Rk)rec;
            this.removeMulrk(thisrk);
        } else if (rec.getOpcode() == 6) {
            Formula f = (Formula)rec;
            this.wkbook.removeFormula(f);
        } else if (rec.getOpcode() == 253) {
            Labelsst lst = (Labelsst)rec;
            Sst strtable = this.wkbook.getSharedStringTable();
            lst.initUnsharedString();
            strtable.removeUnicodestring(lst.getUnsharedString());
        } else if (rec instanceof Mulblank) {
            removerec = ((Mulblank)rec).removeCell(rec.getColNumber());
        }
        if (removerec) {
            if (this.streamer.removeRecord(rec)) {
                if (this.DEBUGLEVEL > 5) {
                    Logger.logInfo("Boundsheet RemoveRec Removed: " + rec.toString());
                }
            } else if (rec instanceof Mul) {
                if (!((Mul)((Object)rec)).removed() && this.DEBUGLEVEL > 1) {
                    Logger.logWarn("RemoveRec failed: " + rec.getClass().getName() + " not found in Streamer Vec");
                }
            } else if (this.DEBUGLEVEL > 1) {
                Logger.logWarn("RemoveRec failed: " + rec.getClass().getName() + " not found in Streamer Vec");
            }
        }
    }

    @Override
    public void removeMulrk(Rk thisrk) {
        Mulrk mymul = (Mulrk)thisrk.getMyMul();
        if (mymul != null) {
            CompatibleVector vect = mymul.removeRk(thisrk);
            boolean deletemulrk = false;
            if (mymul.getColFirst() == thisrk.getColNumber()) {
                deletemulrk = true;
            }
            if (vect != null) {
                for (Rk temprk : vect) {
                    temprk.setNoMul();
                    String loc = temprk.getCellAddress();
                    Double d = new Double(temprk.getDblVal());
                    BiffRec g = this.getCell(loc);
                    int fmt = g.getIxfe();
                    g.getRow().removeCell(g);
                    this.removeCell(loc);
                    this.addValue(d, loc);
                    this.getCell(loc).setIxfe(fmt);
                    this.streamer.removeRecord(temprk);
                }
            }
            if (deletemulrk) {
                mymul.removed = true;
                this.removeRecFromVec(mymul);
            }
        }
    }

    public void removeRowContents(int rownum) throws RowNotFoundException {
        Row r2 = this.getRowByNumber(rownum);
        if (r2 != null) {
            Object[] cells = r2.getCellArray();
            int x = 0;
            while (x < cells.length) {
                this.removeCell((BiffRec)cells[x]);
                ++x;
            }
        } else {
            throw new RowNotFoundException(String.valueOf(this.getSheetName()) + ":" + rownum);
        }
        this.rows.remove(rownum);
        this.removeRecFromVec(r2);
        r2 = null;
    }

    public void removeCols(int first, int count, boolean shift) {
        if (shift) {
            ReferenceTracker.updateReferences(first, count * -1, this, false);
        }
        int colIdx = first;
        while (colIdx < first + count) {
            Colinfo info = this.getColInfo(colIdx);
            if (info != null) {
                if (info.getColLast() < first + count) {
                    if (info.getColFirst() >= first) {
                        this.removeColInfo(info);
                    } else {
                        info.setColLast(first - 1);
                    }
                } else if (info.getColFirst() >= first) {
                    info.setColFirst(first + count);
                }
            }
            try {
                ArrayList<BiffRec> cells = this.getCellsByCol(colIdx);
                int cellCount = cells.size();
                int idx = cellCount - 1;
                while (idx >= 0) {
                    BiffRec cell = (BiffRec)cells.get(idx);
                    if (cell != null) {
                        this.removeCell(cell);
                    }
                    --idx;
                }
            }
            catch (CellNotFoundException cells) {
                // empty catch block
            }
            ++colIdx;
        }
        if (shift) {
            int shiftBy = -1 * count;
            int maxcol = this.getRealMaxCol();
            int colIdx2 = first + 1;
            while (colIdx2 <= maxcol) {
                this.shiftCol(colIdx2, shiftBy);
                ++colIdx2;
            }
        }
        this.dimensions.setColLast(this.getRealMaxCol());
    }

    public ArrayList<BiffRec> getCellsByCol(int colNum) throws CellNotFoundException {
        SortedMap<CellAddressible, BiffRec> theCells = this.cellsByCol.subMap(new CellAddressible.RangeBoundary(0, colNum, true), new CellAddressible.RangeBoundary(0, colNum + 1, false));
        if (theCells.size() == 0) {
            throw new CellNotFoundException(this.sheetname, 0, this.col);
        }
        Collection<BiffRec> cells = theCells.values();
        for (BiffRec biffrec : cells) {
            if (biffrec.getOpcode() != 190) continue;
            ((Mulblank)biffrec).setCurrentCell((short)colNum);
        }
        return new ArrayList<BiffRec>(cells);
    }

    public ArrayList<BiffRec> getCellsByRow(int rowNum) throws CellNotFoundException {
        SortedMap<CellAddressible, BiffRec> theCells = this.cellsByRow.subMap(new CellAddressible.Reference(rowNum, 0), new CellAddressible.Reference(rowNum + 1, 0));
        if (theCells.size() == 0) {
            throw new CellNotFoundException(this.sheetname, 0, this.col);
        }
        Collection<BiffRec> cells = theCells.values();
        return new ArrayList<BiffRec>(cells);
    }

    @Override
    public Colinfo getColInfo(int col) {
        Colinfo info = (Colinfo)this.colinfos.get(new ColumnRange.Reference(col, col));
        if (info == null) {
            return null;
        }
        if (info.inrange(col)) {
            return info;
        }
        return null;
    }

    @Override
    public void removeAllRecords() {
        XLSRecord[] rx = new XLSRecord[this.SheetRecs.size()];
        this.SheetRecs.toArray(rx);
        int t = 0;
        while (t < rx.length) {
            short opcode = rx[t].getOpcode();
            if (opcode != 236 && (opcode != 60 || ((Continue)rx[t]).maskedMso == null)) {
                this.removeRecFromVec(rx[t]);
            } else if (opcode == 236) {
                this.wkbook.msodg.removeMsodrawingrec((MSODrawing)rx[t], this, false);
            } else {
                this.wkbook.msodg.removeMsodrawingrec(((Continue)rx[t]).maskedMso, this, false);
            }
            rx[t] = null;
            ++t;
        }
        this.SheetRecs.clear();
    }

    private void shiftCol(int colNum, int shift) {
        Colinfo info = this.getColInfo(colNum);
        int oldCol = colNum;
        int newCol = oldCol + shift;
        try {
            ArrayList<BiffRec> cells = this.getCellsByCol(colNum);
            for (BiffRec cell : cells) {
                cell.setCol((short)newCol);
                this.updateDimensions(cell.getRowNumber(), cell.getColNumber());
            }
        }
        catch (CellNotFoundException cell) {
            // empty catch block
        }
        if (info != null) {
            int last;
            int first = info.getColFirst();
            if (first == oldCol || first > newCol) {
                info.setColFirst(newCol);
            }
            if ((last = info.getColLast()) == oldCol || last < newCol) {
                info.setColLast(newCol);
            }
        }
    }

    private void removeColInfo(Colinfo ci) {
        this.removeRecFromVec(ci);
        this.colinfos.remove(ci);
    }

    @Override
    public void setBOF(Bof b) {
        this.mybof = b;
        b.setSheet(this);
    }

    @Override
    public boolean isChartOnlySheet() {
        if (this.mybof != null) {
            return this.mybof.isChartBof();
        }
        return false;
    }

    @Override
    public void setEOF(Eof f) {
        this.myeof = f;
    }

    @Override
    public long getLbPlyPos() {
        if (this.mybof != null) {
            return this.mybof.getLbPlyPos();
        }
        return this.lbPlyPos;
    }

    @Override
    public void setLbPlyPos(long newpos) {
        byte[] newposbytes = ByteTools.cLongToLEBytes((int)newpos);
        System.arraycopy(newposbytes, 0, this.getData(), 0, 4);
        this.lbPlyPos = newpos;
    }

    @Override
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public void setDimensions(Dimensions d) {
        if (this.dimensions == null) {
            this.dimensions = d;
            if (this.myidx != null) {
                this.myidx.setDimensions(d);
            }
        }
    }

    private void shiftRow(Row row, int shift) {
        Iterator<BiffRec> cells = row.getCells().iterator();
        Mulblank skipMulBlank = null;
        while (cells.hasNext()) {
            BiffRec cell = cells.next();
            if (cell == skipMulBlank) continue;
            if (cell.getOpcode() == 190) {
                skipMulBlank = (Mulblank)cell;
            }
            this.shiftCellRow(cell, shift);
        }
        int oldRow = row.getRowNumber();
        int newRow = oldRow + shift;
        row.setRowNumber(newRow);
        this.rows.remove(oldRow);
        this.rows.put(newRow, row);
        if (this.dimensions.getRowLast() < newRow) {
            this.dimensions.setRowLast(newRow);
            this.lastRow = row;
        }
    }

    @Override
    public int getMinRow() {
        return this.dimensions.getRowFirst();
    }

    @Override
    public int getMaxRow() {
        return this.dimensions.getRowLast();
    }

    @Override
    public int getMinCol() {
        return this.dimensions.getColFirst();
    }

    @Override
    public int getMaxCol() {
        return this.dimensions.getColLast();
    }

    @Override
    public void updateDimensions(int row, int c) {
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo("Boundsheet Updating Dimensions: " + row + ":" + this.col);
        }
        short col = (short)c;
        this.maximumCellCol = Math.max(this.maximumCellCol, col);
        this.maximumCellRow = Math.max(this.maximumCellRow, row);
        if (this.dimensions != null) {
            this.dimensions.updateDimensions(row - 1, col);
        }
        if (this.myidx != null) {
            this.myidx.updateRowDimensions(this.getMinRow(), this.getMaxRow());
        }
    }

    @Override
    public void setSheetIDX(Index idx) {
        idx.setSheet(this);
        this.myidx = idx;
    }

    public Index getSheetIDX() {
        return this.myidx;
    }

    private void shiftCellRow(BiffRec cell, int shift) {
        int newrow = cell.getRowNumber() + shift;
        cell.setRowNumber(newrow);
        switch (cell.getOpcode()) {
            case 638: {
                ((Rk)cell).setMulrkRow(newrow);
                break;
            }
            case 6: {
                Object o;
                Formula formula = (Formula)cell;
                if (!formula.isSharedFormula() || formula.getInternalRecords().size() <= 0 || !((o = formula.getInternalRecords().get(0)) instanceof Shrfmla)) break;
                Shrfmla s = (Shrfmla)o;
                s.setFirstRow(s.getFirstRow() + shift);
                s.setLastRow(s.getLastRow() + shift);
            }
        }
    }

    @Override
    public int getSheetNum() {
        return this.wkbook.getSheetVect().indexOf(this);
    }

    private Row addNewRow(BiffRec cell) {
        int rn = cell.getRowNumber();
        if (this.getRowByNumber(rn) != null) {
            return this.getRowByNumber(rn);
        }
        Row r2 = new Row(rn, this.wkbook);
        try {
            if (rn >= this.getMaxRow()) {
                this.dimensions.setRowLast(rn);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        r2.setSheet(this);
        this.addRowRec(r2);
        return r2;
    }

    public Row insertRow(int rownum, int flag, boolean shiftrows) {
        Row roe = null;
        if (shiftrows && !this.fastCellAdds) {
            try {
                if (this.lastRow != null) {
                    int startrow = this.lastRow.getRowNumber();
                    if (startrow == 0x100000) {
                        --startrow;
                    }
                    int t = startrow;
                    while (t >= rownum) {
                        Row rowtoshift = this.rows.get(t);
                        if (rowtoshift != null) {
                            try {
                                this.shiftRow(rowtoshift, 1);
                            }
                            catch (Exception e) {
                                Logger.logWarn("Boundsheet.insertRow() failed shifting row: " + t + " - " + e.toString());
                            }
                        }
                        --t;
                    }
                }
                if ((roe = this.getRowByNumber(rownum)) == null) {
                    int[] nArray = new int[2];
                    nArray[0] = rownum;
                    int[] rc = nArray;
                    this.addRecord(Blank.getPrototype(), rc);
                    roe = this.getRowByNumber(rownum);
                }
            }
            catch (Exception a) {
                Logger.logInfo("Boundsheet.insertRow:  Shifting row during Insert failed: " + a);
            }
        } else {
            roe = this.getRowByNumber(rownum);
            if (roe == null) {
                Row r2 = new Row(rownum, this.wkbook);
                if (rownum >= this.getMaxRow()) {
                    this.dimensions.setRowLast(rownum);
                }
                r2.setSheet(this);
                this.addRowRec(r2);
                roe = this.getRowByNumber(rownum);
                roe.resetCacheBytes();
            }
        }
        return roe;
    }

    @Override
    public void updateMergedCells() {
        if (this.mc.size() < 1) {
            return;
        }
        Iterator mcs = this.mc.iterator();
        while (mcs.hasNext()) {
            ((Mergedcells)mcs.next()).update();
        }
    }

    public void addRowRec(Row r2) {
        int rwn = r2.getRowNumber();
        if (this.rows.containsKey(rwn)) {
            if (this.DEBUGLEVEL > 2) {
                Logger.logWarn("Sheet.addRow() attempting to add existing row");
            }
        } else {
            this.rows.put(rwn, r2);
            if (this.lastRow == null) {
                this.lastRow = r2;
            } else if (rwn > this.lastRow.getRowNumber()) {
                this.lastRow = r2;
            }
        }
    }

    @Override
    public boolean getHidden() {
        return this.grbit != 0;
    }

    public boolean getVeryHidden() {
        return this.grbit == 2;
    }

    @Override
    public void setHidden(int gr) {
        this.grbit = (short)gr;
        byte[] bt = ByteTools.shortToLEBytes(this.grbit);
        System.arraycopy(bt, 0, this.getData(), 4, 2);
    }

    @Override
    public boolean selected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean b) {
        if (this.win2 != null) {
            this.win2.setSelected(b);
        }
        if (b) {
            this.getWorkBook().setSelectedSheet(this);
        }
        this.selected = b;
    }

    public void addArrayFormula(Array a) {
        this.arrayformulas.add(a);
    }

    public Array getArrayFormula(String addr) {
        Array form = null;
        int i = 0;
        while (i < this.arrayformulas.size()) {
            form = (Array)this.arrayformulas.get(i);
            if (form.isInRange(addr)) {
                return form;
            }
            ++i;
        }
        return null;
    }

    public void addParentArrayRef(String addr, String ref) {
        if (this.arrFormulaLocs.containsKey(addr)) {
            Logger.logWarn("PARENT ARRAY ALREADY FOUND");
        }
        this.arrFormulaLocs.put(addr, ref);
    }

    public Object getArrayFormulaParent(int[] rc) {
        for (String addr : this.arrFormulaLocs.keySet()) {
            int[] arrayRC = ExcelTools.getRangeRowCol((String)this.arrFormulaLocs.get(addr));
            if (rc[1] < arrayRC[1] || rc[1] > arrayRC[3] || rc[0] < arrayRC[0] || rc[0] > arrayRC[2]) continue;
            return arrayRC;
        }
        return null;
    }

    public boolean isArrayFormulaParent(String addr) {
        return this.arrFormulaLocs.get(addr) != null;
    }

    public String getArrayRef(String formAddress) {
        return (String)this.arrFormulaLocs.get(formAddress);
    }

    public void insertCols(int first, int count) {
        ReferenceTracker.updateReferences(first + 1, count, this, false);
        int colIdx = this.getRealMaxCol();
        while (colIdx >= first) {
            this.shiftCol(colIdx, count);
            --colIdx;
        }
        Colinfo movedCol = this.getColInfo(first + count);
        if (movedCol != null) {
            int i = 0;
            while (i < count) {
                Colinfo newcol = this.getColInfo(first + i);
                if (newcol == null) {
                    this.addColinfo(first + i, first + i, movedCol.getColWidth(), movedCol.getIxfe(), movedCol.getGrbit());
                } else {
                    newcol.setGrbit(movedCol.getGrbit());
                    newcol.setColWidth(movedCol.getColWidth());
                    newcol.setIxfe(movedCol.getIxfe());
                }
                ++i;
            }
        }
        this.dimensions.setColLast(this.getRealMaxCol());
    }

    @Override
    public int getNumRows() {
        return this.rows.size();
    }

    @Override
    public int getNumCells() {
        int counter = 0;
        Set<Integer> cellset = this.rows.keySet();
        Object[] rws = cellset.toArray();
        if (rws.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < rws.length) {
            Row r2 = this.rows.get(rws[i]);
            counter += r2.getNumberOfCells();
            ++i;
        }
        return counter;
    }

    @Override
    public List getColNames() {
        FastAddVector retvec = new FastAddVector();
        int x = 0;
        while (x < this.getRealMaxCol()) {
            String c = ExcelTools.getAlphaVal(x);
            retvec.add(c);
            ++x;
        }
        return retvec;
    }

    @Override
    public int getNumCols() {
        return this.getRealMaxCol();
    }

    public Colinfo createColinfo(int first, int last, int width, int ixfe, int grbit) {
        Colinfo ci = Colinfo.getPrototype(first, last, width, ixfe);
        ci.setGrbit(grbit);
        ci.setWorkBook(this.getWorkBook());
        ci.setSheet(this);
        this.addColinfo(ci);
        int recpos = this.getDimensions().getRecordIndex();
        List sr = this.getSheetRecs();
        BiffRec rec = (BiffRec)sr.get(--recpos);
        while (!(rec instanceof Colinfo) && !(rec instanceof DefColWidth) && recpos > 0) {
            rec = (BiffRec)sr.get(--recpos);
        }
        int cf = ci.getColFirst();
        while (rec instanceof Colinfo && ((Colinfo)rec).getColFirst() > cf) {
            rec = (BiffRec)sr.get(--recpos);
        }
        this.getStreamer().addRecordAt(ci, ++recpos);
        return ci;
    }

    public Colinfo createColinfo(int first, int last, Colinfo template) {
        return this.createColinfo(first, last, template.getColWidth(), template.getIxfe(), template.getGrbit());
    }

    public Colinfo createColinfo(int first, int last) {
        return this.createColinfo(first, last, 2340, 0, 0);
    }

    @Override
    public Row getRowByNumber(int r2) {
        return this.rows.get(r2);
    }

    @Override
    public List getRowNums() {
        Set<Integer> e = this.rows.keySet();
        Iterator<Integer> iter = e.iterator();
        FastAddVector rownames = new FastAddVector();
        while (iter.hasNext()) {
            rownames.add(rownames.size(), iter.next());
        }
        return rownames;
    }

    public SortedMap getSortedRows() {
        TreeMap<Integer, Row> sm = new TreeMap<Integer, Row>(this.rows);
        return sm;
    }

    @Override
    public Row[] getRows() {
        TreeMap<Integer, Row> rxs = new TreeMap<Integer, Row>(this.rows);
        Row[] rarr = new Row[rxs.size()];
        return rxs.values().toArray(rarr);
    }

    public Map getRowMap() {
        return this.rows;
    }

    @Override
    public BiffRec addValue(Object obj, String address) {
        return this.addValue(obj, address, false);
    }

    public BiffRec addValue(Object obj, String address, boolean fixNumberAsString) {
        int[] rc = ExcelTools.getRowColFromString(address);
        return this.addValue(obj, rc, fixNumberAsString);
    }

    public BiffRec addValue(Object obj, int[] rc, boolean fixNumberAsString) {
        return this.addValue(obj, rc, this.getWorkBook().getDefaultIxfe(), fixNumberAsString);
    }

    public BiffRec addValue(Object obj, int[] rc, int FORMAT_ID) {
        return this.addValue(obj, rc, FORMAT_ID, false);
    }

    public BiffRec addValue(Object obj, int[] rc, int FORMAT_ID, boolean fixNumberAsString) {
        double rh;
        BiffRec rec;
        if (rc[1] > 16384) {
            throw new InvalidRecordException("Cell Column number: " + rc[1] + " is greater than maximum allowable Columns: " + 16384);
        }
        if (rc[0] > 0x100000) {
            throw new InvalidRecordException("Cell Row number: " + rc[0] + " is greater than maximum allowable row: " + 0x100000);
        }
        Row r2 = this.getRowByNumber(rc[0]);
        if (FORMAT_ID <= 0) {
            FORMAT_ID = this.getWorkBook().getDefaultIxfe();
        }
        if (FORMAT_ID == this.getWorkBook().getDefaultIxfe()) {
            Colinfo co;
            if (this.getColInfo(rc[1]) != null && (co = this.getColInfo(rc[1])) != null && co.getIxfe() != 0) {
                FORMAT_ID = co.getIxfe();
            }
            if (r2 != null && r2.getExplicitFormatSet()) {
                FORMAT_ID = r2.getIxfe();
            }
        }
        CellRange merge_range = null;
        if (!this.fastCellAdds) {
            try {
                BiffRec mycell;
                rec = mycell = this.getCell(rc[0], rc[1]);
                merge_range = rec.getMergeRange();
                if (rec.getIxfe() != this.getWorkBook().getDefaultIxfe() && rec.getIxfe() != 0) {
                    FORMAT_ID = rec.getIxfe();
                }
                this.removeCell(mycell);
            }
            catch (CellNotFoundException mycell) {
                // empty catch block
            }
        }
        Object[] fixed = null;
        if (!this.fastCellAdds && fixNumberAsString && obj != null) {
            try {
                fixed = this.fixNumberStoredAsString(obj);
                obj = fixed[0];
            }
            catch (Exception rec2) {
                // empty catch block
            }
        }
        rec = this.createValrec(obj, rc, FORMAT_ID);
        if (!this.fastCellAdds && merge_range != null) {
            ((XLSRecord)rec).setMergeRange(merge_range);
        }
        this.addRecord(rec, rc);
        if (fixed != null) {
            FormatHandle f = new FormatHandle(this.wkbook, this.getWorkBook().getDefaultIxfe());
            f.setFormatPattern(fixed[1].toString());
            ((XLSRecord)rec).setXFRecord(f.getFormatId());
        }
        ((XLSRecord)rec).resetCacheBytes();
        if (r2 == null && (rh = this.getDefaultRowHeight()) != 12.75) {
            r2 = this.getRowByNumber(rc[0]);
            r2.setRowHeight((int)(rh * 20.0));
        }
        return rec;
    }

    Object[] fixNumberStoredAsString(Object s) throws NumberFormatException {
        String input = s.toString();
        if (input.indexOf(" ") > -1) {
            input = StringTool.allTrim(input);
        }
        String p = "";
        boolean matched = false;
        NumberAsStringFormat[] numberAsStringFormatArray = NumberAsStringFormat.values();
        int n = numberAsStringFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            NumberAsStringFormat fmts = numberAsStringFormatArray[n2];
            if (input.indexOf(fmts.identifier) > -1) {
                input = StringTool.strip(input, fmts.identifier);
                p = fmts.pattern;
                matched = true;
                Double d = new Double(input);
                d = fmts.adjustValue(d);
                Object[] ret = new Object[]{d, p};
                return ret;
            }
            ++n2;
        }
        throw new NumberFormatException();
    }

    private XLSRecord createValrec(Object obj, int[] rc, int FORMAT_ID) {
        XLSRecord rec = null;
        if (obj == null) {
            rec = new Blank();
        } else if (obj instanceof Formula) {
            rec = (Formula)obj;
        } else if (obj instanceof Double) {
            rec = new NumberRec((Double)obj);
        } else if (obj instanceof String) {
            if (((String)obj).startsWith("=")) {
                try {
                    rec = FormulaParser.getFormulaFromString((String)obj, this, rc);
                    this.getWorkBook().addRecord(rec, false);
                }
                catch (Exception e) {
                    throw new FunctionNotSupportedException("Adding new Formula at " + this.getSheetName() + "!" + ExcelTools.formatLocation(rc) + " failed: " + e.toString() + ".");
                }
            } else if (((String)obj).startsWith("{=")) {
                try {
                    rec = FormulaParser.getFormulaFromString((String)obj, this, rc);
                    rec.isFormula = true;
                }
                catch (Exception e) {
                    throw new FunctionNotSupportedException("Adding new Formula at " + this.getSheetName() + "!" + ExcelTools.formatLocation(rc) + " failed: " + e.toString() + ".");
                }
            } else {
                rec = obj.toString().equalsIgnoreCase("") ? new Blank() : Labelsst.getPrototype((String)obj, this.getWorkBook());
            }
        } else if (obj instanceof Integer) {
            int l = (Integer)obj;
            rec = new NumberRec(l);
        } else if (obj instanceof Long) {
            long l = (Long)obj;
            rec = new NumberRec(l);
        } else if (obj instanceof Boolean) {
            rec = Boolerr.getPrototype();
            ((Boolerr)rec).setBooleanVal((Boolean)obj);
        } else {
            double d = new Double(String.valueOf(obj));
            rec = new NumberRec(d);
        }
        rec.setWorkBook(this.getWorkBook());
        rec.setXFRecord(FORMAT_ID);
        if (rc[0] > this.getMaxRow() || rc[1] > this.getMaxCol()) {
            this.updateDimensions(rc[0], rc[1]);
        }
        return rec;
    }

    @Override
    public void addRecord(BiffRec rec, int[] rc) {
        rec.setSheet(this);
        rec.setRowCol(rc);
        rec.setIsValueForCell(true);
        rec.setStreamer(this.streamer);
        rec.setWorkBook(this.getWorkBook());
        if (!this.fastCellAdds) {
            Row ro = null;
            ro = this.rows.get(rc[0]);
            if (ro == null) {
                ro = this.addNewRow(rec);
            }
        }
        if (this.copypriorformats && !this.fastCellAdds) {
            this.copyPriorCellFormatForNewCells(rec);
        }
        try {
            this.addCell((CellRec)rec);
        }
        catch (ArrayIndexOutOfBoundsException ax) {
            Logger.logErr("Boundsheet.addRecord() failed. Column " + rc[1] + " is greater than Maximum column count");
            throw new InvalidRecordException("Adding cell failed. Column " + rc[1] + " is greater than the maximum column limit.");
        }
    }

    @Override
    public void addCell(CellRec cell) {
        this.cellsByRow.put(cell, cell);
        this.cellsByCol.put(cell, cell);
        Row row = this.rows.get(cell.getRowNumber());
        if (row == null) {
            row = this.addNewRow(cell);
        }
        row.addCell(cell);
        if (cell != null) {
            cell.setSheet(this);
        }
        this.updateDimensions(cell.getRowNumber(), cell.getColNumber());
    }

    @Override
    public void setCopyPriorCellFormats(boolean f) {
        this.copypriorformats = f;
    }

    private boolean copyPriorCellFormatForNewCells(BiffRec c) {
        int row = c.getRowNumber() + 1;
        String cnm = ExcelTools.getAlphaVal(c.getColNumber());
        BiffRec ch = this.getCell(String.valueOf(cnm) + row);
        if (ch == null) {
            return false;
        }
        c.setIxfe(ch.getIxfe());
        return true;
    }

    public int getRealMaxCol() {
        return this.maximumCellCol;
    }

    public Colinfo addColinfo(int begCol, int endCol, int width, int ixfe, int grbit) {
        Colinfo ci = Colinfo.getPrototype(begCol, endCol, width, ixfe);
        ci.setGrbit(grbit);
        ci.setWorkBook(this.getWorkBook());
        ci.setSheet(this);
        this.addColinfo(ci);
        int recpos = this.getDimensions().getRecordIndex();
        List sr = this.getSheetRecs();
        BiffRec rec = (BiffRec)sr.get(--recpos);
        while (!(rec instanceof Colinfo) && !(rec instanceof DefColWidth) && recpos > 0) {
            rec = (BiffRec)sr.get(--recpos);
        }
        int cf = ci.getColFirst();
        while (rec instanceof Colinfo && ((Colinfo)rec).getColFirst() > cf) {
            rec = (BiffRec)sr.get(--recpos);
        }
        this.getStreamer().addRecordAt(ci, ++recpos);
        return ci;
    }

    @Override
    public Colinfo getColinfo(String c) {
        return this.getColInfo(ExcelTools.getIntVal(c));
    }

    @Override
    public Collection<Colinfo> getColinfos() {
        return Collections.unmodifiableCollection(this.colinfos.values());
    }

    public void moveCell(String startaddr, String endaddr) {
        BiffRec c = this.getCell(startaddr);
        if (c.getOpcode() == 638) {
            try {
                Double d = new Double(c.getDblVal());
                this.removeCell(c);
                this.addValue(d, endaddr);
            }
            catch (Exception e) {
                Logger.logInfo("Boundsheet.moveCell() error :" + e);
            }
        } else {
            int[] s = ExcelTools.getRowColFromString(endaddr);
            c.setCol((short)s[1]);
            c.setRowNumber(s[0]);
            this.removeCell(startaddr);
            this.addCell((CellRec)c);
        }
    }

    public void updateCellReferences(BiffRec c, String endaddr) {
        if (c.getOpcode() == 638) {
            try {
                Double d = new Double(c.getDblVal());
                this.removeCell(c);
                this.addValue(d, endaddr);
            }
            catch (Exception e) {
                Logger.logInfo("Boundsheet.moveCell() error :" + e);
            }
        } else {
            int[] s = ExcelTools.getRowColFromString(endaddr);
            c.setCol((short)s[1]);
            c.setRowNumber(s[0]);
            this.addCell((CellRec)c);
        }
    }

    @Override
    @Deprecated
    public BiffRec getCell(String address) {
        int[] rc = ExcelTools.getRowColFromString(address);
        try {
            return this.getCell(rc[0], rc[1]);
        }
        catch (CellNotFoundException ex) {
            return null;
        }
    }

    @Override
    public BiffRec getCell(int row, int col) throws CellNotFoundException {
        BiffRec theCell = (BiffRec)this.cellsByRow.get(new CellAddressible.Reference(row, col));
        if (theCell == null) {
            throw new CellNotFoundException(this.sheetname, row, col);
        }
        if (theCell != null && theCell.getOpcode() == 190) {
            ((Mulblank)theCell).setCurrentCell((short)col);
        }
        return theCell;
    }

    @Override
    public BiffRec[] getCells() {
        Collection<BiffRec> cells = this.cellsByRow.values();
        return cells.toArray(new BiffRec[cells.size()]);
    }

    @Override
    public void addMergedCellsRec(Mergedcells r2) {
        this.mc.add(r2);
    }

    private ArrayList getBuiltInNames() {
        ArrayList<Name> retlist = new ArrayList<Name>();
        Name[] ns = this.getWorkBook().getNames();
        int i = 0;
        while (i < ns.length) {
            if (ns[i].isBuiltIn() && (ns[i].getIxals() == this.getSheetNum() + 1 || ns[i].getItab() == this.getSheetNum() + 1)) {
                retlist.add(ns[i]);
            }
            ++i;
        }
        return retlist;
    }

    protected Name getPrintAreaNameRec(byte type) {
        ArrayList names = this.getBuiltInNames();
        int i = 0;
        while (i < names.size()) {
            Name n = (Name)names.get(i);
            if (n.getBuiltInType() == type) {
                return n;
            }
            ++i;
        }
        return null;
    }

    protected Name getPrintAreaNameRec() {
        return this.getPrintAreaNameRec((byte)6);
    }

    public String getPrintArea() {
        Name n = this.getPrintAreaNameRec();
        if (n != null) {
            String ret = "";
            Stack s = n.getExpression();
            int x = 0;
            while (x < s.size()) {
                Ptg p = (Ptg)s.get(x);
                ret = String.valueOf(ret) + p.toString();
                ++x;
            }
            return ret;
        }
        return null;
    }

    public String getPrintTitles() {
        Stack s;
        int x;
        Name n = this.getPrintAreaNameRec((byte)7);
        if (n != null && (x = 0) < (s = n.getExpression()).size()) {
            Ptg p = (Ptg)s.get(x);
            return p.toString();
        }
        return null;
    }

    public void setPrintArea(String range) {
        this.setPrintArea(range, (byte)6);
    }

    public void setPrintTitles(String range) {
        this.setPrintArea(range, (byte)7);
    }

    private void addFilterDatabase() {
        ArrayList names = this.getBuiltInNames();
        Name n = null;
        int i = 0;
        while (i < names.size() && n == null) {
            if (((Name)names.get(i)).getBuiltInType() == 13) {
                n = (Name)names.get(i);
            }
            ++i;
        }
        if (n == null) {
            try {
                n = new Name(this.getWorkBook(), "Built-in: _FILTER_DATABASE");
                n.setBuiltIn((byte)13);
                int xref = this.getWorkBook().getExternSheet(true).insertLocation(this.getSheetNum(), this.getSheetNum());
                n.setExternsheetRef(xref);
                n.updateSheetReferences(this);
                n.setSheet(this);
                n.setIxals((short)this.getSheetNum());
                n.setItab((short)(this.getSheetNum() + 1));
                String loc = ExcelTools.formatLocation(new int[]{this.getMinRow(), this.getMinCol(), this.getMaxRow() - 1, this.getMaxCol() - 1}, false, false);
                Stack<Ptg> s = new Stack<Ptg>();
                s.push(PtgRef.createPtgRefFromString(String.valueOf(this.getSheetName()) + "!" + loc, n));
                n.setExpression(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void removeFilterDatabase() {
        ArrayList names = this.getBuiltInNames();
        Name n = null;
        try {
            int i = 0;
            while (i < names.size() && n == null) {
                if (((Name)names.get(i)).getBuiltInType() == 13) {
                    n = (Name)names.get(i);
                    this.getWorkBook().removeName(n);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPrintArea(String printarea, byte type) {
        Name n;
        if (type != 7 && (n = this.getPrintAreaNameRec(type)) != null) {
            Stack s = n.getExpression();
            int x = 0;
            while (x < s.size()) {
                Ptg p = (Ptg)s.get(x);
                if (p instanceof PtgRef) {
                    Ptg ptg = PtgRef.createPtgRefFromString(printarea, n);
                    s.remove(x);
                    s.add(x, ptg);
                }
                ++x;
            }
            return;
        }
        try {
            String t = type == 6 ? "PRINT_AREA" : "PRINT_TITLES";
            Name n2 = new Name(this.getWorkBook(), "Built-in: " + t);
            n2.setBuiltIn(type);
            int xref = this.getWorkBook().getExternSheet(true).insertLocation(this.getSheetNum(), this.getSheetNum());
            n2.setExternsheetRef(xref);
            n2.updateSheetReferences(this);
            n2.setSheet(this);
            n2.setIxals((short)this.getSheetNum());
            n2.setItab((short)(this.getSheetNum() + 1));
            Stack<Ptg> s = new Stack<Ptg>();
            Ptg p = PtgRef.createPtgRefFromString(printarea, n2);
            s.push(p);
            n2.setExpression(s);
        }
        catch (Exception e) {
            Logger.logErr("Error setting print area in boundsheet: " + e);
        }
    }

    public ArrayList getNotes() {
        ArrayList notes = new ArrayList();
        int idx = this.getIndexOf((short)28);
        while (idx > -1) {
            notes.add(this.SheetRecs.get(idx++));
            if (((BiffRec)this.SheetRecs.get(idx)).getOpcode() != 28) break;
        }
        return notes;
    }

    @Override
    public Mergedcells getMergedCellsRec() {
        if (this.mc.size() == 0) {
            return null;
        }
        return (Mergedcells)this.getMergedCellsRecs().get(this.getMergedCellsRecs().size() - 1);
    }

    @Override
    public List getMergedCellsRecs() {
        return this.mc;
    }

    public Mergedcells addMergedCellRec() {
        Mergedcells mec = (Mergedcells)Mergedcells.getPrototype();
        mec.setSheet(this);
        this.getStreamer().addRecordAt(mec, this.getSheetRecs().size() - 1);
        this.addMergedCellsRec(mec);
        return mec;
    }

    public List getMergedCells() {
        return this.mc;
    }

    public boolean hasMergedCells() {
        return this.mc.size() > 0;
    }

    @Override
    public String getSheetName() {
        return this.sheetname;
    }

    @Override
    public String toString() {
        return this.getSheetName();
    }

    @Override
    public void init() {
        super.init();
        int lt = ByteTools.readInt(this.getByteAt(0), this.getByteAt(1), this.getByteAt(2), this.getByteAt(3));
        this.lbPlyPos = lt;
        this.grbit = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        if (this.DEBUGLEVEL > 9) {
            Logger.logInfo("Sheet grbit: " + this.grbit);
            Logger.logInfo(" lbplypos: " + this.lbPlyPos);
        }
        this.cch = this.getByteAt(6);
        this.grbitChr = this.getByteAt(7);
        byte[] namebytes = this.getBytesAt(8, this.getLength() - 12);
        try {
            this.sheetname = this.grbitChr == 1 ? new String(namebytes, "UTF-16LE") : new String(namebytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("Boundsheet.init() Unsupported Encoding error: " + e);
        }
        if (this.DEBUGLEVEL > 9) {
            Logger.logInfo("Sheet name: " + this.sheetname);
        }
        this.ooxmlObjects = new ArrayList();
    }

    @Override
    public void setSheetName(String newname) {
        this.cch = (byte)newname.length();
        byte[] namebytes = newname.getBytes();
        this.grbitChr = !ByteTools.isUnicode(newname) ? (byte)0 : 1;
        try {
            namebytes = this.grbitChr == 1 ? newname.getBytes("UTF-16LE") : newname.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            namebytes = newname.getBytes();
            Logger.logWarn("UnsupportedEncodingException in setting sheet name: " + e + " falling back to system default.");
        }
        byte[] newdata = new byte[namebytes.length + 8];
        if (this.data == null) {
            this.data = newdata;
        } else {
            System.arraycopy(this.getData(), 0, newdata, 0, 8);
        }
        System.arraycopy(namebytes, 0, newdata, 8, namebytes.length);
        newdata[6] = this.cch;
        newdata[7] = this.grbitChr;
        this.setData(newdata);
        this.init();
    }

    @Override
    public byte[] getSheetBytes() throws IOException {
        this.setLocalRecs();
        ObjectOutputStream obs = null;
        byte[] b = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        obs = new ObjectOutputStream(baos);
        obs.writeObject(this);
        b = baos.toByteArray();
        return b;
    }

    @Override
    public void setLocalRecs() {
        this.localrecs = new CompatibleVector();
        List newSheetRecs = this.assembleSheetRecs();
        Iterator shtr = newSheetRecs.iterator();
        while (shtr.hasNext()) {
            try {
                XLSRecord x = (XLSRecord)shtr.next();
                x.getData();
                if (x instanceof Labelsst) {
                    ((Labelsst)x).initUnsharedString();
                }
                this.localrecs.add(x);
            }
            catch (Exception e) {
                Logger.logWarn("Setting Boundsheet records problem: " + e);
            }
        }
        this.charts.clear();
        Chart[] chts = this.getWorkBook().getCharts();
        int i = 0;
        while (i < chts.length) {
            if (chts[i].getSheet().equals(this)) {
                this.charts.add(chts[i]);
            }
            ++i;
        }
    }

    public List getCharts() {
        return this.charts;
    }

    @Override
    public short getSheetType() {
        return this.grbit;
    }

    @Override
    public String getSheetTypeString() {
        switch (this.grbit) {
            case 0: {
                return "Sheet or Dialog";
            }
            case 1: {
                return "XL4 Macro";
            }
            case 2: {
                return "Chart";
            }
            case 6: {
                return "VB Module";
            }
        }
        return null;
    }

    public void addChart(Chart c) {
        this.charts.add(c);
    }

    public Chart addChart(byte[] inbytes, short[] coords) {
        return this.addChart(inbytes, "useDefault", coords);
    }

    @Override
    public Chart addChart(byte[] inbytes, String NewChartName, short[] coords) {
        Chart destChart = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(inbytes);
            BufferedInputStream bufstr = new BufferedInputStream(bais);
            ObjectInputStream o = new ObjectInputStream(bufstr);
            destChart = (Chart)o.readObject();
        }
        catch (Exception e) {
            Logger.logInfo("Boundsheet.addChart() failed:" + e);
        }
        if (destChart != null) {
            if (!NewChartName.equals("useDefault")) {
                destChart.setTitle(NewChartName);
            }
            destChart.setSheet(this);
            short[] origCoords = destChart.getCoords();
            coords[0] = origCoords[0];
            coords[1] = origCoords[1];
            destChart.setCoords(coords);
            destChart.setId(this.lastObjId + 1);
            HashMap localFonts = null;
            if (this.getTransferFonts() != null && this.getTransferFonts().size() > 0) {
                localFonts = (HashMap)this.getWorkBook().getFontRecsAsXML();
            }
            List recs = destChart.getXLSrecs();
            int i = 0;
            while (i < recs.size()) {
                XLSRecord rec = (XLSRecord)recs.get(i);
                rec.setWorkBook(this.wkbook);
                rec.setSheet(this);
                if (rec.getOpcode() == 236) {
                    this.wkbook.addChartUpdateMsodg((MSODrawing)rec, this);
                } else {
                    int fid;
                    if (!(rec instanceof Bof)) {
                        rec.init();
                    }
                    if (rec instanceof Dimensions) {
                        destChart.setDimensions((Dimensions)rec);
                    }
                    if (rec instanceof FontBasis) {
                        fid = ((FontBasis)rec).getFontIndex();
                        fid = this.translateFontIndex(fid, localFonts);
                        ((FontBasis)rec).setFontIndex(fid);
                    }
                    if (rec instanceof Fontx) {
                        fid = ((Fontx)rec).getIfnt();
                        if (fid > 0) {
                            fid = this.translateFontIndex(fid, localFonts);
                        }
                        ((Fontx)rec).setIfnt(fid);
                    }
                    try {
                        ((GenericChartObject)rec).setParentChart(destChart);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            this.wkbook.getChartVect().add(destChart);
        }
        this.charts.add(destChart);
        return destChart;
    }

    int translateFontIndex(int fid, HashMap localFonts) {
        if (this.transferFonts != null && fid - 1 < this.transferFonts.size()) {
            Font thisFont = (Font)this.transferFonts.get(fid - 1);
            String xmlFont = "<FONT><" + thisFont.getXML() + "/></FONT>";
            Object fontNum = localFonts.get(xmlFont);
            if (fontNum != null) {
                fid = (Integer)fontNum;
            } else {
                fid = this.getWorkBook().insertFont(thisFont) + 1;
                localFonts.put(xmlFont, fid);
            }
        }
        if (fid > this.getWorkBook().getNumFonts()) {
            fid = 0;
        }
        return fid;
    }

    public void populateForTransfer() {
        XLSRecord x;
        this.getSheetHash();
        BiffRec[] recs = this.getCells();
        int i = 0;
        while (i < recs.length) {
            if (recs[i].getOpcode() == 253) {
                Labelsst mylabel = (Labelsst)recs[i];
                mylabel.initUnsharedString();
            }
            ++i;
        }
        this.transferXfs = this.getWorkBook().getXfrecs();
        i = 0;
        while (i < this.transferXfs.size()) {
            x = (Xf)this.transferXfs.get(i);
            ((Xf)x).populateForTransfer();
            ++i;
        }
        this.transferFonts = this.getWorkBook().getFontRecs();
        i = 0;
        while (i < this.transferFonts.size()) {
            x = (Font)this.transferFonts.get(i);
            x.getData();
            ++i;
        }
    }

    protected List getTransferXfs() {
        return this.transferXfs;
    }

    protected List getTransferFonts() {
        return this.transferFonts;
    }

    @Override
    public Guts getGuts() {
        return this.guts;
    }

    @Override
    public void setGuts(Guts g) {
        this.guts = g;
    }

    @Override
    public void setWsBool(WsBool ws) {
        this.wsbool = ws;
    }

    @Override
    public WsBool getWsBool() {
        return this.wsbool;
    }

    @Override
    public List getLocalRecs() {
        return this.localrecs;
    }

    public void setLocalRecs(FastAddVector l) {
        this.localrecs = l;
    }

    public void setSheetRecs(AbstractList shtRecs) {
        this.SheetRecs = shtRecs;
    }

    @Override
    public byte getGrbitChr() {
        return this.grbitChr;
    }

    @Override
    public void setGrbitChr(byte gb) {
        this.grbitChr = gb;
    }

    public Selection getLastselection() {
        return this.lastselection;
    }

    public void setLastselection(Selection lastselection) {
        this.lastselection = lastselection;
    }

    public void setFastCellAdds(boolean fastCellAdds) {
        this.fastCellAdds = fastCellAdds;
    }

    public Scl getScl() {
        if (this.scl == null) {
            this.scl = new Scl();
            this.SheetRecs.add(this.getIndexOfWindow2(), this.scl);
            this.scl.setSheet(this);
        }
        return this.scl;
    }

    public void setScl(Scl s) {
        this.scl = s;
    }

    public void setShiftRule(boolean bShiftInclusive) {
        this.formulaShiftInclusive = bShiftInclusive;
    }

    public boolean isShiftInclusive() {
        return this.formulaShiftInclusive;
    }

    public PrinterSettingsHandle getPrinterSetupHandle() {
        return new PrinterSettingsHandle(this);
    }

    public List getPrintRecs() {
        return Collections.unmodifiableList(this.printRecs);
    }

    public void addPrintRec(BiffRec record) {
        if (this.printRecs == null) {
            this.printRecs = new ArrayList();
        }
        this.printRecs.add(record);
    }

    public List getAutoFilters() {
        return this.autoFilters;
    }

    public Note createNote(String address, String txt, String author) {
        ArrayList notes = this.getNotes();
        if (address.indexOf(33) == -1) {
            address = String.valueOf(this.getSheetName()) + "!" + address;
        }
        int i = 0;
        while (i < notes.size()) {
            Note n = (Note)notes.get(i);
            if (n.getCellAddressWithSheet().equals(address)) {
                n.setText(txt);
                n.setAuthor(author);
                return n;
            }
            ++i;
        }
        int[] coords = ExcelTools.getRowColFromString(address);
        int insertIndex = this.insertMSOObjectsForNote(coords);
        Txo t = (Txo)Txo.getPrototype();
        t.setSheet(this);
        this.SheetRecs.add(insertIndex++, t);
        this.SheetRecs.add(insertIndex++, t.text);
        t.text.setPredecessor(t);
        Continue c = Continue.getBasicFormattingRunContinues();
        c.setPredecessor(t);
        c.setSheet(this);
        this.SheetRecs.add(insertIndex++, c);
        try {
            t.setStringVal(txt);
        }
        catch (IllegalArgumentException e) {
            Logger.logErr(e.toString());
        }
        insertIndex = this.getIndexOf((short)574);
        Note n = (Note)Note.getPrototype(author);
        n.setId(this.lastObjId);
        n.setSheet(this);
        n.setRowCol(coords[0], coords[1]);
        this.SheetRecs.add(insertIndex, n);
        return n;
    }

    private int insertMSOObjectsForNote(int[] coords) {
        int insertIndex;
        MSODrawingGroup msodg = this.wkbook.getMSODrawingGroup();
        if (msodg == null) {
            msodg = this.wkbook.createMSODrawingGroup();
            msodg.initNewMSODrawingGroup();
        }
        if ((insertIndex = this.getIndexOf((short)28)) == -1) {
            insertIndex = this.getIndexOf((short)574);
        }
        while (insertIndex - 1 > 0) {
            short opc = ((BiffRec)this.SheetRecs.get(insertIndex - 1)).getOpcode();
            if (opc == 236 || opc == 60) {
                MSODrawing rec;
                if (opc == 236) {
                    rec = (MSODrawing)this.SheetRecs.get(insertIndex - 1);
                } else {
                    rec = ((Continue)this.SheetRecs.get((int)(insertIndex - 1))).maskedMso;
                    if (rec == null) break;
                }
                if (rec.getSOLVERContainerLength() == 0) {
                    break;
                }
            } else if (opc == 93 || opc == 60 || opc == 512 || opc == 2150 || opc == 450) break;
            --insertIndex;
        }
        MSODrawing msoheader = msodg.getMsoHeaderRec(this);
        MSODrawing msoDrawing = (MSODrawing)MSODrawing.getPrototype();
        msoDrawing.setSheet(this);
        msoDrawing.setWorkBook(this.getWorkBook());
        if (msoheader == null) {
            msoDrawing.setIsHeader();
            msoheader = msoDrawing;
        }
        msoDrawing.createCommentBox(coords[0], coords[1]);
        this.SheetRecs.add(insertIndex++, msoDrawing);
        ++msoheader.numShapes;
        msodg.addMsodrawingrec(msoDrawing);
        Obj obj = Obj.getBasicObjRecord(25, ++this.lastObjId);
        this.SheetRecs.add(insertIndex++, obj);
        msoDrawing = (MSODrawing)MSODrawing.getTextBoxPrototype();
        msoDrawing.setSheet(this);
        this.SheetRecs.add(insertIndex++, msoDrawing);
        msodg.addMsodrawingrec(msoDrawing);
        this.wkbook.updateMsodrawingHeaderRec(this);
        msodg.setSpidMax(this.wkbook.lastSPID + 1);
        msodg.updateRecord();
        msodg.dirtyflag = true;
        return insertIndex;
    }

    public int insertDropDownBox(int colNum) {
        int insertIndex;
        MSODrawingGroup msodg = this.wkbook.getMSODrawingGroup();
        if (msodg == null) {
            msodg = this.wkbook.createMSODrawingGroup();
            msodg.initNewMSODrawingGroup();
        }
        if ((insertIndex = this.getIndexOf((short)28)) == -1) {
            insertIndex = this.getIndexOf((short)574);
        }
        while (insertIndex - 1 > 0) {
            XLSRecord rec;
            short opc = ((BiffRec)this.SheetRecs.get(insertIndex - 1)).getOpcode();
            if (opc == 236 || opc == 60) {
                if (opc == 236) {
                    rec = (MSODrawing)this.SheetRecs.get(insertIndex - 1);
                } else {
                    rec = ((Continue)this.SheetRecs.get((int)(insertIndex - 1))).maskedMso;
                    if (rec == null) break;
                }
                if (((MSODrawing)rec).getSOLVERContainerLength() == 0) {
                    break;
                }
            } else {
                if (opc == 93) {
                    rec = (Obj)this.SheetRecs.get(insertIndex - 1);
                    if (((Obj)rec).getObjType() != 20) break;
                    return ((Obj)rec).getObjId();
                }
                if (opc == 93 || opc == 60 || opc == 512 || opc == 2150 || opc == 450) break;
            }
            --insertIndex;
        }
        MSODrawing msoheader = msodg.getMsoHeaderRec(this);
        MSODrawing msoDrawing = (MSODrawing)MSODrawing.getPrototype();
        msoDrawing.setSheet(this);
        msoDrawing.setWorkBook(this.getWorkBook());
        if (msoheader == null) {
            msoDrawing.setIsHeader();
            msoheader = msoDrawing;
        }
        msoDrawing.createDropDownListStyle(colNum);
        Obj obj = Obj.getBasicObjRecord(20, ++this.lastObjId);
        int objID = obj.getObjId();
        this.SheetRecs.add(insertIndex++, msoDrawing);
        this.SheetRecs.add(insertIndex++, obj);
        ++msoheader.numShapes;
        msodg.addMsodrawingrec(msoDrawing);
        this.wkbook.updateMsodrawingHeaderRec(this);
        msodg.setSpidMax(this.wkbook.lastSPID + 1);
        msodg.updateRecord();
        msodg.dirtyflag = true;
        return objID;
    }

    public Note createNote(String address, Unicodestring txt, String author) {
        Note nh = this.createNote(address, txt.getStringVal(), author);
        nh.setFormattingRuns(txt.getFormattingRuns());
        return nh;
    }

    /*
     * Unable to fully structure code
     */
    public void removeNote(Note n) {
        id = n.getId();
        idx = this.getIndexOf((short)93);
        if (idx != -1) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            if (((BiffRec)this.SheetRecs.get(idx)).getOpcode() == 93 && (o = (Obj)this.SheetRecs.get(idx)).getObjType() == 25 && o.getObjId() == id) {
                if (((BiffRec)this.SheetRecs.get(idx - 1)).getOpcode() == 236) {
                    --idx;
                    break;
                }
                if (((BiffRec)this.SheetRecs.get(idx + 1)).getOpcode() == 60 && ((Continue)this.SheetRecs.get((int)(idx + 1))).maskedMso != null) break;
            }
            ++idx;
lbl11:
            // 2 sources

            ** while (idx < this.SheetRecs.size())
        }
lbl12:
        // 3 sources

        objidx = 0;
        msoidx = 0;
        maskedMso = true;
        while (idx < this.SheetRecs.size()) {
            mso = null;
            rec = (BiffRec)this.SheetRecs.get(idx);
            if (rec.getOpcode() == 93) {
                ++objidx;
            } else if (rec.getOpcode() == 236) {
                mso = (MSODrawing)rec;
                maskedMso = false;
                if (mso.getShapeType() == 202) {
                    ++msoidx;
                } else if (((MSODrawing)rec).isShape) {
                    break;
                }
            } else if (rec.getOpcode() == 60 && maskedMso) {
                mso = ((Continue)rec).maskedMso;
                if (mso.getShapeType() == 202) {
                    ++msoidx;
                } else if (((MSODrawing)rec).isShape) {
                    break;
                }
            } else if (rec.getOpcode() == 28) break;
            if (objidx > 1 || msoidx > 1) break;
            this.SheetRecs.remove(idx);
            if (mso == null || !mso.isShape) continue;
            msodg = this.wkbook.getMSODrawingGroup();
            msodg.removeMsodrawingrec(mso, this, true);
        }
        idx = this.getIndexOf((short)28);
        while (idx < this.SheetRecs.size() && ((BiffRec)this.SheetRecs.get(idx)).getOpcode() == 28) {
            if (((Note)this.SheetRecs.get(idx)).equals(n)) {
                this.SheetRecs.remove(idx);
                break;
            }
            ++idx;
        }
    }

    /*
     * Unable to fully structure code
     */
    public AutoFilter addAutoFilter(int column) {
        block9: {
            block10: {
                if (this.autoFilters != null && this.autoFilters.size() != 0) break block9;
                this.addFilterDatabase();
                zz = this.getIndexOf((short)125);
                if (zz != -1) ** GOTO lbl8
                zz = this.getIndexOf((short)85) + 1;
                break block10;
lbl-1000:
                // 1 sources

                {
                    ++zz;
lbl8:
                    // 2 sources

                    ** while (((BiffRec)this.SheetRecs.get((int)zz)).getOpcode() == 125)
                }
            }
            rec = new XLSRecord();
            rec.setOpcode((short)155);
            rec.setData(new byte[0]);
            this.SheetRecs.add(zz++, rec);
            rec = new XLSRecord();
            rec.setOpcode((short)157);
            v0 = new byte[2];
            v0[0] = (byte)this.getMaxCol();
            rec.setData(v0);
            this.SheetRecs.add(zz, rec);
            msodg = this.wkbook.getMSODrawingGroup();
            if (msodg != null) {
                insertIndex = this.getIndexOf((short)237);
                if (insertIndex < 0) {
                    insertIndex = this.getIndexOf((short)574);
                }
            } else {
                msodg = this.wkbook.createMSODrawingGroup();
                msodg.initNewMSODrawingGroup();
                insertIndex = this.getIndexOf((short)512) + 1;
            }
            msoheader = msodg.getMsoHeaderRec(this);
            i = 0;
            while (i < this.getRealMaxCol()) {
                try {
                    if (this.getCellsByCol(i).size() == 0) {
                    }
                }
                catch (CellNotFoundException e) {}
                break;
                j = (short)i;
                msoDrawing = (MSODrawing)MSODrawing.getPrototype();
                msoDrawing.setWorkBook(this.wkbook);
                msoDrawing.setSheet(this);
                if (msoheader == null) {
                    msoDrawing.setIsHeader();
                    msoheader = msoDrawing;
                }
                msoDrawing.createDropDownListStyle(j);
                obj = Obj.getBasicObjRecord(20, ++this.lastObjId);
                this.SheetRecs.add(insertIndex++, msoDrawing);
                this.SheetRecs.add(insertIndex++, obj);
                ++msoheader.numShapes;
                msodg.addMsodrawingrec(msoDrawing);
                this.wkbook.updateMsodrawingHeaderRec(this);
                msodg.setSpidMax(this.wkbook.lastSPID + 1);
                msodg.updateRecord();
                msodg.dirtyflag = true;
                ++i;
            }
        }
        af = (AutoFilter)AutoFilter.getPrototype();
        af.setSheet(this);
        af.setCol(column);
        i = this.getIndexOf((short)512);
        this.SheetRecs.add(i, af);
        this.autoFilters.add(af);
        return af;
    }

    public void removeAutoFilter() {
        this.removeFilterDatabase();
        int zz = this.getIndexOf((short)158);
        while (zz != -1) {
            this.SheetRecs.remove(zz);
            zz = this.getIndexOf((short)158);
        }
        zz = this.getIndexOf((short)155);
        if (zz > -1) {
            this.SheetRecs.remove(zz);
        }
        if ((zz = this.getIndexOf((short)157)) > -1) {
            this.SheetRecs.remove(zz);
        }
        this.autoFilters.clear();
        int i = 0;
        while (i < this.rows.size()) {
            this.rows.get(i).setHidden(false);
            ++i;
        }
    }

    public Sxview addPivotTable(String ref, WorkBookHandle wbh, int sId, String tablename) {
        this.wkbook.addPivotCache(ref, wbh, sId);
        int zz = this.win2.getRecordIndex() - 1;
        while (zz > 0) {
            if (((BiffRec)this.SheetRecs.get(zz)).getOpcode() == 28 || ((BiffRec)this.SheetRecs.get(zz)).getOpcode() == 93 || ((BiffRec)this.SheetRecs.get(zz)).getOpcode() == 512) break;
            --zz;
        }
        Sxview sx = (Sxview)Sxview.getPrototype();
        int n = ++zz;
        this.SheetRecs.add(n, sx);
        this.SheetRecs.addAll(++zz, sx.addInitialRecords(this));
        sx.setTableName(tablename);
        this.wkbook.addPivotTable(sx);
        return sx;
    }

    public void evaluateAutoFilters() {
        int i = 0;
        while (i < this.rows.size()) {
            try {
                this.rows.get(i).setHidden(false);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < this.autoFilters.size()) {
            ((AutoFilter)this.autoFilters.get(i)).evaluate();
            ++i;
        }
    }

    public List getOOXMLObjects() {
        return this.ooxmlObjects;
    }

    public void addOOXMLObject(Object o) {
        this.ooxmlObjects.add(o);
    }

    public boolean hasThickBottom() {
        return this.thickBottom;
    }

    public boolean hasThickTop() {
        return this.thickTop;
    }

    public boolean hasZeroHeight() {
        return this.zeroHeight;
    }

    public boolean hasCustomHeight() {
        return this.customHeight;
    }

    public double getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public float getDefaultColumnWidth() {
        if (this.defColWidth != null) {
            return this.defColWidth.getDefaultWidth();
        }
        return this.defaultColWidth;
    }

    public void setThickBottom(boolean b) {
        this.thickBottom = b;
    }

    public void setThickTop(boolean b) {
        this.thickTop = b;
    }

    public void setZeroHeight(boolean b) {
        this.zeroHeight = b;
    }

    public void setHasCustomHeight(boolean b) {
        this.customHeight = b;
    }

    public void setDefaultRowHeight(double h) {
        this.defaultRowHeight = h;
    }

    public void setDefaultColumnWidth(float w) {
        this.defaultColWidth = w;
        if (this.defColWidth != null) {
            this.defColWidth.setDefaultColWidth((int)w);
        }
    }

    public void addOOXMLShape(TwoCellAnchor tca) {
        if (this.ooxmlShapes == null) {
            this.ooxmlShapes = new HashMap();
        }
        this.ooxmlShapes.put(tca.getName(), tca);
    }

    public void addOOXMLShape(OneCellAnchor oca) {
        if (this.ooxmlShapes == null) {
            this.ooxmlShapes = new HashMap();
        }
        this.ooxmlShapes.put(oca.getName(), oca);
    }

    public void addOOXMLShape(Object vml) {
        if (this.ooxmlShapes == null) {
            this.ooxmlShapes = new HashMap();
        }
        this.ooxmlShapes.put("vml", vml);
    }

    public HashMap getOOXMLShapes() {
        return this.ooxmlShapes;
    }

    public SheetView getSheetView() {
        return this.sheetview;
    }

    public void setSheetView(SheetView s) {
        this.sheetview = s;
    }

    public SheetPr getSheetPr() {
        return this.sheetPr;
    }

    public void setSheetPr(SheetPr s) {
        this.sheetPr = s;
    }

    public com.extentech.formats.OOXML.AutoFilter getOOAutoFilter() {
        return this.ooautofilter;
    }

    public void setOOAutoFilter(com.extentech.formats.OOXML.AutoFilter a) {
        this.ooautofilter = a;
    }

    public Name getScopedName(String nameRef) {
        Object o = this.sheetNameRecs.get(nameRef.toUpperCase());
        if (o == null) {
            return null;
        }
        return (Name)o;
    }

    public void addLocalName(Name name) {
        if (this.sheetNameRecs == null) {
            this.sheetNameRecs = new HashMap();
        }
        this.sheetNameRecs.put(name.getNameA(), name);
    }

    public void removeLocalName(Name name) {
        this.sheetNameRecs.remove(name.getNameA());
    }

    public Name getName(String name) {
        if (this.sheetNameRecs == null) {
            return null;
        }
        Object o = this.sheetNameRecs.get(name.toUpperCase());
        if (o != null) {
            return (Name)o;
        }
        return null;
    }

    public Name[] getAllNames() {
        if (this.sheetNameRecs == null) {
            this.sheetNameRecs = new HashMap();
        }
        ArrayList retnames = new ArrayList(this.sheetNameRecs.values());
        Name[] names = new Name[retnames.size()];
        return retnames.toArray(names);
    }

    public void addMarginRecord(BiffRec r2) {
        r2.setSheet(this);
        int i = this.getIndexOf((short)161);
        short thisOpCode = r2.getOpcode();
        while (i > 0) {
            short prevOpCode = ((BiffRec)this.getSheetRecs().get(--i)).getOpcode();
            if (prevOpCode == 132 || prevOpCode == 21 || prevOpCode == 38 || (prevOpCode == 41 || prevOpCode == 40 || prevOpCode == 39) && thisOpCode == 77 || (prevOpCode == 40 || prevOpCode == 39) && thisOpCode == 41 || prevOpCode == 39 && thisOpCode == 40) break;
        }
        this.SheetRecs.add(++i, r2);
    }

    private Row insertRow(int rownum, boolean shiftrows) {
        return this.insertRow(rownum, 0, shiftrows);
    }

    void parseOOXML(WorkBookHandle bk, WorkSheetHandle sheet, InputStream ii, ArrayList sst, ArrayList formulas, ArrayList hyperlinks, HashMap inlineStrs) throws XmlPullParserException, IOException {
        int sfindex = formulas.size();
        Row r2 = null;
        String cellAddr = null;
        int formatId = 0;
        String type = "";
        this.shExternalLinkInfo = new HashMap();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput(new InputStreamReader(ii));
        int eventType = xpp.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String tnm = xpp.getName();
                if (tnm.equals("sheetFormatPr")) {
                    int i = 0;
                    while (i < xpp.getAttributeCount()) {
                        String n = xpp.getAttributeName(i);
                        String v = xpp.getAttributeValue(i);
                        if (n.equals("thickBottom")) {
                            this.setThickBottom(true);
                        } else if (n.equals("thickTop")) {
                            this.setThickTop(true);
                        } else if (n.equals("zeroHeight")) {
                            this.setZeroHeight(v.equals("1"));
                        } else if (n.equals("customHeight")) {
                            this.setHasCustomHeight(v.equals("1"));
                        } else if (n.equals("defaultColWidth")) {
                            this.setDefaultColumnWidth(new Float(v).floatValue());
                        } else if (n.equals("defaultRowHeight")) {
                            this.setDefaultRowHeight(new Double(v));
                        }
                        ++i;
                    }
                } else if (tnm.equals("sheetView")) {
                    SheetView s = (SheetView)SheetView.parseOOXML(xpp).cloneElement();
                    this.setSheetView(s);
                    this.getWindow2().setShowGridlines(!s.getAttrS("showGridlines").equals("0"));
                    if (s.getAttr("showRowColHeaders") != null) {
                        this.getWindow2().setShowSheetHeaders(s.getAttrS("showRowColHeaders").equals("1"));
                    }
                    if (s.getAttr("showZeros") != null) {
                        this.getWindow2().setShowZeroValues(s.getAttrS("showZeros").equals("1"));
                    }
                    if (s.getAttr("showOutlineSymbols") != null) {
                        this.getWindow2().setShowOutlineSymbols(s.getAttrS("showOutlineSymbols").equals("1"));
                    }
                    if (s.getAttr("tabSelected") != null) {
                        this.setSelected(s.getAttrS("tabSelected").equals("1"));
                    }
                    if (s.getAttr("zoomScale") != null) {
                        this.getScl().setZoom(new Double(s.getAttrS("zoomScale")).floatValue() / 100.0f);
                    }
                } else if (tnm.equals("sheetPr")) {
                    SheetPr sp = (SheetPr)SheetPr.parseOOXML(xpp).cloneElement();
                    this.setSheetPr(sp);
                } else if (!tnm.equals("dimension")) {
                    if (tnm.equals("sheetProtection")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equals("password")) {
                                this.getProtectionManager().setPasswordHashed(v);
                            } else if (nm.equals("sheet")) {
                                this.getProtectionManager().setProtected(OOXMLReader.parseBoolean(v));
                            }
                            ++i;
                        }
                    } else if (tnm.equals("col")) {
                        int min = 0;
                        int max = 0;
                        int style = 0;
                        double width = 0.0;
                        boolean hidden = false;
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equals("min")) {
                                min = Integer.valueOf(v);
                            } else if (nm.equals("max")) {
                                max = Integer.valueOf(v);
                            } else if (nm.equals("width")) {
                                width = new Double(v);
                            } else if (nm.equals("hidden")) {
                                hidden = true;
                            } else if (nm.equals("style")) {
                                style = Integer.valueOf(v);
                            }
                            ++i;
                        }
                        if (max > 16384) {
                            max = 16383;
                        }
                        ColHandle col = sheet.addCol(min - 1, max - 1);
                        col.setWidth((int)(width * 256.0));
                        if (style > 0) {
                            col.setFormatId(style);
                        }
                        if (hidden) {
                            col.setHidden(true);
                        }
                    } else if (tnm.equals("row")) {
                        int ht = -1;
                        int ixfe = 0;
                        boolean customHeight = false;
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equals("r")) {
                                int rownum = Integer.valueOf(v) - 1;
                                r2 = this.insertRow(rownum, false);
                                r2.setIxfe(this.getWorkBook().getDefaultIxfe());
                            } else if (nm.equals("ht")) {
                                ht = (int)(new Double(v) * 20.0);
                            } else if (nm.equals("s")) {
                                ixfe = Integer.valueOf(v);
                            } else if (nm.equals("customFormat")) {
                                r2.setIxfe(ixfe);
                            } else if (nm.equals("hidden")) {
                                r2.setHidden(true);
                            } else if (nm.equals("collapsed")) {
                                boolean h = r2.isHidden();
                                r2.setCollapsed(true);
                                if (!h) {
                                    r2.setHidden(false);
                                }
                            } else if (nm.equals("outlineLevel")) {
                                r2.setOutlineLevel(Integer.valueOf(v));
                            } else if (nm.equals("customHeight")) {
                                customHeight = true;
                            } else if (nm.equals("thickBot")) {
                                r2.setHasAnyThickBottomBorder(true);
                            } else if (nm.equals("thickTop")) {
                                r2.setHasAnyThickTopBorder(true);
                            }
                            if (ht != -1 && customHeight) {
                                r2.setRowHeight(ht);
                            }
                            ++i;
                        }
                    } else if (tnm.equals("c")) {
                        if (cellAddr != null) {
                            if (r2.getExplicitFormatSet() || formatId != this.getWorkBook().getDefaultIxfe() && formatId != 0) {
                                int[] rc = ExcelTools.getRowColFromString(cellAddr);
                                OOXMLReader.sheetAdd(sheet, null, rc[0], rc[1], formatId);
                            }
                            cellAddr = null;
                        }
                        formatId = 0;
                        type = "n";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equals("r")) {
                                cellAddr = v;
                            } else if (nm.equals("s")) {
                                formatId = Integer.valueOf(v);
                            } else if (nm.equals("t")) {
                                type = v;
                            }
                            ++i;
                        }
                    } else if (tnm.equals("is")) {
                        if (inlineStrs == null) {
                            inlineStrs = new HashMap<String, String>();
                        }
                        String s = OOXMLReader.getInlineString(xpp);
                        inlineStrs.put(String.valueOf(this.getSheetName()) + "!" + cellAddr, s);
                        int[] rc = ExcelTools.getRowColFromString(cellAddr);
                        OOXMLReader.sheetAdd(sheet, "", rc[0], rc[1], formatId);
                        cellAddr = null;
                    } else if (tnm.equals("f")) {
                        if (cellAddr != null) {
                            String ftype = type;
                            String ref = "";
                            String si = "";
                            String ca = null;
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                String nm = xpp.getAttributeName(i);
                                String v = xpp.getAttributeValue(i);
                                if (nm.equals("t")) {
                                    ftype = String.valueOf(ftype) + "/" + v;
                                } else if (nm.equals("ref")) {
                                    ref = v;
                                } else if (nm.equals("si")) {
                                    si = String.valueOf(Integer.parseInt(v) + sfindex);
                                } else if (nm.equals("ca")) {
                                    ca = "1";
                                }
                                ++i;
                            }
                            String v = OOXMLReader.getNextText(xpp);
                            formulas.add(new String[]{this.getSheetName(), cellAddr, "=" + v, si, ref, ftype, ca, Integer.valueOf(formatId).toString(), ""});
                            type = "f";
                        }
                    } else if (tnm.equals("v")) {
                        if (cellAddr != null) {
                            block147: {
                                String v = OOXMLAdapter.getNextText(xpp);
                                int[] rc = ExcelTools.getRowColFromString(cellAddr);
                                if (type.equals("s")) {
                                    Labelsst labl = Labelsst.getPrototype(null, bk.getWorkBook());
                                    labl.setIsst(Integer.valueOf(v));
                                    labl.setIxfe(formatId);
                                    this.addRecord(labl, rc);
                                } else if (type.equals("n")) {
                                    try {
                                        if (!v.equals("null")) {
                                            OOXMLReader.sheetAdd(sheet, Integer.valueOf(v), rc[0], rc[1], formatId);
                                            break block147;
                                        }
                                        Logger.logWarn("OOXMLAdapter.parse: Unexpected null encountered at: " + cellAddr);
                                    }
                                    catch (NumberFormatException n) {
                                        try {
                                            OOXMLReader.sheetAdd(sheet, new Double(v), rc[0], rc[1], formatId);
                                        }
                                        catch (NumberFormatException nn) {
                                            OOXMLReader.sheetAdd(sheet, new Float(v), rc[0], rc[1], formatId);
                                        }
                                    }
                                } else if (type.equals("b")) {
                                    boolean trx = v.equals("1") || v.equalsIgnoreCase("true");
                                    OOXMLReader.sheetAdd(sheet, trx, rc[0], rc[1], formatId);
                                } else if (type.equals("f")) {
                                    String[] s = (String[])formulas.get(formulas.size() - 1);
                                    s[8] = v;
                                    formulas.set(formulas.size() - 1, s);
                                } else if (!type.equals("e")) {
                                    OOXMLReader.sheetAdd(sheet, v, rc[0], rc[1], formatId);
                                }
                            }
                            cellAddr = null;
                        }
                    } else if (tnm.equals("mergeCell")) {
                        String ref = xpp.getAttributeValue(0);
                        try {
                            CellRange cr = new CellRange(String.valueOf(this.getSheetName()) + "!" + ref, bk);
                            cr.mergeCells(false);
                        }
                        catch (CellNotFoundException cr) {}
                    } else if (tnm.equals("conditionalFormatting")) {
                        Condfmt.parseOOXML(xpp, bk, this);
                    } else if (tnm.equals("dataValidations")) {
                        Dval.parseOOXML(xpp, this);
                    } else if (tnm.equals("autoFilter")) {
                        this.setOOAutoFilter((com.extentech.formats.OOXML.AutoFilter)com.extentech.formats.OOXML.AutoFilter.parseOOXML(xpp));
                    } else if (tnm.equals("hyperlink")) {
                        String ref = "";
                        String rid = "";
                        String desc = "";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            if (xpp.getAttributeName(i).equals("ref")) {
                                ref = xpp.getAttributeValue(i);
                            } else if (xpp.getAttributeName(i).equals("id")) {
                                rid = xpp.getAttributeValue(i);
                            } else if (xpp.getAttributeName(i).equals("display")) {
                                desc = xpp.getAttributeValue(i);
                            }
                            ++i;
                        }
                        hyperlinks.add(new String[]{rid, ref, desc});
                    } else if (tnm.equals("pageSetup")) {
                        Boundsheet.addExternalInfo(this.shExternalLinkInfo, xpp);
                    } else if (tnm.equals("oleObject")) {
                        Boundsheet.addExternalInfo(this.shExternalLinkInfo, xpp);
                    } else if (tnm.equals("control")) {
                        Boundsheet.addExternalInfo(this.shExternalLinkInfo, xpp);
                    } else if (!tnm.equals("AlternateContent")) {
                        if (tnm.equals("Fallback")) {
                            OOXMLReader.getCurrentElement(xpp);
                        } else if (tnm.equals("controlPr")) {
                            OOXMLReader.getCurrentElement(xpp);
                        } else if (tnm.equals("extLst")) {
                            OOXMLReader.getCurrentElement(xpp);
                        }
                    }
                }
            } else if (eventType == 3) {
                String endTag = xpp.getName();
                if (endTag.equals("row") && cellAddr != null) {
                    int[] rc = ExcelTools.getRowColFromString(cellAddr);
                    if (r2.getExplicitFormatSet() || formatId != this.getWorkBook().getDefaultIxfe() && formatId != 0) {
                        OOXMLReader.sheetAdd(sheet, null, rc[0], rc[1], formatId);
                    }
                    cellAddr = null;
                } else if (endTag.equals("worksheet")) break;
            }
            eventType = xpp.next();
        }
    }

    protected static void addExternalInfo(Map<String, String> externalobjs, XmlPullParser xpp) {
        ArrayList<String> attrs = new ArrayList<String>();
        String rId = "";
        int i = 0;
        while (i < xpp.getAttributeCount()) {
            String n = xpp.getAttributeName(i);
            if (n.equals("id")) {
                rId = xpp.getAttributeValue(i);
            } else {
                attrs.add(String.valueOf(n) + "=\"" + xpp.getAttributeValue(i) + "\"");
            }
            ++i;
        }
        String s = Arrays.asList(attrs.toArray()).toString();
        if (s.length() > 2) {
            s = s.substring(1, s.length() - 1);
            s = StringTool.replaceText(s, ",", "");
        }
        externalobjs.put(rId, s);
    }

    protected void parseSheetElements(WorkBookHandle bk, ZipFile zip, ArrayList cl, String parentDir, String externalDir, ArrayList formulas, ArrayList hyperlinks, HashMap inlineStrs, HashMap<String, WorkSheetHandle> pivotTables) throws XmlPullParserException, CellNotFoundException {
        try {
            int i = 0;
            while (i < cl.size()) {
                ZipEntry target;
                String[] c = (String[])cl.get(i);
                String ooxmlElement = c[0];
                String p = StringTool.getPath(c[1]);
                p = OOXMLReader.parsePathForZip(p, parentDir);
                if (!ooxmlElement.equals("hyperlink")) {
                    c[1] = StringTool.stripPath(c[1]);
                }
                String f = c[1];
                String rId = c[2];
                if (ooxmlElement.equals("drawing")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + "_rels/" + f.substring(f.lastIndexOf("/") + 1) + ".rels");
                    ArrayList drawingFiles = null;
                    if (target != null) {
                        drawingFiles = OOXMLReader.parseRels(OOXMLReader.wrapInputStream(OOXMLReader.wrapInputStream(zip.getInputStream(target))));
                    }
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    this.parseDrawingXML(bk, drawingFiles, OOXMLReader.wrapInputStream(zip.getInputStream(target)), zip, p, externalDir);
                } else if (ooxmlElement.equals("vmldrawing")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    StringBuffer vml = this.parseLegacyDrawingXML(bk, OOXMLReader.wrapInputStream(zip.getInputStream(target)));
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + "_rels/" + f.substring(f.lastIndexOf("/") + 1) + ".rels");
                    if (target != null) {
                        String[] embeds = OOXMLReader.storeEmbeds(zip, target, p, externalDir);
                        this.addOOXMLShape(new Object[]{vml, embeds});
                    } else {
                        this.addOOXMLShape(vml);
                    }
                } else if (ooxmlElement.equals("hyperlink")) {
                    c = (String[])cl.get(i);
                    int j = 0;
                    while (j < hyperlinks.size()) {
                        if (rId.equals(((String[])hyperlinks.get(j))[0])) {
                            String[] h = (String[])hyperlinks.get(j);
                            try {
                                bk.getWorkSheet(this.getSheetName()).getCell(h[1]).setURL(rId, h[2], "");
                            }
                            catch (Exception e) {
                                Logger.logErr("OOXMLAdapter.parse: failed setting hyperlink to cell " + h[1] + ":" + e.toString());
                            }
                            break;
                        }
                        ++j;
                    }
                } else if (OOXMLReader.parsePivotTables && ooxmlElement.equals("pivotTable")) {
                    try {
                        pivotTables.put(String.valueOf(p) + f, bk.getWorkSheet(this.getSheetName()));
                    }
                    catch (WorkSheetNotFoundException j) {}
                } else if (ooxmlElement.equals("comments")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    this.parseCommentsXML(bk, OOXMLReader.wrapInputStream(zip.getInputStream(target)));
                } else if (ooxmlElement.equals("macro") || ooxmlElement.equals("activeX") || ooxmlElement.equals("table") || ooxmlElement.equals("vdependencies") || ooxmlElement.equals("oleObject") || ooxmlElement.equals("image") || ooxmlElement.equals("printerSettings")) {
                    String attrs = "";
                    if (this.shExternalLinkInfo != null && this.shExternalLinkInfo.get(rId) != null) {
                        attrs = this.shExternalLinkInfo.get(rId);
                    }
                    OOXMLReader.handleSheetPassThroughs(zip, bk, this, p, externalDir, c, attrs);
                } else {
                    Logger.logWarn("OOXMLAdapter.parse:  XLSX Option Not yet Implemented " + ooxmlElement);
                }
                ++i;
            }
        }
        catch (IOException e) {
            Logger.logErr("OOXMLAdapter.parse failed: " + e.toString());
        }
        this.shExternalLinkInfo = null;
    }

    void parseCommentsXML(WorkBookHandle bk, InputStream ii) {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            Stack<String> lastTag = new Stack<String>();
            ArrayList<String> authors = new ArrayList<String>();
            String addr = "";
            int authId = -1;
            Unicodestring comment = null;
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("author")) {
                        authors.add(OOXMLReader.getNextText(xpp));
                    } else if (tnm.equals("comment")) {
                        if (comment != null && !"".equals(addr)) {
                            this.createNote(addr, comment, (String)authors.get(authId));
                        }
                        addr = xpp.getAttributeValue("", "ref");
                        authId = Integer.valueOf(xpp.getAttributeValue("", "authorId"));
                        comment = null;
                    } else if (tnm.equals("text")) {
                        lastTag.push(tnm);
                        Text t = Text.parseOOXML(xpp, lastTag, bk);
                        comment = t.getCommentWithFormatting();
                    }
                }
                eventType = xpp.next();
            }
            if (!"".equals(comment) && !"".equals(addr)) {
                this.createNote(addr, comment, (String)authors.get(authId));
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.parseCommentsXML: " + e.toString());
        }
    }

    StringBuffer parseLegacyDrawingXML(WorkBookHandle bk, InputStream ii) {
        StringBuffer savedVml = new StringBuffer();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            FastAddVector nhs = new FastAddVector();
            CommentHandle[] anhs = bk.getWorkSheet(this.getSheetName()).getCommentHandles();
            int i = 0;
            while (i < anhs.length) {
                nhs.add(anhs[i]);
                ++i;
            }
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("shapelayout")) {
                        savedVml.append(OOXMLReader.getCurrentElement(xpp));
                    } else if (tnm.equals("shapetype")) {
                        if (!xpp.getAttributeValue("urn:schemas-microsoft-com:office:office", "spt").equals("202")) {
                            savedVml.append(OOXMLReader.getCurrentElement(xpp));
                        } else {
                            OOXMLReader.getCurrentElement(xpp);
                        }
                    } else if (tnm.equals("shape")) {
                        if (!xpp.getAttributeValue("", "type").endsWith("_x0000_t202")) {
                            savedVml.append(OOXMLReader.getCurrentElement(xpp));
                        } else {
                            int r2 = -1;
                            int c = -1;
                            boolean visible = false;
                            short[] bounds = new short[8];
                            while (eventType != 1) {
                                if (eventType == 2) {
                                    tnm = xpp.getName();
                                    if (tnm.equals("Row")) {
                                        r2 = Integer.valueOf(OOXMLReader.getNextText(xpp));
                                    } else if (tnm.equals("Column")) {
                                        c = Integer.valueOf(OOXMLReader.getNextText(xpp));
                                    } else if (tnm.equals("Visible")) {
                                        visible = true;
                                    } else if (tnm.equals("Anchor")) {
                                        String sbounds = OOXMLReader.getNextText(xpp);
                                        sbounds = sbounds.replaceAll("[^0-9,]+", "");
                                        String[] s = sbounds.split(",");
                                        int i2 = 0;
                                        while (i2 < 8) {
                                            bounds[i2] = Short.valueOf(s[i2]);
                                            ++i2;
                                        }
                                    }
                                } else if (eventType == 3 && xpp.getName().equals("shape")) break;
                                eventType = xpp.next();
                            }
                            String addr = ExcelTools.formatLocation(new int[]{r2, c});
                            int i3 = 0;
                            while (i3 < nhs.size()) {
                                CommentHandle nh = (CommentHandle)nhs.get(i3);
                                if (nh.getAddress().endsWith(addr)) {
                                    if (visible) {
                                        nh.show();
                                    }
                                    nh.setTextBoxBounds(bounds);
                                    nhs.remove(i3);
                                    break;
                                }
                                ++i3;
                            }
                        }
                    } else if (!tnm.equals("xml") && !tnm.equals("imagedata")) {
                        savedVml.append(OOXMLReader.getCurrentElement(xpp));
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.parseLegacyDrawingXML: " + e.toString());
        }
        return savedVml;
    }

    void parseDrawingXML(WorkBookHandle bk, ArrayList drawingFiles, InputStream ii, ZipFile zip, String parentDir, String externalDir) {
        try {
            Stack<String> lastTag = new Stack<String>();
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    ZipEntry chFile;
                    ChartHandle ch;
                    String name;
                    ImageHandle im;
                    BufferedInputStream is;
                    ZipEntry img;
                    String imgFile;
                    String s;
                    String tnm = xpp.getName();
                    if (tnm.equals("twoCellAnchor")) {
                        lastTag.push(tnm);
                        TwoCellAnchor t = (TwoCellAnchor)TwoCellAnchor.parseOOXML(xpp, lastTag, bk).cloneElement();
                        if (t.hasImage()) {
                            s = t.getEmbed();
                            if (s.indexOf("rId") == 0) {
                                imgFile = OOXMLReader.parsePathForZip(OOXMLReader.getFilename(drawingFiles, s), parentDir);
                                img = new ZipEntry(imgFile);
                                is = new BufferedInputStream(zip.getInputStream(img));
                                im = new ImageHandle((InputStream)is, this);
                                this.insertImage(im);
                                im.setName(t.getName());
                                im.setShapeName(t.getDescr());
                                im.setBounds(TwoCellAnchor.convertBoundsToBIFF8(this, t.getBounds()));
                                im.setSpPr(t.getSppr());
                                im.setEditMovement(t.getEditAs());
                                im.update();
                            }
                        } else if (t.hasChart()) {
                            s = t.getChartRId();
                            if (s.indexOf("rId") == 0) {
                                String chartfilename = OOXMLReader.getFilename(drawingFiles, s);
                                name = t.getName();
                                if (name == null || name.equals("null")) {
                                    name = "Untitled Chart";
                                }
                                ch = bk.createChart(name, bk.getWorkSheet(this.getSheetName()));
                                ch.setRelativeBounds(TwoCellAnchor.convertBoundsToBIFF8(this, t.getBounds()));
                                ch.setEditMovement(t.getEditAs());
                                ch.setOOXMLName(name);
                                chartfilename = OOXMLReader.parsePathForZip(chartfilename, parentDir);
                                chFile = new ZipEntry(chartfilename);
                                ch.resetFonts();
                                ch.removeLegend();
                                int ps = chartfilename.lastIndexOf("/") + 1;
                                ZipEntry rels = OOXMLReader.getEntry(zip, String.valueOf(chartfilename.substring(0, ps)) + "_rels/" + chartfilename.substring(ps) + ".rels");
                                if (rels != null) {
                                    ArrayList chartEmbeds = OOXMLReader.parseRels(OOXMLReader.wrapInputStream(zip.getInputStream(rels)));
                                    int i = 0;
                                    while (i < chartEmbeds.size()) {
                                        String parentp;
                                        String[] dr = (String[])chartEmbeds.get(i);
                                        if (dr[0].equals("userShape")) {
                                            dr[1] = dr[1].substring(dr[1].lastIndexOf("/") + 1);
                                            ch.addChartEmbed(new String[]{dr[0], String.valueOf(externalDir) + dr[1]});
                                            OOXMLReader.passThrough(zip, String.valueOf(parentDir) + dr[1], String.valueOf(externalDir) + dr[1]);
                                        } else if (dr[0].equals("image")) {
                                            parentp = OOXMLReader.parsePathForZip(dr[1], parentDir);
                                            parentp = parentp.substring(0, parentp.lastIndexOf("/") + 1);
                                            dr[1] = dr[1].substring(dr[1].lastIndexOf("/") + 1);
                                            ch.addChartEmbed(new String[]{dr[0], String.valueOf(externalDir) + dr[1]});
                                            OOXMLReader.passThrough(zip, String.valueOf(parentp) + dr[1], String.valueOf(externalDir) + dr[1]);
                                        } else if (dr[0].equals("themeOverride")) {
                                            parentp = OOXMLReader.parsePathForZip(dr[1], parentDir);
                                            parentp = parentp.substring(0, parentp.lastIndexOf("/") + 1);
                                            dr[1] = dr[1].substring(dr[1].lastIndexOf("/") + 1);
                                            ch.addChartEmbed(new String[]{dr[0], String.valueOf(externalDir) + dr[1]});
                                            ZipEntry target = OOXMLAdapter.getEntry(zip, String.valueOf(parentp) + dr[1]);
                                            bk.getWorkBook().getTheme().parseOOXML(bk, OOXMLAdapter.wrapInputStream(zip.getInputStream(target)));
                                        } else {
                                            Logger.logWarn("OOXMLAdapter.parseDrawingML: unknown chart embed " + dr[0]);
                                        }
                                        ++i;
                                    }
                                }
                                ch.parseOOXML(OOXMLReader.wrapInputStream(zip.getInputStream(chFile)));
                            }
                        } else if (t.hasShape()) {
                            this.addOOXMLShape(t);
                            if (t.getEmbed() != null) {
                                String imgFile2 = OOXMLReader.parsePathForZip(OOXMLReader.getFilename(drawingFiles, t.getEmbed()), parentDir);
                                t.setEmbedFilename(imgFile2);
                                OOXMLReader.passThrough(zip, imgFile2, String.valueOf(externalDir) + imgFile2);
                            }
                        } else {
                            Logger.logErr("OOXMLAdapter.parseDrawingXML: Unknown twoCellAnchor type");
                        }
                    } else if (tnm.equals("oneCellAnchor")) {
                        lastTag.push(tnm);
                        OneCellAnchor oca = (OneCellAnchor)OneCellAnchor.parseOOXML(xpp, lastTag, bk).cloneElement();
                        if (oca.hasImage()) {
                            s = oca.getEmbed();
                            if (s.indexOf("rId") == 0) {
                                imgFile = OOXMLReader.parsePathForZip(OOXMLReader.getFilename(drawingFiles, s), parentDir);
                                img = new ZipEntry(imgFile);
                                is = new BufferedInputStream(OOXMLReader.wrapInputStream(zip.getInputStream(img)));
                                im = new ImageHandle((InputStream)is, this);
                                this.insertImage(im);
                                im.setName(oca.getName());
                                im.setShapeName(oca.getDescr());
                                im.setBounds(oca.getBounds());
                                im.setSpPr(oca.getSppr());
                                im.update();
                            }
                        } else if (oca.hasChart()) {
                            s = oca.getEmbed();
                            if (s.indexOf("rId") == 0) {
                                String chart = OOXMLReader.getFilename(drawingFiles, s);
                                name = oca.getName();
                                if (name == null || name.equals("null")) {
                                    name = "Untitled Chart";
                                }
                                ch = bk.createChart(name, bk.getWorkSheet(this.getSheetName()));
                                ch.setRelativeBounds(oca.getBounds());
                                chart = OOXMLReader.parsePathForZip(chart, parentDir);
                                chFile = new ZipEntry(chart);
                                ch.parseOOXML(OOXMLReader.wrapInputStream(zip.getInputStream(chFile)));
                            }
                        } else if (oca.hasShape()) {
                            this.addOOXMLShape(oca);
                        } else {
                            Logger.logErr("OOXMLAdapter.parseDrawingXML: Unknown oneCellAnchor type");
                        }
                    } else if (tnm.equals("userShapes")) {
                        Logger.logErr("OOXMLAdapter.parseDrawingXML: USER SHAPE ENCOUNTERED");
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.parseDrawingXML: failed " + e.toString());
        }
    }

    @Override
    public void close() {
        XLSRecord r2;
        this.wkbook = null;
        for (Colinfo info : this.colinfos.values()) {
            if (info == null) continue;
            info.close();
        }
        this.colinfos.clear();
        Iterator<Integer> ii = this.rows.keySet().iterator();
        while (ii.hasNext()) {
            Row r3 = this.rows.get(ii.next());
            r3.close();
        }
        this.rows.clear();
        this.cellsByRow = new TreeMap<CellAddressible, BiffRec>(new CellAddressible.RowMajorComparator());
        this.cellsByCol = new TreeMap<CellAddressible, BiffRec>(new CellAddressible.ColumnMajorComparator());
        this.arrayformulas.clear();
        this.transferXfs.clear();
        this.transferFonts.clear();
        this.imageMap.clear();
        this.charts.clear();
        this.ooxmlObjects.clear();
        if (this.ooxmlShapes != null) {
            this.ooxmlShapes.clear();
        }
        this.ooautofilter = null;
        this.mc.clear();
        this.sheetview = null;
        this.sheetPr = null;
        if (this.lastselection != null) {
            this.lastselection.close();
            this.lastselection = null;
        }
        if (this.protector != null) {
            this.protector.close();
            this.protector = null;
        }
        if (this.sheetNameRecs != null) {
            ii = this.sheetNameRecs.keySet().iterator();
            while (ii.hasNext()) {
                Name n = (Name)this.sheetNameRecs.get(ii.next());
                n.close();
            }
            this.sheetNameRecs.clear();
        }
        int i = 0;
        while (i < this.cond_formats.size()) {
            Condfmt c = (Condfmt)this.cond_formats.get(i);
            c.close();
            ++i;
        }
        this.cond_formats.clear();
        i = 0;
        while (i < this.autoFilters.size()) {
            AutoFilter a = (AutoFilter)this.autoFilters.get(i);
            a.close();
            ++i;
        }
        this.autoFilters.clear();
        if (this.lastCell != null) {
            ((XLSRecord)this.lastCell).close();
            this.lastCell = null;
        }
        if (this.lastRow != null) {
            this.lastRow.close();
            this.lastRow = null;
        }
        if (this.win2 != null) {
            this.win2.close();
            this.win2 = null;
        }
        if (this.scl != null) {
            this.scl.close();
            this.scl = null;
        }
        if (this.pane != null) {
            this.pane.close();
            this.pane = null;
        }
        if (this.dval != null) {
            this.dval.close();
            this.dval = null;
        }
        if (this.hdr != null) {
            this.hdr.close();
            this.hdr = null;
        }
        if (this.ftr != null) {
            this.ftr.close();
            this.ftr = null;
        }
        if (this.wsbool != null) {
            this.wsbool.close();
            this.wsbool = null;
        }
        if (this.guts != null) {
            this.guts.close();
            this.guts = null;
        }
        if (this.dimensions != null) {
            this.dimensions.close();
            this.dimensions = null;
        }
        if (this.mybof != null) {
            this.mybof.close();
            this.mybof = null;
        }
        if (this.myeof != null) {
            this.myeof.close();
            this.myeof = null;
        }
        if (this.myidx != null) {
            this.myidx.close();
            this.myidx = null;
        }
        i = 0;
        while (i < this.printRecs.size()) {
            r2 = (XLSRecord)this.printRecs.get(i);
            r2.close();
            ++i;
        }
        this.printRecs.clear();
        int j = 0;
        while (j < this.SheetRecs.size()) {
            r2 = (XLSRecord)this.SheetRecs.get(j);
            r2.close();
            ++j;
        }
        this.SheetRecs.clear();
        if (this.localrecs != null) {
            this.localrecs.clear();
        }
    }

    public DefColWidth getDefColWidth() {
        return this.defColWidth;
    }

    public void setDefColWidth(DefColWidth defColWidth) {
        this.defColWidth = defColWidth;
    }

    private static enum NumberAsStringFormat {
        PERCENT("%", "0%"),
        EURO("\u20ac", "\u20ac#,##0;(\u20ac#,##0)"),
        YEN("\u00a5", "\u00a5#,##0;(\u00a5#,##0)"),
        POUND("\u00a3", "\u00a3#,##0;(\u00a3#,##0)"),
        DOLLAR("$", "$#,##0;(\u20ac#,##0)"),
        ALT_POUND("\u20a4", "\u20a4#,##0;(\u20a4#,##0)");

        private final String identifier;
        private final String pattern;

        private NumberAsStringFormat(String id, String format) {
            this.identifier = id;
            this.pattern = format;
        }

        public String identifier() {
            return this.identifier;
        }

        public String pattern() {
            return this.pattern;
        }

        public double adjustValue(double inputVal) {
            if (this.identifier == "%") {
                return inputVal * 0.01;
            }
            return inputVal;
        }
    }
}

