/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.Logger;

public final class Continue
extends XLSRecord {
    private static final long serialVersionUID = -6303887828816619839L;
    Boolean hasgrbit = null;
    MSODrawing maskedMso = null;
    public byte grbit = 0;
    private byte mygr;
    byte[] deldata = null;
    public BiffRec predecessor = null;
    public int grbitoff = 0;
    private int continue_offset = -1;
    boolean streaming = false;

    public void setHasGrbit(boolean b) {
        if (b && this.getEncryptedByteReader() == this.getByteReader()) {
            this.grbit = this.getByteAt(0);
        }
        this.hasgrbit = b;
    }

    boolean isBigRecContinue() {
        if (this.predecessor == null) {
            return true;
        }
        return this.predecessor.getLength() >= 8224;
    }

    boolean getHasGrbit() {
        if (this.hasgrbit != null) {
            return this.hasgrbit;
        }
        if (this.DEBUGLEVEL > 1) {
            StringBuilder stringBuilder = new StringBuilder("Grbit pos0: ");
            this.getGrbit();
            Logger.logInfo(stringBuilder.append(String.valueOf(0)).toString());
            Logger.logInfo("Grbit pos2: " + String.valueOf(this.getGrbit() & 4));
            Logger.logInfo("Grbit pos3: " + String.valueOf(this.getGrbit() & 8));
        }
        if ((this.getGrbit() & 8) != 0) {
            return true;
        }
        return this.getGrbit() < 2 && this.getGrbit() >= 0;
    }

    byte getGrbit() {
        if (this.data != null) {
            return this.data[0];
        }
        return super.getByteAt(0);
    }

    @Override
    public void init() {
        super.init();
        this.streaming = false;
        this.mygr = super.getByteAt(0);
        if (this.DEBUGLEVEL > 2) {
            Logger.logInfo(" init() GRBIT: " + String.valueOf(this.mygr));
        }
    }

    void setPredecessor(BiffRec pr) {
        this.predecessor = pr;
    }

    @Override
    public byte getByteAt(int off) {
        int s = off;
        int rpos = s + this.grbitoff;
        if (rpos < 0) {
            if (this.DEBUGLEVEL > 5) {
                Logger.logWarn("Continue pointer is: " + rpos);
            }
            rpos = 0;
        }
        return super.getByteAt(rpos -= this.continue_offset);
    }

    @Override
    public byte[] getData() {
        if (this.getHasGrbit() && !this.streaming) {
            super.getData();
            return this.getBytesAt(0, this.getLength() - 4);
        }
        this.streaming = false;
        return super.getData();
    }

    @Override
    public void preStream() {
        this.streaming = true;
    }

    public int getContinueOffset() {
        return this.continue_offset;
    }

    public void setContinueOffset(int i) {
        this.continue_offset = i;
    }

    public BiffRec getPredecessor() {
        return this.predecessor;
    }

    public static Continue getTextContinues(String txt) {
        Continue c = new Continue();
        c.setOpcode((short)60);
        byte[] data = new byte[txt.getBytes().length + 1];
        System.arraycopy(txt.getBytes(), 0, data, 1, data.length - 1);
        c.setData(data);
        c.init();
        return c;
    }

    public static Continue getBasicFormattingRunContinues() {
        Continue c = new Continue();
        c.setOpcode((short)60);
        c.setData(new byte[4]);
        c.init();
        return c;
    }
}

