/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import org.xmlpull.v1.XmlPullParser;

public final class Font
extends XLSRecord
implements FormatConstants {
    private static final long serialVersionUID = -398444997553403671L;
    private short grbit = (short)-1;
    private short cch = (short)-1;
    private short dyHeight = (short)-1;
    private short icv = (short)-1;
    private short bls = (short)-1;
    private short sss = (short)-1;
    private short uls = (short)-1;
    private short bFamily = (short)-1;
    private short bCharSet;
    private String fontName = "";
    private com.extentech.formats.OOXML.Color customColor = null;
    private boolean condensed;
    private boolean extended;
    static final int BITMASK_BOLD = 1;
    static final int BITMASK_ITALIC = 2;
    static final int BITMASK_UNDERLINED = 4;
    static final int BITMASK_STRIKEOUT = 8;
    static final int ANSI_CHARSET = 0;
    static final int DEFAULT_CHARSET = 1;
    static final int SYMBOL_CHARSET = 2;
    static final int SHIFTJIS_CHARSET = 128;
    static final int HANGEUL_CHARSET = 129;
    static final int HANGUL_CHARSET = 129;
    static final int GB2312_CHARSET = 134;
    static final int CHINESEBIG5_CHARSET = 136;
    static final int OEM_CHARSET = 255;
    static final int JOHAB_CHARSET = 130;
    static final int HEBREW_CHARSET = 177;
    static final int ARABIC_CHARSET = 178;
    static final int GREEK_CHARSET = 161;
    static final int TURKISH_CHARSET = 162;
    static final int VIETNAMESE_CHARSET = 163;
    static final int THAI_CHARSET = 222;
    static final int EASTEUROPE_CHARSET = 238;
    static final int RUSSIAN_CHARSET = 204;
    static final int MAC_CHARSET = 77;
    static final int BALTIC_CHARSET = 186;
    private int tableidx = -1;

    @Override
    public void init() {
        super.init();
        this.dyHeight = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.grbit = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.icv = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.bls = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.sss = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.uls = this.getByteAt(10);
        this.bFamily = this.getByteAt(11);
        this.bCharSet = (short)ByteTools.readUnsignedShort(this.getByteAt(12), (byte)0);
        int pos = 14;
        this.cch = this.getByteAt(pos++);
        int buflen = this.cch * 2;
        boolean compressed = false;
        if (buflen + ++pos >= this.getLength()) {
            buflen = this.getLength() - pos;
            compressed = true;
        }
        if (buflen < 0) {
            Logger.logWarn("could not parse font: length reported as " + buflen);
            return;
        }
        byte[] namebytes = this.getBytesAt(pos, buflen);
        if (!compressed) {
            pos = 0;
            try {
                this.fontName = new String(namebytes, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logErr("Font name decoding failed.", e);
            }
        } else {
            this.fontName = new String(namebytes);
        }
    }

    public boolean getStricken() {
        return (this.grbit & 8) == 8;
    }

    public void setStricken(boolean b) {
        if (b) {
            this.grbit = (short)(this.grbit | 8);
        } else {
            int grbittemp = this.grbit ^ 8;
            this.grbit = (short)(grbittemp & this.grbit);
        }
        this.setGrbit();
    }

    public boolean getItalic() {
        int isItalic = this.grbit & 2;
        return isItalic == 2;
    }

    public void setItalic(boolean b) {
        if (b) {
            this.grbit = (short)(this.grbit | 2);
        } else {
            int grbittemp = this.grbit ^ 2;
            this.grbit = (short)(grbittemp & this.grbit);
        }
        this.setGrbit();
    }

    public boolean getUnderlined() {
        return (this.grbit & 4) == 4;
    }

    public void setUnderlined(boolean b) {
        if (b) {
            this.grbit = (short)(this.grbit | 4);
        } else {
            int grbittemp = this.grbit ^ 4;
            this.grbit = (short)(grbittemp & this.grbit);
        }
        this.setGrbit();
        this.setUnderlineStyle((byte)1);
    }

    public boolean getBold() {
        return (this.grbit & 1) == 1;
    }

    public void setBold(boolean b) {
        if (this.data == null) {
            this.setData(this.getData());
        }
        if (b) {
            byte[] boldbytes = ByteTools.shortToLEBytes((short)700);
            System.arraycopy(boldbytes, 0, this.data, 6, 2);
            this.bls = (short)700;
            this.grbit = (short)(this.grbit | 1);
        } else {
            byte[] boldbytes = ByteTools.shortToLEBytes((short)400);
            System.arraycopy(boldbytes, 0, this.data, 6, 2);
            this.bls = (short)400;
            int grbittemp = this.grbit ^ 1;
            this.grbit = (short)(grbittemp & this.grbit);
        }
        this.setGrbit();
    }

    public void setGrbit() {
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        System.arraycopy(b, 0, data, 2, 2);
        this.setData(data);
    }

    public int getIdx() {
        return this.tableidx;
    }

    public void setIdx(int idx) {
        this.tableidx = idx;
    }

    @Override
    public void setWorkBook(WorkBook b) {
        super.setWorkBook(b);
        if (this.tableidx == -1) {
            this.tableidx = this.getWorkBook().addFont(this);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.fontName) + "," + this.bls + "," + this.dyHeight + " " + this.getColorAsColor() + " font style:[" + this.getBold() + this.getItalic() + this.getStricken() + this.getUnderlined() + this.getColor() + this.getUnderlineStyle() + "]";
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getUnderlineStyle() {
        return this.getData()[10];
    }

    public void setUnderlineStyle(byte styl) {
        this.uls = styl;
        this.getData()[10] = styl;
    }

    public Font() {
    }

    public Font(String nm, int stl, int sz) {
        byte[] byArray = new byte[26];
        byArray[0] = -56;
        byArray[4] = -1;
        byArray[5] = 127;
        byArray[6] = -112;
        byArray[7] = 1;
        byArray[14] = 5;
        byArray[15] = 1;
        byArray[16] = 65;
        byArray[18] = 114;
        byArray[20] = 105;
        byArray[22] = 97;
        byArray[24] = 108;
        byte[] bl = byArray;
        this.setOpcode((short)49);
        this.setLength((short)bl.length);
        this.setData(bl);
        this.init();
        this.setFontName(nm);
        this.setFontWeight(stl);
        this.setFontHeight(sz);
    }

    public void setFontName(String fn) {
        byte[] namebytes = null;
        try {
            namebytes = fn.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logWarn("setting Font Name using Default Encoding failed: " + e);
            namebytes = fn.getBytes();
        }
        this.cch = (short)(namebytes.length / 2);
        this.fontName = fn;
        byte[] newdata = new byte[namebytes.length + 16];
        System.arraycopy(this.getBytesAt(0, 13), 0, newdata, 0, 13);
        System.arraycopy(this.getBytesAt(0, 14), 0, newdata, 0, 14);
        newdata[14] = (byte)this.cch;
        newdata[15] = 1;
        System.arraycopy(namebytes, 0, newdata, 16, namebytes.length);
        this.setData(newdata);
        this.init();
    }

    public void setScript(int ss) {
        if (this.data == null) {
            this.setData(this.getData());
        }
        byte[] newss = ByteTools.shortToLEBytes((short)ss);
        System.arraycopy(newss, 0, this.data, 8, 2);
        this.sss = (short)ss;
    }

    public int getScript() {
        return this.sss;
    }

    public void setColor(int cl) {
        if (this.data == null) {
            this.setData(this.getData());
        }
        if (cl != this.icv) {
            byte[] newcl = ByteTools.shortToLEBytes((short)cl);
            System.arraycopy(newcl, 0, this.data, 4, 2);
            this.icv = (short)cl;
        }
        if (this.customColor != null) {
            this.customColor.setColorInt(cl);
        }
    }

    public void setColor(Color color) {
        if (this.customColor != null) {
            this.customColor.setColor(color);
        } else {
            this.customColor = new com.extentech.formats.OOXML.Color(color, "color", this.getWorkBook().getTheme());
        }
        this.icv = (short)this.customColor.getColorInt();
        byte[] newcl = ByteTools.shortToLEBytes(this.icv);
        System.arraycopy(newcl, 0, this.data, 4, 2);
    }

    public void setColor(String clr) {
        if (this.customColor != null) {
            this.customColor.setColor(clr);
        } else {
            this.customColor = new com.extentech.formats.OOXML.Color(clr, "color", this.getWorkBook().getTheme());
        }
        this.icv = (short)this.customColor.getColorInt();
        byte[] newcl = ByteTools.shortToLEBytes(this.icv);
        System.arraycopy(newcl, 0, this.data, 4, 2);
    }

    public void setFontHeight(int ht) {
        if (this.data == null) {
            this.setData(this.getData());
        }
        byte[] newht = ByteTools.shortToLEBytes((short)ht);
        System.arraycopy(newht, 0, this.data, 0, 2);
        this.dyHeight = (short)ht;
    }

    public static int PointsToFontHeight(double h) {
        return (int)(h * 20.0);
    }

    public static double FontHeightToPoints(int h) {
        return (double)h / 20.0;
    }

    public int getFontWeight() {
        return this.bls;
    }

    public int getFontHeight() {
        return this.dyHeight;
    }

    public double getFontHeightInPoints() {
        return (double)this.dyHeight / 20.0;
    }

    public Color getColorAsColor() {
        if (this.customColor != null) {
            return this.customColor.getColorAsColor();
        }
        if (this.icv == Short.MAX_VALUE || this.icv == 64 || this.icv == 81) {
            return Color.BLACK;
        }
        if (this.icv > FormatHandle.COLORTABLE.length) {
            return Color.BLACK;
        }
        if (this.getWorkBook() == null) {
            return FormatHandle.COLORTABLE[this.icv];
        }
        return this.getColorTable()[this.icv];
    }

    public String getColorAsHex() {
        if (this.customColor != null && this.customColor.getColorAsOOXMLRBG() != null) {
            return "#" + this.customColor.getColorAsOOXMLRBG().substring(2);
        }
        return FormatHandle.colorToHexString(this.getColorAsColor());
    }

    public String getColorAsOOXMLRBG() {
        String rgbcolor = this.getColorAsHex();
        return "FF" + rgbcolor.substring(1, rgbcolor.length());
    }

    public int getFontColor() {
        return this.getColor();
    }

    public int getColor() {
        if (this.customColor != null) {
            return this.customColor.getColorInt();
        }
        if (this.icv == Short.MAX_VALUE) {
            return 0;
        }
        return this.icv;
    }

    public void setFontWeight(int wt) {
        if (this.data == null) {
            this.setData(this.getData());
        }
        byte[] newwt = ByteTools.shortToLEBytes((short)wt);
        System.arraycopy(newwt, 0, this.data, 6, 2);
        this.bls = (short)wt;
    }

    public boolean getIsBold() {
        return this.bls > 400;
    }

    public String getXML() {
        return this.getXML(false);
    }

    public String getXML(boolean convertToUnicodeFont) {
        StringBuffer sb = new StringBuffer("");
        if (!convertToUnicodeFont || !this.isUnicodeCharSet()) {
            sb.append("name=\"" + StringTool.convertXMLChars(this.getFontName()) + "\"");
        } else {
            sb.append("name=\"ArialUnicodeMS\"");
        }
        sb.append(" size=\"" + this.getFontHeightInPoints() + "\"");
        sb.append(" color=\"" + FormatHandle.colorToHexString(this.getColorAsColor()) + "\"");
        sb.append(" weight=\"" + this.getFontWeight() + "\"");
        if (this.getIsBold()) {
            sb.append(" bold=\"1\"");
        }
        if (this.getUnderlineStyle() != 0) {
            sb.append(" underline=\"" + this.getUnderlineStyle() + "\"");
        }
        return sb.toString();
    }

    public boolean matches(Font f) {
        return this.fontName.equals(f.fontName) && this.dyHeight == f.dyHeight && this.bls == f.bls && this.getColor() == f.getColor() && this.sss == f.sss && this.uls == f.uls && this.grbit == f.grbit;
    }

    public void setOOXMLColor(com.extentech.formats.OOXML.Color c) {
        if (c != null) {
            this.setColor(c.getColorInt());
        }
        this.customColor = c;
    }

    public com.extentech.formats.OOXML.Color getOOXMLColor() {
        return this.customColor;
    }

    public void setCondensed(boolean condensed) {
        this.condensed = condensed;
    }

    public boolean isCondensed() {
        return this.condensed;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public String getOOXML() {
        String n;
        int cl;
        com.extentech.formats.OOXML.Color c;
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<font>");
        if (this.getIsBold()) {
            ooxml.append("<b/>");
        }
        if (this.getItalic()) {
            ooxml.append("<i/>");
        }
        if (this.getUnderlined()) {
            int u = this.getUnderlineStyle();
            if (u == 1) {
                ooxml.append("<u/>");
            } else if (u == 2) {
                ooxml.append("<u val=\"double\"/>");
            } else if (u == 33) {
                ooxml.append("<u val=\"singleAccounting\"/>");
            } else if (u == 34) {
                ooxml.append("<u val=\"doubleAccounting\"/>");
            }
        }
        if (this.getStricken()) {
            ooxml.append("<strike/>");
        }
        if (!this.isCondensed()) {
            ooxml.append("<condense val=\"0\"/>");
        }
        if (!this.isExtended()) {
            ooxml.append("<extend val=\"0\"/>");
        }
        if ((c = this.getOOXMLColor()) != null) {
            ooxml.append(c.getOOXML());
        } else if (this.icv != 9 && this.icv != 64 && (cl = this.getColor()) > 0) {
            ooxml.append("<color rgb=\"FF" + FormatHandle.colorToHexString(this.getColorTable()[cl]).substring(1) + "\"/>");
        }
        double sz = this.getFontHeightInPoints();
        if (sz > 0.0) {
            ooxml.append("<sz val=\"" + sz + "\"/>");
        }
        if ((n = this.getFontName()) != null && !n.equals("")) {
            ooxml.append("<name val=\"" + n + "\"/>");
        }
        ooxml.append("</font>");
        ooxml.append("\r\n");
        return ooxml.toString();
    }

    public static Font parseOOXML(XmlPullParser xpp, WorkBookHandle bk) {
        com.extentech.formats.OOXML.Color c = null;
        String sz = null;
        String name = "";
        Object u = null;
        boolean b = false;
        boolean strike = false;
        boolean ital = false;
        boolean condense = false;
        boolean expand = false;
        try {
            int eventType = xpp.next();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("sz")) {
                        sz = xpp.getAttributeValue(0);
                    } else if (tnm.equals("name")) {
                        name = xpp.getAttributeValue(0);
                    } else if (tnm.equals("b")) {
                        b = xpp.getAttributeCount() == 0 ? true : xpp.getAttributeValue(0).equals("1");
                    } else if (tnm.equals("i")) {
                        ital = xpp.getAttributeCount() == 0 ? true : xpp.getAttributeValue(0).equals("1");
                    } else if (tnm.equals("u")) {
                        u = xpp.getAttributeCount() == 0 ? Boolean.valueOf(true) : xpp.getAttributeValue(0);
                    } else if (tnm.equals("strike")) {
                        strike = true;
                    } else if (tnm.equals("condense")) {
                        condense = false;
                    } else if (tnm.equals("expand")) {
                        expand = false;
                    } else if (tnm.equals("color")) {
                        c = (com.extentech.formats.OOXML.Color)com.extentech.formats.OOXML.Color.parseOOXML(xpp, FormatHandle.colorFONT, bk);
                    }
                } else if (eventType == 3 && xpp.getName().equals("font")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("Font.parseOOXML: " + e.toString());
        }
        int size = sz == null ? -1 : Font.PointsToFontHeight(new Double(sz));
        Font f = new Font(name, 400, size);
        if (c != null) {
            f.setOOXMLColor(c);
        }
        if (u != null) {
            f.setUnderlined(true);
            if (u instanceof String) {
                if (((String)u).equals("double")) {
                    f.setUnderlineStyle((byte)2);
                } else if (((String)u).equals("singleAccounting")) {
                    f.setUnderlineStyle((byte)33);
                } else if (((String)u).equals("doubleAccounting")) {
                    f.setUnderlineStyle((byte)34);
                }
            }
        }
        if (b) {
            f.setBold(b);
        }
        if (ital) {
            f.setItalic(true);
        }
        if (strike) {
            f.setStricken(true);
        }
        if (!condense) {
            f.setCondensed(false);
        }
        if (!expand) {
            f.setExtended(false);
        }
        return f;
    }

    public String getSVG() {
        StringBuffer sbf = new StringBuffer("font-family='" + this.getFontName() + "'");
        sbf.append(" font-size='" + this.getFontHeightInPoints() + "pt'");
        sbf.append(" font-weight='" + this.getFontWeight() + "'");
        if (this.icv != 9) {
            sbf.append(" fill='" + FormatHandle.colorToHexString(FormatHandle.getColor(this.getColor())) + "'");
        } else {
            sbf.append(" fill='" + FormatHandle.colorToHexString(FormatHandle.getColor(0)) + "'");
        }
        return sbf.toString();
    }

    private boolean isUnicodeCharSet() {
        return this.bCharSet == 128 || this.bCharSet == 129 || this.bCharSet == 129 || this.bCharSet == 134 || this.bCharSet == 136 || this.bCharSet == 177 || this.bCharSet == 178 || this.bCharSet == 161 || this.bCharSet == 162 || this.bCharSet == 163 || this.bCharSet == 222 || this.bCharSet == 238 || this.bCharSet == 204 || this.bCharSet == 186;
    }
}

