/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.CellTypeMismatchException;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.StringRec;
import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.CircularReferenceException;
import com.extentech.formats.XLS.formulas.FormulaCalculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgExp;
import com.extentech.formats.XLS.formulas.PtgMemArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public final class Formula
extends XLSCellRecord {
    private static final long serialVersionUID = 7563301825566021680L;
    private static final short FALWAYSCALC = 1;
    private static final short FCALCONLOAD = 2;
    private static final short FSHRFMLA = 8;
    private Object cachedValue;
    private Stack expression;
    private boolean dirty = false;
    private boolean containsIndirectFunction = false;
    private boolean haveStringRec = false;
    private short grbit = (short)2;
    private StringRec string = null;
    public Shrfmla shared = null;
    private List internalRecords;
    private boolean isExternalRef = false;
    private static ThreadLocal<Integer> recurseCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private boolean closed = false;

    public Formula() {
        this.setOpcode((short)6);
        this.setIsValueForCell(true);
        this.isFormula = true;
    }

    @Override
    public void init() {
        if (this.expression != null) {
            throw new IllegalStateException("can't init a formula created from a string");
        }
        super.init();
        this.data = this.getData();
        if (this.data == null) {
            throw new IllegalStateException("can't init a formula without record bytes");
        }
        super.initRowCol();
        this.ixfe = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.grbit = ByteTools.readShort(this.getByteAt(14), this.getByteAt(15));
        byte[] currVal = this.getBytesAt(6, 8);
        if (currVal[6] == -1 && currVal[7] == -1) {
            if (currVal[0] == 0) {
                this.haveStringRec = true;
                this.cachedValue = null;
            } else {
                this.cachedValue = currVal[0] == 3 ? "" : (currVal[0] == 1 ? Boolean.valueOf(currVal[2] != 0) : (currVal[0] == 2 ? new CalculationException(currVal[2]) : null));
            }
        } else {
            double dbv = ByteTools.eightBytetoLEDouble(currVal);
            if (!Double.isNaN(dbv)) {
                this.cachedValue = new Double(dbv);
            }
        }
        if (this.getSheet() == null) {
            this.setSheet(this.wkbook.getLastbound());
        }
        if (this.DEBUGLEVEL > 10) {
            try {
                Logger.logInfo("INFO: Formula " + this.getCellAddress() + this.getFormulaString());
            }
            catch (Exception e) {
                Logger.logInfo("Debug output of Formula failed: " + e);
            }
        }
        this.populateExpression();
        if (this.containsIndirectFunction) {
            this.registerIndirectFunction();
        }
        this.dirty = false;
    }

    private void clearExpression() {
        Array a;
        if (this.expression == null) {
            return;
        }
        if (this.isArrayFormula() && (a = this.getArray()) != null) {
            this.getSheet().removeRecFromVec(a);
        }
        if (this.hasAttachedString()) {
            if (this.string != null) {
                this.getSheet().removeRecFromVec(this.string);
            }
            this.string = null;
        }
        if (this.isSharedFormula()) {
            this.shared.removeMember(this);
            this.shared = null;
            this.setSharedFormula(false);
        }
        for (Ptg ptg : this.expression) {
            if (!(ptg instanceof PtgRef)) continue;
            ((PtgRef)ptg).removeFromRefTracker();
        }
        this.expression = null;
    }

    public void setExpression(Stack exp) {
        if (this.expression != null) {
            this.clearExpression();
        }
        this.expression = exp;
        this.updateRecord();
    }

    public Stack getExpression() {
        this.populateExpression();
        return this.expression;
    }

    public void addInternalRecord(BiffRec b) {
        if (this.internalRecords == null) {
            this.internalRecords = new ArrayList(3);
        }
        if (b instanceof Shrfmla) {
            this.internalRecords.add(0, b);
        } else if (b instanceof StringRec) {
            if (!this.haveStringRec || this.string == null) {
                this.internalRecords.add(b);
                this.haveStringRec = true;
                this.string = (StringRec)b;
                this.cachedValue = this.string.getStringVal();
            }
        } else {
            this.internalRecords.add(b);
        }
    }

    public void removeInternalRecord(BiffRec b) {
        if (this.internalRecords == null) {
            return;
        }
        this.internalRecords.remove(b);
    }

    public List getInternalRecords() {
        if (this.internalRecords == null) {
            return Collections.emptyList();
        }
        return this.internalRecords;
    }

    public boolean hasAttachedString() {
        return this.haveStringRec;
    }

    public StringRec getAttatchedString() {
        return this.string;
    }

    public boolean getCalcAlways() {
        return (this.grbit & 1) != 0;
    }

    public void setCalcAlways(boolean fAlwaysCalc) {
        this.grbit = fAlwaysCalc ? (short)(this.grbit | 1) : (short)(this.grbit & 0xFFFFFFFE);
    }

    public void setIsExternalRef(boolean isExternalRef) {
        this.isExternalRef = isExternalRef;
    }

    public String getTypeName() {
        return "formula";
    }

    protected void registerIndirectFunction() {
        this.getWorkBook().addIndirectFormula(this);
    }

    protected void calculateIndirectFunction() {
        this.clearCachedValue();
        try {
            this.calculateFormula();
        }
        catch (FunctionNotSupportedException functionNotSupportedException) {
        }
        catch (Exception e) {
            Logger.logErr("Error registering lookup for INDIRECT() function at cell: " + this.getCellAddress() + " : " + e);
        }
    }

    void populateExpression() {
        block5: {
            if (this.expression != null || this.data == null) {
                return;
            }
            try {
                short length = ByteTools.readShort(this.getByteAt(20), this.getByteAt(21));
                if (length + 22 > this.data.length) {
                    throw new Exception("cce longer than record");
                }
                this.expression = ExpressionParser.parseExpression(this.getBytesAt(22, this.reclen - 22), this, length);
                if (this.isSharedFormula()) {
                    this.initSharedFormula(null);
                }
            }
            catch (Exception e) {
                if (this.DEBUGLEVEL <= -10) break block5;
                Logger.logInfo("Formula.init:  Parsing Formula failed: " + e);
            }
        }
    }

    void initSharedFormula(Shrfmla target) throws FormulaNotFoundException {
        if (!this.isSharedFormula()) {
            this.setSharedFormula(true);
        }
        if (this.shared != null) {
            return;
        }
        if (this.expression.size() != 1 || !(this.expression.get(0) instanceof PtgExp)) {
            this.setSharedFormula(false);
            return;
        }
        PtgExp pointer = (PtgExp)this.expression.get(0);
        if (target != null) {
            this.shared = target;
        } else {
            try {
                this.shared = ((Formula)this.getSheet().getCell((int)pointer.getRwFirst(), (int)pointer.getColFirst())).shared;
                if (this.shared == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                if (this.getCellAddress().equals(pointer.getReferent())) {
                    return;
                }
                throw new FormulaNotFoundException("FORMULA at " + this.getCellAddress() + " refers to missing SHRFMLA at " + pointer.getReferent());
            }
        }
        this.shared.addMember(this);
        if (this.shared.containsIndirectFunction) {
            this.registerIndirectFunction();
        }
    }

    public void convertSharedFormula() {
        if (!this.isSharedFormula()) {
            throw new IllegalStateException("not a shared formula reference");
        }
        this.shared = null;
        this.setSharedFormula(false);
    }

    public String getFormulaString() {
        this.populateExpression();
        if (!this.isArrayFormula()) {
            return FormulaParser.getFormulaString(this);
        }
        return "{" + FormulaParser.getFormulaString(this) + "}";
    }

    public List getPtgsByLocation(String loc) throws FormulaNotFoundException {
        this.populateExpression();
        if (loc.indexOf("!") == -1) {
            loc = String.valueOf(this.getSheet().getSheetName()) + "!" + loc;
        }
        return ExpressionParser.getPtgsByLocation(loc, this.expression);
    }

    public Ptg[] getCellRangePtgs() throws FormulaNotFoundException {
        return ExpressionParser.getCellRangePtgs(this.expression);
    }

    public boolean setLocationPolicy(String loc, int l) {
        this.populateExpression();
        try {
            List dx = this.getPtgsByLocation(loc);
            for (Ptg d : dx) {
                d.setLocationPolicy(l);
                if (l != 2) continue;
                d.initTrackerCell();
            }
            return true;
        }
        catch (FormulaNotFoundException e) {
            Logger.logInfo("locking Formula Location failed:" + loc + ": " + e.toString());
            return false;
        }
    }

    public void updateRecord() {
        this.dirty = true;
        if (this.data == null) {
            this.setData(new byte[6]);
        }
        if (this.cachedValue instanceof String && !"".equals(this.cachedValue) && !Formula.isErrorValue((String)this.cachedValue)) {
            if (!this.haveStringRec || this.string == null) {
                this.string = new StringRec((String)this.cachedValue);
                this.string.setSheet(this.getSheet());
                this.string.setRowNumber(this.getRowNumber());
                this.string.setCol(this.getColNumber());
                this.getWorkBook().setLastFormula(this);
                this.getWorkBook().addRecord(this.string, true);
                this.haveStringRec = true;
            } else {
                this.string.setStringVal((String)this.cachedValue);
            }
        } else if (this.string != null) {
            this.string.remove(false);
            this.removeInternalRecord(this.string);
            this.haveStringRec = false;
        }
    }

    @Override
    public void preStream() {
        byte[] value;
        if (!this.dirty && !this.isSharedFormula() && this.cachedValue != null && this.getWorkBook().getCalcMode() != 1) {
            return;
        }
        try {
            if (this.cachedValue == null) {
                this.calculateFormula();
            }
        }
        catch (FunctionNotSupportedException functionNotSupportedException) {
            // empty catch block
        }
        Object writeValue = this.cachedValue;
        if (this.cachedValue == null) {
            this.grbit = (short)(this.grbit | 2);
            if (writeValue == null) {
                writeValue = new Double(Double.NaN);
            }
        }
        if (this.getWorkBook().getCalcMode() == 1) {
            this.grbit = (short)(this.grbit | 2);
        }
        Stack<PtgExp> expr = this.expression;
        if (this.isSharedFormula()) {
            expr = new Stack<PtgExp>();
            expr.add(this.shared.getPointer());
        }
        byte[][] ptgdata = new byte[expr.size()][];
        byte[] rgb = null;
        short cce = 0;
        int rgblen = 0;
        int idx = 0;
        while (idx < expr.size()) {
            byte[] extra;
            Ptg ptg = (Ptg)expr.get(idx);
            ptgdata[idx] = ptg.getRecord();
            cce = (short)(cce + ptgdata[idx].length);
            if (ptg instanceof PtgArray) {
                extra = ((PtgArray)ptg).getPostRecord();
                rgb = ByteTools.append(extra, rgb);
                rgblen = (short)(rgblen + extra.length);
            } else if (ptg instanceof PtgMemArea) {
                extra = ((PtgMemArea)ptg).getPostRecord();
                rgb = ByteTools.append(extra, rgb);
                rgblen = (short)(rgblen + extra.length);
            }
            ++idx;
        }
        byte[] newdata = new byte[22 + cce + rgblen];
        System.arraycopy(this.data, 0, newdata, 0, 6);
        if (writeValue instanceof Number) {
            value = ByteTools.toBEByteArray(((Number)writeValue).doubleValue());
        } else {
            value = new byte[8];
            value[1] = 0;
            value[3] = 0;
            value[4] = 0;
            value[5] = 0;
            value[6] = -1;
            value[7] = -1;
            if (writeValue instanceof String) {
                if (!Formula.isErrorValue((String)writeValue)) {
                    value[2] = 0;
                    String sval = (String)writeValue;
                    if (sval.equals("") || this.string == null) {
                        value[0] = 3;
                    } else {
                        value[0] = 0;
                        this.string.setStringVal(sval);
                    }
                } else {
                    value[0] = 2;
                    value[2] = CalculationException.getErrorCode((String)writeValue);
                }
            } else if (writeValue instanceof Boolean) {
                value[0] = 1;
                value[2] = (Boolean)writeValue != false ? (byte)1 : 0;
            } else if (writeValue instanceof CalculationException) {
                value[0] = 2;
                value[2] = ((CalculationException)writeValue).getErrorCode();
            } else {
                throw new Error("unknown value type " + (writeValue == null ? "null" : writeValue.getClass().getName()));
            }
        }
        System.arraycopy(value, 0, newdata, 6, 8);
        System.arraycopy(ByteTools.shortToLEBytes(this.grbit), 0, newdata, 14, 2);
        Arrays.fill(newdata, 16, 19, (byte)0);
        System.arraycopy(ByteTools.shortToLEBytes(cce), 0, newdata, 20, 2);
        int offset = 22;
        int idx2 = 0;
        while (idx2 < ptgdata.length) {
            System.arraycopy(ptgdata[idx2], 0, newdata, offset, ptgdata[idx2].length);
            offset += ptgdata[idx2].length;
            ++idx2;
        }
        if (rgblen > 0) {
            System.arraycopy(rgb, 0, newdata, offset, rgblen);
        }
        this.setData(newdata);
        this.dirty = false;
    }

    @Override
    public Object clone() {
        this.preStream();
        return super.clone();
    }

    @Override
    public int getIntVal() throws RuntimeException {
        Object obx = this.calculateFormula();
        try {
            int ret;
            double tl = (Double)obx;
            if (tl > 2.147483647E9) {
                throw new NumberFormatException("getIntVal: Formula value is larger than the maximum java signed int size");
            }
            if (tl < -2.147483648E9) {
                throw new NumberFormatException("getIntVal: Formula value is smaller than the minimum java signed int size");
            }
            double db = (Double)obx;
            if (db - (double)(ret = ((Double)obx).intValue()) > 0.0 && this.DEBUGLEVEL > 50) {
                Logger.logWarn("Loss of precision converting " + tl + " to int.");
            }
            return ret;
        }
        catch (ClassCastException tl) {
            long l = 0L;
            String s = String.valueOf(obx);
            if (s.equals("")) {
                s = "0";
            }
            try {
                String t = "";
                BigDecimal bd = new BigDecimal(s);
                l = bd.longValue();
                if (l > Integer.MAX_VALUE) {
                    throw new NumberFormatException("Formula value is larger than the maximum java signed int size");
                }
                if (l < Integer.MIN_VALUE) {
                    throw new NumberFormatException("Formula value is smaller than the minimum java signed int size");
                }
                return Integer.valueOf(new Long(l).toString());
            }
            catch (NumberFormatException ne) {
                throw new NumberFormatException("getIntVal: Formula is a non-numeric value");
            }
            catch (Exception e) {
                throw new NumberFormatException("getIntVal: " + e);
            }
        }
    }

    @Override
    public float getFloatVal() {
        Object obx = this.calculateFormula();
        try {
            if (obx instanceof Float) {
                float d = ((Float)obx).floatValue();
                return d;
            }
        }
        catch (Exception e) {
            Logger.logErr("Formula.getFloatVal failed for: " + this.toString(), e);
        }
        try {
            String s = String.valueOf(obx);
            if (s.equals("")) {
                s = "0";
            }
            Float d = new Float(s);
            return d.floatValue();
        }
        catch (NumberFormatException ex) {
            return Float.NaN;
        }
        catch (Exception e) {
            Logger.logWarn("Formula.getFloatVal() failed: " + e);
            return Float.NaN;
        }
    }

    @Override
    public boolean getBooleanVal() {
        Object obx = this.calculateFormula();
        try {
            if (obx instanceof Boolean) {
                return (Boolean)obx;
            }
        }
        catch (Exception e) {
            Logger.logErr("getBooleanVal failed for: " + this.toString(), e);
        }
        try {
            String s = String.valueOf(obx);
            if (s.equalsIgnoreCase("true") || s.equals("1")) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.logWarn("getBooleanVal() failed: " + e);
        }
        return false;
    }

    @Override
    public double getDblVal() {
        Object obx = this.calculateFormula();
        try {
            if (obx instanceof Double) {
                double d = (Double)obx;
                return d;
            }
        }
        catch (Exception e) {
            Logger.logErr("Formula.getDblVal failed for: " + this.toString(), e);
        }
        String s = String.valueOf(obx);
        if (s.equals("")) {
            s = "0";
        }
        try {
            Double d = new Double(s);
            return d;
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
        catch (Exception e) {
            Logger.logWarn("Formula.getDblVal() failed: " + e);
            return Double.NaN;
        }
    }

    private static String getDoubleAsFormattedString(double theNum) {
        return ExcelTools.getNumberAsString(theNum);
    }

    @Override
    public String getStringVal() {
        Object obx = this.calculateFormula();
        try {
            if (obx instanceof Double) {
                double d = (Double)obx;
                if (!Double.isNaN(d)) {
                    return Formula.getDoubleAsFormattedString(d);
                }
                return "NaN";
            }
        }
        catch (Exception e) {
            Logger.logErr("Formula.getStringVal failed for: " + this.toString(), e);
        }
        if (obx == null) {
            return "";
        }
        return obx.toString();
    }

    public Object calculateFormula() throws FunctionNotSupportedException {
        if (this.getWorkBook().getCalcMode() == 1) {
            return this.cachedValue;
        }
        if (this.getWorkBook().getCalcMode() == 0) {
            if (!this.isExternalRef) {
                this.cachedValue = null;
            } else {
                return this.cachedValue;
            }
        }
        return this.calculate();
    }

    public Object calculate() {
        Integer depth = recurseCount.get();
        try {
            recurseCount.set(depth + 1);
            if (depth > WorkBookHandle.RECURSION_LEVELS_ALLOWED) {
                Logger.logWarn("Recursion levels reached in calculating formula " + this.getCellAddressWithSheet() + ". Possible circular reference.  Recursion levels can be set through WorkBookHandle.setFormulaRecursionLevels");
                Object object = this.cachedValue = new CalculationException(-1);
                return object;
            }
            Object object = this.calculateInternal();
            return object;
        }
        finally {
            recurseCount.set(depth);
        }
    }

    private Object calculateInternal() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        this.populateExpression();
        try {
            this.cachedValue = FormulaCalculator.calculateFormula(this.expression);
        }
        catch (StackOverflowError e) {
            Logger.logWarn("Stack overflow while calculating " + this.getCellAddressWithSheet() + ". Possible circular reference.");
            this.cachedValue = new CalculationException(-1);
            return this.cachedValue;
        }
        if (this.cachedValue == null) {
            throw new FunctionNotSupportedException("Unable to calculate Formula " + this.getFormulaString() + " at: " + this.getSheet().getSheetName() + "!" + this.getCellAddress());
        }
        if (this.cachedValue.toString().equals("#CIR_ERR!")) {
            return new CircularReferenceException(-1);
        }
        if (this.cachedValue.toString().length() >= 1 && this.cachedValue.toString().charAt(0) == '{') {
            int colA;
            int rowA;
            String arrStr = (String)this.cachedValue;
            arrStr = arrStr.substring(1, arrStr.length() - 1);
            String[] rows = null;
            String[][] cols = null;
            rows = arrStr.split(";");
            cols = new String[rows.length][];
            int i = 0;
            while (i < rows.length) {
                cols[i] = rows[i].split(",", -1);
                ++i;
            }
            try {
                PtgExp pxp = (PtgExp)this.expression.elementAt(0);
                rowA = this.getRowNumber() - pxp.getRwFirst();
                colA = this.getColNumber() - pxp.getColFirst();
                if (rows.length == 1 && rowA > 0 && colA == 0) {
                    colA = rowA;
                    rowA = 0;
                }
            }
            catch (ClassCastException e) {
                rowA = 0;
                colA = 0;
            }
            this.cachedValue = cols[rowA][colA];
            try {
                this.cachedValue = new Double((String)this.cachedValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGLEVEL > 10) {
                Logger.log(this.cachedValue);
            }
        }
        if (this.getAttatchedString() != null) {
            this.getAttatchedString().setStringVal(String.valueOf(this.cachedValue));
        }
        this.updateRecord();
        return this.cachedValue;
    }

    @Override
    public String toString() {
        this.populateExpression();
        return super.toString();
    }

    public boolean isSharedFormula() {
        return (this.grbit & 8) != 0;
    }

    private void setSharedFormula(boolean isSharedFormula) {
        this.grbit = isSharedFormula ? (short)(this.grbit | 8) : (short)(this.grbit & 0xFFFFFFF7);
    }

    @Override
    public void setStringVal(String v) {
        throw new CellTypeMismatchException("Attempting to set a string value on a formula");
    }

    public boolean isArrayFormula() {
        if (this.internalRecords != null && this.internalRecords.size() > 0) {
            return this.internalRecords.get(0) instanceof Array;
        }
        return false;
    }

    public Array getArray() {
        try {
            return (Array)this.internalRecords.get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setArrayRefs(String s) {
        Object o;
        if (this.internalRecords != null && this.internalRecords.size() > 0 && (o = this.internalRecords.get(0)) instanceof Array) {
            Array a = (Array)o;
            int[] rc = ExcelTools.getRangeRowCol(s);
            a.setFirstRow(rc[0]);
            a.setFirstCol(rc[1]);
            a.setLastRow(rc[2]);
            a.setLastCol(rc[3]);
        }
    }

    public void setCachedValue(Object newValue) {
        if (newValue == null) {
            this.clearCachedValue();
        } else {
            this.cachedValue = newValue;
        }
    }

    public void clearCachedValue() {
        this.cachedValue = null;
        this.haveStringRec = false;
    }

    public String getArrayRefs() {
        if (this.internalRecords != null && this.internalRecords.size() > 0) {
            Object o = this.internalRecords.get(0);
            return ((Array)o).getArrayRefs();
        }
        return "";
    }

    public static void incrementSharedFormula(Stack origStack, int rowInc, int colInc, int[] range) {
        int i = 0;
        while (i < origStack.size()) {
            Ptg p = (Ptg)origStack.elementAt(i);
            try {
                String s = p.getLocation();
                if (!(!p.getIsReference() || ((PtgRef)p).wholeRow && colInc != 0 || ((PtgRef)p).wholeCol && rowInc != 0)) {
                    int[] rc;
                    if (!(p instanceof PtgArea)) {
                        boolean[] bRelRefs = new boolean[]{((PtgRef)p).isRowRel(), ((PtgRef)p).isColRel()};
                        rc = ExcelTools.getRowColFromString(s);
                        if (bRelRefs[0]) {
                            rc[0] = rc[0] + rowInc;
                        }
                        if (bRelRefs[1]) {
                            rc[1] = rc[1] + colInc;
                        }
                        PtgRef pr = new PtgRef();
                        pr.setParentRec(p.getParentRec());
                        pr.setUseReferenceTracker(false);
                        pr.setLocation(ExcelTools.formatLocation(rc, bRelRefs[0], bRelRefs[1]));
                        pr.setUseReferenceTracker(true);
                        origStack.set(i, pr);
                    } else {
                        String sh = ExcelTools.stripSheetNameFromRange(s)[0];
                        rc = ExcelTools.getRangeRowCol(s);
                        boolean[] bRelRefs = new boolean[]{((PtgArea)p).getFirstPtg().isRowRel(), ((PtgArea)p).getLastPtg().isRowRel(), ((PtgArea)p).getFirstPtg().isColRel(), ((PtgArea)p).getLastPtg().isColRel()};
                        if (bRelRefs[0]) {
                            rc[0] = rc[0] + rowInc;
                        }
                        if (bRelRefs[1]) {
                            rc[2] = rc[2] + rowInc;
                        }
                        if (bRelRefs[2]) {
                            rc[1] = rc[1] + colInc;
                        }
                        if (bRelRefs[3]) {
                            rc[3] = rc[3] + colInc;
                        }
                        PtgArea pa = new PtgArea(false);
                        pa.setParentRec(p.getParentRec());
                        if (sh != null) {
                            pa.setLocation(String.valueOf(sh) + "!" + ExcelTools.formatRangeRowCol(rc, bRelRefs));
                        } else {
                            pa.setLocation(ExcelTools.formatRangeRowCol(rc, bRelRefs));
                        }
                        pa.setUseReferenceTracker(true);
                        origStack.set(i, pa);
                    }
                }
            }
            catch (Exception ex) {
                Logger.logErr("Formula.incrementSharedFormula: " + ex.toString());
            }
            ++i;
        }
    }

    protected void setContainsIndirectFunction(boolean containsIndirectFunction) {
        this.containsIndirectFunction = containsIndirectFunction;
    }

    public void destroy() {
        this.clearExpression();
    }

    public static boolean isErrorValue(String s) {
        if (s == null) {
            return false;
        }
        return Collections.binarySearch(Arrays.asList("#DIV/0!", "#N/A", "#NAME?", "#NULL!", "#NUM!", "#REF!", "#VALUE!"), s.trim()) > -1;
    }

    @Override
    public void close() {
        if (this.expression != null) {
            while (!this.expression.isEmpty()) {
                GenericPtg p = (GenericPtg)this.expression.pop();
                if (p instanceof PtgRef) {
                    ((PtgRef)p).close();
                } else {
                    p.close();
                }
                Object var1_1 = null;
            }
        }
        if (this.string != null) {
            this.string.close();
            this.string = null;
        }
        if (this.shared != null) {
            if (this.shared.getMembers() == null || this.shared.getMembers().size() == 1) {
                this.shared.close();
            } else {
                this.shared.removeMember(this);
            }
            this.shared = null;
        }
        if (this.internalRecords != null) {
            this.internalRecords.clear();
        }
        super.close();
        this.closed = true;
    }

    protected void finalize() {
        if (!this.closed) {
            this.close();
        }
    }

    public void replacePtg(Ptg thisptg, Ptg ptgErr) {
        ptgErr.setParentRec(this);
        int idx = this.expression.indexOf(thisptg);
        this.expression.remove(idx);
        this.expression.insertElementAt(ptgErr, idx);
    }
}

