/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Guts
extends XLSRecord {
    private static final long serialVersionUID = 2815489536116897500L;
    private short dxRwGut;
    private short dyColGut;
    private short iLevelRwMac;
    private short iLevelColMac;

    @Override
    public void init() {
        super.init();
        this.dxRwGut = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.dyColGut = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.iLevelRwMac = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.iLevelColMac = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("INFO: Guts settings: dxRwGut:" + this.dxRwGut + " dyColGut:" + this.dyColGut + " iLevelRwMac:" + this.iLevelRwMac + " iLevelColMac:" + this.iLevelColMac);
        }
    }

    public void setRowGutterSize(int i) {
        this.dxRwGut = (short)i;
        this.updateRecBody();
    }

    public int getRowGutterSize() {
        return this.dxRwGut;
    }

    public void setColGutterSize(int i) {
        this.dyColGut = (short)i;
        this.updateRecBody();
    }

    public int getColGutterSize() {
        return this.dyColGut;
    }

    public void setMaxRowLevel(int i) {
        this.iLevelRwMac = (short)i;
        this.updateRecBody();
    }

    public int getMaxRowLevel() {
        return this.iLevelRwMac;
    }

    public void setMaxColLevel(int i) {
        this.iLevelColMac = (short)i;
        this.updateRecBody();
    }

    public int getMaxColLevel() {
        return this.iLevelColMac;
    }

    private void updateRecBody() {
        byte[] newbytes = ByteTools.shortToLEBytes(this.dxRwGut);
        newbytes = ByteTools.append(ByteTools.shortToLEBytes(this.dyColGut), newbytes);
        newbytes = ByteTools.append(ByteTools.shortToLEBytes(this.iLevelRwMac), newbytes);
        newbytes = ByteTools.append(ByteTools.shortToLEBytes(this.iLevelColMac), newbytes);
        this.setData(newbytes);
    }
}

