/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Dbcell;
import com.extentech.formats.XLS.Dimensions;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.Serializable;

public final class Index
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = -753407655976707961L;
    private int rwMic;
    private int rwMac;
    private int dbnum = 0;
    private CompatibleVector dbcells = new CompatibleVector();
    private int indexnum;
    private static int defaultsize = 16;
    private Dimensions dims;
    int offsetStart = 0;

    public static XLSRecord getPrototype() {
        Index idx = new Index();
        byte[] dt = new byte[defaultsize];
        idx.originalsize = defaultsize;
        idx.setData(dt);
        idx.setOpcode((short)523);
        idx.setLength((short)defaultsize);
        idx.init();
        return idx;
    }

    void setDimensions(Dimensions d) {
        this.dims = d;
    }

    void setDimensionsOffset(int offset) {
        byte[] recData = this.getData();
        byte[] newoff = ByteTools.cLongToLEBytes(offset);
        System.arraycopy(newoff, 0, recData, 12, 4);
        this.setData(recData);
    }

    public void setIndexNum(int n) {
        this.indexnum = n;
    }

    public int getIndexNum() {
        return this.indexnum;
    }

    void addDBCell(Dbcell dbc) {
        boolean bAdd = true;
        if (bAdd) {
            dbc.setDBCNum(this.dbnum++);
            this.dbcells.add(dbc);
        }
    }

    void resetDBCells() {
        this.dbnum = 0;
        this.dbcells = new CompatibleVector();
    }

    void updateDbcellPointers() {
        this.streamer = this.getSheet().streamer;
        Boundsheet bs = this.getSheet();
        Row[] rowz = bs.getRows();
        if (rowz.length != 0) {
            this.updateRowDimensions(rowz[0].getRowNumber(), rowz[rowz.length - 1].getRowNumber());
        }
        int arrsize = 16 + this.dbcells.size() * 4;
        byte[] newBytes = new byte[arrsize];
        Object dbc = null;
        System.arraycopy(this.getData(), 0, newBytes, 0, 16);
        int offset = 16;
        int i = 0;
        while (i < this.dbcells.size()) {
            Dbcell db = (Dbcell)this.dbcells.elementAt(i);
            int dbOff = db.getOffset();
            byte[] b = ByteTools.cLongToLEBytes(dbOff);
            newBytes[offset++] = b[0];
            newBytes[offset++] = b[1];
            newBytes[offset++] = b[2];
            newBytes[offset++] = b[3];
            ++i;
        }
        this.setData(newBytes);
    }

    void updateDimensions() {
        byte[] rkdata = this.getData();
        byte[] newb = ByteTools.cLongToLEBytes(this.dims.offset);
        rkdata[12] = newb[0];
        rkdata[13] = newb[1];
        rkdata[14] = newb[2];
        rkdata[15] = newb[3];
    }

    Dbcell[] getDBCells() {
        Object[] obj = this.dbcells.toArray();
        Dbcell[] dbcs = new Dbcell[obj.length];
        System.arraycopy(obj, 0, dbcs, 0, obj.length);
        return dbcs;
    }

    @Override
    public void init() {
        super.init();
        this.rwMic = ByteTools.readInt(this.getBytesAt(4, 4));
        this.rwMac = ByteTools.readInt(this.getBytesAt(8, 4));
    }

    public void updateRowDimensions(int lowRow, int hiRow) {
        byte[] rw = ByteTools.cLongToLEBytes(lowRow);
        System.arraycopy(rw, 0, this.getData(), 4, 4);
        rw = ByteTools.cLongToLEBytes(hiRow + 1);
        System.arraycopy(rw, 0, this.getData(), 8, 4);
    }

    void setDbcellPosition(int DbcellNumber, int DbOffset) {
        if (this.offsetStart == 0) {
            this.offsetStart = this.getSheet().getMyBof().getOffset();
        }
        int insertOffset = DbOffset - this.offsetStart;
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo("Setting DBBiffRec Position, offsetStart:" + this.offsetStart + " & InsertOffset = " + insertOffset);
        }
        this.offsetStart += insertOffset;
        int insertloc = 16 + DbcellNumber * 4;
        byte[] off = ByteTools.cLongToLEBytes(insertOffset);
        System.arraycopy(off, 0, this.data, insertloc, 4);
    }

    @Override
    public void preStream() {
        this.getData();
        int arrsize = 16 + this.dbcells.size() * 4;
        byte[] newBytes = new byte[arrsize];
        Object dbc = null;
        System.arraycopy(this.getData(), 0, newBytes, 0, 16);
        this.setData(newBytes);
    }

    class dbCellPointer
    implements Serializable {
        private static final long serialVersionUID = -5132922970171084839L;
        int cellloc = 0;
        int datasiz = 0;
        short s2;
        short s3;
        byte[] cdb = new byte[4];

        dbCellPointer(byte[] b) {
            this.cdb = b;
            this.cellloc = ByteTools.readShort(b[0], b[1]);
            this.datasiz = ByteTools.readShort(b[2], b[3]);
        }

        void adjustPosition(int i) {
            this.cellloc += i;
            this.datasiz += i;
        }

        byte[] getBytes() {
            byte[] bite = new byte[4];
            System.arraycopy(ByteTools.shortToLEBytes((short)this.cellloc), 0, bite, 0, 2);
            System.arraycopy(ByteTools.shortToLEBytes((short)this.datasiz), 0, bite, 2, 2);
            return bite;
        }
    }
}

