/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Label
extends XLSCellRecord {
    private static final long serialVersionUID = -2921430854162954640L;
    int cch;
    String val;

    @Override
    public void init() {
        super.init();
        short s = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.rw = s;
        this.col = s = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        s = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.ixfe = s;
        short s1 = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.cch = s1;
        if (this.getByteAt(8) > 1) {
            byte[] namebytes = this.getBytesAt(8, this.getLength() - 8);
            this.val = new String(namebytes);
        } else {
            try {
                Unicodestring thistr = null;
                byte[] tmpBytes = this.getBytesAt(6, this.cch * 2 + 4);
                thistr = new Unicodestring();
                thistr.init(tmpBytes, false);
                this.val = thistr.toString();
            }
            catch (Exception e) {
                Logger.logWarn("ERROR Label.init: decoding string failed: " + e);
            }
        }
        this.setIsValueForCell(true);
        this.isString = true;
    }

    @Override
    public void setStringVal(String v) {
        this.val = v;
        int newstrlen = v.length();
        byte[] newbytes = new byte[newstrlen + 8];
        System.arraycopy(this.getData(), 0, newbytes, 0, 6);
        byte[] blen = ByteTools.cLongToLEBytes(newstrlen);
        System.arraycopy(blen, 0, newbytes, 6, 2);
        byte[] strbytes = v.getBytes();
        System.arraycopy(strbytes, 0, newbytes, 8, newstrlen);
        this.setData(newbytes);
        this.init();
    }

    void setStringVal(String v, boolean b) {
        this.setStringVal(v);
    }

    @Override
    public String getStringVal() {
        return this.val;
    }
}

