/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class Labelsst
extends XLSCellRecord {
    private static final long serialVersionUID = 467127849827595055L;
    int isst;
    private Unicodestring unsharedstr;

    void setIsst(int i) {
        this.isst = i;
        System.arraycopy(ByteTools.cLongToLEBytes(this.isst), 0, this.getData(), 6, 4);
        try {
            this.getWorkBook().getSharedStringTable().initSharingOnStrings(this.isst);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static Labelsst getPrototype(String val, WorkBook bk) {
        Labelsst retlab = new Labelsst();
        retlab.originalsize = 10;
        retlab.setOpcode((short)253);
        retlab.setLength(10);
        retlab.setData(new byte[retlab.originalsize]);
        if (val != null) {
            Sst sst = bk.getSharedStringTable();
            retlab.isst = sst.insertUnicodestring(val);
            System.arraycopy(ByteTools.cLongToLEBytes(retlab.isst), 0, retlab.getData(), 6, 4);
        } else {
            retlab.isst = -1;
        }
        retlab.getData()[4] = 15;
        retlab.setWorkBook(bk);
        retlab.init();
        return retlab;
    }

    @Override
    public void init() {
        super.init();
        super.initRowCol();
        short s = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.ixfe = s;
        this.isst = ByteTools.readInt(this.getByteAt(6), this.getByteAt(7), this.getByteAt(8), this.getByteAt(9));
        this.setIsValueForCell(true);
        this.isString = true;
        this.resetCacheBytes();
        if (this.isst != -1) {
            try {
                this.getWorkBook().getSharedStringTable().initSharingOnStrings(this.isst);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    void initUnsharedString() {
        this.unsharedstr = this.getWorkBook().getSharedStringTable().getUStringAt(this.isst);
    }

    public Unicodestring getUnsharedString() {
        if (this.unsharedstr == null) {
            this.initUnsharedString();
        }
        return this.unsharedstr;
    }

    boolean insertUnsharedString(Sst sst) {
        if (this.unsharedstr == null) {
            return false;
        }
        this.isst = sst.insertUnicodestring(this.unsharedstr.toString());
        this.setIsst(this.isst);
        return true;
    }

    @Override
    public String getStringVal() {
        if (this.unsharedstr != null) {
            return this.unsharedstr.toString();
        }
        return this.getWorkBook().getSharedStringTable().getUStringAt(this.isst).toCachingString();
    }

    @Override
    public int getIntVal() {
        String s = this.getStringVal();
        try {
            Integer i = Integer.valueOf(s);
            return i;
        }
        catch (NumberFormatException n) {
            return 0;
        }
    }

    @Override
    public double getDblVal() {
        String s = this.getStringVal();
        try {
            Double d = new Double(s);
            return d;
        }
        catch (NumberFormatException n) {
            Calendar c;
            this.getXfRec();
            if (this.myxf.isDatePattern()) {
                GregorianCalendar c2;
                block7: {
                    String format = this.myxf.getFormatPattern();
                    WorkBookHandle.simpledateformat.applyPattern(format);
                    Date d = WorkBookHandle.simpledateformat.parse(s);
                    c2 = new GregorianCalendar();
                    c2.setTime(d);
                    if (c2 != null) break block7;
                    return Double.NaN;
                }
                try {
                    return DateConverter.getXLSDateVal(c2);
                }
                catch (Exception format) {
                    // empty catch block
                }
            }
            if ((c = DateConverter.convertStringToCalendar(s)) == null) {
                return Double.NaN;
            }
            return DateConverter.getXLSDateVal(c);
        }
    }

    @Override
    public void setStringVal(String v) {
        String ov = this.getStringVal();
        if (v.equals(ov)) {
            return;
        }
        if (this.getSheet().getWorkBook().getSharedStringTable().isSharedString(this.isst)) {
            Unicodestring str;
            this.isst = this.getSheet().getWorkBook().getSharedStringTable().insertUnicodestring(v);
            System.arraycopy(ByteTools.cLongToLEBytes(this.isst), 0, this.getData(), 6, 4);
            this.init();
            this.unsharedstr = str = this.getSheet().getWorkBook().getSharedStringTable().getUStringAt(this.isst);
        } else {
            Unicodestring str = this.getSheet().getWorkBook().getSharedStringTable().getUStringAt(this.isst);
            int origLen = str.getLength();
            str.updateUnicodeString(v);
            int delta = str.getLength() - origLen;
            this.getSheet().getWorkBook().getSharedStringTable().adjustSstLength(delta);
            this.unsharedstr = str;
        }
    }

    public void setStringVal(Unicodestring v) {
        if (v.equals(this.getUnsharedString())) {
            return;
        }
        this.isst = this.getSheet().getWorkBook().getSharedStringTable().find(v);
        if (this.isst == -1) {
            this.isst = this.getSheet().getWorkBook().getSharedStringTable().insertUnicodestring(v);
        }
        System.arraycopy(ByteTools.cLongToLEBytes(this.isst), 0, this.getData(), 6, 4);
        this.init();
        this.unsharedstr = v;
    }

    @Override
    public String toString() {
        try {
            return "LABELSST:" + this.getCellAddress() + ":" + this.getStringVal();
        }
        catch (Exception e) {
            Logger.logErr("Labelsst toString failed.", e);
            return "#ERR!";
        }
    }
}

