/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import java.io.UnsupportedEncodingException;

public final class Password
extends XLSRecord {
    private static final long serialVersionUID = 380140909635538745L;
    private short hash;

    public Password() {
        this.setOpcode((short)19);
        this.setLength(2);
        this.originalsize = 2;
    }

    public boolean validatePassword(String guess) {
        return Password.hashPassword(guess) == this.getPasswordHash();
    }

    public short getPasswordHash() {
        return this.hash;
    }

    public String getPasswordHashString() {
        String raw = Integer.toHexString(this.hash & 0xFFFF).toUpperCase();
        return "0000".substring(0, 4 - raw.length()).concat(raw);
    }

    protected static short hashPassword(String password) {
        byte[] strBytes;
        try {
            strBytes = password.getBytes("windows-1252");
        }
        catch (UnsupportedEncodingException e) {
            try {
                strBytes = password.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("ISO-8859-1 charset is missing");
            }
        }
        int hash = 0;
        int idx = strBytes.length - 1;
        while (idx >= 0) {
            hash ^= strBytes[idx];
            hash = hash << 1 & Short.MAX_VALUE | hash >>> 14 & 1;
            --idx;
        }
        hash ^= strBytes.length & 0xFFFF;
        return (short)(hash ^= 0xCE4B);
    }

    public void setPassword(String password) {
        this.hash = Password.hashPassword(password);
        this.updateRecord();
    }

    public void setHashedPassword(short hash) {
        this.hash = hash;
        this.updateRecord();
    }

    public void setHashedPassword(String hash) {
        this.hash = (short)Integer.parseInt(hash, 16);
        this.updateRecord();
    }

    private void updateRecord() {
        this.setData(ByteTools.shortToLEBytes(this.hash));
    }

    @Override
    public void init() {
        super.init();
        this.hash = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        Boundsheet sheet = this.getSheet();
        if (sheet != null) {
            sheet.getProtectionManager().addRecord(this);
        }
    }
}

