/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.FeatHeadr;
import com.extentech.formats.XLS.Password;
import com.extentech.formats.XLS.Protect;

public abstract class ProtectionManager {
    protected Protect protect;
    protected FeatHeadr enhancedProtection;
    protected Password password;

    public void addRecord(BiffRec record) {
        if (record instanceof Protect) {
            this.protect = (Protect)record;
        } else if (record instanceof Password) {
            this.password = (Password)record;
        }
    }

    public boolean getProtected() {
        return this.protect != null && this.protect.getIsLocked();
    }

    public void setProtected(boolean value) {
        this.protect.setLocked(value);
    }

    public String getPassword() {
        if (this.password == null) {
            return "0000";
        }
        return this.password.getPasswordHashString();
    }

    public void setPassword(String pass) {
        this.password.setPassword(pass);
    }

    public void setPasswordHashed(String pass) {
        this.password.setHashedPassword(pass);
    }

    public boolean checkPassword(String guess) {
        if (this.password == null) {
            return guess == null || guess.equals("");
        }
        return this.password.validatePassword(guess);
    }

    public void close() {
        if (this.enhancedProtection != null) {
            this.enhancedProtection.close();
        }
        if (this.password != null) {
            this.password.close();
        }
        if (this.protect != null) {
            this.protect.close();
        }
    }
}

