/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Arrays;

public class SXFDBType
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    private short wTypeSql;

    @Override
    public void init() {
        super.init();
        this.wTypeSql = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXFDBType -" + Arrays.toString(this.getData()));
        }
    }

    public static XLSRecord getPrototype() {
        SXFDBType sf = new SXFDBType();
        sf.setOpcode((short)443);
        sf.setData(new byte[2]);
        sf.init();
        return sf;
    }

    public void setType(int type) {
        this.wTypeSql = (short)type;
        byte[] b = ByteTools.shortToLEBytes(this.wTypeSql);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    @Override
    public String toString() {
        return "SXFDBType: " + this.wTypeSql + Arrays.toString(this.getRecord());
    }

    public int getType() {
        return this.wTypeSql;
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }

    static enum ODBCType {
        SQL_TYPE_NULL(0),
        SQL_CHAR(1),
        SQL_DECIMAL(3),
        SQL_INTEGER(4),
        SQL_SMALLINT(5),
        SQL_FLOAT(6),
        SQL_REAL(7),
        SQL_DOUBLE(8),
        SQL_TIMESTAMP(11),
        SQL_VARCHAR(12),
        SQL_BIT(65529),
        SQL_BINARY(65534);

        private final short type;

        private ODBCType(int type) {
            this.type = (short)type;
        }

        public short type() {
            return this.type;
        }

        public static ODBCType get(int type) {
            ODBCType[] oDBCTypeArray = ODBCType.values();
            int n = oDBCTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ODBCType c = oDBCTypeArray[n2];
                if (c.type == type) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }
}

