/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Arrays;

public class SXNum
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    double num;

    @Override
    public void init() {
        super.init();
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXNum -");
        }
        this.num = ByteTools.eightBytetoLEDouble(this.getBytesAt(0, 8));
    }

    @Override
    public String toString() {
        return "SXNum: " + this.num + Arrays.toString(this.getRecord());
    }

    public static XLSRecord getPrototype() {
        SXNum sxnum = new SXNum();
        sxnum.setOpcode((short)201);
        sxnum.setData(new byte[8]);
        sxnum.init();
        return sxnum;
    }

    public void setNum(double n) {
        this.num = n;
        this.setData(ByteTools.doubleToLEByteArray(this.num));
    }

    public double getNum() {
        return this.num;
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }
}

