/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.FeatHeadr;
import com.extentech.formats.XLS.ObjProtect;
import com.extentech.formats.XLS.Password;
import com.extentech.formats.XLS.Protect;
import com.extentech.formats.XLS.ProtectionManager;
import com.extentech.formats.XLS.ScenProtect;
import java.io.Serializable;

public class SheetProtectionManager
extends ProtectionManager
implements Serializable {
    private static final long serialVersionUID = -7450088022236591508L;
    private Boundsheet sheet;
    private ObjProtect objprotect;
    private ScenProtect scenprotect;

    public SheetProtectionManager(Boundsheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public void addRecord(BiffRec record) {
        if (record instanceof ObjProtect) {
            this.objprotect = (ObjProtect)record;
        } else if (record instanceof ScenProtect) {
            this.scenprotect = (ScenProtect)record;
        } else if (record instanceof FeatHeadr) {
            this.enhancedProtection = (FeatHeadr)record;
        } else {
            super.addRecord(record);
        }
    }

    @Override
    public void setProtected(boolean value) {
        if (value) {
            if (this.protect == null) {
                this.addProtectionRecord();
            }
            if (this.enhancedProtection != null) {
                if (this.enhancedProtection.getProtectionOption(1) && this.objprotect == null) {
                    this.insertObjProtect();
                }
                this.setScenProtect(this.enhancedProtection.getProtectionOption(2));
            }
        } else {
            if (this.protect != null) {
                this.sheet.removeRecFromVec(this.protect);
                this.protect = null;
            }
            if (this.objprotect != null) {
                this.sheet.removeRecFromVec(this.objprotect);
                this.objprotect = null;
            }
        }
    }

    public boolean getProtected(int option) {
        if (this.enhancedProtection != null) {
            return this.enhancedProtection.getProtectionOption(option);
        }
        switch (option) {
            case 1: {
                if (this.protect != null) {
                    return this.objprotect == null;
                }
                return true;
            }
            case 2: {
                if (this.scenprotect != null) {
                    return this.scenprotect.getIsLocked();
                }
                return true;
            }
            case 1024: 
            case 16384: {
                return true;
            }
        }
        return false;
    }

    public void setProtected(int option, boolean value) {
        switch (option) {
            case 1: {
                if (value) {
                    if (this.protect == null) break;
                    this.insertObjProtect();
                    break;
                }
                if (this.objprotect == null) break;
                this.sheet.removeRecFromVec(this.objprotect);
                break;
            }
            case 2: {
                if (this.protect == null) break;
                this.setScenProtect(value);
            }
        }
        if (this.enhancedProtection == null) {
            this.enhancedProtection = (FeatHeadr)FeatHeadr.getPrototype();
            int i = this.sheet.getSheetRecs().size() - 1;
            this.sheet.insertSheetRecordAt(this.enhancedProtection, i);
        }
        this.enhancedProtection.setProtectionOption(option, value);
    }

    private void insertPassword() {
        if (this.password != null) {
            return;
        }
        this.password = new Password();
        if (this.protect == null) {
            this.addProtectionRecord();
        }
        int insertIdx = this.protect.getRecordIndex();
        if (this.protect != null) {
            ++insertIdx;
        }
        if (this.objprotect != null) {
            ++insertIdx;
        }
        if (this.scenprotect != null) {
            ++insertIdx;
        }
        this.sheet.insertSheetRecordAt(this.password, insertIdx);
    }

    private void removePassword() {
        if (this.password == null) {
            return;
        }
        this.sheet.removeRecFromVec(this.password);
        this.password = null;
    }

    @Override
    public void setPassword(String pass) {
        if (pass != null && !pass.equals("")) {
            this.insertPassword();
            super.setPassword(pass);
        } else {
            this.removePassword();
        }
    }

    @Override
    public void setPasswordHashed(String pass) {
        if (pass != null) {
            this.insertPassword();
            super.setPasswordHashed(pass);
        } else {
            this.removePassword();
        }
    }

    private void setScenProtect(boolean value) {
        if (this.scenprotect == null) {
            this.scenprotect = new ScenProtect();
            this.sheet.insertSheetRecordAt(this.scenprotect, this.protect.getRecordIndex() + 1);
        }
        this.scenprotect.setLocked(value);
    }

    private void insertObjProtect() {
        if (this.objprotect == null) {
            this.objprotect = new ObjProtect();
            this.objprotect.setLocked(true);
            this.sheet.insertSheetRecordAt(this.objprotect, (this.scenprotect != null ? this.scenprotect : this.protect).getRecordIndex() + 1);
        }
    }

    private void addProtectionRecord() {
        this.protect = new Protect();
        int i = 0;
        while (++i < this.sheet.getSheetRecs().size()) {
            short opc = ((BiffRec)this.sheet.getSheetRecs().get(i)).getOpcode();
            if (opc == 18) {
                this.protect = (Protect)this.sheet.getSheetRecs().get(i);
                if (((BiffRec)this.sheet.getSheetRecs().get(++i)).getOpcode() == 221) {
                    this.scenprotect = (ScenProtect)this.sheet.getSheetRecs().get(i);
                    ++i;
                }
                if (((BiffRec)this.sheet.getSheetRecs().get(i)).getOpcode() != 99) break;
                this.objprotect = (ObjProtect)this.sheet.getSheetRecs().get(i);
                break;
            }
            if (opc == 85 || opc == 125 || opc == 512) break;
        }
        this.sheet.insertSheetRecordAt(this.protect, i);
        this.protect.setLocked(true);
    }

    @Override
    public void close() {
        super.close();
        this.sheet = null;
        if (this.objprotect != null) {
            this.objprotect.close();
        }
        if (this.scenprotect != null) {
            this.scenprotect.close();
        }
    }
}

