/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.DConRef;
import com.extentech.formats.XLS.SxAddl;
import com.extentech.formats.XLS.SxVS;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public class SxStreamID
extends XLSRecord
implements XLSConstants {
    private short streamId = (short)-1;
    private static final long serialVersionUID = 2639291289806138985L;
    private ArrayList subRecs = new ArrayList();

    @Override
    public void init() {
        super.init();
        this.streamId = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXSTREAMID: streamid:" + this.streamId);
        }
    }

    public void addSubrecord(BiffRec r2) {
        this.subRecs.add(r2);
    }

    public static XLSRecord getPrototype() {
        SxStreamID ss = new SxStreamID();
        ss.setOpcode((short)213);
        ss.setData(new byte[2]);
        ss.init();
        return ss;
    }

    public short getStreamID() {
        return this.streamId;
    }

    public void setStreamID(int sid) {
        this.streamId = (short)sid;
        byte[] b = ByteTools.shortToLEBytes(this.streamId);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public CellRange getCellRange() {
        int i = 0;
        while (i < this.subRecs.size()) {
            BiffRec br = (BiffRec)this.subRecs.get(i);
            if (br.getOpcode() == 227) {
                if (((SxVS)br).getSourceType() != 1) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Pivot Table Data Sources other than Sheet are not supported");
                    return null;
                }
            } else {
                if (br.getOpcode() == 81) {
                    return ((DConRef)br).getCellRange();
                }
                if (br.getOpcode() == 82) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Name sources are not yet supported");
                    return null;
                }
                if (br.getOpcode() == 437) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Name sources are not yet supported");
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public void setCellRange(CellRange cr) {
        int i = 0;
        while (i < this.subRecs.size()) {
            BiffRec br = (BiffRec)this.subRecs.get(i);
            if (br.getOpcode() == 227) {
                if (((SxVS)br).getSourceType() != 1) {
                    Logger.logErr("SXSTREAMID.setCellRange:  Pivot Table Data Sources other than Sheet are not supported");
                    return;
                }
            } else {
                if (br.getOpcode() == 81) {
                    ((DConRef)br).setCellRange(cr);
                    return;
                }
                if (br.getOpcode() == 82) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Name sources are not yet supported");
                    return;
                }
                if (br.getOpcode() == 437) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Name sources are not yet supported");
                    return;
                }
            }
            ++i;
        }
    }

    public void setCellRange(String cr) {
        int i = 0;
        while (i < this.subRecs.size()) {
            BiffRec br = (BiffRec)this.subRecs.get(i);
            if (br.getOpcode() == 227) {
                if (((SxVS)br).getSourceType() != 1) {
                    Logger.logErr("SXSTREAMID.setCellRange:  Pivot Table Data Sources other than Sheet are not supported");
                    return;
                }
            } else {
                if (br.getOpcode() == 81) {
                    ((DConRef)br).setCellRange(cr);
                    return;
                }
                if (br.getOpcode() == 82) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Name sources are not yet supported");
                    return;
                }
                if (br.getOpcode() == 437) {
                    Logger.logErr("SXSTREAMID.getCellRange:  Name sources are not yet supported");
                    return;
                }
            }
            ++i;
        }
    }

    public ArrayList addInitialRecords(WorkBook bk, String ref, String sheetName) {
        ArrayList initialrecs = new ArrayList();
        short sid = this.getStreamID();
        SxVS sxvs = (SxVS)SxVS.getPrototype();
        this.addInit(initialrecs, sxvs, bk);
        if (bk.getName(ref) != null) {
            Logger.logErr("PivotCache:  Name Data Sources are Not Supported");
        } else {
            DConRef dc = (DConRef)DConRef.getPrototype();
            int[] rc = ExcelTools.getRangeRowCol(ref);
            dc.setRange(rc, sheetName);
            this.addInit(initialrecs, dc, bk);
        }
        byte[] b = ByteTools.cLongToLEBytes(sid);
        b = ByteTools.append(new byte[2], b);
        SxAddl sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcCache, SxAddl.SxcCache.SxdId.sxd(), b);
        this.addInit(initialrecs, sa, bk);
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcCache, SxAddl.SxcCache.SxdVer10Info.sxd(), null);
        this.addInit(initialrecs, sa, bk);
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcCache, SxAddl.SxcCache.SxdVerSxMacro.sxd(), null);
        this.addInit(initialrecs, sa, bk);
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcCache, SxAddl.SxcCache.SxdEnd.sxd(), null);
        this.addInit(initialrecs, sa, bk);
        return initialrecs;
    }

    private void addInit(ArrayList initialrecs, XLSRecord rec, WorkBook bk) {
        rec.setWorkBook(bk);
        initialrecs.add(rec);
        this.addSubrecord(rec);
    }
}

