/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.PivotCache;
import com.extentech.formats.XLS.QsiSXTag;
import com.extentech.formats.XLS.SxAddl;
import com.extentech.formats.XLS.SxDI;
import com.extentech.formats.XLS.SxEX;
import com.extentech.formats.XLS.SxPI;
import com.extentech.formats.XLS.SxVIEWEX9;
import com.extentech.formats.XLS.SxVdEX;
import com.extentech.formats.XLS.Sxivd;
import com.extentech.formats.XLS.Sxli;
import com.extentech.formats.XLS.Sxvd;
import com.extentech.formats.XLS.Sxvi;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Sxview
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    short rwFirst = 0;
    short rwLast = 0;
    short colFirst = 0;
    short colLast = 0;
    short rwFirstHead = 0;
    short rwFirstData = 0;
    short colFirstData = 0;
    short iCache = 0;
    short sxaxis4Data = 0;
    short ipos4Data = 0;
    short cDim = 0;
    short cDimRw = 0;
    short cDimCol = 0;
    short cDimPg = 0;
    short cDimData = 0;
    short cRw = 0;
    short cCol = 0;
    byte grbit1 = 0;
    byte grbit2 = 0;
    short itblAutoFmt = 0;
    short cchName = 0;
    short cchData = 0;
    byte[] rgch;
    boolean fRwGrand = false;
    boolean fColGrand = false;
    boolean fAutoFormat = false;
    boolean fWH = false;
    boolean fFont = false;
    boolean fAlign = false;
    boolean fBorder = false;
    boolean fPattern = false;
    boolean fNumber = false;
    String PivotTableName = null;
    String DataFieldName = null;
    private ArrayList<BiffRec> subRecs = new ArrayList();
    private byte[] PROTOTYPE_BYTES;

    public Sxview() {
        byte[] byArray = new byte[44];
        byArray[18] = 1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[36] = 11;
        byArray[37] = 2;
        byArray[38] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    public static XLSRecord getPrototype() {
        Sxview sx = new Sxview();
        sx.setOpcode((short)176);
        sx.setData(sx.PROTOTYPE_BYTES);
        sx.init();
        return sx;
    }

    @Override
    public void init() {
        super.init();
        if (this.getLength() <= 0) {
            if (this.DEBUGLEVEL > -1) {
                Logger.logInfo("no data in SXVIEW");
            }
        } else {
            byte[] tmp;
            byte encoding;
            this.rwFirst = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
            this.rwLast = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
            this.colFirst = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
            this.colLast = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
            this.rwFirstHead = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
            this.rwFirstData = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
            this.colFirstData = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
            this.iCache = ByteTools.readShort(this.getByteAt(14), this.getByteAt(15));
            this.sxaxis4Data = ByteTools.readShort(this.getByteAt(18), this.getByteAt(19));
            this.ipos4Data = ByteTools.readShort(this.getByteAt(20), this.getByteAt(21));
            this.cDim = ByteTools.readShort(this.getByteAt(22), this.getByteAt(23));
            this.cDimRw = ByteTools.readShort(this.getByteAt(24), this.getByteAt(25));
            this.cDimCol = ByteTools.readShort(this.getByteAt(26), this.getByteAt(27));
            this.cDimPg = ByteTools.readShort(this.getByteAt(28), this.getByteAt(29));
            this.cDimData = ByteTools.readShort(this.getByteAt(30), this.getByteAt(31));
            this.cRw = ByteTools.readShort(this.getByteAt(32), this.getByteAt(33));
            this.cCol = ByteTools.readShort(this.getByteAt(34), this.getByteAt(35));
            this.grbit1 = this.getByteAt(37);
            this.grbit2 = this.getByteAt(36);
            this.initGrbit();
            this.itblAutoFmt = ByteTools.readShort(this.getByteAt(38), this.getByteAt(39));
            this.cchName = ByteTools.readShort(this.getByteAt(40), this.getByteAt(41));
            this.cchData = ByteTools.readShort(this.getByteAt(42), this.getByteAt(43));
            int fullnamelen = this.cchName + this.cchData;
            this.rgch = new byte[fullnamelen];
            int pos = 44;
            if (this.cchName > 0) {
                encoding = this.getByteAt(pos++);
                tmp = this.getBytesAt(pos, this.cchName * (encoding + 1));
                try {
                    this.PivotTableName = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.logInfo("encoding PivotTable name in Sxview: " + e);
                }
                pos += this.cchName * (encoding + 1);
            }
            if (this.cchData > 0) {
                encoding = this.getByteAt(pos++);
                tmp = this.getBytesAt(pos, this.cchData * (encoding + 1));
                try {
                    this.DataFieldName = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.logInfo("encoding PivotTable name in Sxview: " + e);
                }
            }
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXVIEW: name:" + this.getTableName() + " iCache:" + this.iCache + " cDim:" + this.cDim + " cDimRw:" + this.cDimRw + " cDimCol:" + this.cDimCol + " cDimPg:" + this.cDimPg + " cDimData:" + this.cDimData + " cRw:" + this.cRw + " cCol:" + this.cCol + " datafieldname:" + this.DataFieldName);
        }
    }

    protected void setAxis4Data(short s) {
        this.sxaxis4Data = s;
        byte[] b = ByteTools.shortToLEBytes(this.sxaxis4Data);
        System.arraycopy(b, 0, this.data, 18, 2);
    }

    public short getSxaxis4Data() {
        return this.sxaxis4Data;
    }

    protected void setIpos4Data(short s) {
        this.ipos4Data = s;
        byte[] b = ByteTools.shortToLEBytes(this.ipos4Data);
        System.arraycopy(b, 0, this.data, 20, 2);
    }

    public short getIpos4Data() {
        return this.ipos4Data;
    }

    public void setNPivotFields(short s) {
        this.cDim = s;
        byte[] b = ByteTools.shortToLEBytes(this.cDim);
        System.arraycopy(b, 0, this.data, 22, 2);
        int i = 0;
        while (i < this.subRecs.size()) {
            BiffRec br = this.subRecs.get(i);
            if (br.getOpcode() == 241) break;
            this.getSheet().removeRecFromVec(br);
            this.subRecs.remove(i);
            --i;
            ++i;
        }
        this.cDimRw = 0;
        this.cDimCol = 0;
        this.cDimPg = 0;
        this.cDimData = 0;
        this.cRw = 0;
        this.cCol = 0;
        int zz = this.getRecordIndex() + 1;
        int i2 = 0;
        while (i2 < this.cDim) {
            Sxvd svd = (Sxvd)Sxvd.getPrototype();
            svd.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(zz++, svd);
            this.subRecs.add(i2 * 2, svd);
            SxVdEX svdex = (SxVdEX)SxVdEX.getPrototype();
            svdex.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(zz++, svdex);
            this.subRecs.add(i2 * 2 + 1, svdex);
            ++i2;
        }
    }

    public Sxvd addPivotFieldToAxis(int axis, int fieldIndex) {
        int zz = this.getRecordIndex() + 1;
        SxVdEX sxvdex = (SxVdEX)this.getSubRec(256, fieldIndex);
        if (sxvdex != null) {
            zz = sxvdex.getRecordIndex() + 1;
        }
        Sxvd sxvd = (Sxvd)Sxvd.getPrototype();
        sxvd.setSheet(this.getSheet());
        this.getSheet().getSheetRecs().add(zz++, sxvd);
        this.subRecs.add(this.cDim * 2, sxvd);
        SxVdEX svdex = (SxVdEX)SxVdEX.getPrototype();
        svdex.setSheet(this.getSheet());
        this.getSheet().getSheetRecs().add(zz++, svdex);
        this.subRecs.add(this.cDim * 2 + 1, svdex);
        this.cDim = (short)(this.cDim + 1);
        sxvd.setAxis(axis);
        return sxvd;
    }

    public short getNPivotFields() {
        return this.cDim;
    }

    public void addRowField(int fieldNumber) {
        int zz;
        this.cDimRw = (short)(this.cDimRw + 1);
        byte[] b = ByteTools.shortToLEBytes(this.cDimRw);
        System.arraycopy(b, 0, this.data, 24, 2);
        Sxivd sxivd = (Sxivd)this.getSubRec(180, this.cDimCol > 0 ? 1 : 0);
        if (sxivd == null && (zz = this.getPivotRecordInsertionIndexes(180, 1, -1)) > 0) {
            sxivd = (Sxivd)Sxivd.getPrototype();
            sxivd.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxivd);
            this.subRecs.add(zz, sxivd);
        }
        sxivd.addField(fieldNumber);
    }

    public void addColField(int fieldNumber) {
        int zz;
        this.cDimCol = (short)(this.cDimCol + 1);
        byte[] b = ByteTools.shortToLEBytes(this.cDimCol);
        System.arraycopy(b, 0, this.data, 26, 2);
        Sxivd sxivd = (Sxivd)this.getSubRec(180, 0);
        if (sxivd == null && (zz = this.getPivotRecordInsertionIndexes(180, 0, -1)) > 0) {
            sxivd = (Sxivd)Sxivd.getPrototype();
            sxivd.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxivd);
            this.subRecs.add(zz, sxivd);
        }
        sxivd.addField(fieldNumber);
    }

    public short getCDimRw() {
        return this.cDimRw;
    }

    public short getCDimCol() {
        return this.cDimCol;
    }

    public void addPageField(int fieldIndex, int itemIndex) {
        int zz;
        this.cDimPg = (short)(this.cDimPg + 1);
        byte[] b = ByteTools.shortToLEBytes(this.cDimPg);
        System.arraycopy(b, 0, this.data, 28, 2);
        SxPI sxpi = (SxPI)this.getSubRec(182, -1);
        if (sxpi == null && (zz = this.getPivotRecordInsertionIndexes(182, -1, -1)) > 0) {
            sxpi = (SxPI)SxPI.getPrototype();
            sxpi.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxpi);
            this.subRecs.add(zz, sxpi);
        }
        sxpi.addPageField(fieldIndex, itemIndex);
    }

    public short getCDimPg() {
        return this.cDimPg;
    }

    public void addDataField(int fieldIndex, String aggregateFunction, String name) {
        this.cDimData = (short)(this.cDimData + 1);
        byte[] b = ByteTools.shortToLEBytes(this.cDimData);
        System.arraycopy(b, 0, this.data, 30, 2);
        SxDI sxdi = null;
        int zz = this.getPivotRecordInsertionIndexes(197, -1, -1);
        if (zz > 0) {
            sxdi = (SxDI)SxDI.getPrototype();
            sxdi.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxdi);
            this.subRecs.add(zz, sxdi);
        }
        sxdi.addDataField(fieldIndex, aggregateFunction, name);
    }

    public short getCDimData() {
        return this.cDimData;
    }

    public void addPivotItem(Sxvd axis, int itemType, int cacheItem) {
        int n = axis.getNumItems();
        axis.setNumItems(n + 1);
        int axisIndex = this.getSubRecIndex(axis);
        int zz = this.getPivotRecordInsertionIndexes(178, n, axisIndex);
        Sxvi sxvi = (Sxvi)Sxvi.getPrototype();
        sxvi.setItemType(itemType);
        sxvi.setCacheItem(cacheItem);
        sxvi.setSheet(this.getSheet());
        this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxvi);
        this.subRecs.add(zz, sxvi);
        if (cacheItem != -1) {
            PivotCache pc = this.getWorkBook().getPivotCache();
            pc.addCacheItem(this.iCache, cacheItem);
        }
    }

    public void addPivotLineToROWAxis(int repeat, int nLines, int type, short[] indexes) {
        this.cRw = (short)(this.cRw + 1);
        byte[] b = ByteTools.shortToLEBytes(this.cRw);
        System.arraycopy(b, 0, this.data, 32, 2);
        Sxli sxli = (Sxli)this.getSubRec(181, 0);
        if (sxli == null) {
            int zz = this.getPivotRecordInsertionIndexes(181, 0, -1);
            if (zz > 0) {
                sxli = (Sxli)Sxli.getPrototype(this.getWorkBook());
                sxli.setSheet(this.getSheet());
                this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxli);
                this.subRecs.add(zz, sxli);
                sxli.addField(repeat, nLines, type, indexes);
                sxli = (Sxli)Sxli.getPrototype(this.getWorkBook());
                sxli.setSheet(this.getSheet());
                this.getSheet().getSheetRecs().add(this.subRecs.get(zz + 1).getRecordIndex(), sxli);
                this.subRecs.add(zz + 1, sxli);
            }
        } else {
            sxli.addField(repeat, nLines, type, indexes);
        }
    }

    public short getCRw() {
        return this.cRw;
    }

    protected boolean hasRowPivotItemsRecord() {
        return this.getSubRec(181, 0) != null;
    }

    public void addPivotLineToCOLAxis(int repeat, int nLines, int type, short[] indexes) {
        int zz;
        this.cCol = (short)(this.cCol + 1);
        byte[] b = ByteTools.shortToLEBytes(this.cCol);
        System.arraycopy(b, 0, this.data, 34, 2);
        Sxli sxli = (Sxli)this.getSubRec(181, 1);
        if (sxli == null && (zz = this.getPivotRecordInsertionIndexes(181, 0, -1)) == -1) {
            sxli = (Sxli)Sxli.getPrototype();
            sxli.setSheet(this.getSheet());
            this.getSheet().getSheetRecs().add(this.subRecs.get(zz).getRecordIndex(), sxli);
            this.subRecs.add(zz, sxli);
        }
        sxli.addField(repeat, nLines, type, indexes);
    }

    public short getCCol() {
        return this.cCol;
    }

    public void setICache(short s) {
        this.iCache = s;
        byte[] b = ByteTools.shortToLEBytes(this.iCache);
        System.arraycopy(b, 0, this.data, 14, 2);
    }

    public short getICache() {
        return this.iCache;
    }

    private void initGrbit() {
        this.fRwGrand = (this.grbit1 & 1) == 1;
        this.fColGrand = (this.grbit1 & 2) == 2;
        this.fAutoFormat = (this.grbit1 & 8) == 8;
        this.fWH = (this.grbit1 & 0x10) == 16;
        this.fFont = (this.grbit1 & 0x20) == 32;
        this.fAlign = (this.grbit1 & 0x40) == 64;
        this.fBorder = (this.grbit1 & 0x80) == 128;
        this.fPattern = (this.grbit2 & 1) == 1;
        this.fNumber = (this.grbit2 & 2) == 2;
        this.getData()[36] = this.grbit2;
        this.getData()[37] = this.grbit1;
    }

    public void addSubrecord(BiffRec r2) {
        this.subRecs.add(r2);
    }

    public void setFRwGrand(boolean b) {
        if (b != this.fRwGrand) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0xFE) : (byte)(this.grbit1 | 1);
            this.initGrbit();
        }
    }

    public boolean getFRwGrand() {
        return this.fRwGrand;
    }

    public void setColGrand(boolean b) {
        if (b != this.fColGrand) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0xFD) : (byte)(this.grbit1 | 2);
            this.initGrbit();
        }
    }

    public boolean getFColGrand() {
        return this.fColGrand;
    }

    public void setFAutoFormat(boolean b) {
        if (b != this.fAutoFormat) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0xFB) : (byte)(this.grbit1 | 4);
            this.initGrbit();
        }
    }

    public boolean getFAutoFormat() {
        return this.fAutoFormat;
    }

    public void setFWH(boolean b) {
        if (b != this.fWH) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0xEF) : (byte)(this.grbit1 | 0x10);
            this.initGrbit();
        }
    }

    public boolean getFWH() {
        return this.fWH;
    }

    public void setFFont(boolean b) {
        if (b != this.fFont) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0xDF) : (byte)(this.grbit1 | 0x20);
            this.initGrbit();
        }
    }

    public boolean getFFont() {
        return this.fFont;
    }

    public void setFAlign(boolean b) {
        if (b != this.fAlign) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0xBF) : (byte)(this.grbit1 | 0x40);
            this.initGrbit();
        }
    }

    public boolean getFAlign() {
        return this.fAlign;
    }

    public void setFBorder(boolean b) {
        if (b != this.fBorder) {
            this.grbit1 = !b ? (byte)(this.grbit1 & 0x7F) : (byte)(this.grbit1 | 0x80);
            this.initGrbit();
        }
    }

    public boolean getFBorder() {
        return this.fBorder;
    }

    public void setFPattern(boolean b) {
        if (b != this.fPattern) {
            this.grbit2 = !b ? (byte)(this.grbit2 & 0xFE) : (byte)(this.grbit2 | 1);
            this.initGrbit();
        }
    }

    public boolean getFPattern() {
        return this.fPattern;
    }

    public void setFNumber(boolean b) {
        if (b != this.fNumber) {
            this.grbit2 = !b ? (byte)(this.grbit2 & 0xFE) : (byte)(this.grbit2 | 1);
            this.initGrbit();
        }
    }

    public boolean getFNumber() {
        return this.fNumber;
    }

    public void setLocation(String range) {
        int[] rc = ExcelTools.getRangeRowCol(range);
        this.setRwFirst((short)rc[0]);
        this.setColFirst((short)rc[1]);
        this.setRwLast((short)rc[2]);
        this.setColLast((short)rc[3]);
    }

    public void setRwFirst(short s) {
        this.rwFirst = s;
        byte[] b = ByteTools.shortToLEBytes(this.rwFirst);
        System.arraycopy(b, 0, this.data, 0, 2);
    }

    public short getRwFirst() {
        return this.rwFirst;
    }

    public void setRwLast(short s) {
        this.rwLast = s;
        byte[] b = ByteTools.shortToLEBytes(this.rwLast);
        System.arraycopy(b, 0, this.data, 2, 2);
    }

    public short getRwLast() {
        return this.rwLast;
    }

    public void setColFirst(short s) {
        this.colFirst = s;
        byte[] b = ByteTools.shortToLEBytes(this.colFirst);
        System.arraycopy(b, 0, this.data, 4, 2);
    }

    public short getColFirst() {
        return this.colFirst;
    }

    public void setColLast(short s) {
        this.colLast = s;
        byte[] b = ByteTools.shortToLEBytes(this.colLast);
        System.arraycopy(b, 0, this.data, 6, 2);
    }

    public short getColLast() {
        return this.colLast;
    }

    public void setRwFirstHead(short s) {
        this.rwFirstHead = s;
        byte[] b = ByteTools.shortToLEBytes(this.rwFirstHead);
        System.arraycopy(b, 0, this.data, 8, 2);
    }

    public short getRwFirstHead() {
        return this.rwFirstHead;
    }

    public void setRwFirstData(short s) {
        this.rwFirstData = s;
        byte[] b = ByteTools.shortToLEBytes(this.rwFirstData);
        System.arraycopy(b, 0, this.data, 10, 2);
    }

    public short getRwFirstData() {
        return this.rwFirstData;
    }

    public void setColFirstData(short s) {
        this.colFirstData = s;
        byte[] b = ByteTools.shortToLEBytes(this.colFirstData);
        System.arraycopy(b, 0, this.data, 12, 2);
    }

    public short getColFirstData() {
        return this.colFirstData;
    }

    public void setGrbit(short s) {
        byte[] b = ByteTools.shortToLEBytes(s);
        this.grbit2 = b[0];
        this.grbit1 = b[1];
        System.arraycopy(b, 0, this.data, 36, 2);
        this.initGrbit();
    }

    public void setItblAutoFmt(short s) {
        this.itblAutoFmt = s;
        byte[] b = ByteTools.shortToLEBytes(this.itblAutoFmt);
        System.arraycopy(b, 0, this.data, 38, 2);
    }

    public short getItblAutoFmt() {
        return this.itblAutoFmt;
    }

    public void setTableName(String s) {
        this.PivotTableName = s;
        this.buildRgch();
        QsiSXTag qsi = (QsiSXTag)this.getSubRec(2050, -1);
        if (qsi != null) {
            qsi.setName(s);
        }
        int i = this.subRecs.size() - 1;
        while (i > 0) {
            BiffRec br = this.subRecs.get(i);
            if (br.getOpcode() == 2148 && ((SxAddl)br).getRecordId() == SxAddl.SxcView.sxdId) {
                ((SxAddl)br).setViewName(s);
                break;
            }
            --i;
        }
    }

    public String getTableName() {
        return this.PivotTableName;
    }

    public void setDataName(String s) {
        this.DataFieldName = s;
        this.buildRgch();
    }

    public String getDataName() {
        return this.DataFieldName;
    }

    private void buildRgch() {
        byte[] data = new byte[44];
        System.arraycopy(this.getData(), 0, data, 0, 44);
        byte[] strbytes = new byte[]{};
        byte[] databytes = new byte[]{};
        try {
            if (this.PivotTableName != null) {
                strbytes = this.PivotTableName.getBytes("ISO-8859-1");
            }
            if (this.DataFieldName != null) {
                databytes = this.DataFieldName.getBytes("ISO-8859-1");
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("encoding pivot table name in SXVIEW: " + e);
        }
        this.cchName = (short)strbytes.length;
        byte[] nm = ByteTools.shortToLEBytes(this.cchName);
        data[40] = nm[0];
        data[41] = nm[1];
        this.cchData = (short)databytes.length;
        nm = ByteTools.shortToLEBytes(this.cchData);
        data[42] = nm[0];
        data[43] = nm[1];
        byte[] newrgch = new byte[this.cchName + this.cchData + 2];
        System.arraycopy(strbytes, 0, newrgch, 1, this.cchName);
        System.arraycopy(databytes, 0, newrgch, this.cchName + 2, this.cchData);
        data = ByteTools.append(newrgch, data);
        this.setData(data);
    }

    private BiffRec getSubRec(int opcode, int index) {
        int j = 0;
        int i = 0;
        while (i < this.subRecs.size()) {
            BiffRec br = this.subRecs.get(i);
            if (br.getOpcode() == opcode && (index == -1 || j++ == index)) {
                return br;
            }
            ++i;
        }
        return null;
    }

    private int getSubRecIndex(BiffRec br) {
        int i = 0;
        while (i < this.subRecs.size()) {
            if (br == this.subRecs.get(i)) break;
            ++i;
        }
        return i;
    }

    private int getSubRecIndex(int opcode, int index) {
        int j = 0;
        int i = 0;
        while (i < this.subRecs.size()) {
            BiffRec br = this.subRecs.get(i);
            if (br.getOpcode() == opcode && (index == -1 || j++ == index)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getPivotRecordInsertionIndexes(int opcode, int index, int pivotFieldIndex) {
        int i;
        int j = 0;
        if (pivotFieldIndex < 0) {
            i = this.subRecs.size() - 1;
            while (i >= 0) {
                BiffRec br = this.subRecs.get(i);
                short bropcode = br.getOpcode();
                if (bropcode == opcode) {
                    if (j >= index) break;
                    ++j;
                } else if (opcode == 181 && (bropcode == 197 || bropcode == 182 || bropcode == 180 || bropcode == 256) || opcode == 197 && (bropcode == 182 || bropcode == 180 || bropcode == 256) || opcode == 182 && (bropcode == 180 || bropcode == 256) || opcode == 180 && bropcode == 256 || opcode == 177 && bropcode == 241) break;
                --i;
            }
            ++i;
        } else {
            i = pivotFieldIndex + 1;
            while (i < this.subRecs.size()) {
                BiffRec br = this.subRecs.get(i);
                short bropcode = br.getOpcode();
                if (bropcode == opcode) {
                    if (j >= index) break;
                    ++j;
                } else if (bropcode == 256) break;
                ++i;
            }
        }
        return i;
    }

    public ArrayList addInitialRecords(Boundsheet sheet) {
        ArrayList initialrecs = new ArrayList();
        this.setSheet(sheet);
        this.setWorkBook(sheet.getWorkBook());
        SxEX sxex = (SxEX)SxEX.getPrototype();
        this.addInit(initialrecs, sxex, sheet);
        QsiSXTag qsi = (QsiSXTag)QsiSXTag.getPrototype();
        this.addInit(initialrecs, qsi, sheet);
        SxVIEWEX9 sxv = (SxVIEWEX9)SxVIEWEX9.getPrototype();
        this.addInit(initialrecs, sxv, sheet);
        SxAddl sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcView, SxAddl.SxcView.sxdId.sxd(), null);
        this.addInit(initialrecs, sa, sheet);
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcView, SxAddl.SxcView.sxdVer10Info.sxd(), null);
        this.addInit(initialrecs, sa, sheet);
        byte[] byArray = new byte[10];
        byArray[6] = 51;
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcView, SxAddl.SxcView.sxdTableStyleClient.sxd(), byArray);
        this.addInit(initialrecs, sa, sheet);
        byte[] byArray2 = new byte[6];
        byArray2[0] = 2;
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcView, SxAddl.SxcView.sxdVerUpdInv.sxd(), byArray2);
        this.addInit(initialrecs, sa, sheet);
        byte[] byArray3 = new byte[6];
        byArray3[0] = -1;
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcView, SxAddl.SxcView.sxdVerUpdInv.sxd(), byArray3);
        this.addInit(initialrecs, sa, sheet);
        sa = SxAddl.getDefaultAddlRecord(SxAddl.ADDL_CLASSES.sxcView, SxAddl.SxcView.sxdEnd.sxd(), null);
        this.addInit(initialrecs, sa, sheet);
        return initialrecs;
    }

    private void addInit(ArrayList initialrecs, XLSRecord rec, Boundsheet sheet) {
        initialrecs.add(rec);
        rec.setSheet(sheet);
        rec.setWorkBook(this.getWorkBook());
        this.addSubrecord(rec);
    }

    @Override
    public String toString() {
        return "SXVIEW: name:" + this.getTableName() + " iCache:" + this.iCache + " cDim:" + this.cDim + " cDimRw:" + this.cDimRw + " cDimCol:" + this.cDimCol + " cDimPg:" + this.cDimPg + " cDimData:" + this.cDimData + " cRw:" + this.cRw + " cCol:" + this.cCol + " datafieldname:" + this.DataFieldName;
    }
}

