/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;

public final class TabID
extends XLSRecord {
    private static final long serialVersionUID = 722748113519841817L;
    CompatibleVector tabIDs = new CompatibleVector();

    @Override
    public void init() {
        super.init();
        int i = 0;
        while (i < this.getLength() - 4) {
            short s = ByteTools.readShort(this.getByteAt(i), this.getByteAt(i + 1));
            Short sh = s;
            this.tabIDs.add(sh);
            i += 2;
        }
    }

    void removeRecord() {
        short largest = 0;
        int i = 0;
        while (i < this.tabIDs.size()) {
            Short sh = (Short)this.tabIDs.get(i);
            short newshort = sh;
            if (newshort > largest) {
                largest = newshort;
            }
            ++i;
        }
        this.tabIDs.remove((Object)largest);
        this.updateRecord();
    }

    void addNewRecord() {
        short largest = 0;
        int i = 0;
        while (i < this.tabIDs.size()) {
            Short sh = (Short)this.tabIDs.get(i);
            short newshort = sh;
            if (newshort > largest) {
                largest = newshort;
            }
            ++i;
        }
        largest = (short)(largest + 1);
        Short sh = largest;
        this.tabIDs.add(sh);
        this.updateRecord();
    }

    private boolean changeOrder(int sheet, int newpos) {
        int sz = this.tabIDs.size();
        if (sheet < 0 || newpos < 0 || sheet >= sz || newpos >= sz) {
            Logger.logWarn("changing Sheet order failed: invalid Sheet Index: " + sheet + ":" + newpos);
            return false;
        }
        Object b = this.tabIDs.get(sheet);
        this.tabIDs.remove(b);
        this.tabIDs.insertElementAt(b, newpos);
        this.updateRecord();
        return true;
    }

    public void updateRecord() {
        short newlen = (short)(this.tabIDs.size() * 2);
        byte[] newbody = new byte[newlen];
        int counter = 0;
        int i = 0;
        while (i < this.tabIDs.size()) {
            Short sh = (Short)this.tabIDs.get(i);
            byte[] b = ByteTools.shortToLEBytes(sh);
            newbody[counter] = b[0];
            newbody[counter + 1] = b[1];
            counter += 2;
            ++i;
        }
        this.setData(newbody);
    }

    public CompatibleVector getTabIDs() {
        return this.tabIDs;
    }
}

