/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public final class Txo
extends XLSRecord {
    private static final long serialVersionUID = -7043468034346138525L;
    Continue text;
    Continue formattingruns;
    int state = 0;
    short grbit = 0;
    short cchText = 0;
    short cbRuns = 0;
    short rot = 0;
    boolean compressedUnicode = false;
    private byte[] PROTOTYPE_BYTES;

    public Txo() {
        byte[] byArray = new byte[18];
        byArray[0] = 18;
        byArray[1] = 2;
        byArray[12] = 4;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        int datalen = this.getLength();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.rot = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.cchText = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.cbRuns = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.setIsValueForCell(false);
        this.isString = true;
        this.isContinueMerged = true;
    }

    @Override
    public String getStringVal() {
        String s = "";
        if (this.text == null) {
            return null;
        }
        byte encoding = this.text.getData()[0];
        byte[] barr = new byte[this.text.getData().length - 1];
        System.arraycopy(this.text.getData(), 1, barr, 0, barr.length);
        try {
            s = encoding == 0 ? new String(barr, "ISO-8859-1") : new String(barr, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("reading Text Object failed: " + e.toString());
        }
        return s;
    }

    @Override
    public void setStringVal(String v) throws IllegalArgumentException {
        if (v != null && v.indexOf(60) >= 0) {
            v = this.parseFormatting(v);
        } else {
            this.setFormattingRuns(null);
        }
        byte[] a = v.getBytes();
        byte[] b = new byte[a.length + 1];
        System.arraycopy(a, 0, b, 1, a.length);
        if (this.DEBUGLEVEL > 1) {
            Logger.logInfo("Txo CHANGING: " + this.getStringVal());
        }
        b[0] = 0;
        if (this.text != null) {
            this.text.setData(b);
        } else {
            this.text = Continue.getTextContinues(v);
        }
        b = ByteTools.shortToLEBytes((short)a.length);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
        this.cchText = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        if (this.DEBUGLEVEL > 1) {
            Logger.logInfo(" TO: " + this.getStringVal());
        }
    }

    private String parseFormatting(String s) throws IllegalArgumentException {
        try {
            boolean informatting = false;
            StringBuffer txt = new StringBuffer();
            short[] frs = new short[2];
            ArrayList<short[]> formattingRuns = new ArrayList<short[]>();
            boolean u = false;
            boolean st = false;
            boolean it = false;
            boolean b = false;
            String font = "Arial";
            int sz = 10;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (!informatting) {
                    if (c != '<') {
                        txt.append(c);
                    } else {
                        informatting = true;
                        frs = new short[]{(short)txt.length(), 0};
                        u = false;
                        st = false;
                        it = false;
                        b = false;
                        sz = 10;
                        font = "Arial";
                    }
                } else {
                    String[] z = s.substring(i).split("[;>]");
                    if (z == null || z.length == 0 || z.length == 1 && !z[0].endsWith(">") && !z[0].endsWith(";")) {
                        txt.append('<');
                        --i;
                        informatting = false;
                    } else {
                        String section = z[0];
                        if (section.equals("b")) {
                            b = true;
                        } else if (section.equals("i")) {
                            it = true;
                        } else if (section.equals("u")) {
                            u = true;
                        } else if (section.equals("s")) {
                            st = true;
                        } else if (section.startsWith("f=")) {
                            font = section.substring(3);
                            font = font.substring(0, font.indexOf(34));
                        } else if (section.startsWith("sz=")) {
                            String ssz = section.substring(4);
                            ssz = ssz.substring(0, ssz.indexOf(34));
                            sz = Integer.valueOf(ssz);
                        }
                        if ((i += section.length()) < s.length() && s.charAt(i) == '>') {
                            int fIndex;
                            informatting = false;
                            Font f = new Font(font, 400, sz * 20);
                            if (b) {
                                f.setBold(b);
                            }
                            if (it) {
                                f.setItalic(it);
                            }
                            if (u) {
                                f.setUnderlined(u);
                            }
                            if (st) {
                                f.setStricken(st);
                            }
                            if ((fIndex = this.getWorkBook().getFontIdx(f)) == -1) {
                                fIndex = this.getWorkBook().insertFont(f) + 1;
                            }
                            frs[1] = (short)fIndex;
                            formattingRuns.add(frs);
                        }
                    }
                }
                ++i;
            }
            if (formattingRuns.size() > 0) {
                formattingRuns.add(new short[]{(short)txt.toString().length(), 15});
                this.setFormattingRuns(formattingRuns);
            }
            return txt.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse String Pattern: " + s);
        }
    }

    public void setStringVal(Unicodestring txt) {
        this.setStringVal(txt.getStringVal());
        this.setFormattingRuns(txt.getFormattingRuns());
    }

    public ArrayList getFormattingRuns() {
        ArrayList<short[]> formattingRuns = new ArrayList<short[]>();
        int frcontinues = this.getSheet().getSheetRecs().indexOf(this) + 2;
        Continue fr = (Continue)this.getSheet().getSheetRecs().get(frcontinues);
        byte[] frdata = fr.getData();
        int nFormattingRuns = frdata.length / 8;
        if (nFormattingRuns <= 1) {
            return null;
        }
        int i = 0;
        while (i < nFormattingRuns * 8) {
            short idx = ByteTools.readShort(frdata[i++], frdata[i++]);
            short font = ByteTools.readShort(frdata[i++], frdata[i++]);
            formattingRuns.add(new short[]{idx, font});
            i += 4;
        }
        return formattingRuns;
    }

    public void setFormattingRuns(ArrayList formattingRuns) {
        byte[] frs = new byte[4];
        if (formattingRuns != null) {
            frs = new byte[formattingRuns.size() * 8];
            int i = 0;
            while (i < formattingRuns.size()) {
                short[] o = (short[])formattingRuns.get(i);
                byte[] charIndex = ByteTools.shortToLEBytes(o[0]);
                byte[] fontIndex = ByteTools.shortToLEBytes(o[1]);
                System.arraycopy(charIndex, 0, frs, i * 8, 2);
                System.arraycopy(fontIndex, 0, frs, i * 8 + 2, 2);
                ++i;
            }
        }
        int frcontinues = this.getSheet().getSheetRecs().indexOf(this) + 2;
        Continue fr = (Continue)this.getSheet().getSheetRecs().get(frcontinues);
        fr.setData(frs);
        this.cbRuns = (short)frs.length;
        byte[] b = ByteTools.shortToLEBytes(this.cbRuns);
        this.getData()[12] = b[0];
        this.getData()[13] = b[1];
    }

    public static XLSRecord getPrototype() {
        Txo t = new Txo();
        t.setOpcode((short)438);
        t.setData(t.PROTOTYPE_BYTES);
        t.init();
        t.text = Continue.getTextContinues("");
        return t;
    }

    @Override
    public String toString() {
        return this.getStringVal();
    }
}

