/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;

public final class Unicodestring
implements XLSConstants,
Serializable {
    private static final long serialVersionUID = -1800227752945355535L;
    private int DEBUGLEVEL = -1;
    int cch;
    private int cchExtRst = 0;
    private byte[] ExtRst;
    private boolean fHighByte = false;
    private int formatlen = 0;
    private byte[] formatrunnum = new byte[2];
    private byte[] formattingarray;
    private boolean fRichSt = false;
    private byte grbit;
    private int numformattingruns = 0;
    private int sstpos = -1;
    private byte[] stringarray;
    private int stringlen;
    private int offer;
    private boolean westernencoding = true;
    int len = 0;

    public boolean equals(Object obj) {
        String val;
        return obj instanceof Unicodestring ? (this.westernencoding ? Arrays.equals(this.getWesternBytes(), ((Unicodestring)obj).getWesternBytes()) : Arrays.equals(this.getEasternBytes(), ((Unicodestring)obj).getEasternBytes())) : obj instanceof String && (val = this.toString()).equals(obj);
    }

    byte[] getEasternBytes() {
        byte[] data = new byte[this.stringarray.length + this.formatlen + this.offer + this.ExtRst.length];
        byte[] cchbyte = ByteTools.cLongToLEBytes(this.cch);
        System.arraycopy(cchbyte, 0, data, 0, 2);
        data[2] = this.grbit;
        byte[] cchExtByte = ByteTools.cLongToLEBytes(this.cchExtRst);
        int tempoffset = 3;
        if (this.fRichSt) {
            tempoffset = 5;
        }
        System.arraycopy(cchExtByte, 0, data, tempoffset, 4);
        this.stringlen = this.stringarray.length;
        System.arraycopy(this.stringarray, 0, data, this.offer, this.stringlen);
        if (this.isRichString()) {
            this.formatrunnum = ByteTools.shortToLEBytes((short)this.numformattingruns);
            data[3] = this.formatrunnum[0];
            data[4] = this.formatrunnum[1];
            System.arraycopy(this.formattingarray, 0, data, this.stringlen + this.offer, this.formatlen);
        }
        System.arraycopy(this.ExtRst, 0, data, this.stringlen + this.offer + this.formatlen, this.ExtRst.length);
        if (data[0] == 0) {
            Logger.logInfo("Unicodestring has zero length.");
        }
        return data;
    }

    byte getGrbit() {
        return this.grbit;
    }

    int getLength() {
        return this.stringarray.length + this.formatlen + this.offer;
    }

    int getSSTPos() {
        return this.sstpos;
    }

    byte[] getWesternBytes() {
        byte[] data = new byte[this.stringarray.length + this.formatlen + this.offer];
        byte[] cchbyte = ByteTools.cLongToLEBytes(this.cch);
        System.arraycopy(cchbyte, 0, data, 0, 2);
        data[2] = this.grbit;
        this.stringlen = this.stringarray.length;
        System.arraycopy(this.stringarray, 0, data, this.offer, this.stringlen);
        if (this.isRichString()) {
            this.formatrunnum = ByteTools.shortToLEBytes((short)this.numformattingruns);
            data[3] = this.formatrunnum[0];
            data[4] = this.formatrunnum[1];
            System.arraycopy(this.formattingarray, 0, data, this.stringlen + this.offer, this.formatlen);
        }
        return data;
    }

    void init(byte[] ustrdata, boolean extrstbrk) {
        this.setLen(ustrdata.length);
        this.grbit = ustrdata[2];
        try {
            if ((this.grbit & 4) == 4) {
                this.westernencoding = false;
                this.initEasternEncoding(ustrdata, extrstbrk);
            } else {
                this.initWesternEncoding(ustrdata);
            }
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    void initEasternEncoding(byte[] ustrdata, boolean extrstbrk) throws NegativeArraySizeException {
        int dlen = this.cch = (int)ByteTools.readShort(ustrdata[0], ustrdata[1]);
        this.grbit = ustrdata[2];
        this.offer = 7;
        if ((this.grbit & 1) == 1) {
            dlen *= 2;
            this.fHighByte = true;
        }
        this.stringarray = new byte[dlen];
        if ((this.grbit & 8) == 8) {
            this.fRichSt = true;
        }
        if (this.fRichSt) {
            this.offer = 9;
            try {
                System.arraycopy(ustrdata, this.offer, this.stringarray, 0, dlen);
                this.formatrunnum[0] = ustrdata[3];
                this.formatrunnum[1] = ustrdata[4];
                this.numformattingruns = ByteTools.readShort(this.formatrunnum[0], this.formatrunnum[1]);
                this.formatlen = this.numformattingruns * 4;
                this.formattingarray = new byte[this.formatlen];
                System.arraycopy(ustrdata, dlen + this.offer, this.formattingarray, 0, this.formatlen);
                this.cchExtRst = ByteTools.readInt(ustrdata[5], ustrdata[6], ustrdata[7], ustrdata[8]);
                if (ustrdata.length - dlen - this.offer - this.cchExtRst != this.formatlen) {
                    System.out.println("Unicodestring.initEasternEncoding: Format runs are not correct");
                }
                this.ExtRst = new byte[this.cchExtRst];
                System.arraycopy(ustrdata, dlen + this.offer + this.formatlen, this.ExtRst, 0, this.cchExtRst);
                if (this.ExtRst[0] != 1 || this.ExtRst[1] != 0) {
                    Logger.logWarn("Unicodestring.initEasternEncoding: Phonetic Data is not correct");
                }
            }
            catch (Throwable e) {
                Logger.logInfo("Problem parsing rich text Eastern Unicodestring.  len:" + dlen + " rich:" + this.fRichSt + ".  " + e);
            }
        } else {
            try {
                this.cchExtRst = ByteTools.readInt(ustrdata[3], ustrdata[4], ustrdata[5], ustrdata[6]);
                int extrstLen = ustrdata.length - (this.formatlen + this.offer + dlen);
                int off = 0;
                if (this.cchExtRst != extrstLen || extrstbrk) {
                    if (this.DEBUGLEVEL > 0) {
                        Logger.logWarn("Unicodestring ExtRst Inconsistent.");
                    }
                    this.cchExtRst = extrstLen;
                }
                this.ExtRst = new byte[this.cchExtRst];
                System.arraycopy(ustrdata, 7, this.stringarray, 0, dlen);
                System.arraycopy(ustrdata, ustrdata.length - this.ExtRst.length - off, this.ExtRst, 0, this.ExtRst.length);
                if (this.ExtRst[0] != 1 || this.ExtRst[1] != 0) {
                    Logger.logWarn("Unicodestring.initEasternEncoding: Phonetic Data is not correct");
                }
            }
            catch (Throwable t) {
                Logger.logInfo("Problem Parsing non-rich Eastern Unicodestring.  len:" + dlen + " rich:" + this.fRichSt + ".  " + t.toString());
            }
        }
    }

    void initWesternEncoding(byte[] ustrdata) throws NegativeArraySizeException {
        this.cch = ByteTools.readShort(ustrdata[0], ustrdata[1]);
        int dlen = this.cch + 0;
        this.grbit = ustrdata[2];
        this.offer = 3;
        if ((this.grbit & 1) == 1) {
            dlen *= 2;
            this.fHighByte = true;
        } else {
            this.fHighByte = false;
        }
        if (dlen + this.offer > ustrdata.length) {
            dlen = ustrdata.length - this.offer;
        }
        if ((this.grbit & 8) == 8) {
            this.fRichSt = true;
        }
        if (this.fRichSt) {
            this.formatrunnum[0] = ustrdata[3];
            this.formatrunnum[1] = ustrdata[4];
            this.numformattingruns = ByteTools.readShort(this.formatrunnum[0], this.formatrunnum[1]);
            this.offer = 5;
            this.formatlen = ustrdata.length - dlen - this.offer;
            this.formattingarray = new byte[this.formatlen];
            System.arraycopy(ustrdata, dlen + this.offer, this.formattingarray, 0, this.formatlen);
        }
        this.stringarray = new byte[dlen + 0];
        try {
            System.arraycopy(ustrdata, this.offer, this.stringarray, 0, dlen);
        }
        catch (Exception e) {
            Logger.logInfo("Problem Parsing Western Unicodestring.  len:" + dlen + " rich:" + this.fRichSt + ".  " + e);
        }
    }

    boolean isBreakable(int pos) {
        int mypos = this.getSSTPos();
        int strstart = mypos + this.offer;
        int strend = strstart + this.stringarray.length;
        byte[] bts = this.read();
        int brkpos = strstart - pos;
        if (brkpos < 0) {
            brkpos *= -1;
        }
        if (this.cch < 2) {
            return false;
        }
        if (this.cchExtRst > 0) {
            return false;
        }
        if (pos > mypos + this.cchExtRst + this.stringarray.length + this.offer) {
            return false;
        }
        if (pos > strstart && pos < strend) {
            return this.getLength() > 8220;
        }
        return false;
    }

    public boolean charBreakOnBounds(int pos) {
        int mypos = this.getSSTPos();
        int strstart = mypos + this.offer;
        int strend = strstart + this.stringarray.length;
        byte[] bts = this.read();
        int brkpos = strstart - pos;
        if (brkpos < 0) {
            brkpos *= -1;
        }
        return brkpos % 2 != 0;
    }

    boolean isRichString() {
        return this.fRichSt;
    }

    public boolean isEasternString() {
        return !this.westernencoding;
    }

    public boolean isWesternString() {
        return this.westernencoding;
    }

    public byte[] read() {
        if (this.westernencoding) {
            return this.getWesternBytes();
        }
        return this.getEasternBytes();
    }

    public byte[] readStr() {
        return this.stringarray;
    }

    void setSSTPos(int p) {
        this.sstpos = p;
    }

    public String toString() {
        try {
            if (this.fHighByte) {
                return new String(this.stringarray, "UTF-16LE");
            }
            return new String(this.stringarray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("Problem decoding Unicodestring.  " + e + " Resorting to default encoding: " + "ISO-8859-1");
            try {
                return new String(this.stringarray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException t) {
                if (this.DEBUGLEVEL > -1) {
                    Logger.logInfo("Problem decoding Unicodestring.  " + t);
                }
                return null;
            }
        }
    }

    public String toCachingString() {
        try {
            if (this.fHighByte) {
                return new String(this.stringarray, "UTF-16LE");
            }
            return new String(this.stringarray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("Problem decoding Unicodestring.  " + e + " Resorting to default encoding: " + "ISO-8859-1");
            try {
                return new String(this.stringarray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException t) {
                if (this.DEBUGLEVEL > -1) {
                    Logger.logInfo("Problem decoding Unicodestring.  " + t);
                }
                return null;
            }
        }
    }

    public void updateUnicodeString(String s) {
        if (s.equals(this.toString())) {
            return;
        }
        byte[] strbytes = null;
        try {
            if (!ByteTools.isUnicode(s)) {
                strbytes = s.getBytes("ISO-8859-1");
                this.grbit = (byte)(this.grbit & 0xFE);
            } else {
                strbytes = s.getBytes("UTF-16LE");
                if ((this.grbit & 1) != 1) {
                    this.grbit = (byte)(this.grbit + 1);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("Problem encoding string: " + e);
        }
        int strdatalen = strbytes.length;
        int strlen = s.length();
        byte[] blen = ByteTools.cLongToLEBytes(strlen);
        if ((this.grbit & 4) == 4) {
            this.grbit = (byte)(this.grbit & 0xFB);
            this.ExtRst = null;
            this.offer -= 4;
            this.westernencoding = true;
        }
        if ((this.grbit & 8) == 8) {
            this.formatlen = 0;
            this.fRichSt = false;
            this.grbit = (byte)(this.grbit ^ 8);
            this.offer -= 2;
        }
        byte[] newbytes = new byte[strdatalen + this.offer + this.formatlen];
        newbytes[2] = this.grbit;
        System.arraycopy(blen, 0, newbytes, 0, 2);
        System.arraycopy(strbytes, 0, newbytes, this.offer, strdatalen);
        if (this.isRichString()) {
            System.arraycopy(this.formattingarray, 0, newbytes, strdatalen + this.offer, this.formatlen);
            newbytes[3] = this.formatrunnum[0];
            newbytes[4] = this.formatrunnum[1];
        }
        this.init(newbytes, false);
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int leng) {
        this.len = leng;
    }

    public String getStringVal() {
        return this.toString();
    }

    public boolean hasFormattingRuns() {
        return this.numformattingruns > 0;
    }

    public ArrayList getFormattingRuns() {
        if (this.numformattingruns == 0) {
            return null;
        }
        ArrayList<short[]> formattingruns = new ArrayList<short[]>();
        int i = 0;
        while (i < this.numformattingruns) {
            short charIndex = ByteTools.readShort(this.formattingarray[i * 4], this.formattingarray[i * 4 + 1]);
            short fontIndex = ByteTools.readShort(this.formattingarray[i * 4 + 2], this.formattingarray[i * 4 + 3]);
            formattingruns.add(new short[]{charIndex, fontIndex});
            ++i;
        }
        return formattingruns;
    }

    private static boolean isJapanese(char c) {
        return c >= '\u0100' && c <= '\uffff';
    }

    public static boolean containsJapanese(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Unicodestring.isJapaneseII(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isJapaneseII(char c) {
        if (c >= '\u30a0' && c <= '\u30ff') {
            return true;
        }
        if (c >= '\u3040' && c <= '\u309f') {
            return true;
        }
        if (c >= '\u4e00' && c <= '\u9fff') {
            return true;
        }
        if (c >= '\u3000' && c <= '\u303f') {
            return true;
        }
        if (c >= '\u2f00' && c <= '\u2fdf') {
            return true;
        }
        if (c >= '\u3190' && c <= '\u319f') {
            return true;
        }
        if (c >= '\u3400' && c <= '\u4db5') {
            return true;
        }
        if (c >= '\ufe30' && c <= '\ufe4f') {
            return true;
        }
        if (c >= '\u3300' && c <= '\u33ff') {
            return true;
        }
        return c >= '\u2e80' && c <= '\u2eff';
    }
}

